/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.com.model;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrLicenseContainer;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVDEVCountInfo;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.cvs.createldevs.base.cntl.SJctrCreateLDEVsBaseDC;
import sanproject.sn2.controller.wizard.cvs.createldevs.base.model.SJctrCreateLDEVsDmDataModel;
import sanproject.sn2.controller.wizard.cvs.createldevs.base.model.SJctrCreateLDEVsEmulationTypeDataModel;
import sanproject.sn2.controller.wizard.cvs.createldevs.hdp.com.SJctrPoolDetail;
import sanproject.sn2.controller.wizard.cvs.editldevs.SJctrEditLDEVsDC;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.system.SJmoCvdevInfo;

public class SJctrDataSavingDataModel
extends SJctrComboBoxDataModel
implements SJctrCVSMacro {
    private String spaceData = "-1";

    public SJctrDataSavingDataModel() {
        this.initListener();
    }

    public void refData(List poolDetail) {
        super.setEnableListener(false);
        this.removeAllItems();
        short items = this.checkDisplayItems(poolDetail);
        if (items == 0) {
            this.initData_disabled();
        } else if (items == 1) {
            this.initData_deduplicationDisabled();
        } else {
            this.initData_allItems();
        }
        super.setEnableListener(true);
    }

    public void initData_disabled() {
        this.addItem(Short.toString((short)0), this.getComUtility().getGuidance("DISABLED"));
        this.setSelectedIndex(0);
    }

    public void initData_deduplicationDisabled() {
        this.addItem(Short.toString((short)1), this.getComUtility().getGuidance("COMPRESS"));
        this.addItem(Short.toString((short)0), this.getComUtility().getGuidance("DISABLED"));
        this.setSelectedIndex(1);
    }

    public void initData_allItems() {
        this.addItem(Short.toString((short)1), this.getComUtility().getGuidance("COMPRESS"));
        this.addItem(Short.toString((short)2), this.getComUtility().getGuidance("DEDUPLICATION_AND_COMPRESSION"));
        this.addItem(Short.toString((short)0), this.getComUtility().getGuidance("DISABLED"));
        this.setSelectedIndex(2);
    }

    public short getSDataSaving() {
        short rtn = 0;
        String selData = this.getSelection();
        if (selData != null) {
            rtn = Short.parseShort(selData);
        }
        return rtn;
    }

    public boolean isDataSave() {
        boolean rtn = false;
        rtn = this.getSDataSaving() != 0;
        return rtn;
    }

    private void initListener() {
        this.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrDataSavingDataModel.this.fireMessageEvent(SJctrCreateLDEVsBaseDC.NOTIFY_CREATE_LDEVS.CHANGE_DATASAVING);
                }
            }
        });
    }

    public short checkDisplayItems(List poolDetail) {
        int rtn = 0;
        SJctrCreateLDEVsDmDataModel DmDataModel = (SJctrCreateLDEVsDmDataModel)this.getDataController().getDataObjectModel("COM_DIRECT_MAPPING");
        SJctrCreateLDEVsEmulationTypeDataModel emu = (SJctrCreateLDEVsEmulationTypeDataModel)this.getDataController().getDataObjectModel("COM_EMUTYPE");
        if (DmDataModel.isDM() || !this.isLicense() || !emu.getSelection().equals("OPEN-V")) {
            return (short)rtn;
        }
        List<?> ldevStatusList = ((SJctrCreateLDEVsBaseDC)this.getDataController()).getCache(KEY_CLASS_GETLDEVSTATUS);
        for (int i = 0; i < poolDetail.size(); ++i) {
            SJctrPoolDetail pool = (SJctrPoolDetail)poolDetail.get(i);
            if (pool.isPbTSM()) continue;
            rtn = 1;
            if (!this.checkDeduplication(pool, ldevStatusList).booleanValue()) continue;
            rtn = 2;
            break;
        }
        return (short)rtn;
    }

    private Boolean checkDeduplication(SJctrPoolDetail pool, List ldevStatusList) {
        boolean rtn = true;
        if (!pool.isPoolDedup()) {
            return false;
        }
        if (!SJctrCVSUtility.checkFptVolLdevStatus(pool, ldevStatusList)) {
            return false;
        }
        return rtn;
    }

    public boolean refDataEdit(List<SJctrLDEVDetail> ldevList, List<SJmoPoolDetail> poolList) {
        super.setEnableListener(false);
        this.removeAllItems();
        if (!this.checkDisplayItemsEdit(ldevList, poolList)) {
            this.initData_hyphen();
            return false;
        }
        if (null != this.getItem(this.spaceData)) {
            this.setSelection(this.spaceData);
        } else {
            this.setSelection(Short.toString(ldevList.get(0).getSDataSaving()));
        }
        super.setEnableListener(true);
        return true;
    }

    private boolean checkDisplayItemsEdit(List<SJctrLDEVDetail> ldevList, List poolList) {
        boolean isSpace = false;
        boolean isComp = true;
        boolean isDeduAndComp = true;
        List<?> ldevStatusList = ((SJctrEditLDEVsDC)this.getDataController()).getCache(KEY_CLASS_GETLDEVSTATUS);
        List<?> cvdevList = ((SJctrEditLDEVsDC)this.getDataController()).getCache(KEY_CLASS_GETCVDEVINFO);
        SJmoCvdevInfo cvd = (SJmoCvdevInfo)cvdevList.get(0);
        SJctrCVDEVCountInfo cvdev = new SJctrCVDEVCountInfo(cvd);
        int usedCvdevNum = 0;
        short selDataSaving = -1;
        if (ldevList.size() <= 0) {
            this.getLogUty().putlog("checkDisplayItemsEdit", "ldevList not found", null, 30000);
            return false;
        }
        selDataSaving = ldevList.get(0).getSDataSaving();
        HashSet<Integer> poolIdList = new HashSet<Integer>();
        HashSet<Integer> deduAndCompPoolIdList = new HashSet<Integer>();
        for (int i = 0; i < ldevList.size(); ++i) {
            SJctrLDEVDetail ldev = ldevList.get(i);
            if (ldev.getByVolumeType() != 3 || ldev.getBFPTVol() || ldev.getIDataSavingStatus() == 5 || ldev.getIDataSavingStatus() == 6) {
                return false;
            }
            int poolIndex = Collections.binarySearch(poolList, ldev.getPoolIndex());
            if (poolIndex >= 0) {
                poolIdList.add(poolIndex);
                if (ldev.getSDataSaving() == 2) {
                    deduAndCompPoolIdList.add(poolIndex);
                }
            } else {
                this.getLogUty().putlog("checkDisplayItemsEdit", "poolIndex not found", null, 30000);
                return false;
            }
            if (ldev.getByStatus() != 1 || ldev.getIEmulationType() != 625 || ldev.isBPbTSM() || ldev.isBHrt() || ldev.getBDM() || ldev.getbJNLVolume()) {
                isComp = false;
                isDeduAndComp = false;
            }
            if (selDataSaving != ldev.getSDataSaving()) {
                isSpace = true;
            }
            if (ldev.getBDRDVol() || ldev.getIDataSavingStatus() != 0) continue;
            usedCvdevNum += cvdev.getCVDEVMaxNum(ldev.getLLDEVLBASize(), ldev.getByVolumeType(), ldev.isBPoolType());
        }
        Iterator iterator = poolIdList.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            SJmoPoolDetail pool = (SJmoPoolDetail)poolList.get(index);
            if (!pool.isPoolDedup()) {
                isDeduAndComp = false;
                continue;
            }
            if (SJctrCVSUtility.checkFptVolLdevStatus(pool, ldevStatusList)) continue;
            isDeduAndComp = false;
            if (!deduAndCompPoolIdList.contains(index)) continue;
            return false;
        }
        if (cvdev.getIRemaningCVDEVCount() < usedCvdevNum || !this.isLicense()) {
            isComp = false;
            isDeduAndComp = false;
        }
        this.addItem(this.spaceData, "");
        if (isComp) {
            this.addItem(Short.toString((short)1), this.getComUtility().getGuidance("COMPRESS"));
        }
        if (isDeduAndComp) {
            this.addItem(Short.toString((short)2), this.getComUtility().getGuidance("DEDUPLICATION_AND_COMPRESSION"));
        }
        this.addItem(Short.toString((short)0), this.getComUtility().getGuidance("DISABLED"));
        if (!isSpace && null != this.getItem(Short.toString(selDataSaving))) {
            this.removeItem(this.spaceData);
        }
        return true;
    }

    public void initData_hyphen() {
        super.setEnableListener(false);
        this.removeAllItems();
        this.addItem("-");
        this.setSelectedIndex(0);
        super.setEnableListener(true);
    }

    public boolean chkData() {
        boolean rtn = true;
        String selData = this.getSelection();
        if (selData.equals(this.spaceData)) {
            SJctrCVSUtility.output_Error(30, 22, 105148);
            rtn = false;
        }
        return rtn;
    }

    public boolean isLicense() {
        SJctrAuthorizeContainer AuthorizeContainer = this.getDataController().getOwner().getAuthorizeContainer();
        SJctrLicenseContainer licensecontainer = AuthorizeContainer.getLisenceContainer();
        boolean isLicense = licensecontainer.checkPP(SJctrLicenseContainer.PPID_DKCDC);
        return isLicense;
    }
}

