/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.cvs.deletelogicaldevices;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.serversx.data.RJiPGIndex;
import sanproject.serverux.dataimpl.EXDPGOperation;
import sanproject.serverux.dataimpl.EXDsetAOUReleaseVvol_IN;
import sanproject.serverux.dataimpl.EXDsetAOUReleaseVvol_OUT;
import sanproject.serverux.dataimpl.EXDsetPgOperation_IN;
import sanproject.serverux.dataimpl.EXDsetPgOperation_OUT;
import sanproject.serverux.dataimpl.EXDsetQSReleaseVvol_IN;
import sanproject.serverux.dataimpl.EXDsetQSReleaseVvol_OUT;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrKeyValueErrorInfo;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.comparator.SJctrArrayGroupIndexComparator;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.wizard.cvs.com.SJctrAluErrorInfo;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSMacro;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.cvs.com.SJctrLDEVDetail;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;

public class SJctrDeleteLogicalDevicesAC
extends SJctrApplyController
implements SJctrCVSMacro {
    public List<SJctrLDEVDetail> ldevDetailList;
    protected List<SJctrError> resultData = null;
    private int iApplyType = 0;
    public static final int APPLY_TYPE_CTRL = 0;
    public static final int APPLY_TYPE_BASIC = 1;
    public static final int APPLY_TYPE_HDP = 2;
    public static final int APPLY_TYPE_QS = 3;
    public static final int APPLY_TYPE_ALU = 4;
    public static final int APPLY_TYPE_SLU = 5;
    protected boolean bChkDRD = false;

    @Override
    protected void setApplyResult(Object resultObject) {
        EXDPGOperation[] delVol;
        EXDsetPgOperation_OUT out;
        SJctrLogUty.info(this.title, "setApplyResult", "START");
        super.setApplyResult(resultObject);
        if (resultObject instanceof EXDsetQSReleaseVvol_OUT) {
            out = (EXDsetQSReleaseVvol_OUT)resultObject;
            delVol = out.getAllPGOperation();
            this.setErrData(delVol);
        }
        if (resultObject instanceof EXDsetAOUReleaseVvol_OUT) {
            out = (EXDsetAOUReleaseVvol_OUT)resultObject;
            delVol = out.getAllPGOperation();
            this.setErrData(delVol);
        }
        if (resultObject instanceof SanResponse) {
            SanResponse response = (SanResponse)resultObject;
            if ("MNTdeleteLdevs".equals(response.id())) {
                this.setErrDataForBasic(response);
            } else {
                this.setErrData_ASLU((SanResponse)resultObject);
            }
        }
        if (this.resultData == null) {
            this.resultData = new ArrayList<SJctrError>();
        }
        SJctrLogUty.info(this.title, "setApplyResult", resultObject.toString());
    }

    private void setErrData(EXDPGOperation[] delVol) {
        int iError = 0;
        ArrayList<EXDPGOperation> PGDataList = new ArrayList<EXDPGOperation>();
        for (int i = 0; i < delVol.length; ++i) {
            EXDPGOperation delPG = delVol[i];
            PGDataList.add(delPG);
            if (delPG.getResult() == 0) continue;
            iError = delPG.getResult();
        }
        if (iError == 0) {
            return;
        }
        this.resultData = new ArrayList<SJctrError>();
        Collections.sort(this.ldevDetailList, new SJctrLdevIndexComparator());
        Collections.sort(PGDataList);
        boolean bErrFlg = false;
        for (int i = 0; i < this.ldevDetailList.size(); ++i) {
            SJctrLDEVDetail ldev = this.ldevDetailList.get(i);
            RJiPGIndex wkPgIndex = new RJiPGIndex();
            wkPgIndex.setIFB4(ldev.getIFB4());
            wkPgIndex.setIPG(ldev.getIPG());
            SJctrError result = new SJctrError(32, 5, 0);
            int pgIndex = Collections.binarySearch(PGDataList, wkPgIndex);
            if (pgIndex >= 0) {
                EXDPGOperation pg = (EXDPGOperation)PGDataList.get(pgIndex);
                result.setError(pg.getResult());
            }
            if (this.iApplyType == 2 && (ldev.getByVolumeType() == 2 || ldev.getByVolumeType() == 5 || ldev.isDPSluVol() || this.chkDrd(ldev))) {
                result.setError(6537);
            }
            if (this.iApplyType == 3 && (ldev.getByVolumeType() == 5 || ldev.isDPSluVol() || this.chkDrd(ldev))) {
                result.setError(6537);
            }
            this.resultData.add(result);
            if (result.getError() == 0 || bErrFlg) continue;
            this.setError(result);
            bErrFlg = true;
        }
        if (!bErrFlg) {
            this.resultData = new ArrayList<SJctrError>();
        }
    }

    private void setErrDataForBasic(SanResponse kvResponse) {
        this.resultData = new ArrayList<SJctrError>();
        try {
            SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(kvResponse);
            if (errorInfo.getErrorCode() != 0) {
                SJctrError error = errorInfo.createError();
                this.setError(error);
                if (errorInfo.hasLowerNodeError()) {
                    SanList kvResultLdevs = kvResponse.getList("Ldevs");
                    this.resultData = SJctrCVSUtility.createStatusList(error.getFunc(), error.getModule(), this.ldevDetailList, kvResultLdevs);
                    for (int i = 0; i < this.ldevDetailList.size(); ++i) {
                        SJctrLDEVDetail ldevDetail = this.ldevDetailList.get(i);
                        SJctrError result = this.resultData.get(i);
                        byte volumeType = ldevDetail.getByVolumeType();
                        if (volumeType != 3 && volumeType != 2 && volumeType != 5 && !ldevDetail.isDPSluVol() && !this.chkDrd(ldevDetail)) continue;
                        result.setFunc(32);
                        result.setModule(5);
                        result.setError(6537);
                    }
                }
            }
        }
        catch (SanDataException ex) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
            SJctrLogUty.error(this.getClass().getSimpleName(), "setErrDataForBasic", "Failed to build result list", ex);
        }
    }

    private void setErrData_ASLU(SanResponse kvResponse) {
        ArrayList<Object> errList;
        block16: {
            SJctrError error;
            SJctrLogUty.info(this.title, "setErrData_ASLU", "START");
            errList = new ArrayList();
            try {
                SJctrKeyValueErrorInfo errorInfo = new SJctrKeyValueErrorInfo(kvResponse);
                if (errorInfo.hasLowerNodeError()) {
                    SanList kvResultLdevs;
                    error = errorInfo.createError();
                    this.setError(error);
                    if (this.iApplyType == 4) {
                        kvResultLdevs = kvResponse.getList("Alus");
                        errList = SJctrAluErrorInfo.createList(kvResultLdevs, SJctrAluErrorInfo.ATTRI_ASLU_DELETE);
                    } else if (this.iApplyType == 5) {
                        kvResultLdevs = kvResponse.getList("Slus");
                        errList = SJctrAluErrorInfo.createList(kvResultLdevs, SJctrAluErrorInfo.ATTRI_ASLU_DELETE);
                    }
                    break block16;
                }
                if (errorInfo.isOverAll()) {
                    this.setError(errorInfo.createError());
                    return;
                }
                return;
            }
            catch (SanDataException ex) {
                error = new SJctrError(33, 5, 1049);
                this.setError(error);
            }
        }
        this.resultData = new ArrayList<SJctrError>();
        Collections.sort(this.ldevDetailList, new SJctrLdevIndexComparator());
        Collections.sort(errList);
        for (SJctrLDEVDetail ldev : this.ldevDetailList) {
            SJctrAluErrorInfo error;
            int i;
            SJctrError status = new SJctrError(32, 5, 0);
            if (this.iApplyType == 4) {
                if (ldev.getBAlu()) {
                    for (i = 0; i < errList.size(); ++i) {
                        error = (SJctrAluErrorInfo)errList.get(i);
                        if (!SJctrAluErrorInfo.chgByStr(ldev.getByAluID()).equals(SJctrAluErrorInfo.chgByStr(error.getByASluId()))) continue;
                        status = error.createError();
                        break;
                    }
                }
                if (ldev.isDPSluVol() || this.chkDrd(ldev)) {
                    status.setError(6537);
                }
            }
            if (this.iApplyType == 5) {
                if (ldev.isDPSluVol()) {
                    for (i = 0; i < errList.size(); ++i) {
                        error = (SJctrAluErrorInfo)errList.get(i);
                        if (!SJctrAluErrorInfo.chgByStr(ldev.getBySluID()).equals(SJctrAluErrorInfo.chgByStr(error.getByASluId()))) continue;
                        status = error.createError();
                        break;
                    }
                }
                if (this.chkDrd(ldev)) {
                    status.setError(6537);
                }
            }
            this.resultData.add(status);
        }
        SJctrLogUty.info(this.title, "setErrData_ASLU", "END");
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public boolean hasApplyResult() {
        boolean rtn = false;
        switch (this.iApplyType) {
            case 1: {
                rtn = this.getResultData() != null && !this.getResultData().isEmpty();
                break;
            }
            case 3: {
                rtn = true;
                break;
            }
            case 2: {
                rtn = true;
                break;
            }
            case 4: {
                rtn = true;
                break;
            }
            case 5: {
                rtn = true;
            }
        }
        return rtn;
    }

    @Override
    public int getLeadTime() {
        int rtn = 0;
        switch (this.iApplyType) {
            case 1: {
                rtn = 480;
                break;
            }
            case 3: {
                rtn = (this.getQSDelData().getSize() / 256 + 1) * 40;
                break;
            }
            case 2: {
                rtn = (this.getHDPDelData().getSize() / 256 + 1) * 40;
                break;
            }
            case 4: {
                rtn = (this.getAlulist().size() / 256 + 1) * 40;
                break;
            }
            case 5: {
                rtn = (this.getSlulist().size() / 256 + 1) * 40;
            }
        }
        return rtn;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<EXDsetPgOperation_IN> applyList = new ArrayList<EXDsetPgOperation_IN>();
        switch (this.iApplyType) {
            case 1: {
                applyList.addAll(this.getBasicDelData());
                break;
            }
            case 3: {
                applyList.add(this.getQSDelData());
                break;
            }
            case 2: {
                applyList.add(this.getHDPDelData());
                break;
            }
            case 4: {
                applyList.add((EXDsetPgOperation_IN)this.getAluDelData());
                break;
            }
            case 5: {
                applyList.add((EXDsetPgOperation_IN)this.getSluDelData());
            }
        }
        return applyList;
    }

    private ArrayList getBasicDelData() {
        ArrayList rtn = null;
        rtn = this.createApplyList();
        return rtn;
    }

    private EXDsetQSReleaseVvol_IN getQSDelData() {
        EXDsetQSReleaseVvol_IN DelVol_QS = new EXDsetQSReleaseVvol_IN();
        for (SJctrLDEVDetail ldevDetail : this.ldevDetailList) {
            if (ldevDetail.getByVolumeType() != 2) continue;
            EXDPGOperation DELInfo = new EXDPGOperation();
            DELInfo.iFB4 = ldevDetail.getIFB4();
            DELInfo.iPG = ldevDetail.getIPG();
            DelVol_QS.setPG(DELInfo);
        }
        return DelVol_QS;
    }

    private EXDsetAOUReleaseVvol_IN getHDPDelData() {
        EXDsetAOUReleaseVvol_IN DelVol_AOU = new EXDsetAOUReleaseVvol_IN();
        for (SJctrLDEVDetail ldevDetail : this.ldevDetailList) {
            if (ldevDetail.getByVolumeType() != 3 || ldevDetail.getBSlu() || this.chkDrd(ldevDetail)) continue;
            EXDPGOperation DELInfo = new EXDPGOperation();
            DELInfo.iFB4 = ldevDetail.getIFB4();
            DELInfo.iPG = ldevDetail.getIPG();
            DelVol_AOU.setPG(DELInfo);
        }
        return DelVol_AOU;
    }

    private SanRequest getAluDelData() {
        SanRequest rtn = this.newRequest("VVOLdeleteAlus");
        ArrayList<SJctrLDEVDetail> aluList = this.getAlulist();
        try {
            SanList ldevs = rtn.newList("Alus");
            for (SJctrLDEVDetail ldev : aluList) {
                SanObject ldevParameter = ldevs.addObj();
                ldevParameter.putByteArray("Id", ldev.getByAluID());
                SJctrLogUty.info(this.title, "getAluDelData", "LDEVID=" + ldev.getIndexKey() + ",ALUID=" + SJctrAluErrorInfo.chgByStr(ldev.getByAluID()));
            }
        }
        catch (SanDataException e) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
        return rtn;
    }

    private SanRequest getSluDelData() {
        SanRequest rtn = this.newRequest("VVOLdeleteSlus");
        ArrayList<SJctrLDEVDetail> sluList = this.getSlulist();
        try {
            SanList ldevs = rtn.newList("Slus");
            for (SJctrLDEVDetail ldev : sluList) {
                SanObject ldevParameter = ldevs.addObj();
                ldevParameter.putByteArray("Id", ldev.getBySluID());
                SJctrLogUty.info(this.title, "getSluDelData", "LDEVID=" + ldev.getIndexKey() + ",SLUID=" + SJctrAluErrorInfo.chgByStr(ldev.getBySluID()));
            }
        }
        catch (SanDataException e) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
        }
        return rtn;
    }

    private ArrayList<SJctrLDEVDetail> getAlulist() {
        ArrayList<SJctrLDEVDetail> rtn = new ArrayList<SJctrLDEVDetail>();
        for (SJctrLDEVDetail ldevDetail : this.ldevDetailList) {
            if (ldevDetail.getByVolumeType() != 5) continue;
            rtn.add(ldevDetail);
        }
        return rtn;
    }

    private ArrayList<SJctrLDEVDetail> getSlulist() {
        ArrayList<SJctrLDEVDetail> rtn = new ArrayList<SJctrLDEVDetail>();
        for (SJctrLDEVDetail ldevDetail : this.ldevDetailList) {
            if (!ldevDetail.isDPSluVol() || this.chkDrd(ldevDetail)) continue;
            rtn.add(ldevDetail);
        }
        return rtn;
    }

    private ArrayList createApplyList() {
        ArrayList<SanRequest> rtn = new ArrayList<SanRequest>();
        Collections.sort(this.ldevDetailList, new SJctrArrayGroupIndexComparator());
        List<SJctrLDEVDetail> ldevDetailListDelCV = this.createLdevDetailListDelCV(this.ldevDetailList);
        SanRequest request = this.newRequest("MNTdeleteLdevs");
        try {
            SanList ldevs = request.newList("Ldevs");
            for (int i = 0; i < ldevDetailListDelCV.size(); ++i) {
                SJctrLDEVDetail ldevDetail = ldevDetailListDelCV.get(i);
                SanObject ldevParameter = ldevs.addObj();
                int[] id = new int[]{ldevDetail.getSLdkc(), ldevDetail.getSCu(), ldevDetail.getSLdev()};
                int[] parityGroupId = new int[]{ldevDetail.getIFB4(), ldevDetail.getIPG()};
                ldevParameter.putIntArray("Id", id);
                if (SJctrOptionMonitorUtility.isExternal(ldevDetail.getIFB4())) {
                    int[] externalGroupId = new int[]{ldevDetail.getIFB4() - 100, ldevDetail.getIPG()};
                    ldevParameter.putIntArray("ExternalGroupId", externalGroupId);
                    continue;
                }
                ldevParameter.putIntArray("ParityGroupId", parityGroupId);
            }
            if (ldevDetailListDelCV.size() > 0) {
                rtn.add(request);
            }
        }
        catch (SanDataException e) {
            SJctrError error = new SJctrError(33, 5, 1049);
            this.setError(error);
            SJctrLogUty.error(this.getClass().getSimpleName(), "createApplyList", "Failed to build MNTdeleteLdevs parameter", e);
        }
        Collections.sort(this.ldevDetailList, new SJctrLdevIndexComparator());
        return rtn;
    }

    private List<SJctrLDEVDetail> createLdevDetailListDelCV(List<SJctrLDEVDetail> ldevDetailList) {
        ArrayList<SJctrLDEVDetail> ldevDetailListDelCV = new ArrayList<SJctrLDEVDetail>();
        for (int i = 0; i < ldevDetailList.size(); ++i) {
            SJctrLDEVDetail ldevDetail = ldevDetailList.get(i);
            if (ldevDetail.getByVolumeType() != 0 && ldevDetail.getByVolumeType() != 1) continue;
            ldevDetailListDelCV.add(ldevDetail);
        }
        return ldevDetailListDelCV;
    }

    public void setWizardSetData(List<SJctrLDEVDetail> ldevDetailList, int iApplyType, boolean bChkDRD) {
        this.ldevDetailList = ldevDetailList;
        this.iApplyType = iApplyType;
        this.bChkDRD = bChkDRD;
    }

    public ArrayList getApplyList(List<SJctrLDEVDetail> ldevDetailList) {
        SJctrDeleteLogicalDevicesAC ac;
        ArrayList<SJctrDeleteLogicalDevicesAC> rtn = new ArrayList<SJctrDeleteLogicalDevicesAC>();
        if (this.getBasicDelData().size() > 0) {
            ac = new SJctrDeleteLogicalDevicesAC();
            ac.setWizardSetData(ldevDetailList, 1, this.bChkDRD);
            rtn.add(ac);
        }
        if (this.getHDPDelData().getSize() > 0) {
            ac = new SJctrDeleteLogicalDevicesAC();
            ac.setWizardSetData(ldevDetailList, 2, this.bChkDRD);
            rtn.add(ac);
        }
        if (this.getQSDelData().getSize() > 0) {
            ac = new SJctrDeleteLogicalDevicesAC();
            ac.setWizardSetData(ldevDetailList, 3, this.bChkDRD);
            rtn.add(ac);
        }
        if (this.getAlulist().size() > 0) {
            ac = new SJctrDeleteLogicalDevicesAC();
            ac.setWizardSetData(ldevDetailList, 4, this.bChkDRD);
            rtn.add(ac);
        }
        if (this.getSlulist().size() > 0) {
            ac = new SJctrDeleteLogicalDevicesAC();
            ac.setWizardSetData(ldevDetailList, 5, this.bChkDRD);
            rtn.add(ac);
        }
        return rtn;
    }

    private boolean chkDrd(SJctrLDEVDetail ldevDetail) {
        return this.bChkDRD && ldevDetail.chkAshyncTargetDelLdev_DRD();
    }
}

