/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editalert.settings.tab.email.dc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertDef;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertUtility;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.dialog.addaddress.SJctrAddAddressDialogDC;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.dialog.changeset.SJctrChangeSettingsDialogDC;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.model.SJctrEmailDialogData;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.model.SJctrEmailSettingsAddressFromModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.model.SJctrEmailSettingsAddressReplyToModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.model.SJctrEmailSettingsData;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.model.SJctrEmailSettingsMailNoticeModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.model.SJctrEmailSettingsMailServerModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.model.SJctrEmailSettingsModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.model.SJctrEmailSettingsRowData;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.model.SJctrEmailSettingsSMTPAccountModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.model.SJctrEmailSettingsSMTPAuthModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.model.SJctrEmailSettingsSMTPPasswordModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.model.SJctrEmailSettingsTableDataModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.email.model.SJctrEmailSettingsTestButtonModel;
import sanproject.sn2.controller.wizard.tabmanage.dc.SJctrTabManageDataController;
import sanproject.sn2.controller.wizard.tabmanage.model.SJctrMultiInheritedData;
import sanproject.sn2.controller.wizard.tabmanage.sub.SJctrTabManageSubDC;

public class SJctrEmailSettingsSubDC
extends SJctrTabManageSubDC
implements SJctrEditAlertDef {
    private boolean isTableEdited = false;
    private SJctrCheckBoxDataModel editFlg;
    private SJctrEmailSettingsMailNoticeModel mailNotice;
    private SJctrEmailSettingsAddressFromModel addrFrom;
    private SJctrEmailSettingsAddressReplyToModel addrReply;
    private SJctrEmailSettingsMailServerModel mailSrv;
    private SJctrEmailSettingsSMTPAuthModel smtpAuth;
    private SJctrEmailSettingsSMTPAccountModel account;
    private SJctrEmailSettingsSMTPPasswordModel password;
    private SJctrEmailSettingsModel settingTable;
    private SJctrEmailSettingsTestButtonModel testBtn;

    public SJctrEmailSettingsSubDC(SJctrTabManageDataController managerDC) throws SJcException {
        super(managerDC);
    }

    @Override
    protected void initListener() {
        this.addMessageEventListener(NOTIFY_EMAIL_SETTINGS.PUSH_EMAIL_ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEmailSettingsSubDC.this.doActionAddAddress();
                SJctrEmailSettingsSubDC.this.isTableEdited = true;
            }
        });
        this.addMessageEventListener(NOTIFY_EMAIL_SETTINGS.PUSH_EMAIL_CHG, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEmailSettingsSubDC.this.doActionChangeSettings();
                SJctrEmailSettingsSubDC.this.isTableEdited = true;
            }
        });
        this.addMessageEventListener(NOTIFY_EMAIL_SETTINGS.PUSH_EMAIL_DEL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEmailSettingsSubDC.this.doActionDeleteAddress();
                SJctrEmailSettingsSubDC.this.isTableEdited = true;
            }
        });
        this.addMessageEventListener(NOTIFY_EMAIL_SETTINGS.PUSH_TEST_MAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEmailSettingsSubDC.this.doActionSendTestEmail();
            }
        });
    }

    @Override
    public boolean checkStartData() {
        return true;
    }

    @Override
    public boolean checkConstructData() {
        SJctrEmailSettingsData data = this.getEmailSettingsData();
        this.mailNotice.updateDataModel();
        this.mailNotice.setSelectedRadioButton(data.getMailNotice());
        this.addrFrom.updateDataModel();
        this.addrFrom.setAddressText(data.getAddressFrom());
        this.addrReply.updateDataModel();
        this.addrReply.setAddressText(data.getAddressReplyTo());
        this.mailSrv.updateDataModel();
        this.mailSrv.setServerType(data.getMailServerType());
        this.mailSrv.setServerText(data.getMailSeverText());
        this.smtpAuth.updateDataModel();
        this.smtpAuth.setSelectedRadioButton(data.getSmtpAuth());
        this.account.updateDataModel();
        this.account.setAccountText(data.getAccount());
        this.password.updateDataModel();
        this.password.setPasswordText(data.getPassword());
        boolean isAllowed = this.getOwner().getAuthorizeContainer().getRoleResourceContainer().checkAuthority(33);
        if (!isAllowed) {
            this.mailNotice.setEnableAll(false);
            this.addrFrom.setEnableAll(false);
            this.addrReply.setEnableAll(false);
            this.mailSrv.setEnableAll(false);
            this.smtpAuth.setEnableAll(false);
            this.account.setEnableAll(false);
            this.password.setEnableAll(false);
            this.settingTable.setEnableAll(false);
            this.testBtn.setEnableAll(false);
        }
        return true;
    }

    private SJctrEmailSettingsData getEmailSettingsData() {
        SJctrEmailSettingsData data = new SJctrEmailSettingsData(SJctrEditAlertUtility.getMailEnvInfo());
        ArrayList<SJctrEmailSettingsData> array = new ArrayList<SJctrEmailSettingsData>();
        array.add(data);
        this.putCache(KEY_CLASS_EMAIL_SETTINGS, array);
        return data;
    }

    @Override
    public boolean checkEndData() {
        this.addrFrom.chkData();
        this.addrReply.chkData();
        this.mailSrv.chkData();
        this.account.chkData();
        this.password.chkData();
        SJctrEmailSettingsTableDataModel tableModel = ((SJctrEmailSettingsModel)this.getDataObjectModel("COM_EMAIL_SETTINGS")).getTable();
        if (this.mailNotice.getSelectedRadioButton() == 1 && tableModel.getRowCount() == 0) {
            SJctrEditAlertUtility.errorMsg(86, 22, 205033);
        }
        return true;
    }

    @Override
    public void createInheritedData(SJctrMultiInheritedData data) {
        data.putInheritedData(KEY_CLASS_EMAIL_SETTINGS, this.updateEmailCache());
    }

    private List<?> updateEmailCache() {
        List<?> list = this.getCache(KEY_CLASS_EMAIL_SETTINGS);
        SJctrEmailSettingsData emailData = (SJctrEmailSettingsData)list.get(0);
        emailData.setMailNotice((byte)this.mailNotice.getSelectedRadioButton());
        emailData.setAddressFrom(this.addrFrom.getAddressText());
        emailData.setAddressReplyTo(this.addrReply.getAddressText());
        emailData.setMailServerType((byte)this.mailSrv.getServerType());
        emailData.setMailServerText(this.mailSrv.getServerText());
        emailData.setSmtpAuth((byte)this.smtpAuth.getSelectedRadioButton());
        emailData.setAccount(this.account.getAccountText());
        emailData.setPassword(this.password.getPasswordText());
        emailData.setInfoEdited(this.editFlg.isSelect());
        emailData.setTableEdited(this.isTableEdited);
        return list;
    }

    @Override
    public Map<String, SJctrDataObjectModel<?>> getDataObjects() {
        LinkedHashMap map = new LinkedHashMap();
        this.editFlg = new SJctrCheckBoxDataModel();
        map.put("COM_EMAIL_EDITED", this.editFlg);
        this.mailNotice = new SJctrEmailSettingsMailNoticeModel();
        map.put("COM_MAIL_NOTICE", this.mailNotice);
        this.addrFrom = new SJctrEmailSettingsAddressFromModel();
        map.put("COM_MAIL_ADDRESS_FROM", this.addrFrom);
        this.addrReply = new SJctrEmailSettingsAddressReplyToModel();
        map.put("COM_MAIL_ADDRESS_REPLY_TO", this.addrReply);
        this.mailSrv = new SJctrEmailSettingsMailServerModel();
        map.put("COM_MAIL_SERVER", this.mailSrv);
        this.smtpAuth = new SJctrEmailSettingsSMTPAuthModel();
        map.put("COM_SMTP_AUTH", this.smtpAuth);
        this.account = new SJctrEmailSettingsSMTPAccountModel();
        map.put("COM_SMTP_ACCOUNT", this.account);
        this.password = new SJctrEmailSettingsSMTPPasswordModel();
        map.put("COM_SMTP_PASSWORD", this.password);
        this.settingTable = new SJctrEmailSettingsModel();
        map.put("COM_EMAIL_SETTINGS", this.settingTable);
        this.testBtn = new SJctrEmailSettingsTestButtonModel();
        map.put("COM_TEST_EMAIL", this.testBtn);
        return map;
    }

    @Override
    public String getTabName() {
        return this.getOwner().getComUtility().getGuidance("EMAIL");
    }

    public void doActionAddAddress() {
        SJctrEmailSettingsTableDataModel tableModel = ((SJctrEmailSettingsModel)this.getDataObjectModel("COM_EMAIL_SETTINGS")).getTable();
        if (tableModel.getRowCount() == 32) {
            SJctrEditAlertUtility.errorMsg(86, 22, 205032);
        }
        SJctrEmailDialogData dialogData = this.getEmailDialogData(null);
        this.openEmailDialog(SJctrAddAddressDialogDC.class, dialogData);
    }

    public void doActionChangeSettings() {
        SJctrEmailSettingsTableDataModel tableModel = ((SJctrEmailSettingsModel)this.getDataObjectModel("COM_EMAIL_SETTINGS")).getTable();
        SJctrEmailDialogData dialogData = this.getEmailDialogData(tableModel.getSelectedRowData());
        this.openEmailDialog(SJctrChangeSettingsDialogDC.class, dialogData);
    }

    public void doActionDeleteAddress() {
        SJctrEmailSettingsTableDataModel tableModel = ((SJctrEmailSettingsModel)this.getDataObjectModel("COM_EMAIL_SETTINGS")).getTable();
        List<?> dataList = this.getCache(KEY_CLASS_EMAIL_SETTINGS);
        SJctrEmailSettingsData emailData = (SJctrEmailSettingsData)this.getCache(KEY_CLASS_EMAIL_SETTINGS).get(0);
        Map<String, Byte> addrMap = emailData.getAddressSettings();
        for (Object obj : tableModel.getSelectedRowData()) {
            SJctrEmailSettingsRowData row = (SJctrEmailSettingsRowData)obj;
            addrMap.remove(row.getAddress());
        }
        this.putCache(KEY_CLASS_EMAIL_SETTINGS, dataList);
        tableModel.doRefresh();
    }

    public void doActionSendTestEmail() {
        SJctrEmailSettingsTableDataModel tableModel = ((SJctrEmailSettingsModel)this.getDataObjectModel("COM_EMAIL_SETTINGS")).getTable();
        if (tableModel.getRowCount() == 0) {
            SJctrEditAlertUtility.errorMsg(86, 22, 205033);
        }
        List<?> list = this.updateEmailCache();
        SJctrEmailSettingsData emailData = (SJctrEmailSettingsData)list.get(0);
        SJctrEditAlertUtility.sendMAILgetMailTestSend(emailData.getTestMAILgetMailEnvInfo());
        SJctrEditAlertUtility.errorMsg(86, 22, 209002);
    }

    @Override
    public void doActionDialogClosed(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
        Object notifyObj = event.getNofifyObject();
        if (notifyObj instanceof Map) {
            Map map = (Map)notifyObj;
            List dialogDataList = (List)map.get("COM_DIALOG_DATA");
            SJctrEmailDialogData dialogData = (SJctrEmailDialogData)dialogDataList.get(0);
            List<?> dataList = this.getCache(KEY_CLASS_EMAIL_SETTINGS);
            SJctrEmailSettingsData emailData = (SJctrEmailSettingsData)dataList.get(0);
            emailData.setAddressSettings(dialogData.getSettingsTableData());
            this.putCache(KEY_CLASS_EMAIL_SETTINGS, dataList);
            ((SJctrEmailSettingsModel)this.getDataObjectModel("COM_EMAIL_SETTINGS")).getTable().doRefresh();
        }
    }

    private void openEmailDialog(Class<? extends SJctrDialogDataController> dialogClass, SJctrEmailDialogData dialogData) {
        ArrayList<SJctrEmailDialogData> list = new ArrayList<SJctrEmailDialogData>();
        list.add(dialogData);
        HashMap dataMap = new HashMap();
        dataMap.put("COM_DIALOG_DATA", list);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(dialogClass, dataMap);
        this.addUpdateDisp(relatedObj);
    }

    private SJctrEmailDialogData getEmailDialogData(List<Object> selectedList) {
        SJctrEmailDialogData data = new SJctrEmailDialogData();
        SJctrEmailSettingsData emailData = (SJctrEmailSettingsData)this.getCache(KEY_CLASS_EMAIL_SETTINGS).get(0);
        data.setSettingsTableData(emailData.getAddressSettings());
        data.setSelectedList(selectedList);
        return data;
    }

    public static enum NOTIFY_EMAIL_SETTINGS implements SJctrNotifyState
    {
        PUSH_EMAIL_ADD,
        PUSH_EMAIL_CHG,
        PUSH_EMAIL_DEL,
        PUSH_TEST_MAIL;

    }
}

