/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editalert.settings.tab.snmp.dialog.model;

import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrIpAddrUtility;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertDef;
import sanproject.sn2.controller.wizard.editalert.com.SJctrIPv6ShortAddressChanger;
import sanproject.sn2.controller.wizard.editalert.settings.com.SJctrAlertDataModel;

public class SJctrManagerIPAddressModel
extends SJctrSimpleDataModel
implements SJctrEditAlertDef,
SJctrAlertDataModel {
    private SJctrRadioButtonGroupDataModel radioModel;
    private SJctrTextBoxDataModel textModel;

    public SJctrManagerIPAddressModel() {
        this.initDataModel();
    }

    private void initDataModel() {
        this.radioModel = new SJctrRadioButtonGroupDataModel();
        this.addDataModel("COM_RADIO", this.radioModel);
        this.textModel = new SJctrTextBoxDataModel();
        this.addDataModel("COM_TEXT", this.textModel);
    }

    public void setAddressText(String text) {
        this.textModel.setValue(text);
    }

    public String getAddressText() {
        return this.textModel.getValue();
    }

    public String getRegularAddressText() throws SJcException {
        String text = this.textModel.getValue();
        if (this.radioModel.isSelect("COM_IPV4")) {
            return new SJctrIpAddrUtility.IPv4().toRegularWithUsableCheck(text);
        }
        return SJctrIPv6ShortAddressChanger.getIPv6ShortAddr(text);
    }

    public int getAddressType() {
        if (this.radioModel.isSelect("COM_IPV4")) {
            return 4;
        }
        return 6;
    }

    public boolean chkData() {
        boolean isCorrect = true;
        String text = this.textModel.getValue();
        isCorrect = this.radioModel.isSelect("COM_IPV4") ? new SJctrIpAddrUtility.IPv4().chkRegex(text) : new SJctrIpAddrUtility.IPv6().chkRegex(text);
        return isCorrect;
    }

    @Override
    public void updateDataModel() {
        this.radioModel.add("COM_IPV4", this.getComUtility().getGuidance("IPV4"));
        this.radioModel.add("COM_IPV6", this.getComUtility().getGuidance("IPV6"));
        this.radioModel.setSelect("COM_IPV4");
    }

    @Override
    public void setEnableAll(boolean flag) {
        this.radioModel.setEnable(flag);
        this.textModel.setEnable(flag);
    }
}

