/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.editalert.settings.tab.syslog.dc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.SJcMessage;
import sanproject.sn2.com.utility.SJcProductUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertDef;
import sanproject.sn2.controller.wizard.editalert.com.SJctrEditAlertUtility;
import sanproject.sn2.controller.wizard.editalert.settings.tab.syslog.model.SJctrEditAlertSyslogSettingData;
import sanproject.sn2.controller.wizard.editalert.settings.tab.syslog.model.SJctrSendTestButtonModel;
import sanproject.sn2.controller.wizard.editalert.settings.tab.syslog.model.SJctrSyslogTestResultObject;
import sanproject.sn2.controller.wizard.syslogbase.com.SJctrSyslogUtility;
import sanproject.sn2.controller.wizard.syslogbase.dc.SJctrSyslogSettingBaseSubDC;
import sanproject.sn2.controller.wizard.syslogbase.model.SJctrCertificationFileTextBox;
import sanproject.sn2.controller.wizard.tabmanage.dc.SJctrTabManageDataController;
import sanproject.sn2.controller.wizard.tabmanage.model.SJctrMultiInheritedData;
import sanproject.syslog.communicator.SyslogCommunicator;
import sanproject.syslog.enums.SyslogServerType;
import sanproject.syslog.enums.SyslogType;

public class SJctrEditSyslogSettingsSubDC
extends SJctrSyslogSettingBaseSubDC
implements SJctrEditAlertDef {
    protected SJctrSyslogTestResultObject testResult;
    protected SJctrSendTestButtonModel testBtn;

    public SJctrEditSyslogSettingsSubDC(SJctrTabManageDataController managerDC) throws SJcException {
        super(managerDC, SyslogType.SimSyslog);
    }

    @Override
    public String getTabName() {
        return this.getOwner().getComUtility().getGuidance("SYSLOG_SN2");
    }

    @Override
    protected void initListener() {
        super.initListener();
        this.addMessageEventListener(NOTIFY_ALERT_SYSLOG_SETTINGS.PUSH_SEND_TEST, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditSyslogSettingsSubDC.this.doActionSendTest();
            }
        });
    }

    @Override
    public Map<String, SJctrDataObjectModel<?>> getDataObjects() {
        Map<String, SJctrDataObjectModel<?>> map = this.getBaseDataObjects();
        this.testBtn = new SJctrSendTestButtonModel();
        map.put("COM_SEND_TEST_SYSLOG", this.testBtn);
        this.testResult = new SJctrSyslogTestResultObject();
        map.put("COM_SYSLOG_TEST_RESULT", this.testResult);
        return map;
    }

    @Override
    public boolean checkStartData() {
        return true;
    }

    @Override
    public boolean checkConstructData() {
        SJctrEditAlertSyslogSettingData data = this.getSyslogSettingData();
        this.transfer.organizeDataModel(data);
        this.primary.initItems();
        this.primary.setSelectEnabled(data.isEnablePrimary());
        this.primarySrv.organizeDataModel(data);
        this.secondary.initItems();
        this.secondary.setSelectEnabled(data.isEnableSecondary());
        this.secondarySrv.organizeDataModel(data);
        this.location.setValue(data.getLocation());
        this.timeout.setValue(Integer.toString(data.getTimeout()));
        this.interval.setValue(Integer.toString(data.getInterval()));
        this.retries.setValue(Integer.toString(data.getNumOfRetries()));
        this.checkRequiredFile();
        boolean isAllowed = this.getOwner().getAuthorizeContainer().getRoleResourceContainer().checkAuthority(33);
        if (!isAllowed) {
            this.transfer.setEnable(false);
            this.primary.setEnable(false);
            this.primarySrv.setEnableAll(false);
            this.secondary.setEnable(false);
            this.secondarySrv.setEnableAll(false);
            this.location.setEnable(false);
            this.timeout.setEnable(false);
            this.interval.setEnable(false);
            this.retries.setEnable(false);
            this.testBtn.setEnable(false);
        }
        return true;
    }

    private SJctrEditAlertSyslogSettingData getSyslogSettingData() {
        SJctrEditAlertSyslogSettingData data = new SJctrEditAlertSyslogSettingData(SJctrEditAlertUtility.getSIMSyslogInfo());
        ArrayList<SJctrEditAlertSyslogSettingData> array = new ArrayList<SJctrEditAlertSyslogSettingData>();
        array.add(data);
        this.putCache(KEY_CLASS_SYSLOG_SETTING_DATA, array);
        return data;
    }

    @Override
    public void createInheritedData(SJctrMultiInheritedData data) {
        List<?> list = this.getCache(KEY_CLASS_SYSLOG_SETTING_DATA);
        SJctrEditAlertSyslogSettingData syslogData = (SJctrEditAlertSyslogSettingData)list.get(0);
        this.setBaseInheritedData(syslogData);
        SyslogCommunicator communicator = SyslogCommunicator.createCertificateCommitter(SyslogType.SimSyslog, syslogData.isUploadedClientPrimary(), syslogData.getPassPrimary(), syslogData.isUploadedClientSecondary(), syslogData.getPassSecondary(), syslogData.isUploadedRootPrimary(), syslogData.isUploadedRootSecondary());
        if (syslogData.isEdited() && syslogData.isSelectedTLS()) {
            syslogData.setCommunicator(communicator);
        }
        data.putInheritedData(KEY_CLASS_SYSLOG_SETTING_DATA, list);
    }

    @Override
    public boolean checkEndData() {
        this.testResult.clearResult();
        return this.checkEndBaseData();
    }

    @Override
    public void doActionDialogClosed(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
    }

    private void doActionSendTest() {
        List<?> list = this.getCache(KEY_CLASS_SYSLOG_SETTING_DATA);
        SJctrEditAlertSyslogSettingData syslogData = (SJctrEditAlertSyslogSettingData)list.get(0);
        this.setBaseInheritedData(syslogData);
        String userName = this.getOwner().getUserSession().getUserName();
        int sessionID = this.getOwner().getUserSession().getSessionIdentificationID();
        String strSessionID = String.valueOf(sessionID);
        String serialNo = SJcProductUty.getSerialNumber();
        serialNo = SJctrSyslogUtility.paddingZeroHead(serialNo, 5);
        this.testResult.clearResult();
        this.checkEndBaseData();
        this.doActionSendTestPrimary(syslogData, userName, serialNo, strSessionID);
        this.doActionSendTestSecondary(syslogData, userName, serialNo, strSessionID);
        this.setDirtyAll();
    }

    private void doActionSendTestPrimary(SJctrEditAlertSyslogSettingData syslogData, String userName, String serialNo, String sessionID) {
        SJcMessage msg = null;
        if (syslogData.getTransportType() == 2) {
            if (this.primary.isSelectedEnable()) {
                msg = SyslogCommunicator.sendTLS(SyslogType.SimSyslog, SyslogServerType.Primary, syslogData.isUploadedClientPrimary(), syslogData.getPassPrimary(), syslogData.isUploadedRootPrimary(), syslogData.getIpTextPrimary(), syslogData.getPortNumPrimary(), (byte)syslogData.getTimeout(), serialNo, userName, syslogData.getLocation(), sessionID);
            }
        } else if (this.primary.isSelectedEnable()) {
            msg = SyslogCommunicator.sendUDP(SyslogType.SimSyslog, SyslogServerType.Primary, syslogData.getIpTextPrimary(), syslogData.getPortNumPrimary(), serialNo, userName, syslogData.getLocation(), sessionID);
        }
        this.testResult.setResultPrimary(msg);
    }

    private void doActionSendTestSecondary(SJctrEditAlertSyslogSettingData syslogData, String userName, String serialNo, String sessionID) {
        SJcMessage msg = null;
        if (syslogData.getTransportType() == 2) {
            if (this.secondary.isSelectedEnable()) {
                msg = SyslogCommunicator.sendTLS(SyslogType.SimSyslog, SyslogServerType.Secondary, syslogData.isUploadedClientSecondary(), syslogData.getPassSecondary(), syslogData.isUploadedRootSecondary(), syslogData.getIpTextSecondary(), syslogData.getPortNumSecondary(), (byte)syslogData.getTimeout(), serialNo, userName, syslogData.getLocation(), sessionID);
            }
        } else if (this.secondary.isSelectedEnable()) {
            msg = SyslogCommunicator.sendUDP(SyslogType.SimSyslog, SyslogServerType.Secondary, syslogData.getIpTextSecondary(), syslogData.getPortNumSecondary(), serialNo, userName, syslogData.getLocation(), sessionID);
        }
        this.testResult.setResultSecondary(msg);
    }

    @Override
    protected void openFileDialog(SJctrCertificationFileTextBox crt) {
        this.testResult.clearResult();
        super.openFileDialog(crt);
    }

    public static enum NOTIFY_ALERT_SYSLOG_SETTINGS implements SJctrNotifyState
    {
        PUSH_SEND_TEST;

    }
}

