/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.backupkeys;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.utility.SJcFileUty;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.password.SJctrPassUtility;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyGenerationInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.system.manager.SJmoEncryptionKeyInfoMgr;

public class SJctrBackupKeysDC
extends SJctrWizardDataController {
    protected static final int DISP_ID = 17827889;
    private SJctrTextBoxDataModel passwordText;
    private SJctrTextBoxDataModel reEntPasswordText;
    private SJctrFooterDataModel footer;

    public SJctrBackupKeysDC() {
        super(17827889);
        this.initDataModel();
    }

    private void initDataModel() {
        this.passwordText = new SJctrTextBoxDataModel();
        this.addDataObjectModel("COM_PASSWORD", this.passwordText);
        this.reEntPasswordText = new SJctrTextBoxDataModel();
        this.addDataObjectModel("COM_REENTER_PASSWORD", this.reEntPasswordText);
        this.footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", this.footer);
    }

    @Override
    public boolean checkStartData() {
        boolean bRtn = true;
        return bRtn;
    }

    @Override
    public boolean checkConstructData() {
        boolean bRtn = true;
        ArrayList transDataList = new ArrayList();
        Object transData = null;
        List<Object> encKeyMgrList = new ArrayList();
        SJmoEncryptionKeyInfoMgr encKeyMgr = null;
        ArrayList alEncryptionKeyInfoDEK = new ArrayList();
        ArrayList alEncryptionKeyInfoCEK = new ArrayList();
        ArrayList alEncryptionKeyInfoKEK = new ArrayList();
        Object encKeyIndo = null;
        List<Object> subsytemInfoList = new ArrayList();
        SJmoSubsystemInfo subsystemInfo = null;
        ArrayList<String> backupFileNameList = new ArrayList<String>();
        String strBackupFileName = "";
        boolean iCnt = false;
        boolean iIndex = false;
        encKeyMgrList = this.getCache(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR);
        if (encKeyMgrList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "encKeyMgrList size0");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        encKeyMgr = (SJmoEncryptionKeyInfoMgr)encKeyMgrList.get(0);
        alEncryptionKeyInfoDEK = encKeyMgr.getAlEncryptionKeyInfoDEK();
        alEncryptionKeyInfoCEK = encKeyMgr.getAlEncryptionKeyInfoCEK();
        alEncryptionKeyInfoKEK = encKeyMgr.getAlEncryptionKeyInfoKEK();
        SJmoEncryptionKeyGenerationInfo chkPolicy = encKeyMgr.getGenerationInfo();
        if (chkPolicy.getIEncKeyGenerationInfo() <= -1) {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
            return false;
        }
        if (chkPolicy.getIEncKeyGenerationInfo() == 0) {
            SJctrEncryptionKeysUtility.createErrorDialog(105493);
            return false;
        }
        SJctrEncryptionKeysUtility.chkKekKey(encKeyMgrList);
        if (alEncryptionKeyInfoDEK.isEmpty() && alEncryptionKeyInfoCEK.isEmpty() && alEncryptionKeyInfoKEK.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "EncryptionKey isEmpty");
            SJctrEncryptionKeysUtility.createErrorDialog(105471);
        }
        if ((subsytemInfoList = this.getCache(SJctrEncryptionKeysUtility.KEY_CLASS_SUBSYSTEM_INFO)).size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "subsytemInfoList size0");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        subsystemInfo = (SJmoSubsystemInfo)subsytemInfoList.get(0);
        strBackupFileName = this.getComUtility().getEncryptionKeysUtility().makeBackupFileName(subsystemInfo);
        backupFileNameList.add(strBackupFileName);
        SJctrComUtility comUty = this.getComUtility();
        String strLabel = SJctrPassUtility.toDispPolicyLabel("enc_rule.properties", comUty, 255);
        this.passwordText.setLabel(strLabel);
        this.putCache("KEY_BACKUP_FILE_NAME", backupFileNameList);
        return bRtn;
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        if (SJcFileUty.exists("enctmp")) {
            SJcFileUty.deleteFile("", "enctmp");
        }
    }

    @Override
    public boolean checkEndData() {
        boolean bRtn = true;
        String strPassWord = "";
        String strReEntPassWord = "";
        ArrayList<String> passWordList = new ArrayList<String>();
        strPassWord = this.passwordText.getValue();
        strReEntPassWord = this.reEntPasswordText.getValue();
        SJctrPassUtility.chkPass("enc_rule.properties", strPassWord, 255);
        if (!strPassWord.equals(strReEntPassWord)) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEndData", "password unmatch");
            SJctrEncryptionKeysUtility.createErrorDialog(106081);
        }
        passWordList.add(strPassWord);
        this.putCache("KEY_BACKUP_PASSWORD", passWordList);
        this.chkFinishBtn(false);
        return bRtn;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> setReq = super.getModelDirect();
        setReq.add(this.createModelDirect(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR));
        setReq.add(this.createModelDirect(SJctrEncryptionKeysUtility.KEY_CLASS_SUBSYSTEM_INFO));
        return setReq;
    }

    public SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> reqClass) {
        SJctrGetDirectWrapper directWrapper = null;
        SJmoGetKind_IF kind = null;
        SJmoGetRange_IF range = null;
        ArrayList filterList = null;
        SJmoGetDirect direct = null;
        try {
            kind = reqClass.newInstance();
            range = null;
            filterList = new ArrayList();
            direct = new SJmoGetDirect(kind, range, filterList);
            directWrapper = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException insExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "SJctrGetDirectWrapper", "InstantiationException");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        catch (IllegalAccessException illExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "SJctrGetDirectWrapper", "IllegalAccessException");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        return directWrapper;
    }

    @Override
    public String getDispName() {
        String strTaskName = this.getComUtility().getGuidance("BACKUP_KEYS_TO_FILE");
        return strTaskName;
    }

    public void chkFinishBtn(boolean bFlg) {
        SJctrDataObjectModel<? extends SJctrDataObject> dataModel = this.getDataObjectModel("COM_FOOTER");
        SJctrFooterDataModel footer = (SJctrFooterDataModel)dataModel;
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(bFlg);
    }
}

