/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.kmip.restorekeys.ctrl;

import java.util.List;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.kmip.restorekeys.model.SJctrRestoreKeysFromServerTableModel;
import sanproject.sn2.kms.common.SJkmsReferInfo;
import sanproject.sn2.kms.util.SJkmsCommunicationUty;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevStatusInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgEncryptionInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPgLdevInfo;
import sanproject.sn2.model.connector.kind.SJmoGetSubsystemInfo;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyGenerationInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.system.manager.SJmoEncryptionKeyInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoPgEncryptionInfo;
import sanproject.sn2.model.data.volume.SJmoPgLdevInfo;

public class SJctrRestoreKeysFromServerDC
extends SJctrWizardDataController
implements SJctrEncryptionKeyDef {
    public SJctrRestoreKeysFromServerDC() {
        super(0x1101401);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrRestoreKeysFromServerTableModel restoreTable = new SJctrRestoreKeysFromServerTableModel();
        this.addDataObjectModel("COM_TABLE", restoreTable);
        SJctrFooterDataModel footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", footer);
    }

    @Override
    public boolean checkConstructData() {
        List<?> subSystemInfoList;
        SJmoSubsystemInfo subSystemInfoNo;
        String strSubSystemInfoNo;
        List<SJkmsReferInfo> backUpList;
        SJmoEncryptionKeyInfoMgr mgr;
        SJmoEncryptionKeyGenerationInfo chkPolicy;
        boolean rtn = true;
        List<SJmoPgEncryptionInfo> pgList = null;
        pgList = this.getCache(SJctrEncryptionKeysUtility.KEY_CLASS_PGENCRYPTION_INFO);
        List<SJmoPgLdevInfo> pgLdevList = null;
        pgLdevList = this.getCache(KEY_CLASS_PGLDEV_INFO);
        List<SJmoLdevStatusInfo> stsLdevList = null;
        stsLdevList = this.getCache(KEY_CLASS_LDEVSTATUS_INFO);
        List<SJmoEncryptionKeyInfoMgr> encKeyMgrList = this.getCache(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR);
        if (encKeyMgrList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "encKeyMgrList size0");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        if ((chkPolicy = (mgr = (SJmoEncryptionKeyInfoMgr)encKeyMgrList.get(0)).getGenerationInfo()).getIEncKeyGenerationInfo() <= -1) {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
            return false;
        }
        if (chkPolicy.getIEncKeyGenerationInfo() == 0) {
            SJctrEncryptionKeysUtility.createErrorDialog(105493);
            return false;
        }
        SJctrEncryptionKeysUtility.chkKekKey(encKeyMgrList);
        SJctrEncryptionKeysUtility.checkPgBlocked(pgList, pgLdevList, stsLdevList);
        if (!SJctrEncryptionKeysUtility.kmsServerIsEnabled()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "kmsServer is False");
            SJctrEncryptionKeysUtility.createErrorDialog(105462);
        }
        if ((backUpList = SJkmsCommunicationUty.refer(strSubSystemInfoNo = (subSystemInfoNo = (SJmoSubsystemInfo)(subSystemInfoList = this.getCache(SJmoGetSubsystemInfo.class)).get(0)).getDKCSNAddString())).isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "backUpList isEmpty");
            SJctrEncryptionKeysUtility.createErrorDialog(105502);
        }
        this.putCache("COM_RESTOREINFO", backUpList);
        return rtn;
    }

    @Override
    public String getDispName() {
        String taskName = this.getComUtility().getGuidance("RESTORE_KEYS_FROM_SERVER");
        return taskName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJctrGetDirectWrapper encList = this.createModelDirect(SJmoGetPgEncryptionInfo.class);
        set.add(encList);
        SJctrGetDirectWrapper pgLdevIngo = this.createModelDirect(SJmoGetPgLdevInfo.class);
        set.add(pgLdevIngo);
        SJctrGetDirectWrapper ldevStatusInfo = this.createModelDirect(SJmoGetLdevStatusInfo.class);
        set.add(ldevStatusInfo);
        SJctrGetDirectWrapper subSystemIndo = this.createModelDirect(SJmoGetSubsystemInfo.class);
        set.add(subSystemIndo);
        set.add(this.createModelDirect(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR));
        return set;
    }

    public SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> reqClass) {
        SJctrGetDirectWrapper directWrapper = null;
        try {
            SJmoGetKind_IF kind = reqClass.newInstance();
            SJmoGetRange_IF range = null;
            List filterList = null;
            SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
            directWrapper = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException insExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "SJctrGetDirectWrapper", "InstantiationException");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        catch (IllegalAccessException illExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "SJctrGetDirectWrapper", "IllegalAccessException");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
        return directWrapper;
    }

    @Override
    public boolean checkEndData() {
        boolean rtn = true;
        SJctrRestoreKeysFromServerTableModel tableModel = null;
        tableModel = (SJctrRestoreKeysFromServerTableModel)this.getDataObjectModel("COM_TABLE");
        List<Object> selectedRowData = tableModel.getSelectedRowData();
        this.putCache("COM_RESTOREINFO", selectedRowData);
        return rtn;
    }
}

