/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.encryption.kmip.restorekeys.msg;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.base.session.SJbaseUserSession;
import sanproject.sn2.controller.com.SJctrEncryptionKeysUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionAuditLogUty;
import sanproject.sn2.controller.wizard.encryption.com.SJctrEncryptionKeyDef;
import sanproject.sn2.controller.wizard.encryption.kmip.restorekeys.ctrl.SJctrRestoreKeysFromServerAC;
import sanproject.sn2.kms.common.SJkmsReferInfo;
import sanproject.sn2.kms.util.SJkmsCommunicationUty;
import sanproject.sn2.model.data.system.SJmoEncryptionKeyGenerationInfo;
import sanproject.sn2.model.data.system.SJmoSubsystemInfo;
import sanproject.sn2.model.data.system.manager.SJmoEncryptionKeyInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;
import sanproject.sn2.model.data.volume.SJmoPgEncryptionInfo;
import sanproject.sn2.model.data.volume.SJmoPgLdevInfo;

public class SJctrRestoreKeysFromServerMsgSubWizard
extends SJctrSubWizard
implements SJctrEncryptionKeyDef {
    @Override
    public Class<?> getConfirmClass() {
        return KEY_CLASS_RESTOREKEYSRV_MSG_DC;
    }

    @Override
    public Class<?>[] getClassList() {
        return new Class[0];
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", "RESTORE_KEYS_FROM_SERVER");
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> retSet = new HashSet<SJctrGetDirectWrapper>();
        retSet.add(SJctrEncryptionKeysUtility.createModelDirect(KEY_CLASS_PGENCRYPTIONINFO));
        retSet.add(SJctrEncryptionKeysUtility.createModelDirect(KEY_CLASS_PGLDEV_INFO));
        retSet.add(SJctrEncryptionKeysUtility.createModelDirect(KEY_CLASS_LDEVSTATUS_INFO));
        retSet.add(SJctrEncryptionKeysUtility.createModelDirect(KEY_CLASS_SUBSYSTEM_INFO));
        retSet.add(SJctrEncryptionKeysUtility.createModelDirect(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR));
        return retSet;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        this.checkStartData(wizard);
        this.checkConstructData(wizard);
        List<?> restoreInfo = wizard.getCache("COM_RESTOREINFO");
        SJkmsReferInfo restoreTarget = (SJkmsReferInfo)restoreInfo.get(0);
        List<?> subsystemInfo = wizard.getCache(KEY_CLASS_SUBSYSTEM_INFO);
        String dkcNumber = ((SJmoSubsystemInfo)subsystemInfo.get(0)).getDKCSNAddString();
        SJctrUserController uc = wizard.getOwner();
        SJctrRelatedDispDataObject related = uc.createRelatedDispData(this.getConfirmClass());
        SJctrRestoreKeysFromServerAC ac = new SJctrRestoreKeysFromServerAC(dkcNumber, restoreTarget);
        ac.setBackRestAdtLog(new SJctrEncryptionAuditLogUty.SJctrBackRestoreAuditLog((SJbaseUserSession)uc.getUserSession()));
        wizard.addConfirmData(ac, related);
        SJctrEncryptionKeysUtility.addResotreAC(wizard, related);
    }

    private void checkStartData(SJctrWizardWindowDC wizard) {
        List<?> refereInfoList = wizard.getCache("COM_RESTOREINFO");
        if (refereInfoList == null) {
            SJctrLogUty.error(this.getClass().getSimpleName(), "checkConstructData", "RefereInfo is Null");
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        }
    }

    private void checkConstructData(SJctrWizardWindowDC wizard) {
        List<SJmoEncryptionKeyInfoMgr> encKeyMgrList = wizard.getCache(SJctrEncryptionKeysUtility.KEY_CLASS_ENCRYPTION_MGR);
        SJmoEncryptionKeyInfoMgr mgr = (SJmoEncryptionKeyInfoMgr)encKeyMgrList.get(0);
        SJmoEncryptionKeyGenerationInfo chkPolicy = mgr.getGenerationInfo();
        if (chkPolicy.getIEncKeyGenerationInfo() <= -1) {
            SJctrEncryptionKeysUtility.createErrorDialog(107001);
        } else if (chkPolicy.getIEncKeyGenerationInfo() == 0) {
            SJctrEncryptionKeysUtility.createErrorDialog(105493);
        }
        SJctrEncryptionKeysUtility.chkKekKey(encKeyMgrList);
        this.checkPgBlocked(wizard);
        this.checkKmsServerSetting();
        List<?> subsystemInfo = wizard.getCache(KEY_CLASS_SUBSYSTEM_INFO);
        String dkcNumber = ((SJmoSubsystemInfo)subsystemInfo.get(0)).getDKCSNAddString();
        this.checkTargetRestoreInfo(wizard, dkcNumber);
    }

    private void checkPgBlocked(SJctrWizardWindowDC wizard) {
        List<SJmoPgEncryptionInfo> pgEncryptionList = wizard.getCache(KEY_CLASS_PGENCRYPTIONINFO);
        List<SJmoPgLdevInfo> pgLdevList = wizard.getCache(KEY_CLASS_PGLDEV_INFO);
        List<SJmoLdevStatusInfo> ldevStatusList = wizard.getCache(KEY_CLASS_LDEVSTATUS_INFO);
        SJctrEncryptionKeysUtility.checkPgBlocked(pgEncryptionList, pgLdevList, ldevStatusList);
    }

    private void checkKmsServerSetting() {
        if (!SJctrEncryptionKeysUtility.kmsServerIsEnabled()) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "checkKmsServerSetting", "Key management server setting is disabled");
            SJctrEncryptionKeysUtility.createErrorDialog(105470);
        }
    }

    private void checkTargetRestoreInfo(SJctrWizardWindowDC wizard, String dkcNumber) {
        List<?> restoreInfo = wizard.getCache("COM_RESTOREINFO");
        SJkmsReferInfo restoreTarget = (SJkmsReferInfo)restoreInfo.get(0);
        List<SJkmsReferInfo> allRestoreInfo = SJkmsCommunicationUty.refer(dkcNumber);
        Collections.sort(allRestoreInfo);
        int idx = Collections.binarySearch(allRestoreInfo, restoreTarget);
        if (idx < 0) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "checkTargetBackupInfo", "RestoreTarget is not exists");
            SJctrEncryptionKeysUtility.createErrorDialog(105503);
        }
    }
}

