/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.environmental.editsystemopts;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.environmental.SJctrEnvUtility;
import sanproject.sn2.controller.wizard.environmental.com.SJctrEnvironmentalDataMacro;
import sanproject.sn2.controller.wizard.environmental.editsystemopts.SJctrEditSystemOptsConfirmData;
import sanproject.sn2.controller.wizard.environmental.editsystemopts.SJctrEditSystemOptsTableModel;
import sanproject.sn2.controller.wizard.environmental.editsystemopts.SJctrSNSystemOptionInfo;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetSystemOption;
import sanproject.sn2.model.data.system.SJmoSystemOption;

public class SJctrEditSystemOptsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1101701;
    private static final String DISP_TITLE = "EDIT_SOMS";
    private static final String SCREEN_GUID = "ENV";
    private static final String[] OPT_NAME_SN_OPTION = SJctrEnvironmentalDataMacro.GUID_SN_OPTION_NAME;
    private static final String KEY_TABLE_SN_OPTION = "COM_TABLE_SN_OPTION";
    private static final String KEY_ENABLE_SN_OPTION = "COM_ENABLE";
    private static final String KEY_DISABLE_SN_OPTION = "COM_DISABLE";

    public SJctrEditSystemOptsDC() {
        super(0x1101701);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance(DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetSystemOption kind = new SJmoGetSystemOption();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_SN_OPTION, new SJctrEditSystemOptsTableModel());
        SJctrButtonDataModel btn_enable = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ENABLE_SN_OPTION, btn_enable);
        btn_enable.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditSystemOptsDC.this.fireMessageEvent(EDIT_SYSTEM_OPTIONS_MSG.SELECT_ENABLE_SN_OPTION);
            }
        });
        SJctrButtonDataModel btn_disable = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_DISABLE_SN_OPTION, btn_disable);
        btn_disable.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrEditSystemOptsDC.this.fireMessageEvent(EDIT_SYSTEM_OPTIONS_MSG.SELECT_DISABLE_SN_OPTION);
            }
        });
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(EDIT_SYSTEM_OPTIONS_MSG.SELECT_ENABLE_SN_OPTION, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditSystemOptsDC.this.chgStatus(event, dstModel, SJctrEditSystemOptsDC.KEY_TABLE_SN_OPTION, true);
                SJctrEditSystemOptsDC.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
        this.addMessageEventListener(EDIT_SYSTEM_OPTIONS_MSG.SELECT_DISABLE_SN_OPTION, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditSystemOptsDC.this.chgStatus(event, dstModel, SJctrEditSystemOptsDC.KEY_TABLE_SN_OPTION, false);
                SJctrEditSystemOptsDC.setFinishChangeCheck(event.getSource().getDataController(), true);
            }
        });
    }

    private void chgStatus(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel, String tblKey, boolean status) {
        SJctrEditSystemOptsTableModel tableData = (SJctrEditSystemOptsTableModel)this.getDataObjectModel(tblKey);
        List<Object> selectData = tableData.getSelectedRowData();
        for (Object info : selectData) {
            ((SJctrSNSystemOptionInfo)info).setOptStatus(status);
        }
        tableData.doRefresh();
        tableData.addRowSelectionList(selectData);
        this.updateFooter();
    }

    @Override
    public boolean checkConstructData() {
        List<?> optInfoList = this.getCache(SJmoGetSystemOption.class);
        if (null == optInfoList) {
            this.logUty.putlog("checkConstructData", "Information of SN System Option List is null.");
            SJctrError err = new SJctrError(SJctrEnvironmentalDataMacro.iFUNCTION_CODE, SJctrEnvironmentalDataMacro.iMODULE_CODE, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == optInfoList.size()) {
            this.logUty.putlog("checkConstructData", "Size of SN System Option List is zero.");
            SJctrError err = new SJctrError(SJctrEnvironmentalDataMacro.iFUNCTION_CODE, SJctrEnvironmentalDataMacro.iMODULE_CODE, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoSystemOption optInfo = (SJmoSystemOption)optInfoList.get(0);
        if (null == optInfo) {
            this.logUty.putlog("checkConstructData", "Information of SN System Option is null.");
            SJctrError err = new SJctrError(SJctrEnvironmentalDataMacro.iFUNCTION_CODE, SJctrEnvironmentalDataMacro.iMODULE_CODE, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJctrSNSystemOptionInfo> optList = this.getSysOptInfoList(optInfo);
        SJctrEditSystemOptsTableModel tableData = (SJctrEditSystemOptsTableModel)this.getDataObjectModel(KEY_TABLE_SN_OPTION);
        tableData.setBasicDataList(optList);
        return true;
    }

    private List<SJctrSNSystemOptionInfo> getSysOptInfoList(SJmoSystemOption optInfo) {
        ArrayList<SJctrSNSystemOptionInfo> OptTblList = new ArrayList<SJctrSNSystemOptionInfo>();
        for (int index = 0; index < 1024; ++index) {
            boolean status = false;
            String optName = "?";
            if (optInfo.isSnSysOptBit(index)) {
                status = true;
            }
            if (index < OPT_NAME_SN_OPTION.length) {
                optName = this.getComUtility().getGuidance(SCREEN_GUID, OPT_NAME_SN_OPTION[index]);
            }
            if (optName.equals("Reserve")) {
                optName = optName + SJctrComUtility.toPaddingZeroString(index, 4);
            }
            SJctrSNSystemOptionInfo info = new SJctrSNSystemOptionInfo(index, optName, status);
            OptTblList.add(info);
        }
        return OptTblList;
    }

    @Override
    public boolean checkEndData() {
        try {
            List<Object> allRowData;
            SJctrEditSystemOptsConfirmData confirmData = new SJctrEditSystemOptsConfirmData();
            SJctrEditSystemOptsTableModel table = (SJctrEditSystemOptsTableModel)this.getDataObjectModel(KEY_TABLE_SN_OPTION);
            List<Object> sysOptInfoList = allRowData = table.getAllRowData();
            this.checkSysOptBoth5and6Set(sysOptInfoList);
            confirmData.setOptionInfoList(sysOptInfoList);
            ArrayList<SJctrEditSystemOptsConfirmData> confirmDataList = new ArrayList<SJctrEditSystemOptsConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditSystemOptsConfirmData.class, confirmDataList);
            SJctrEditSystemOptsDC.setFinishChangeCheck(this, false);
        }
        catch (SJcException exp) {
            this.logUty.putlog("checkEndData", "Confirm Information of SN System Option is Error.");
            throw SJctrEnvUtility.convEnvLogicErrorException(exp, 107003);
        }
        return true;
    }

    public static void setFinishChangeCheck(SJctrDataController dc, boolean changeCheckFlg) {
        SJctrButtonDataModel finishButton;
        SJctrFooterDataModel footer;
        if (null != dc && null != (footer = (SJctrFooterDataModel)dc.getDataObjectModel("COM_FOOTER")) && null != (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH))) {
            finishButton.setChangeCheck(changeCheckFlg);
        }
    }

    private void checkSysOptBoth5and6Set(List<SJctrSNSystemOptionInfo> sysOptInfoList) {
        SJctrSNSystemOptionInfo sysOpt5 = null;
        SJctrSNSystemOptionInfo sysOpt6 = null;
        for (SJctrSNSystemOptionInfo sysOptInfo : sysOptInfoList) {
            if (sysOptInfo.getOptIndex() == 5) {
                sysOpt5 = sysOptInfo;
                continue;
            }
            if (sysOptInfo.getOptIndex() != 6) continue;
            sysOpt6 = sysOptInfo;
        }
        if (sysOpt5 == null || sysOpt6 == null) {
            this.logUty.putlog("checkSysOptBoth5and6Set", "Either No.5 or No.6 is null.");
            throw SJctrEnvUtility.makeException(107001);
        }
        if (sysOpt5.getOptStatus() && sysOpt6.getOptStatus()) {
            this.logUty.putlog("checkSysOptBoth5and6Set", "Both No.5 and No.6 be enabled.");
            throw SJctrEnvUtility.makeException(400001);
        }
    }

    public static enum EDIT_SYSTEM_OPTIONS_MSG implements SJctrNotifyState
    {
        SELECT_ENABLE_SN_OPTION,
        SELECT_DISABLE_SN_OPTION;

    }
}

