/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.license.licensecheckresult;

import java.util.HashSet;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.license.com.SJctr1PPInfo;
import sanproject.sn2.controller.wizard.license.licensecheckresult.SJctrLicenseCheckMessageModel;
import sanproject.sn2.controller.wizard.license.licensecheckresult.SJctrLicenseCheckResultTableModel;

public class SJctrLicenseCheckResultDialogDC
extends SJctrDialogDataController {
    public static final int DISP_ID = 34664535;
    public static final String KEY_LICENSE_CHECK_ERROR = "LICENSE_CHECK_ERROR";
    public static final String KEY_MESSAGE = "COM_MESSAGE";
    public static final String KEY_TABLE = "COM_TABLE";
    private List<SJctr1PPInfo> errorPPList = null;
    private SJctrLicenseCheckMessageModel msgModel = null;
    private SJctrLicenseCheckResultTableModel tableModel = null;

    public SJctrLicenseCheckResultDialogDC() throws SJcException {
        super(34664535);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.msgModel = new SJctrLicenseCheckMessageModel();
        this.addDataObjectModel(KEY_MESSAGE, this.msgModel);
        this.tableModel = new SJctrLicenseCheckResultTableModel();
        this.addDataObjectModel(KEY_TABLE, this.tableModel);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    @Override
    public boolean checkStartData() {
        this.errorPPList = this.getCache(KEY_LICENSE_CHECK_ERROR);
        if (this.errorPPList == null || this.errorPPList.isEmpty()) {
            SJctrError sJctrError = new SJctrError(4, 22, 207001);
        }
        return true;
    }

    private void initListener() {
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.CLOSE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                List relatedList = SJctrLicenseCheckResultDialogDC.this.getRelatedDataController();
                if (relatedList != null) {
                    for (SJctrDataController dc : relatedList) {
                        dc.fireMessageEvent(CHECKRESULT_MSG.CLOSE_DIALOG, null);
                    }
                }
                SJctrLicenseCheckResultDialogDC.this.doClose();
            }
        });
    }

    @Override
    public void makeDataModel() {
        int function = 201;
        int module = 22;
        int error = 106039;
        int hicError = 0;
        HashSet<Integer> errSet = new HashSet<Integer>(this.errorPPList.size());
        for (SJctr1PPInfo errorPP : this.errorPPList) {
            hicError = errorPP.getErrCode();
            errSet.add(hicError);
        }
        if (errSet.size() == 1) {
            function = 4;
            module = 5;
            error = hicError;
        }
        this.msgModel.SetErrorCode(function, module, error);
        this.tableModel.setTableKeyData(this.errorPPList);
        super.makeDataModel();
    }

    public static enum CHECKRESULT_MSG implements SJctrNotifyState
    {
        CLOSE_DIALOG;

    }
}

