/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.addhosts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.lunm.addhosts.SJctrAddHostsConfirmData;
import sanproject.sn2.controller.wizard.lunm.addhosts.SJctrConfirmSelectedHGTableModel;
import sanproject.sn2.controller.wizard.lunm.addhosts.SJctrConfirmSelectedHostTableModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrAddHostsTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertyDC;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertySelectData;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;

public class SJctrAddHostsConfirmDC
extends SJctrConfirmDataController {
    protected static final int DISP_ID = 17825855;
    public static final String KEY_TABLE_HOSTGROUPS = "COM_TABLE_HOSTGROUPS";
    public static final String KEY_TABLE_HOSTS = "COM_TABLE_HOSTS";
    public static final int EC_START_MODEL_DATA_ERROR = 107004;
    public static final int EC_NOT_SELECT_DETAIL_DATA = 105040;
    public static final int EC_TOO_MANY_SELECT_DETAIL_DATA = 105041;
    public static final int EC_DETAIL_MODEL_NOT_FOUND = 107004;

    public SJctrAddHostsConfirmDC() throws SJcException {
        super(17825855);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> confirmDataList = this.getCache("SJctrAddHostsConfirmData");
        if (confirmDataList != null && confirmDataList.size() == 1) {
            SJctrAddHostsConfirmData confirmData = (SJctrAddHostsConfirmData)confirmDataList.get(0);
            List<SJmoPortDetail> portDetail = confirmData.getPortDetailList();
            List<SJmoPortHostGroupInfo> portHg = confirmData.getPortHgList();
            List<SJmoPortAttributeInfo> portAttr = confirmData.getPortAttributeList();
            List<SJctrAddHostsTableKey> addHostsKey = confirmData.getAddHostsInfo();
            List<SJctrPortHostGroupTableKey> addPortHgList = confirmData.getTargetPortHgList();
            if (portHg == null || portHg.size() <= 0 || portDetail == null || portDetail.size() <= 0 || portAttr == null || portAttr.size() <= 0 || addHostsKey == null || addHostsKey.size() <= 0 || addPortHgList == null || addPortHgList.size() <= 0) {
                SJctrError err = new SJctrError(10, 22, 107004);
                SJcException exp = err.createException();
                throw exp;
            }
        } else {
            SJctrError err = new SJctrError(10, 22, 107004);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_HOSTGROUPS, new SJctrConfirmSelectedHGTableModel());
        this.addDataObjectModel(KEY_TABLE_HOSTS, new SJctrConfirmSelectedHostTableModel());
    }

    private void initListener() {
        this.addMessageEventListener(CONFIRM_MSG.DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrPortHostGroupTableKey selectPtHg;
                SJctrTableDataModel targetTable = (SJctrTableDataModel)SJctrAddHostsConfirmDC.this.getDataObjectModel(SJctrAddHostsConfirmDC.KEY_TABLE_HOSTGROUPS);
                List<Object> selectedRows = targetTable.getSelectedRowData();
                if (selectedRows.size() == 0) {
                    SJctrLogUty.info(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "Port isn't selected.");
                    SJctrError err = new SJctrError(10, 22, 105040);
                    SJcException exp = err.createException();
                    throw exp;
                }
                if (selectedRows.size() > 1) {
                    SJctrLogUty.info(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "too many Port is selected. Num = " + selectedRows.size());
                    SJctrError err = new SJctrError(10, 22, 105041);
                    SJcException exp = err.createException();
                    throw exp;
                }
                List<?> confirmDataList = SJctrAddHostsConfirmDC.this.getCache("SJctrAddHostsConfirmData");
                SJctrAddHostsConfirmData confirmData = (SJctrAddHostsConfirmData)confirmDataList.get(0);
                List<SJmoPortDetail> ptDtList = confirmData.getPortDetailList();
                int index = Collections.binarySearch(ptDtList, (selectPtHg = (SJctrPortHostGroupTableKey)selectedRows.get(0)).getPortHostGroupInfo());
                if (index < 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "Port# Not Found in SJmoPortDetail Class.");
                    SJctrError err = new SJctrError(10, 22, 107004);
                    SJcException exp = err.createException();
                    throw exp;
                }
                SJctrHGPropertySelectData dialogData = new SJctrHGPropertySelectData();
                dialogData.setData(ptDtList.get(index), selectPtHg.getHostGroupInfo());
                ArrayList<SJctrHGPropertySelectData> dialogList = new ArrayList<SJctrHGPropertySelectData>();
                dialogList.add(dialogData);
                HashMap map = new HashMap();
                map.put("HG_PROPERTY_SELECT_DATA", dialogList);
                SJctrRelatedDispDataObject relatedObj = SJctrAddHostsConfirmDC.this.createDialog(SJctrHGPropertyDC.class, map);
                SJctrAddHostsConfirmDC.this.addUpdateDisp(relatedObj);
            }
        });
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap map = new HashMap();
        List<?> confirmDataList = this.getCache("SJctrAddHostsConfirmData");
        map.put("SJctrAddHostsConfirmData", confirmDataList);
        return map;
    }

    public static enum CONFIRM_MSG implements SJctrNotifyState
    {
        DETAIL;

    }
}

