/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.addhosts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.addhosts.SJctrAddHostsConfirmData;
import sanproject.sn2.controller.wizard.lunm.addhosts.SJctrAvailableHostsTableModel;
import sanproject.sn2.controller.wizard.lunm.addhosts.SJctrSelectedHostsTableModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrAddHostsTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrModelDataCheck;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrReplaceDataForConfirm;
import sanproject.sn2.controller.wizard.lunm.comdialog.SJctrAddNewHostsDialogDC;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortWwnInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoWwn;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrAddHostsDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1100031;
    public static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE";
    public static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    public static final String KEY_ADD = "COM_ADD";
    public static final String KEY_REMOVE = "COM_REMOVE";
    public static final String KEY_FOOTER = "COM_FOOTER";
    public static final Class KEY_CLASS_MPORTATTR = SJmoGetPortAttributeInfo.class;
    public static final Class KEY_CLASS_MPORTHG = SJmoGetPortHostGroupInfo.class;
    public static final Class KEY_CLASS_MPORTWWN = SJmoGetPortWwnInfo.class;
    public static final Class KEY_CLASS_MPORTDETL = SJmoGetPortDetail.class;
    public static final Class KEY_CLASS_RSG = SJmoGetRSGgetAllRsgs.class;
    public static final Class KEY_CLASS_PORTHGFROMLV = SJctrPortHostGroupTableKey.class;
    public static final String KEY_CLASS_PORTHGINDEX = "KEY_CLASS_PORTHGINDEX";
    public static final String KEY_SELECTED_ADD_WWN = "KEY_SELECTED_ADD_WWN";
    public static final String KEY_CLASS_CONFIRM_DATA = "SJctrAddHostsConfirmData";
    public static final String TITLE = "DISP_DI3S_TITLE";
    public static final String KEY_TABLE = "COM_TABLE";
    public static int ADDHOST_ERR1 = 107001;
    public static int ADDHOST_ERR2 = 106501;
    public static int ADDHOST_ERR3 = 107001;
    public static int ADDHOST_ERR4 = 105018;
    public static int ADDHOST_ERR5 = 105026;
    public static int ADDHOST_ERR6 = 105021;
    public static int ADDHOST_ERR7 = 105297;
    public static int ADDHOST_ERR8 = 107002;
    public static int ADDHOST_ERR_SysRSG_HG = 205164;
    public static int ADDHOST_ERR_vPort = 205166;
    List<SJmoWwn> availableWwnList;

    public SJctrAddHostsDC() throws SJcException {
        super(0x1100031);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, new SJctrAvailableHostsTableModel());
        this.addDataObjectModel(KEY_TABLE_SELECTED, new SJctrSelectedHostsTableModel());
        SJctrButtonDataModel add = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAddHostsDC.this.addAction();
                    }
                });
            }
        };
        this.addDataObjectModel(KEY_ADD, add);
        SJctrButtonDataModel remove = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        SJctrAddHostsDC.this.removeAction();
                    }
                });
            }
        };
        this.addDataObjectModel(KEY_REMOVE, remove);
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        boolean bRet = true;
        SJctrWizardWindowDC wizard = this.getWizardWindow();
        List<?> targetList = wizard.getCache(KEY_CLASS_PORTHGFROMLV);
        if (targetList == null || targetList.size() == 0) {
            bRet = false;
            SJctrError err = new SJctrError(10, 22, ADDHOST_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        return bRet;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        List<SJctrPortHostGroupTableKey> targetList = this.getCache(KEY_CLASS_PORTHGFROMLV);
        ArrayList<SJctrError> errlist = new ArrayList<SJctrError>(targetList.size());
        for (int errpos = 0; errpos < targetList.size(); ++errpos) {
            SJctrError oneError = new SJctrError(0, 0, 0);
            errlist.add(oneError);
        }
        ret = this.checkEquipPort(targetList, errlist);
        if (ret) {
            ret = this.checkEquipPortHG(targetList, errlist);
        }
        if (ret) {
            ret = this.checkPortAttribute(targetList, errlist);
        }
        if (ret) {
            ret = this.checkRsgPortHG(targetList, errlist);
        }
        if (ret) {
            ret = this.checkContainsPortHG(targetList, errlist);
        }
        if (!ret) {
            SJctrDataController parentDC = this.getWizardWindow().getParentDC();
            SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
            ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(targetList.size());
            for (int errpos = 0; errpos < targetList.size(); ++errpos) {
                SJctrError oneError = errlist.get(errpos);
                if (oneError.getError() == 0) continue;
                SJctrErrorColumnData oneErrorColumn = new SJctrErrorColumnData(targetList.get(errpos), oneError);
                errColumnList.add(oneErrorColumn);
            }
            SJctrError errInfo = ((SJctrErrorColumnData)errColumnList.get(0)).getError();
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errColumnList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        return ret;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        set.add(this.createModelDirect(KEY_CLASS_MPORTATTR));
        set.add(this.createModelDirect(KEY_CLASS_MPORTHG));
        set.add(this.createModelDirect(KEY_CLASS_MPORTWWN));
        set.add(this.createModelDirect(KEY_CLASS_MPORTDETL));
        set.add(this.createModelDirect(KEY_CLASS_RSG));
        return set;
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) {
        SJctrGetDirectWrapper retValue = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList filterList = new ArrayList();
            SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
            retValue = new SJctrGetDirectWrapper(direct);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return retValue;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        List<?> addHostList = this.getCache(KEY_SELECTED_ADD_WWN);
        if (addHostList == null || addHostList.size() == 0) {
            ret = false;
            SJctrError err = new SJctrError(10, 22, ADDHOST_ERR5);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> portDetailList = this.getCache(KEY_CLASS_MPORTDETL);
        List<SJctrPortHostGroupTableKey> targetHg = this.getCache(KEY_CLASS_PORTHGINDEX);
        SJctrComUtility comUtil = this.getComUtility();
        SJctrPortUtility portUtil = comUtil.getPortUtility();
        portUtil.checkPortSecurityMsg(portDetailList, targetHg, this);
        return ret;
    }

    private void initListener() {
        this.addMessageEventListener(NOTIFY_ADD_HOSTS.ADD_NEW_HOST, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrAddHostsDC.this.enterAddNewHostAction();
            }
        });
        this.addMessageEventListener(SJctrDialogDataController.DIALOG_MSG.EXIT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                Object notifyObj = event.getNofifyObject();
                if (notifyObj instanceof Map) {
                    Map map = (Map)notifyObj;
                    SJctrAddHostsDC.this.exitAddNewHostAction(map);
                }
            }
        });
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("LUNM", TITLE);
    }

    private boolean checkEquipPort(List<SJctrPortHostGroupTableKey> targetList, List<SJctrError> errList) {
        boolean ret = true;
        List<?> ptHg = this.getCache(KEY_CLASS_MPORTHG);
        if (ptHg == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEquipPort", "SJmoGetPortHostGroupInfo Not Found in the Cache.");
            return false;
        }
        for (int index = 0; index < targetList.size(); ++index) {
            SJctrPortHostGroupTableKey onePtHgKey = targetList.get(index);
            int searchRet = Collections.binarySearch(ptHg, onePtHgKey.getPortHostGroupInfo());
            if (searchRet >= 0) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(ADDHOST_ERR2);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkEquipPort", "Not Found port#=" + onePtHgKey.getPortHostGroupInfo().getSPort());
        }
        return ret;
    }

    private boolean checkEquipPortHG(List<SJctrPortHostGroupTableKey> targetList, List<SJctrError> errList) {
        ArrayList<SJctrPortHostGroupTableKey> keyList;
        boolean ret = true;
        List<SJmoPortHostGroupInfo> cacheList = this.getCache(KEY_CLASS_MPORTHG);
        ret = SJctrModelDataCheck.checkEquipPortHG(targetList, cacheList, keyList = new ArrayList<SJctrPortHostGroupTableKey>(targetList.size()), errList);
        if (ret) {
            this.putCache(KEY_CLASS_PORTHGINDEX, keyList);
        }
        return ret;
    }

    private boolean checkRsgPortHG(List<SJctrPortHostGroupTableKey> targetList, List<SJctrError> errList) {
        boolean ret = true;
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, ADDHOST_ERR8);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJmoPortDetail> portDetailList = this.getCache(SJmoGetPortDetail.class);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        for (int index = 0; index < targetList.size(); ++index) {
            boolean hnasLu;
            SJctrPortHostGroupTableKey ptHgTableKey = targetList.get(index);
            SJmoHostGroupInfo hgInfo = ptHgTableKey.getHostGroupInfo();
            hgIndex.setSPort(hgInfo.getSPort());
            hgIndex.setSHostGroup(hgInfo.getSHostGroup());
            boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
            if (!rsgFlg) {
                ret = false;
                SJctrError errElement = errList.get(index);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(ADDHOST_ERR7);
                continue;
            }
            boolean sysRsgFlg = rsgUtil.isSelRscHgInSysRsg(hgIndex);
            if (sysRsgFlg) {
                ret = false;
                SJctrError errElement = errList.get(index);
                errElement.setFunc(10);
                errElement.setModule(22);
                errElement.setError(ADDHOST_ERR_SysRSG_HG);
            }
            if (!(hnasLu = this.checkHgHnasLu(portDetailList, ptHgTableKey))) continue;
            ret = false;
            SJctrError errElement = errList.get(index);
            errElement.setFunc(10);
            errElement.setModule(22);
            errElement.setError(ADDHOST_ERR_vPort);
        }
        return ret;
    }

    private boolean checkHgHnasLu(List<SJmoPortDetail> portDetailList, SJctrPortHostGroupTableKey ptHgTableKey) {
        SJmoHostGroupInfo hgInfo = ptHgTableKey.getHostGroupInfo();
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort(hgInfo.getSPort());
        int index = Collections.binarySearch(portDetailList, portIndex);
        if (index >= 0) {
            SJmoPortDetail portDetail = portDetailList.get(index);
            return SJctrPortUtility.isHnasPort(portDetail);
        }
        return false;
    }

    private boolean checkContainsPortHG(List<SJctrPortHostGroupTableKey> targetList, List<SJctrError> errList) {
        boolean ret = true;
        for (int index = 0; index < targetList.size() - 1; ++index) {
            for (int point = index + 1; point < targetList.size(); ++point) {
                short port2;
                short port1 = targetList.get(index).getPortHostGroupInfo().getSPort();
                if (port1 != (port2 = targetList.get(point).getPortHostGroupInfo().getSPort())) continue;
                ret = false;
                SJctrError errElement1 = errList.get(index);
                errElement1.setFunc(10);
                errElement1.setModule(22);
                errElement1.setError(ADDHOST_ERR4);
                SJctrError errElement2 = errList.get(point);
                errElement2.setFunc(10);
                errElement2.setModule(22);
                errElement2.setError(ADDHOST_ERR4);
                SJctrLogUty.warn(this.getClass().getSimpleName(), "checkContainsPortHG", "Row#1 = " + index + ", Row#2 = " + point + " Same Port# Selected. (Port#" + port1 + ")");
            }
        }
        return ret;
    }

    private boolean checkPortAttribute(List<SJctrPortHostGroupTableKey> targetList, List<SJctrError> errList) {
        boolean ret = true;
        List<SJmoPortAttributeInfo> cacheList = this.getCache(KEY_CLASS_MPORTATTR);
        ret = SJctrModelDataCheck.checkPortAttribute(targetList, cacheList, errList);
        return ret;
    }

    private void addAction() {
        SJcException exp;
        int selectCount;
        int addRowCount;
        boolean bErrAddFlg = true;
        SJctrAvailableHostsTableModel availableTable = (SJctrAvailableHostsTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrSelectedHostsTableModel selectedTable = (SJctrSelectedHostsTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> addHostsKey = availableTable.getSelectedRowDataOrder();
        ArrayList<SJmoWwn> availableWwnList = new ArrayList<SJmoWwn>(addHostsKey.size());
        for (Object availableRowData : addHostsKey) {
            SJctrAddHostsTableKey availableAddHostsData = (SJctrAddHostsTableKey)availableRowData;
            SJmoWwn wwnList = availableAddHostsData.getWwnInfo();
            availableWwnList.add(wwnList);
        }
        ArrayList<SJmoWwn> selectedWwnList = new ArrayList<SJmoWwn>(selectedTable.getAllRowData().size());
        for (Object selectedRowData : selectedTable.getAllRowData()) {
            SJctrAddHostsTableKey selectedAddHostsData = (SJctrAddHostsTableKey)selectedRowData;
            SJmoWwn wwnList = selectedAddHostsData.getWwnInfo();
            selectedWwnList.add(wwnList);
        }
        ArrayList<SJctrError> errlist = new ArrayList<SJctrError>(addHostsKey.size());
        for (int errpos = 0; errpos < addHostsKey.size(); ++errpos) {
            SJctrError oneError = new SJctrError(0, 0, 0);
            errlist.add(oneError);
        }
        if (bErrAddFlg) {
            ArrayList<String> blockWwnList = new ArrayList<String>(availableTable.getUsedWwn().size());
            blockWwnList.addAll(availableTable.getUsedWwn());
            if (!SJctrModelDataCheck.checkContainsWwn(availableWwnList, blockWwnList, errlist)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "Try to add WWN is already used in this port!!");
                bErrAddFlg = false;
            }
        }
        if (bErrAddFlg) {
            ArrayList<String> alreadySelectWwnList = new ArrayList<String>(selectedWwnList.size());
            for (SJmoWwn wwn : selectedWwnList) {
                alreadySelectWwnList.add(SJctrComUtility.toWWNDisplay(wwn));
            }
            if (!SJctrModelDataCheck.checkContainsWwn(availableWwnList, alreadySelectWwnList, errlist)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "Try to add WWN is already selected!!");
                bErrAddFlg = false;
            }
        }
        if (bErrAddFlg) {
            ArrayList<String> blockNicknameList = new ArrayList<String>(availableTable.getUsedNickname().size());
            blockNicknameList.addAll(availableTable.getUsedNickname());
            if (!SJctrModelDataCheck.checkContainsWwnNickname(availableWwnList, blockNicknameList, errlist)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "Try to add WWN-Nickname is already used in this port!!");
                bErrAddFlg = false;
            }
        }
        if (bErrAddFlg) {
            ArrayList<String> alreadySelectNicknameList = new ArrayList<String>(selectedWwnList.size());
            for (SJmoWwn wwn : selectedWwnList) {
                alreadySelectNicknameList.add(wwn.getStrWWNNickName());
            }
            if (!SJctrModelDataCheck.checkContainsWwnNickname(availableWwnList, alreadySelectNicknameList, errlist)) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "Try to add WWN-Nickname is already selected!!");
                bErrAddFlg = false;
            }
        }
        if (bErrAddFlg && SJctrModelDataCheck.isSameHBAWWN(addHostsKey, errlist)) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "Try to add WWN(wwn-byte) is overlapped in this operation!!");
        }
        if (bErrAddFlg && SJctrModelDataCheck.isSameNickname(addHostsKey, errlist)) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "Try to add WWN(nickname) is overlapped in this operation!!");
        }
        ArrayList<Object> list = new ArrayList<Object>(addHostsKey.size());
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(addHostsKey.size());
        for (int errpos = 0; errpos < addHostsKey.size(); ++errpos) {
            SJctrError errElement = errlist.get(errpos);
            if (errElement.getError() == 0) {
                list.add(addHostsKey.get(errpos));
                continue;
            }
            SJctrAddHostsTableKey errKey = (SJctrAddHostsTableKey)addHostsKey.get(errpos);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(errKey, errElement);
            errColumnList.add(errColumn);
        }
        if (bErrAddFlg && this.isOverWwnMax(addRowCount = list.size(), selectCount = selectedTable.getAllRowData().size())) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "addAction", "No more wwns can be registered in the port.");
            SJctrError err = new SJctrError(10, 22, ADDHOST_ERR6);
            exp = err.createException();
            throw exp;
        }
        if (list.size() > 0 && bErrAddFlg) {
            availableTable.removeRowData(list);
            selectedTable.addRowDataTop(list);
            List<Object> selectedTableData = selectedTable.getAllRowData();
            this.putCache(KEY_SELECTED_ADD_WWN, selectedTableData);
        }
        if (errColumnList.size() != 0) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(availableTable, errColumnList);
            availableTable.setDirty();
            selectedTable.setDirty();
            SJctrError errInfo = errDc.getRepresentativeError(errColumnList);
            exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
    }

    private boolean isOverWwnMax(int addRowCount, int selectCount) {
        boolean ret = false;
        List<?> targetPortHgList = this.getCache(KEY_CLASS_PORTHGINDEX);
        if (targetPortHgList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "isOverWwnMax", "KEY_CLASS_PORTHGINDEX Not Found in the Cache.");
            return true;
        }
        List<?> cachePortHgList = this.getCache(KEY_CLASS_MPORTHG);
        for (SJctrPortHostGroupTableKey portHg : targetPortHgList) {
            int searchRet = Collections.binarySearch(cachePortHgList, portHg.getPortHostGroupInfo());
            if (searchRet < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "isOverWwnMax", "Skipped Port#= " + portHg.getPortHostGroupInfo().getSPort());
                continue;
            }
            SJmoPortHostGroupInfo hostGrp = (SJmoPortHostGroupInfo)cachePortHgList.get(searchRet);
            int portWwnSum = 0;
            for (SJmoHostGroupInfo oneHostGrp : hostGrp.getAlPortHostGroup()) {
                portWwnSum += oneHostGrp.getAlHostGroupWwn().size();
            }
            int afterWwnConnt = portWwnSum + addRowCount + selectCount;
            if (afterWwnConnt <= SJctrPortUtility.PORT_WWN_MAX) continue;
            ret = true;
            SJctrLogUty.warn(this.getClass().getSimpleName(), "isOverWwnMax", "Now Registered Port Wwn Count = " + portWwnSum + ", Try to Add Wwn Count = " + addRowCount + " (Port#=" + hostGrp.getSPort() + ")");
            break;
        }
        return ret;
    }

    private void removeAction() {
        SJctrTableDataModel avaliableTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJctrTableDataModel selectedTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        List<Object> list = selectedTable.removeSelectedRowData();
        avaliableTable.addRowDataTop(list);
        List<Object> selectedTableData = selectedTable.getAllRowData();
        this.putCache(KEY_SELECTED_ADD_WWN, selectedTableData);
    }

    private void enterAddNewHostAction() {
        SJctrAvailableHostsTableModel availableTable = (SJctrAvailableHostsTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        List<Object> addList = availableTable.getSelectedRowData();
        ArrayList<SJmoWwn> selectWwnList = new ArrayList<SJmoWwn>(addList.size());
        for (Object rowObj : addList) {
            SJctrAddHostsTableKey rowKey = (SJctrAddHostsTableKey)rowObj;
            selectWwnList.add(rowKey.getWwnInfo());
        }
        HashMap map = new HashMap();
        map.put("KEY_WWN_DIALOG_IN", selectWwnList);
        map.put("KEY_AVAILABLE_WWN", this.availableWwnList);
        ArrayList<String> blockWwnList = new ArrayList<String>(availableTable.getUsedWwn().size());
        blockWwnList.addAll(availableTable.getUsedWwn());
        map.put("KEY_BLOCK_WWNSTRING", blockWwnList);
        ArrayList<String> blockNicknameList = new ArrayList<String>(availableTable.getUsedNickname().size());
        blockNicknameList.addAll(availableTable.getUsedNickname());
        map.put("KEY_BLOCK_NICKNAME", blockNicknameList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrAddNewHostsDialogDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    private void exitAddNewHostAction(Map<String, List<?>> carryMap) {
        SJctrAvailableHostsTableModel avaliableTable = (SJctrAvailableHostsTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        List<?> carryWwnList = carryMap.get("KEY_WWN_DIALOG_OUT");
        if (carryWwnList == null || carryWwnList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "exitAddNewHostAction", "KEY_WWN_DIALOG_OUT Not Found!!");
            return;
        }
        SJmoWwn newWwn = (SJmoWwn)carryWwnList.get(0);
        SJmoPortHostGroupInfo newPtHgInfo = new SJmoPortHostGroupInfo();
        SJmoHostGroupInfo newHgInfo = new SJmoHostGroupInfo();
        SJctrAddHostsTableKey hostKey = new SJctrAddHostsTableKey(newPtHgInfo, newHgInfo, newWwn, true);
        ArrayList<SJctrAddHostsTableKey> addList = new ArrayList<SJctrAddHostsTableKey>(1);
        addList.add(hostKey);
        avaliableTable.addRowDataTop(addList);
        if (this.availableWwnList == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "exitAddNewHostAction", "Available Table Key Not Found!! --> remake Available Table Key List.");
            this.availableWwnList = new ArrayList<SJmoWwn>();
        }
        this.availableWwnList.add(newWwn);
        avaliableTable.setDirty();
    }

    SJctrAddHostsConfirmData createConfirmData(List<SJctrPortHostGroupTableKey> targetPortHgList, List<SJctrAddHostsTableKey> addHostList) {
        TreeSet<SJmoPortHostGroupInfo> portSet = new TreeSet<SJmoPortHostGroupInfo>();
        for (SJctrPortHostGroupTableKey key : targetPortHgList) {
            portSet.add(key.getPortHostGroupInfo());
        }
        ArrayList<SJmoPortIndex> targetPortList = new ArrayList<SJmoPortIndex>(portSet);
        List<SJmoPortAttributeInfo> portAttributeList = this.getCache(KEY_CLASS_MPORTATTR);
        List<SJmoPortAttributeInfo> confirmPortAttrList = SJctrReplaceDataForConfirm.getConfirmPortAttrInfo(targetPortList, portAttributeList);
        List<SJmoPortDetail> portDetailList = this.getCache(KEY_CLASS_MPORTDETL);
        List<SJmoPortDetail> confirmPortDetailList = SJctrReplaceDataForConfirm.getConfirmPortDetail(targetPortList, portDetailList);
        List<SJmoPortHostGroupInfo> confirmPortHgList = this.replaceConfirmPortHgInfo(targetPortHgList, addHostList);
        List<SJctrPortHostGroupTableKey> newTargetList = SJctrReplaceDataForConfirm.replaceConfirmTargetList(targetPortHgList, confirmPortHgList);
        SJctrAddHostsConfirmData confirmData = new SJctrAddHostsConfirmData();
        confirmData.setPortAttributeList(confirmPortAttrList);
        confirmData.setPortDetailList(confirmPortDetailList);
        confirmData.setPortHgList(confirmPortHgList);
        confirmData.setAddHostsInfo(addHostList);
        confirmData.setTargetPortHgList(newTargetList);
        ArrayList<SJctrAddHostsConfirmData> confirmDataList = new ArrayList<SJctrAddHostsConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(KEY_CLASS_CONFIRM_DATA, confirmDataList);
        return confirmData;
    }

    public SJmoPortHostGroupInfo createNewPortHgInfo(SJmoPortHostGroupInfo portHg) throws CloneNotSupportedException {
        SJmoPortHostGroupInfo createPortHg = null;
        createPortHg = new SJmoPortHostGroupInfo();
        createPortHg.setSPort(portHg.getSPort());
        ArrayList<SJmoHostGroupInfo> alPortHostGroup = new ArrayList<SJmoHostGroupInfo>();
        for (Object hgObj : portHg.getAlPortHostGroup()) {
            SJmoHostGroupInfo hg = (SJmoHostGroupInfo)hgObj;
            SJmoHostGroupInfo newHg = this.createHostGroupInfo(hg);
            alPortHostGroup.add(newHg);
        }
        createPortHg.setAlPortHostGroup(alPortHostGroup);
        return createPortHg;
    }

    public SJmoHostGroupInfo createHostGroupInfo(SJmoHostGroupInfo hostGroupInfo) throws CloneNotSupportedException {
        SJmoHostGroupInfo result = (SJmoHostGroupInfo)hostGroupInfo.clone();
        ArrayList wwnList = hostGroupInfo.getAlHostGroupWwn();
        ArrayList<SJmoWwn> resultWwnList = new ArrayList<SJmoWwn>(wwnList.size());
        for (SJmoWwn wwn : wwnList) {
            SJmoWwn resultWwn = (SJmoWwn)wwn.clone();
            resultWwnList.add(resultWwn);
        }
        result.setAlHostGroupWwn(resultWwnList);
        return result;
    }

    private List<SJmoPortHostGroupInfo> replaceConfirmPortHgInfo(List<SJctrPortHostGroupTableKey> targetPortHgList, List<SJctrAddHostsTableKey> addHostList) {
        List<?> portHgList = this.getCache(KEY_CLASS_MPORTHG);
        TreeMap<String, SJmoPortHostGroupInfo> confirmPortHgMap = new TreeMap<String, SJmoPortHostGroupInfo>();
        for (SJctrPortHostGroupTableKey ptHgKey : targetPortHgList) {
            int searchResult = Collections.binarySearch(portHgList, ptHgKey.getPortHostGroupInfo());
            if (searchResult < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "exitAddNewHostAction", "SJmoPortHostGroupInfo not found.");
                continue;
            }
            SJmoPortHostGroupInfo portHg = (SJmoPortHostGroupInfo)portHgList.get(searchResult);
            SJmoPortHostGroupInfo createPortHg = null;
            if (confirmPortHgMap.containsKey(ptHgKey.getPortHostGroupInfo().toString())) {
                createPortHg = (SJmoPortHostGroupInfo)confirmPortHgMap.get(ptHgKey.getPortHostGroupInfo().toString());
            } else {
                try {
                    createPortHg = this.createNewPortHgInfo(portHg);
                }
                catch (CloneNotSupportedException e) {
                    this.getLogUty().putlog("createConfirmData", "SJmoPortHostGroupInfo clone fail", e, 30000);
                    continue;
                }
            }
            ArrayList hgArray = createPortHg.getAlPortHostGroup();
            SJmoHostGroupInfo createTargetHg = null;
            for (SJmoHostGroupInfo oneModelHg : hgArray) {
                if (oneModelHg.getSHostGroup() != ptHgKey.getHostGroupInfo().getSHostGroup()) continue;
                createTargetHg = oneModelHg;
                break;
            }
            if (createTargetHg == null) {
                this.getLogUty().putlog("createConfirmData", "SJmoHostGroupInfo not found.", null, 20000);
                continue;
            }
            for (SJctrAddHostsTableKey addHostData : addHostList) {
                SJmoWwn wwnInfo = new SJmoWwn();
                wwnInfo.setByWWN(addHostData.getWwnInfo().getByWWN());
                wwnInfo.setStrWWNNickName(addHostData.getWwnInfo().getStrWWNNickName());
                createTargetHg.getAlHostGroupWwn().add(wwnInfo);
            }
            confirmPortHgMap.put(ptHgKey.getPortHostGroupInfo().toString(), createPortHg);
        }
        ArrayList<SJmoPortHostGroupInfo> confirmPortHgList = new ArrayList<SJmoPortHostGroupInfo>();
        confirmPortHgList.addAll(confirmPortHgMap.values());
        return confirmPortHgList;
    }

    public static enum NOTIFY_ADD_HOSTS implements SJctrNotifyState
    {
        ADD_NEW_HOST;

    }
}

