/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.addiscsihosts;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.lunm.com.SJctrAddHostsTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupWwnTableKey;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationError;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJctrAddHostsIscsiAC
extends SJctrApplyController
implements SJmoKeyValueDefine_IF {
    private static final int LUNM_BASE_TIME = 30;
    private static final double COEFFICIENT = 0.003;
    public List<SJctrAddHostsTableKey> addHostsKey;
    public List<SJctrPortHostGroupTableKey> portHgKey;
    private List<SJctrPortHostGroupWwnTableKey> portItHostKeyList = Collections.emptyList();
    private Map<Short, Map<Short, Map<String, SJctrError>>> portMap = null;
    protected SJctrError representativeError = null;
    List<SJctrError> resultData = null;

    @Override
    public int getLeadTime() {
        ArrayList<?> applylist = this.getSetList();
        double leadtime = 30.0 + (double)applylist.size() * 0.003;
        leadtime = Math.ceil(leadtime);
        return (int)leadtime;
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList applyList = new ArrayList(1);
        return applyList;
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw new NullPointerException();
        }
        try {
            SanRequest requestData = supplier.newRequest("LUNMcreateiScsiName");
            SanList reqPortList = requestData.newList("iScsiPorts");
            if (this.portHgKey == null || this.addHostsKey == null) {
                SJctrLogUty.error("SJctrEditIscsiPortIsnsAC", "applyStart", "Parameter is invalid.");
                return;
            }
            Collections.sort(this.portHgKey);
            short sPort = -1;
            SanObject portsParam = null;
            SanList iScsiTargets = null;
            for (SJctrPortHostGroupTableKey ptHGTableKey : this.portHgKey) {
                if (portsParam == null || ptHGTableKey.getIscsiTargetInfo().getSPort() != sPort) {
                    portsParam = reqPortList.addObj();
                    sPort = ptHGTableKey.getIscsiTargetInfo().getSPort();
                    portsParam.putInt("Id", (int)sPort);
                    iScsiTargets = portsParam.newList("iScsiTargets");
                }
                SJmoIscsiTargetInfo iscsiTarget = ptHGTableKey.getIscsiTargetInfo();
                SanObject iscsiTargetsParam = iScsiTargets.addObj();
                iscsiTargetsParam.putInt("Id", (int)iscsiTarget.getSIscsiTarget());
                SanList iScsiNames = iscsiTargetsParam.newList("RemoteiScsiNames");
                for (SJctrAddHostsTableKey addHostsData : this.addHostsKey) {
                    SanObject iScsiNamesParam = iScsiNames.addObj();
                    iScsiNamesParam.putString("Name", addHostsData.getIscsiNameInfo().getStrIscsiName());
                    iScsiNamesParam.putString("NickName", addHostsData.getIscsiNameInfo().getStrIscsiNickName());
                }
            }
            ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
            applyList.add(requestData);
            SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMcreateiScsiName)");
            Object resultObject = supplier.applyStart(this.getLockId(), applyList);
            SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMcreateiScsiName)");
            this.getMapPortError(resultObject);
            this.setApplyResult();
        }
        catch (SJcException se) {
            SJctrLogUty.error(this.title, "applyStart", "SJcException occurred. " + se.getMessage());
            SJctrError error = SJctrError.parseError(se);
            this.setError(error);
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error(this.title, "applyStart", "The Key-Value interfaced error occurred. " + sdEx.getMessage());
            SJctrError error = SJctrError.parseError((Exception)((Object)sdEx));
            this.setError(error);
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    private void getMapPortError(Object resultObject) throws SanDataException {
        SanObject repErrorInfo;
        int[] errMsgId;
        if (!(resultObject instanceof SanResponse)) {
            SJcException error = SJctrIscsiUtility.makeException(107001);
            throw error;
        }
        SJctrLogUty.info(this.title, "getMapPort", "get SanResponse.");
        SanResponse responseData = (SanResponse)resultObject;
        if (this.representativeError == null && 0 != (errMsgId = (repErrorInfo = responseData.getObj("ErrorInfo")).getIntArray("MessageId"))[1]) {
            this.representativeError = new SJctrIscsiOperationError(errMsgId);
        }
        SanList portList = responseData.getList("iScsiPorts");
        if (this.portMap == null) {
            this.portMap = new HashMap<Short, Map<Short, Map<String, SJctrError>>>(portList.size());
        }
        for (SanObject port : portList) {
            short portID = (short)port.getInt("Id");
            SanList iSCSITargetList = port.getList("iScsiTargets");
            Map<Short, Map<String, SJctrError>> itMap = this.portMap.get(portID);
            if (itMap == null) {
                itMap = new HashMap<Short, Map<String, SJctrError>>(iSCSITargetList.size());
                this.portMap.put(portID, itMap);
            }
            for (SanObject iSCSITarget : iSCSITargetList) {
                short itID = (short)iSCSITarget.getInt("Id");
                SanList iSCSINameList = iSCSITarget.getList("RemoteiScsiNames");
                Map<String, SJctrError> itNameErrMap = itMap.get(itID);
                if (itNameErrMap == null) {
                    itNameErrMap = new HashMap<String, SJctrError>(iSCSINameList.size());
                    itMap.put(itID, itNameErrMap);
                }
                for (SanObject iSCSIName : iSCSINameList) {
                    String itName = iSCSIName.getString("Name");
                    SanObject errInfo = iSCSIName.getObj("ErrorInfo");
                    int[] errMsgId2 = errInfo.getIntArray("MessageId");
                    SJctrIscsiOperationError error = new SJctrIscsiOperationError(errMsgId2);
                    itNameErrMap.put(itName, error);
                }
            }
        }
    }

    public void setWizardSetData(List<SJctrAddHostsTableKey> addHostsInfo, List<SJctrPortHostGroupTableKey> portHgInfo) {
        this.addHostsKey = addHostsInfo;
        this.portHgKey = portHgInfo;
    }

    public void setWizardDispData(List<SJctrPortHostGroupWwnTableKey> portHgHostInfoList) {
        this.portItHostKeyList = portHgHostInfoList;
    }

    protected void setApplyResult() {
        super.setApplyResult(null);
        if (this.representativeError != null) {
            this.setError(this.representativeError);
        } else {
            this.setError(SJctrIscsiUtility.makeError(0));
        }
        if (!this.portMap.isEmpty()) {
            this.resultData = new ArrayList<SJctrError>(this.portItHostKeyList.size());
            for (SJctrPortHostGroupWwnTableKey portiTHostInfo : this.portItHostKeyList) {
                SJctrError errorInfo = this.getErrorInfo(portiTHostInfo);
                this.resultData.add(errorInfo);
            }
        }
    }

    private SJctrError getErrorInfo(SJctrPortHostGroupWwnTableKey portiTHostInfo) {
        SJctrError ret = null;
        try {
            short portId = portiTHostInfo.getPortIscsiTargetInfo().getSPort();
            short itId = portiTHostInfo.getIscsiTargetInfo().getSIscsiTarget();
            String iSCSIName = portiTHostInfo.getIscsiNameInfo().getStrIscsiName();
            Map<Short, Map<String, SJctrError>> itMap = this.portMap.get(portId);
            Map<String, SJctrError> errorMap = itMap.get(itId);
            ret = errorMap.get(iSCSIName);
            if (ret == null) {
                ret = SJctrIscsiUtility.makeError(107001);
            }
        }
        catch (NullPointerException e) {
            return SJctrIscsiUtility.makeError(107001);
        }
        return ret;
    }

    @Override
    public boolean hasApplyResult() {
        boolean rtn = false;
        if (this.resultData != null && this.resultData.size() > 0) {
            rtn = true;
        }
        return rtn;
    }
}

