/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrRsgUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertySelectData;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrHGPropertySummaryModel
extends SJctrSimpleDataModel {
    public static final String KEY_PTNAME = "COM_PT_NAME";
    public static final String KEY_HGNAME = "COM_HG_NAME";
    public static final String KEY_HOSTMODE = "COM_HOSTMODE";
    public static final String KEY_HMONO = "COM_HMONO";
    public static final String KEY_T10PI_MODE = "COM_T10PI_MODE";
    public static final String KEY_RSG = "COM_RSGNAME";
    public static final String KEY_CONFIRM_PORTATTR = "CONFIRM_PORTATTR";
    public static final String KEY_CONFIRM_RSG = "CONFIRM_RSG";

    @Override
    public void makeDataObject() {
        List<?> dat = this.getDataController().getProxy().getCache("HG_PROPERTY_SELECT_DATA");
        SJctrHGPropertySelectData selectData = null;
        if (dat != null && dat.size() > 0) {
            selectData = (SJctrHGPropertySelectData)dat.get(0);
        }
        this.makeSummary(selectData);
    }

    protected void makeSummary(SJctrHGPropertySelectData selectData) {
        List<?> rsgDetailList;
        SJctrUserController uc = this.getDataController().getOwner();
        SJctrPortUtility portUtil = uc.getComUtility().getPortUtility();
        boolean bInitiator = false;
        List<?> portAttrList = this.getDataController().getProxy().getCache(KEY_CONFIRM_PORTATTR);
        if (portAttrList == null) {
            portAttrList = this.getDataController().getModelData(SJmoGetPortAttributeInfo.class);
        }
        if ((rsgDetailList = this.getDataController().getProxy().getCache(KEY_CONFIRM_RSG)) == null) {
            rsgDetailList = this.getDataController().getModelData(SJmoGetRSGgetAllRsgs.class);
        }
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        SJmoRSGInfo rsgInfo = null;
        SJmoPortDetail port = null;
        SJmoHostGroupInfo hostGroup = null;
        if (selectData != null) {
            int portAttrIdx;
            port = selectData.getPortDetail();
            hostGroup = selectData.getHostGroupInfo();
            if (portAttrList != null && !portAttrList.isEmpty() && rsgDetailList != null && !rsgDetailList.isEmpty() && (portAttrIdx = Collections.binarySearch(portAttrList, port)) >= 0) {
                SJmoPortAttributeInfo portAttr = (SJmoPortAttributeInfo)portAttrList.get(portAttrIdx);
                if (portAttr.getByPortKind() == 5) {
                    bInitiator = true;
                } else {
                    hgIndex.setSPort(hostGroup.getSPort());
                    hgIndex.setSHostGroup(hostGroup.getSHostGroup());
                    SJmoRSGgetRsg rtnRsg = null;
                    ArrayList<SJmoRSGgetRsg> rsglist = ((SJmoRSGgetAllRsgs)rsgDetailList.get(0)).getRsgs();
                    for (SJmoRSGgetRsg rsg : rsglist) {
                        ArrayList<SJmoHostGroupIndex> hgList = rsg.getHostGrps();
                        int index = Collections.binarySearch(hgList, hgIndex);
                        if (index < 0) continue;
                        rtnRsg = rsg;
                    }
                    if (rtnRsg != null) {
                        rsgInfo = rtnRsg.getRsgInfo();
                    }
                }
            }
        }
        Object summaryData = this.getManageData();
        ((SJctrDataObject)summaryData).setData(KEY_PTNAME, portUtil.toPortNameDisplay(port));
        ((SJctrDataObject)summaryData).setData(KEY_HGNAME, portUtil.toHostGroupNameDisplay(hostGroup));
        ((SJctrDataObject)summaryData).setData(KEY_HOSTMODE, portUtil.toHostModeDisplay(hostGroup));
        ((SJctrDataObject)summaryData).setData(KEY_HMONO, portUtil.appendToHostModeOptionNoDisplay(hostGroup));
        ((SJctrDataObject)summaryData).setData(KEY_T10PI_MODE, portUtil.toT10PIModeDisplay(port));
        if (!bInitiator) {
            ((SJctrDataObject)summaryData).setData(KEY_RSG, SJctrRsgUtility.toRsgIdDisplay(uc.getComUtility(), rsgInfo));
        } else {
            ((SJctrDataObject)summaryData).setData(KEY_RSG, SJctrPortUtility.STR_HYPHEN);
        }
    }
}

