/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.copylunpaths;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.column.SJctrALUAModeColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrArrayGroupColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrEmulationTypeColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLdevCapacityLUSEColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLdevIdColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLdevNameColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLunIdColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrPathNumColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrT10PiColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.data.SJctrTblDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLdevDetailLUSEInfo;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.copylunpaths.SJctrCopyLunPathsConfirmData;
import sanproject.sn2.controller.wizard.lunm.copylunpaths.SJctrCopyLunPathsSelectPath;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrConfirmMappedLUNsTableModel
extends SJctrTableDataModel {
    public static final String KEY_COL_LUNID = "COM_COL_LUNID";
    public static final String KEY_COL_LDEVID = "COM_COL_LDEVID";
    public static final String KEY_COL_LDEVNAME = "COM_COL_LDEVNAME";
    public static final String KEY_COL_EMUTYPE = "COM_COL_EMUTYPE";
    public static final String KEY_COL_LDEVCAP = "COM_COL_LDEVCAP";
    public static final String KEY_COL_ARYGRP = "COM_COL_ARYGRP";
    public static final String KEY_COL_RAIDLEV = "COM_COL_RAIDLEV";
    public static final String KEY_COL_LUNNUM = "COM_COL_LUNNUM";
    public static final String KEY_COL_ALUAMODE = "COM_COL_ALUAMODE";
    public static final String KEY_TOTAL_CAPACITY = "COM_TOTAL_CAPACITY";
    public static final int CALC_UNIT = 1024;
    static final Format CAP_FORMAT = new DecimalFormat("0.00");
    static final BigDecimal bdLBAtoGB = new BigDecimal(0x200000);

    public SJctrConfirmMappedLUNsTableModel() {
        super(false);
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        SJctrCopyLunPathsConfirmData confirmList;
        List<SJctrPortLunTableKey> pathList;
        List<Object> retList = new ArrayList(0);
        List<?> confirmDataList = this.getDataController().getProxy().getCache(SJctrCopyLunPathsConfirmData.class);
        if (confirmDataList != null && confirmDataList.size() != 0 && (pathList = (confirmList = (SJctrCopyLunPathsConfirmData)confirmDataList.get(0)).getSelectPathList()) != null) {
            retList = pathList;
        }
        Collections.sort(retList);
        return retList;
    }

    @Override
    public void makeDataObject() {
        String totalCap = this.makeTotalCapacity();
        ((SJctrTblDataObject)this.getManageData()).setData(KEY_TOTAL_CAPACITY, totalCap);
        super.makeDataObject();
    }

    private String makeTotalCapacity() {
        long totalCap = this.makeTotalCapacityLong();
        SJctrCapacityUtility capUtil = this.getComUtility().getCapacityUtility();
        String result = capUtil.toUnitString(totalCap);
        return result;
    }

    private long makeTotalCapacityLong() {
        long totalCap = 0L;
        List<?> confirmDataList = this.getDataController().getProxy().getCache(SJctrCopyLunPathsConfirmData.class);
        if (confirmDataList == null || confirmDataList.size() == 0) {
            return 0L;
        }
        SJctrCopyLunPathsConfirmData confirmData = (SJctrCopyLunPathsConfirmData)confirmDataList.get(0);
        List<SJctrPortLunTableKey> portLunList = confirmData.getSelectPathList();
        if (portLunList == null || portLunList.size() == 0) {
            return 0L;
        }
        List<SJctrLdevDetailLUSEInfo> ldevDtlList = confirmData.getLdevDetailList();
        if (ldevDtlList == null || ldevDtlList.size() == 0) {
            return 0L;
        }
        for (SJctrPortLunTableKey portLun : portLunList) {
            SJmoPortLunDetail portlunDtl = portLun.getPortLunDetail();
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ldevIndex.setLdevIndex(portlunDtl.getSLDKC(), portlunDtl.getSCU(), portlunDtl.getSLDEV());
            Collections.sort(ldevDtlList);
            int index = Collections.binarySearch(ldevDtlList, ldevIndex);
            if (index < 0) continue;
            SJctrLdevDetailLUSEInfo ldevDtl = ldevDtlList.get(index);
            totalCap += ldevDtl.getLTotalLBASize();
        }
        return totalCap;
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        SJmoGetRange_IF ret = null;
        return ret;
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrLunIdColumnFromPortLunTableKey(KEY_COL_LUNID));
        this.addColumn(new SJctrLdevIdColumnFromPortLunTableKey(KEY_COL_LDEVID));
        this.addColumn(new SJctrLdevNameColumnFromPortLunTableKey(KEY_COL_LDEVNAME));
        SJctrEmulationTypeColumnFromPortLunTableKey emuType = new SJctrEmulationTypeColumnFromPortLunTableKey(KEY_COL_EMUTYPE);
        if (SJctrDataController.isHM()) {
            emuType.setSupportColumn(false);
        }
        this.addColumn(emuType);
        this.addColumn(new SJctrLdevCapacityLUSEColumnFromPortLunTableKey(KEY_COL_LDEVCAP));
        this.addColumn(new SJctrArrayGroupColumnFromPortLunTableKey(KEY_COL_ARYGRP));
        this.addColumn(new SJctrPathNumColumnFromPortLunTableKey(KEY_COL_LUNNUM));
        this.addColumn(new SJctrALUAModeColumnFromPortLunTableKey(KEY_COL_ALUAMODE));
        this.addColumn(new SJctrT10PiColumnFromPortLunTableKey("COM_COL_T10PI"));
    }

    @Override
    protected void setModelData(Map<SJctrGetDirectWrapper, List<?>> models) {
        HashMap map = new HashMap();
        super.setModelData(map);
        List<?> confirmDataList = this.getDataController().getProxy().getCache(SJctrCopyLunPathsConfirmData.class);
        if (confirmDataList == null || confirmDataList.size() == 0) {
            this.getLogUty().putlog("setModelData", "confirmData not found");
            return;
        }
        SJctrCopyLunPathsConfirmData confirmData = (SJctrCopyLunPathsConfirmData)confirmDataList.get(0);
        this.setBasicData(SJctrPortHostGroupTableKey.class, confirmData.getPortHGTableKeyList());
        this.setBasicData(SJctrCopyLunPathsSelectPath.class, confirmData.getSelectPathList());
        this.setBasicData(SJmoGetPortDetail.class, confirmData.getPortDetailList());
        this.setBasicData(SJmoGetPortAttributeInfo.class, confirmData.getPortAttributeList());
        this.setBasicData(SJmoGetLdevDetail.class, confirmData.getLdevDetailList());
        this.setBasicData(SJctrLdevDetailLUSEInfo.class, confirmData.getLdevDetailList());
        this.setBasicData(SJmoGetLdevNicknameInfo.class, confirmData.getLdevNicknameList());
    }
}

