/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.copylunpaths;

import java.util.ArrayList;
import java.util.List;
import sanproject.serverux.dataimpl.AddLUPath;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHGIndex;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;

public class SJctrCopyLunPathsAC
extends SJctrApplyController {
    private static final int LUNM_BASE_TIME = 30;
    private static final double COEFFICIENT = 0.003;
    List<SJctrPortHGIndex> portHGList = new ArrayList<SJctrPortHGIndex>();
    List<SJmoPortLunDetail> pathDtlList = new ArrayList<SJmoPortLunDetail>();

    public void setApplyList(List<SJctrPortHostGroupTableKey> portHGTableKeyList, List<SJctrPortLunTableKey> selectPathList) {
        for (SJctrPortHostGroupTableKey portHGTableKey : portHGTableKeyList) {
            SJctrPortHGIndex portHGIndex = new SJctrPortHGIndex();
            if (portHGTableKey.isFibre()) {
                portHGIndex.setIndex(portHGTableKey.getPortHostGroupInfo().getSPort(), portHGTableKey.getHostGroupInfo().getSHostGroup());
            } else {
                portHGIndex.setIndex(portHGTableKey.getIscsiTargetInfo().getSPort(), portHGTableKey.getIscsiTargetInfo().getSIscsiTarget());
            }
            this.portHGList.add(portHGIndex);
        }
        for (SJctrPortLunTableKey selectPath : selectPathList) {
            this.pathDtlList.add(selectPath.getPortLunDetail());
        }
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList<AddLUPath> addLUPathList = new ArrayList<AddLUPath>(this.portHGList.size() * this.pathDtlList.size());
        for (SJctrPortHGIndex portHostGroup : this.portHGList) {
            for (SJmoPortLunDetail portLun : this.pathDtlList) {
                AddLUPath addLUPath = this.createAddLUPath(portHostGroup, portLun);
                addLUPathList.add(addLUPath);
            }
        }
        int applySize = addLUPathList.size();
        ArrayList<AddLUPath> applyList = new ArrayList<AddLUPath>(applySize);
        applyList.addAll(addLUPathList);
        return applyList;
    }

    private AddLUPath createAddLUPath(SJctrPortHGIndex portHG, SJmoPortLunDetail pathDtl) {
        AddLUPath addLUPath = new AddLUPath();
        addLUPath.setSPort(portHG.getPort());
        addLUPath.setSHostGroup(portHG.getHostGroup());
        addLUPath.setSLUN(pathDtl.getSLUN());
        addLUPath.setSLDKC(pathDtl.getSLDKC());
        addLUPath.setSCU(pathDtl.getSCU());
        addLUPath.setSLDEV(pathDtl.getSLDEV());
        return addLUPath;
    }

    @Override
    public int getLeadTime() {
        ArrayList<?> applylist = this.getSetList();
        double leadtime = 30.0 + (double)applylist.size() * 0.003;
        leadtime = Math.ceil(leadtime);
        return (int)leadtime;
    }
}

