/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.copylunpaths;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.copylunpaths.SJctrConfirmMappedLUNsTableModel;
import sanproject.sn2.controller.wizard.lunm.copylunpaths.SJctrConfirmSelectedHGTableModel;
import sanproject.sn2.controller.wizard.lunm.copylunpaths.SJctrConfirmSelectedITTableModel;
import sanproject.sn2.controller.wizard.lunm.copylunpaths.SJctrCopyLunPathsConfirmData;
import sanproject.sn2.controller.wizard.lunm.copylunpaths.SJctrCopyLunPathsDC;
import sanproject.sn2.modelrc.util.SJmoRscUtil;

public class SJctrCopyLunPathsConfirmDC
extends SJctrConfirmDataController {
    protected static final int DISP_ID = 17826143;
    public static final String KEY_TABLE_HOSTGROUPS = "COM_TABLE_HOSTGROUPS";
    public static final String KEY_TABLE_ISCSI = "COM_TABLE_SELECTED_ISCSI";
    public static final String KEY_TABLE_LUNS = "COM_TABLE_LUNS";
    public static final String KEY_FIBRE_SETTING = "COM_FIBRE_SETTING";
    private boolean fibreSetting = true;
    public static int COPYLUNPATHS_CONFIRM_ERR1 = 107003;

    public SJctrCopyLunPathsConfirmDC() throws SJcException {
        super(17826143);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        SJctrCopyLunPathsConfirmData confirmData = null;
        List<?> confirmDataList = this.getCache(SJctrCopyLunPathsConfirmData.class);
        if (confirmDataList == null) {
            ret = false;
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_CONFIRM_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        if (confirmDataList.size() == 0) {
            ret = false;
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_CONFIRM_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        if (!(confirmDataList.get(0) instanceof SJctrCopyLunPathsConfirmData)) {
            ret = false;
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_CONFIRM_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        if (ret) {
            confirmData = (SJctrCopyLunPathsConfirmData)confirmDataList.get(0);
        }
        if (ret) {
            List<SJctrPortHostGroupTableKey> portHGTblKeyList = confirmData.getPortHGTableKeyList();
            if (portHGTblKeyList == null) {
                ret = false;
                SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_CONFIRM_ERR1);
                SJcException exp = err.createException();
                throw exp;
            }
            if (portHGTblKeyList.size() == 0) {
                ret = false;
                SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_CONFIRM_ERR1);
                SJcException exp = err.createException();
                throw exp;
            }
            for (SJctrPortHostGroupTableKey portHGTblKey : portHGTblKeyList) {
                if (portHGTblKey.getPortHostGroupInfo() == null && portHGTblKey.getPortIscsiTargetInfo() == null) {
                    ret = false;
                    SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_CONFIRM_ERR1);
                    SJcException exp = err.createException();
                    throw exp;
                }
                if (portHGTblKey.getHostGroupInfo() == null && portHGTblKey.getIscsiTargetInfo() == null) {
                    ret = false;
                    SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_CONFIRM_ERR1);
                    SJcException exp = err.createException();
                    throw exp;
                }
                this.fibreSetting = portHGTblKeyList.get(0).isFibre();
            }
        }
        if (ret) {
            SJcException exp;
            SJctrError err;
            List<SJctrPortLunTableKey> selectPathList = confirmData.getSelectPathList();
            if (selectPathList == null) {
                ret = false;
                err = new SJctrError(10, 22, COPYLUNPATHS_CONFIRM_ERR1);
                exp = err.createException();
                throw exp;
            }
            if (selectPathList.size() == 0) {
                ret = false;
                err = new SJctrError(10, 22, COPYLUNPATHS_CONFIRM_ERR1);
                exp = err.createException();
                throw exp;
            }
            for (SJctrPortLunTableKey selectPath : selectPathList) {
                if (selectPath.getPortLunInfo() == null) {
                    ret = false;
                    SJctrError err2 = new SJctrError(10, 22, COPYLUNPATHS_CONFIRM_ERR1);
                    SJcException exp2 = err2.createException();
                    throw exp2;
                }
                if (selectPath.getPortLunDetail() != null) continue;
                ret = false;
                SJctrError err3 = new SJctrError(10, 22, COPYLUNPATHS_CONFIRM_ERR1);
                SJcException exp3 = err3.createException();
                throw exp3;
            }
        }
        return ret;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_HOSTGROUPS, new SJctrConfirmSelectedHGTableModel());
        this.addDataObjectModel(KEY_TABLE_ISCSI, new SJctrConfirmSelectedITTableModel());
        this.addDataObjectModel(KEY_TABLE_LUNS, new SJctrConfirmMappedLUNsTableModel());
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_HG_MSG.DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrCopyLunPathsConfirmDC.this.getDataObjectModel(SJctrCopyLunPathsConfirmDC.KEY_TABLE_HOSTGROUPS);
                List<Object> selectedRows = selectedTable.getSelectedRowData();
            }
        });
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap map = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrCopyLunPathsConfirmData.class);
        map.put(SJctrCopyLunPathsConfirmData.class, confirmDataList);
        Map<String, List<?>> result = SJctrConfirmDataController.mapkeyClassToString(map);
        return result;
    }

    @Override
    public List<SJmoRscUtil> getRscUtil() {
        List<SJmoRscUtil> rscUtilList = this.getCache(SJctrCopyLunPathsDC.KEY_LUN_UTIL_DATA);
        return rscUtilList;
    }

    public static enum SELECT_HG_MSG implements SJctrNotifyState
    {
        DETAIL;

    }
}

