/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.copylunpaths;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.com.comparator.SJctrPortLunDetailComparator;
import sanproject.sn2.controller.com.comparator.SJctrPortLunDetail_LdevComparator;
import sanproject.sn2.controller.com.comparator.SJctrPortLunDetail_LunComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLdevDetailLUSEInfo;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPathIndex;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertyDC;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertySelectData;
import sanproject.sn2.controller.wizard.lunm.copylunpaths.SJctrAvailableHGTableModel;
import sanproject.sn2.controller.wizard.lunm.copylunpaths.SJctrAvailableITTableModel;
import sanproject.sn2.controller.wizard.lunm.copylunpaths.SJctrCopyLunPathsConfirmData;
import sanproject.sn2.controller.wizard.lunm.copylunpaths.SJctrSelectedHGTableModel;
import sanproject.sn2.controller.wizard.lunm.copylunpaths.SJctrSelectedITTableModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.iscsitargetproperties.SJctrIscsiTargetPropertiesDC;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrPortTypeDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevGuardInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.connector.kind.SJmoGetRscUtilLun;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevGuardInfo;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.modelrc.util.SJmoRscUtilLun;

public class SJctrCopyLunPathsDC
extends SJctrWizardDataController {
    public static final String TITLE = "DISP_TITLE_SEL_HG_IT";
    protected static final int DISP_ID = 0x1100151;
    public static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE";
    public static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    public static final String KEY_TABLE_ISCSI_AVAILABLE = "COM_TABLE_AVAILABLE_ISCSI";
    public static final String KEY_TABLE_ISCSI_SELECTED = "COM_TABLE_SELECTED_ISCSI";
    private static final String KEY_RADIO_SEL_OBJ = "COM_SELOBJINF";
    public static final String KEY_BUTTON_IS_FIBER = "COM_BUTTON_IS_FIBER";
    private SJctrPortTypeDataModel radioInfo = null;
    public static final String KEY_ADD = "COM_ADD";
    public static final String KEY_REMOVE = "COM_REMOVE";
    public static final Class KEY_CLASS_SELECT_HOST_GROUP = SJctrPathIndex.class;
    public static final Class<?> KEY_LUN_UTIL_DATA = SJmoGetRscUtilLun.class;
    public static final String KEY_TABLE = "COM_TABLE";
    SJctrPortHostGroupTableKey selectData = null;
    List<SJctrPathIndex> selectPathList = null;
    List<SJctrPortLunTableKey> selectPathTblKeyList = null;
    List portLunList = null;
    List ldevGuardList = null;
    List portHGList = null;
    List portDtlList = null;
    List portAttrList = null;
    List ldevDetailList = null;
    List ldevLuseList = null;
    List ldevNickList = null;
    SJmoHUVMvboxIndex ldevVboxId = null;
    public static int MSG_ERR_CACHE_MODEL = 107003;
    public static int COPYLUNPATHS_ERR1 = 107003;
    public static int COPYLUNPATHS_ERR2 = 106501;
    public static int COPYLUNPATHS_ERR3 = 106511;
    public static int COPYLUNPATHS_ERR4 = 106519;
    public static int COPYLUNPATHS_ERR5 = 108005;
    public static int COPYLUNPATHS_ERR6 = 105082;
    public static int COPYLUNPATHS_ERR7 = 107002;
    public static int COPYLUNPATHS_ERR8 = 105297;
    public static int COPYLUNPATHS_ERR9 = 105298;
    public static int COPYLUNPATHS_ERR_PORT_ATTR = 105019;
    public static int COPYLUNPATHS_ERR_SysRSG_HG = 205164;
    public static int COPYLUNPATHS_ERR_SysRSG_LDEV = 205165;
    public static int COPYLUNPATHS_ERR_vPort = 205166;
    static final SJctrPortLunDetailComparator PORTLUN_COMP = new SJctrPortLunDetailComparator();
    static final String KEY_TARGET_IT_INFO = "KEY_TARGET_IT_INFO";
    static final SJctrPortLunDetail_LunComparator PORTLUN_LUN_COMP = new SJctrPortLunDetail_LunComparator();
    static final SJctrPortLunDetail_LdevComparator PORTLUN_LDEV_COMP = new SJctrPortLunDetail_LdevComparator();

    public SJctrCopyLunPathsDC() throws SJcException {
        super(0x1100151);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> targetList = this.getCache(KEY_CLASS_SELECT_HOST_GROUP);
        if (targetList == null) {
            ret = false;
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        if (targetList.size() == 0) {
            ret = false;
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        if (ret) {
            for (Object portObj : targetList) {
                if (portObj instanceof SJctrPathIndex) continue;
                ret = false;
                SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR1);
                SJcException exp = err.createException();
                throw exp;
            }
        }
        if (ret) {
            this.selectPathList = targetList;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean result = true;
        SJctrError errInfo = null;
        this.initPathGroupRadio();
        List<?> rscUtilLun = this.getCache(KEY_LUN_UTIL_DATA);
        if (rscUtilLun == null || rscUtilLun.size() == 0) {
            this.logUty.putlog("checkConstructData", "SJmoRscUtilLun is not Found.");
            errInfo = new SJctrError(10, 22, MSG_ERR_CACHE_MODEL);
            throw errInfo.createException();
        }
        this.logUty.putlog("checkConstructData", "SJmoRscUtilLun = " + rscUtilLun.size());
        SJctrDataController parentDC = this.getWizardWindow().getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = parentTbl.getSelectedRowData();
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(this.selectPathList.size());
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR7);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        List<?> portLunData = this.getCache(SJmoGetPortLunInfo.class);
        SJmoPortIndex port = new SJmoPortIndex();
        port.setSPort(this.selectPathList.get(0).getPort());
        List<?> modelPortAttrList = this.getCache(SJmoGetPortAttributeInfo.class);
        Collections.sort(modelPortAttrList);
        int portAttrIndex = Collections.binarySearch(modelPortAttrList, port);
        if (portAttrIndex < 0) {
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR2);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoPortAttributeInfo seletcPortAttr = (SJmoPortAttributeInfo)modelPortAttrList.get(portAttrIndex);
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        int portDetailIndex = Collections.binarySearch(portDetailList, port);
        if (portDetailIndex < 0) {
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR2);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoPortDetail portDetail = (SJmoPortDetail)portDetailList.get(portDetailIndex);
        if (SJctrPortUtility.isHnasUserPort(portDetail)) {
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR_vPort);
            SJcException exp = err.createException();
            throw exp;
        }
        byte portKind = seletcPortAttr.getByPortKind();
        if (portKind == 5 || portKind == 6) {
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR_PORT_ATTR);
            SJcException exp = err.createException();
            throw exp;
        }
        int portLunIndex = Collections.binarySearch(portLunData, port);
        if (portLunIndex >= 0) {
            SJmoPortLunInfo portInfo = (SJmoPortLunInfo)portLunData.get(portLunIndex);
            ArrayList portLunDtlList = portInfo.getAlPortLun();
            Collections.sort(portLunDtlList, PORTLUN_COMP);
            this.selectPathTblKeyList = new ArrayList<SJctrPortLunTableKey>(this.selectPathList.size());
            for (SJctrPathIndex selectPath : this.selectPathList) {
                hgIndex.setSPort(selectPath.getPort());
                hgIndex.setSHostGroup(selectPath.getHostGroup());
                boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
                if (!rsgFlg) {
                    SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR8);
                    SJcException exp = err.createException();
                    throw exp;
                }
                boolean sysRsgFlg = rsgUtil.isSelRscHgInSysRsg(hgIndex);
                if (sysRsgFlg) {
                    SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR_SysRSG_HG);
                    SJcException exp = err.createException();
                    throw exp;
                }
                SJmoPortLunDetail pathDtl = new SJmoPortLunDetail();
                pathDtl.setSHostGroup(selectPath.getHostGroup());
                pathDtl.setSLUN(selectPath.getLun());
                int dtlIndex = Collections.binarySearch(portLunDtlList, pathDtl, PORTLUN_COMP);
                if (dtlIndex < 0) {
                    result = false;
                    SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR3);
                    if (errInfo == null) {
                        errInfo = err;
                    }
                    SJctrPortLunTableKey errKey = this.getErrorRowData(selectedRowList, selectPath);
                    SJctrErrorColumnData errData = new SJctrErrorColumnData(errKey, err);
                    errList.add(errData);
                    continue;
                }
                SJctrPortLunTableKey tableKey = new SJctrPortLunTableKey(portInfo, (SJmoPortLunDetail)portLunDtlList.get(dtlIndex));
                this.selectPathTblKeyList.add(tableKey);
            }
        } else {
            result = false;
            for (Object selectRowData : selectedRowList) {
                SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR2);
                if (errInfo == null) {
                    errInfo = err;
                }
                SJctrPortLunTableKey errKey = (SJctrPortLunTableKey)selectRowData;
                SJctrErrorColumnData errData = new SJctrErrorColumnData(errKey, err);
                errList.add(errData);
            }
        }
        if (result) {
            List<?> ldevGuardData = this.getCache(SJmoGetLdevGuardInfo.class);
            for (SJctrPortLunTableKey selectPathTblKey : this.selectPathTblKeyList) {
                SJmoLdevGuardInfo ldevGD;
                SJmoPortLunDetail selectPathDtl = selectPathTblKey.getPortLunDetail();
                SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
                ldevIndex.setLdevIndex(selectPathDtl.getSLDKC(), selectPathDtl.getSCU(), selectPathDtl.getSLDEV());
                int rsgId = rsgUtil.getRsgId(ldevIndex);
                boolean rsgFlg = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
                if (!rsgFlg) {
                    SJctrLogUty.info(this.getClass().getSimpleName(), "checkConstructData", "Extract Impossible Ldev RSG ID = " + rsgId);
                    result = false;
                    SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR9);
                    if (errInfo == null) {
                        errInfo = err;
                    }
                    SJctrErrorColumnData errData = new SJctrErrorColumnData(selectPathTblKey, err);
                    errList.add(errData);
                    continue;
                }
                boolean sysRsgFlg = rsgUtil.isSelRscLdevInSysRsg(ldevIndex);
                if (sysRsgFlg) {
                    result = false;
                    SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR_SysRSG_LDEV);
                    if (errInfo == null) {
                        errInfo = err;
                    }
                    SJctrErrorColumnData errData = new SJctrErrorColumnData(selectPathTblKey, err);
                    errList.add(errData);
                    continue;
                }
                int gdIndex = Collections.binarySearch(ldevGuardData, ldevIndex);
                if (gdIndex < 0 || gdIndex < 0 || ((ldevGD = (SJmoLdevGuardInfo)ldevGuardData.get(gdIndex)).getByLdevGuardStatus() & 8) != 8) continue;
                result = false;
                SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR5);
                if (errInfo == null) {
                    errInfo = err;
                }
                SJctrErrorColumnData errData = new SJctrErrorColumnData(selectPathTblKey, err);
                errList.add(errData);
            }
            SJmoPortLunDetail ptLunKey = this.selectPathTblKeyList.get(0).getPortLunDetail();
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ldevIndex.setLdevIndex(ptLunKey.getSLDKC(), ptLunKey.getSCU(), ptLunKey.getSLDEV());
            this.ldevVboxId = rsgUtil.getRsgFromLdev(ldevIndex).getRsgInfo().getVboxIndex();
            this.portLunList = portLunData;
            this.ldevGuardList = ldevGuardData;
        }
        if (!result) {
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        ArrayList targetList = new ArrayList();
        this.putCache("KEY_TARGET_HG_INFO", targetList);
        ArrayList targetItList = new ArrayList();
        this.putCache(KEY_TARGET_IT_INFO, targetItList);
        return result;
    }

    @Override
    public boolean checkEndData() {
        List<?> selectedList = this.getCache("KEY_TARGET_HG_INFO");
        List<?> selectedITList = this.getCache(KEY_TARGET_IT_INFO);
        if (!(selectedList != null && selectedList.size() != 0 || selectedITList != null && selectedITList.size() != 0)) {
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR6);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        List<SJctrPortHostGroupTableKey> targetHg = this.getCache("KEY_TARGET_HG_INFO");
        if (targetHg == null || targetHg.size() == 0) {
            targetHg = this.getCache(KEY_TARGET_IT_INFO);
        }
        SJctrComUtility comUtil = this.getComUtility();
        SJctrPortUtility portUtil = comUtil.getPortUtility();
        portUtil.checkPortSecurityMsg(portDetailList, targetHg, this);
        SJctrPortTypeDataModel radioInfo = (SJctrPortTypeDataModel)this.getDataObjectModel(KEY_RADIO_SEL_OBJ);
        ArrayList<Boolean> isFibreFlg = new ArrayList<Boolean>();
        isFibreFlg.add(radioInfo.isSelectFibre());
        this.putCache(KEY_BUTTON_IS_FIBER, isFibreFlg);
        return true;
    }

    public SJctrCopyLunPathsConfirmData copyLunPathsData() {
        boolean fiberSelectedFlag = this.radioInfo.isSelectFibre();
        List<?> selectedList = null;
        selectedList = fiberSelectedFlag ? this.getCache("KEY_TARGET_HG_INFO") : this.getCache(KEY_TARGET_IT_INFO);
        this.portDtlList = this.getCache(SJmoGetPortDetail.class);
        this.ldevDetailList = this.getCache(SJmoGetLdevDetail.class);
        this.ldevLuseList = this.getCache(SJmoGetLdevLuseInfo.class);
        this.ldevNickList = this.getCache(SJmoGetLdevNicknameInfo.class);
        SJctrCopyLunPathsConfirmData confirmData = new SJctrCopyLunPathsConfirmData();
        ArrayList<SJctrPortHostGroupTableKey> portHgList = new ArrayList<SJctrPortHostGroupTableKey>(selectedList.size());
        ArrayList<SJmoPortDetail> selectPortDtl = new ArrayList<SJmoPortDetail>(selectedList.size());
        ArrayList<SJmoPortAttributeInfo> selectPortAtr = new ArrayList<SJmoPortAttributeInfo>(selectedList.size());
        ArrayList<SJmoLdevDetail> selectLdevDtl = new ArrayList<SJmoLdevDetail>(this.selectPathList.size());
        ArrayList<SJmoLdevNicknameInfo> selectLdevNick = new ArrayList<SJmoLdevNicknameInfo>(this.selectPathList.size());
        for (Object selectData : selectedList) {
            SJctrPortHostGroupTableKey portHGData = (SJctrPortHostGroupTableKey)selectData;
            int dtlIndex = -1;
            int attrIndex = -1;
            if (fiberSelectedFlag) {
                dtlIndex = Collections.binarySearch(this.portDtlList, portHGData.getPortHostGroupInfo());
                attrIndex = Collections.binarySearch(this.portAttrList, portHGData.getPortHostGroupInfo());
            } else {
                dtlIndex = Collections.binarySearch(this.portDtlList, portHGData.getPortIscsiTargetInfo());
                attrIndex = Collections.binarySearch(this.portAttrList, portHGData.getPortIscsiTargetInfo());
            }
            portHgList.add(portHGData);
            if (dtlIndex >= 0) {
                selectPortDtl.add((SJmoPortDetail)this.portDtlList.get(dtlIndex));
            }
            if (attrIndex < 0) continue;
            selectPortAtr.add((SJmoPortAttributeInfo)this.portAttrList.get(attrIndex));
        }
        for (SJctrPortLunTableKey portLunTblKey : this.selectPathTblKeyList) {
            SJmoPortLunDetail portLunDtl = portLunTblKey.getPortLunDetail();
            SJmoLdevIndex ldevIndex = new SJmoLdevIndex();
            ldevIndex.setLdevIndex(portLunDtl.getSLDKC(), portLunDtl.getSCU(), portLunDtl.getSLDEV());
            int index = Collections.binarySearch(this.ldevDetailList, ldevIndex);
            if (index >= 0) {
                selectLdevDtl.add((SJmoLdevDetail)this.ldevDetailList.get(index));
            }
            if ((index = Collections.binarySearch(this.ldevNickList, ldevIndex)) < 0) continue;
            selectLdevNick.add((SJmoLdevNicknameInfo)this.ldevNickList.get(index));
        }
        List<SJctrLdevDetailLUSEInfo> ldevDtlLuse = SJctrLdevUtility.getLdevDetailLUListSEInfoList(selectLdevDtl, this.ldevDetailList, this.ldevLuseList);
        for (SJctrLdevDetailLUSEInfo dtl : ldevDtlLuse) {
            int pathNum = dtl.getILUPathNumber();
            dtl.setILUPathNumber(pathNum += portHgList.size());
        }
        Collections.sort(selectPortDtl);
        Collections.sort(selectPortAtr);
        Collections.sort(selectLdevDtl);
        Collections.sort(selectLdevNick);
        confirmData.setPortHGTableKeyList(portHgList);
        confirmData.setSelectPathList(this.selectPathTblKeyList);
        confirmData.setPortDetailList(selectPortDtl);
        confirmData.setPortAttributeList(selectPortAtr);
        confirmData.setLdevDetailList(ldevDtlLuse);
        confirmData.setLdevNicknameList(selectLdevNick);
        List<SJmoPortLunInfo> portLunInfoList = this.getCache(SJmoGetPortLunInfo.class);
        confirmData.setPortLunInfoList(portLunInfoList);
        ArrayList<SJctrCopyLunPathsConfirmData> confirmDataList = new ArrayList<SJctrCopyLunPathsConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache(SJctrCopyLunPathsConfirmData.class, confirmDataList);
        List<?> utilList = this.getCache(KEY_LUN_UTIL_DATA);
        SJmoRscUtilLun rscUtilLun = (SJmoRscUtilLun)utilList.get(0);
        this.resetRscUtil();
        rscUtilLun.clearRsvData();
        ArrayList<SJmoPortLunDetail> createLunList = new ArrayList<SJmoPortLunDetail>();
        for (SJctrPortHostGroupTableKey portHostGroup : portHgList) {
            for (SJctrPortLunTableKey portLun : this.selectPathTblKeyList) {
                short portId = -1;
                short hgId = -1;
                if (fiberSelectedFlag) {
                    portId = portHostGroup.getPortHostGroupInfo().getSPort();
                    hgId = portHostGroup.getHostGroupInfo().getSHostGroup();
                } else {
                    portId = portHostGroup.getPortIscsiTargetInfo().getSPort();
                    hgId = portHostGroup.getIscsiTargetInfo().getSIscsiTarget();
                }
                short lun = portLun.getPortLunDetail().getSLUN();
                SJmoPortLunDetail detail = new SJmoPortLunDetail();
                detail.setSPort(portId);
                detail.setSHostGroup(hgId);
                detail.setSLUN(lun);
                detail.setIDataMode(2);
                createLunList.add(detail);
            }
        }
        ArrayList<ArrayList<SJmoPortLunDetail>> rsvList = new ArrayList<ArrayList<SJmoPortLunDetail>>();
        rsvList.add(createLunList);
        rscUtilLun.setRsvData(rsvList);
        ArrayList<SJmoRscUtilLun> rscUtilLunLst = new ArrayList<SJmoRscUtilLun>();
        rscUtilLunLst.add(rscUtilLun);
        this.putCache(KEY_LUN_UTIL_DATA, rscUtilLunLst);
        return confirmData;
    }

    @Override
    public String getDispName() {
        String dispName = this.getComUtility().getGuidance("LUNM", TITLE);
        return dispName;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, new SJctrAvailableHGTableModel());
        this.addDataObjectModel(KEY_TABLE_SELECTED, new SJctrSelectedHGTableModel());
        this.addDataObjectModel(KEY_TABLE_ISCSI_AVAILABLE, new SJctrAvailableITTableModel());
        this.addDataObjectModel(KEY_TABLE_ISCSI_SELECTED, new SJctrSelectedITTableModel());
        this.radioInfo = new SJctrPortTypeDataModel();
        this.addDataObjectModel(KEY_RADIO_SEL_OBJ, this.radioInfo);
        SJctrButtonDataModel add = new SJctrButtonDataModel(){
            {
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        this.fireMessageEvent(SELECT_HG_MSG.ADD);
                    }
                });
            }

            @Override
            public Object getDataObject(SJctrDataObject inputObject) {
                return null;
            }
        };
        this.addDataObjectModel(KEY_ADD, add);
        SJctrButtonDataModel remove = new SJctrButtonDataModel(){
            {
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        this.fireMessageEvent(SELECT_HG_MSG.REMOVE);
                    }
                });
            }

            @Override
            public Object getDataObject(SJctrDataObject inputObject) {
                return null;
            }
        };
        this.addDataObjectModel(KEY_REMOVE, remove);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_HG_MSG.ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable;
                SJctrTableDataModel avaliableTable;
                if (SJctrCopyLunPathsDC.this.radioInfo.isSelectFibre()) {
                    avaliableTable = (SJctrTableDataModel)SJctrCopyLunPathsDC.this.getDataObjectModel(SJctrCopyLunPathsDC.KEY_TABLE_AVAILABLE);
                    selectedTable = (SJctrTableDataModel)SJctrCopyLunPathsDC.this.getDataObjectModel(SJctrCopyLunPathsDC.KEY_TABLE_SELECTED);
                } else {
                    avaliableTable = (SJctrTableDataModel)SJctrCopyLunPathsDC.this.getDataObjectModel(SJctrCopyLunPathsDC.KEY_TABLE_ISCSI_AVAILABLE);
                    selectedTable = (SJctrTableDataModel)SJctrCopyLunPathsDC.this.getDataObjectModel(SJctrCopyLunPathsDC.KEY_TABLE_ISCSI_SELECTED);
                }
                SJctrCopyLunPathsDC.this.radioInfo.setEnable(false);
                SJctrCopyLunPathsDC.this.radioInfo.setDirty();
                List<Object> list = avaliableTable.removeSelectedRowData();
                selectedTable.addRowDataTop(list);
                List<Object> okList = list;
                List<?> targetList = SJctrCopyLunPathsDC.this.radioInfo.isSelectFibre() ? SJctrCopyLunPathsDC.this.getCache("KEY_TARGET_HG_INFO") : SJctrCopyLunPathsDC.this.getCache(SJctrCopyLunPathsDC.KEY_TARGET_IT_INFO);
                okList.addAll(targetList);
                Collections.sort(okList);
                if (SJctrCopyLunPathsDC.this.radioInfo.isSelectFibre()) {
                    SJctrCopyLunPathsDC.this.putCache("KEY_TARGET_HG_INFO", okList);
                } else {
                    SJctrCopyLunPathsDC.this.putCache(SJctrCopyLunPathsDC.KEY_TARGET_IT_INFO, okList);
                }
                SJctrCopyLunPathsDC.this.updateFooter();
            }
        });
        this.addMessageEventListener(SELECT_HG_MSG.REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable = SJctrCopyLunPathsDC.this.radioInfo.isSelectFibre() ? (SJctrTableDataModel)SJctrCopyLunPathsDC.this.getDataObjectModel(SJctrCopyLunPathsDC.KEY_TABLE_SELECTED) : (SJctrTableDataModel)SJctrCopyLunPathsDC.this.getDataObjectModel(SJctrCopyLunPathsDC.KEY_TABLE_ISCSI_SELECTED);
                List<Object> list = selectedTable.removeSelectedRowData();
                SJctrTableDataModel avaliableTable = SJctrCopyLunPathsDC.this.radioInfo.isSelectFibre() ? (SJctrTableDataModel)SJctrCopyLunPathsDC.this.getDataObjectModel(SJctrCopyLunPathsDC.KEY_TABLE_AVAILABLE) : (SJctrTableDataModel)SJctrCopyLunPathsDC.this.getDataObjectModel(SJctrCopyLunPathsDC.KEY_TABLE_ISCSI_AVAILABLE);
                avaliableTable.addRowDataTop(list);
                List<Object> delList = list;
                ArrayList targetList = null;
                targetList = SJctrCopyLunPathsDC.this.radioInfo.isSelectFibre() ? new ArrayList(SJctrCopyLunPathsDC.this.getCache("KEY_TARGET_HG_INFO")) : new ArrayList(SJctrCopyLunPathsDC.this.getCache(SJctrCopyLunPathsDC.KEY_TARGET_IT_INFO));
                Collections.sort(delList);
                for (int i = delList.size() - 1; i >= 0; --i) {
                    SJctrPortHostGroupTableKey key = (SJctrPortHostGroupTableKey)delList.get(i);
                    int index = Collections.binarySearch(targetList, key);
                    if (index >= 0) {
                        targetList.remove(index);
                        continue;
                    }
                    SJctrCopyLunPathsDC.this.logUty.putlog("REMOVE Action", "Not found from cache list: " + key);
                }
                if (targetList.size() == 0) {
                    SJctrCopyLunPathsDC.this.radioInfo.setEnable(true);
                    SJctrCopyLunPathsDC.this.radioInfo.setDirty();
                }
                if (SJctrCopyLunPathsDC.this.radioInfo.isSelectFibre()) {
                    SJctrCopyLunPathsDC.this.putCache("KEY_TARGET_HG_INFO", targetList);
                } else {
                    SJctrCopyLunPathsDC.this.putCache(SJctrCopyLunPathsDC.KEY_TARGET_IT_INFO, targetList);
                }
                SJctrCopyLunPathsDC.this.updateFooter();
            }
        });
        this.addMessageEventListener(SELECT_HG_MSG.DETAIL_AVAILABLE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrCopyLunPathsDC.this.getDataObjectModel(SJctrCopyLunPathsDC.KEY_TABLE_AVAILABLE);
                List<Object> selectedRows = selectedTable.getSelectedRowData();
                SJctrCopyLunPathsDC.this.makeHGProperty(selectedRows);
            }
        });
        this.addMessageEventListener(SELECT_HG_MSG.DETAIL_SELECTED, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrCopyLunPathsDC.this.getDataObjectModel(SJctrCopyLunPathsDC.KEY_TABLE_SELECTED);
                List<Object> selectedRows = selectedTable.getSelectedRowData();
                SJctrCopyLunPathsDC.this.makeHGProperty(selectedRows);
            }
        });
        this.addMessageEventListener(SELECT_HG_MSG.DETAIL_ISCSI_AVAILABLE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel availableTable = (SJctrTableDataModel)SJctrCopyLunPathsDC.this.getDataObjectModel(SJctrCopyLunPathsDC.KEY_TABLE_ISCSI_AVAILABLE);
                List<Object> selectedRows = availableTable.getSelectedRowData();
                SJctrCopyLunPathsDC.this.makeITProperty(selectedRows);
            }
        });
        this.addMessageEventListener(SELECT_HG_MSG.DETAIL_ISCSI_SELECTED, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrCopyLunPathsDC.this.getDataObjectModel(SJctrCopyLunPathsDC.KEY_TABLE_ISCSI_SELECTED);
                List<Object> selectedRows = selectedTable.getSelectedRowData();
                SJctrCopyLunPathsDC.this.makeITProperty(selectedRows);
            }
        });
    }

    private void makeHGProperty(List<Object> selectedRowList) {
        if (selectedRowList.size() == 0) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "Port isn't selected.");
            return;
        }
        if (selectedRowList.size() > 1) {
            SJctrLogUty.info(this.getClass().getSimpleName(), "initListener(DETAIL Message)", "too many Port is selected. Num = " + selectedRowList.size());
            return;
        }
        SJctrHGPropertySelectData hgProperty = new SJctrHGPropertySelectData();
        SJctrPortHostGroupTableKey tblKeyData = (SJctrPortHostGroupTableKey)selectedRowList.get(0);
        SJmoPortDetail portDtl = this.searchPortDtl(tblKeyData.getPortHostGroupInfo());
        hgProperty.setData(portDtl, tblKeyData.getHostGroupInfo());
        ArrayList<SJctrHGPropertySelectData> dialogList = new ArrayList<SJctrHGPropertySelectData>();
        dialogList.add(hgProperty);
        HashMap map = new HashMap();
        map.put("HG_PROPERTY_SELECT_DATA", dialogList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrHGPropertyDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    SJmoPortDetail searchPortDtl(SJmoPortIndex port) {
        SJmoPortDetail portDtl = null;
        List<?> portDtlList = this.getCache(SJmoGetPortDetail.class);
        int dtlIndex = Collections.binarySearch(portDtlList, port);
        if (dtlIndex >= 0) {
            portDtl = (SJmoPortDetail)portDtlList.get(dtlIndex);
        }
        return portDtl;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        List<Object> filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortHostGroupInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortLunInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevGuardInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevDetail();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRscUtilLun();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    ArrayList<Object> getAvailableTableData() {
        ArrayList<Object> retList = new ArrayList<Object>();
        ArrayList<SJctrPortHostGroupTableKey> tableKeyList = new ArrayList<SJctrPortHostGroupTableKey>();
        List<?> portHGData = this.getCache(SJmoGetPortHostGroupInfo.class);
        List<?> portAttrData = this.getCache(SJmoGetPortAttributeInfo.class);
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR7);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        List<SJmoPortLunInfo> portLunData = this.getCache(SJmoGetPortLunInfo.class);
        List<SJmoPortLunDetail> selectPathDtlList = this.getSelectPathDetail(portLunData);
        boolean t10piEnable = false;
        List<?> ldevDetailList = this.getCache(SJmoGetLdevDetail.class);
        SJctrLdevIndexComparator ldevComp = new SJctrLdevIndexComparator();
        for (SJmoPortLunDetail lun : selectPathDtlList) {
            SJmoLdevDetail ldevDetail;
            boolean t10pi;
            int lunIndex = Collections.binarySearch(ldevDetailList, lun, ldevComp);
            if (lunIndex < 0 || !(t10pi = (ldevDetail = (SJmoLdevDetail)ldevDetailList.get(lunIndex)).getBT10pi())) continue;
            t10piEnable = true;
            break;
        }
        for (SJmoPortHostGroupInfo ptHGInfo : portHGData) {
            SJmoPortAttributeInfo ptAttr;
            byte attribute;
            int attrIndex = Collections.binarySearch(portAttrData, ptHGInfo);
            if (attrIndex < 0 || (attribute = (ptAttr = (SJmoPortAttributeInfo)portAttrData.get(attrIndex)).getByPortKind()) != 3 && attribute != 4 && attribute != 9) continue;
            if (t10piEnable) {
                SJmoPortDetail portDetail;
                SJmoPortIndex portIndex = new SJmoPortIndex();
                portIndex.setSPort(ptAttr.getSPort());
                int portDetailIndex = Collections.binarySearch(portDetailList, portIndex);
                if (portDetailIndex >= 0 && (portDetail = (SJmoPortDetail)portDetailList.get(portDetailIndex)).getIT10Pi() != 1) continue;
            }
            ArrayList hgList = ptHGInfo.getAlPortHostGroup();
            for (SJmoHostGroupInfo hgInfo : hgList) {
                SJctrPortHostGroupTableKey tableKey = new SJctrPortHostGroupTableKey(ptHGInfo, hgInfo);
                tableKeyList.add(tableKey);
            }
        }
        SJctrPathIndex selectPath = this.selectPathList.get(0);
        short port = selectPath.getPort();
        short hg = selectPath.getHostGroup();
        SJmoPortHostGroupInfo dummyPT = new SJmoPortHostGroupInfo();
        SJmoHostGroupInfo dummyHG = new SJmoHostGroupInfo();
        dummyPT.setSPort(port);
        dummyHG.setSHostGroup(hg);
        SJctrPortHostGroupTableKey serchData = new SJctrPortHostGroupTableKey(dummyPT, dummyHG);
        Collections.sort(tableKeyList);
        int selectIndex = Collections.binarySearch(tableKeyList, serchData);
        if (selectIndex >= 0) {
            this.selectData = (SJctrPortHostGroupTableKey)tableKeyList.get(selectIndex);
            tableKeyList.remove(selectIndex);
        }
        List<?> utilList = this.getCache(KEY_LUN_UTIL_DATA);
        SJmoRscUtilLun rscUtilLun = (SJmoRscUtilLun)utilList.get(0);
        this.resetRscUtil();
        for (SJctrPortHostGroupTableKey tblKeyData : tableKeyList) {
            SJmoRSGgetRsg hgRsg;
            SJmoHUVMvboxIndex hgVboxId;
            BitSet bsOrgHmo;
            boolean bPortCosolidationHmo;
            SJmoPortDetail portDetail;
            boolean sysRsgFlg;
            boolean addFlg = true;
            int ptIndex = Collections.binarySearch(portLunData, tblKeyData.getPortHostGroupInfo());
            if (ptIndex >= 0) {
                SJmoPortLunInfo pathInfo = portLunData.get(ptIndex);
                ArrayList pathDtlList = pathInfo.getAlHostGroupLun(tblKeyData.getHostGroupInfo().getSHostGroup());
                Collections.sort(pathDtlList);
                if (pathDtlList.size() + this.selectPathList.size() > SJctrPortUtility.PORT_LUN_MAX) continue;
                Collections.sort(pathDtlList, PORTLUN_LUN_COMP);
                for (SJmoPortLunDetail selectPathDtl : selectPathDtlList) {
                    short chkLun;
                    short chkHostGrp;
                    if (!addFlg) break;
                    short chkPort = tblKeyData.getPortHostGroupInfo().getSPort();
                    int checkRet = rscUtilLun.chkLunID(chkPort, chkHostGrp = tblKeyData.getHostGroupInfo().getSHostGroup(), chkLun = selectPathDtl.getSLUN());
                    if (checkRet == 0) continue;
                    addFlg = false;
                    break;
                }
                if (!addFlg) continue;
                Collections.sort(pathDtlList, PORTLUN_LDEV_COMP);
                for (SJmoPortLunDetail selectPathDtl : selectPathDtlList) {
                    if (Collections.binarySearch(pathDtlList, selectPathDtl, PORTLUN_LDEV_COMP) < 0) continue;
                    addFlg = false;
                    break;
                }
            }
            short chkPort = tblKeyData.getHostGroupInfo().getSPort();
            short chkHostGrp = tblKeyData.getHostGroupInfo().getSHostGroup();
            hgIndex.setSPort(chkPort);
            hgIndex.setSHostGroup(chkHostGrp);
            boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
            if (!rsgFlg || (sysRsgFlg = rsgUtil.isSelRscHgInSysRsg(hgIndex))) continue;
            SJmoPortIndex portIndex = new SJmoPortIndex();
            portIndex.setSPort(tblKeyData.getHostGroupInfo().getSPort());
            int portDetailIndex = Collections.binarySearch(portDetailList, portIndex);
            if (portDetailIndex >= 0 && SJctrPortUtility.isHnasUserPort(portDetail = (SJmoPortDetail)portDetailList.get(portDetailIndex)) || !(bPortCosolidationHmo = (bsOrgHmo = tblKeyData.getHostGroupInfo().getBtOption()).get(88)) && ((hgVboxId = (hgRsg = rsgUtil.getRsgFromHg(hgIndex)).getRsgInfo().getVboxIndex()) == null || hgVboxId.compareTo(this.ldevVboxId) != 0) || !addFlg) continue;
            retList.add(tblKeyData);
        }
        this.portAttrList = portAttrData;
        return retList;
    }

    private List<SJmoPortLunDetail> getSelectPathDetail(List<SJmoPortLunInfo> portLunList) {
        ArrayList<SJmoPortLunDetail> selectPathDtlList = new ArrayList<SJmoPortLunDetail>(this.selectPathList.size());
        List<SJmoPortLunInfo> targetList = portLunList;
        this.selectPathTblKeyList = new ArrayList<SJctrPortLunTableKey>(this.selectPathList.size());
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort(this.selectPathList.get(0).getPort());
        int index = Collections.binarySearch(targetList, portIndex);
        if (index >= 0) {
            SJmoPortLunInfo portLunInfo = targetList.get(index);
            ArrayList portLunDtlList = portLunInfo.getAlHostGroupLun(this.selectPathList.get(0).getHostGroup());
            Collections.sort(portLunDtlList, PORTLUN_LUN_COMP);
            for (SJctrPathIndex pathInfo : this.selectPathList) {
                SJmoPortLunDetail serchdata = new SJmoPortLunDetail();
                serchdata.setSHostGroup(pathInfo.getHostGroup());
                serchdata.setSLUN(pathInfo.getLun());
                int selectDtlIndex = Collections.binarySearch(portLunDtlList, serchdata, PORTLUN_LUN_COMP);
                if (selectDtlIndex < 0) continue;
                SJmoPortLunDetail selectPathDtl = (SJmoPortLunDetail)portLunDtlList.get(selectDtlIndex);
                SJctrPortLunTableKey tblKey = new SJctrPortLunTableKey(portLunInfo, selectPathDtl);
                this.selectPathTblKeyList.add(tblKey);
                selectPathDtlList.add(selectPathDtl);
            }
        }
        return selectPathDtlList;
    }

    private SJctrPortLunTableKey getErrorRowData(List selectRowDataList, SJctrPathIndex pathIndex) {
        SJctrPortLunTableKey ret = null;
        List tblKeyList = selectRowDataList;
        for (SJctrPortLunTableKey tblKey : tblKeyList) {
            SJmoPortLunInfo portLunInfo = tblKey.getPortLunInfo();
            SJmoPortLunDetail portLunDtl = tblKey.getPortLunDetail();
            SJctrPathIndex path = new SJctrPathIndex();
            path.setIndex(portLunInfo.getSPort(), portLunDtl.getSHostGroup(), portLunDtl.getSLUN());
            if (pathIndex.compareTo(path) != 0) continue;
            ret = tblKey;
            break;
        }
        return ret;
    }

    private void makeITProperty(List<Object> selectedRowList) {
        HashMap map = new HashMap();
        ArrayList<SJmoIscsiTargetInfo> itInfoList = new ArrayList<SJmoIscsiTargetInfo>(selectedRowList.size());
        for (Object ptHgTable : selectedRowList) {
            itInfoList.add(((SJctrPortHostGroupTableKey)ptHgTable).getIscsiTargetInfo());
        }
        map.put("KEY_SELECTED_ISCSI_TARGETS", itInfoList);
        SJctrRelatedDispDataObject relatedObj = this.createDialog(SJctrIscsiTargetPropertiesDC.class, map);
        this.addUpdateDisp(relatedObj);
    }

    ArrayList<Object> getAvailableIscsiTableData() {
        ArrayList<Object> retList = new ArrayList<Object>();
        ArrayList<SJctrPortHostGroupTableKey> tableKeyList = new ArrayList<SJctrPortHostGroupTableKey>();
        List<?> portITData = this.getCache(SJmoGetPortIscsiTargetInfo.class);
        List<?> portAttrData = this.getCache(SJmoGetPortAttributeInfo.class);
        List<?> rsgDetailList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR7);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJmoHostGroupIndex itIndex = new SJmoHostGroupIndex();
        List<SJmoPortLunInfo> portLunData = this.getCache(SJmoGetPortLunInfo.class);
        List<SJmoPortLunDetail> selectPathDtlList = this.getSelectPathDetail(portLunData);
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        boolean t10piEnable = false;
        List<?> ldevDetailList = this.getCache(SJmoGetLdevDetail.class);
        SJctrLdevIndexComparator ldevComp = new SJctrLdevIndexComparator();
        for (SJmoPortLunDetail lun : selectPathDtlList) {
            SJmoLdevDetail ldevDetail;
            boolean t10pi;
            int lunIndex = Collections.binarySearch(ldevDetailList, lun, ldevComp);
            if (lunIndex < 0 || !(t10pi = (ldevDetail = (SJmoLdevDetail)ldevDetailList.get(lunIndex)).getBT10pi())) continue;
            t10piEnable = true;
            break;
        }
        for (SJmoPortIscsiTargetInfo ptITInfo : portITData) {
            SJmoPortAttributeInfo ptAttr;
            byte attribute;
            int attrIndex = Collections.binarySearch(portAttrData, ptITInfo);
            if (attrIndex < 0 || (attribute = (ptAttr = (SJmoPortAttributeInfo)portAttrData.get(attrIndex)).getByPortKind()) != 3 && attribute != 4 && attribute != 9) continue;
            if (t10piEnable) {
                SJmoPortDetail portDetail;
                SJmoPortIndex portIndex = new SJmoPortIndex();
                portIndex.setSPort(ptAttr.getSPort());
                int portDetailIndex = Collections.binarySearch(portDetailList, portIndex);
                if (portDetailIndex >= 0 && (portDetail = (SJmoPortDetail)portDetailList.get(portDetailIndex)).getIT10Pi() != 1) continue;
            }
            ArrayList<SJmoIscsiTargetInfo> itList = ptITInfo.getAlPortIscsiTarget();
            for (SJmoIscsiTargetInfo itInfo : itList) {
                SJctrPortHostGroupTableKey tableKey = new SJctrPortHostGroupTableKey(ptITInfo, itInfo);
                tableKeyList.add(tableKey);
            }
        }
        SJctrPathIndex selectPath = this.selectPathList.get(0);
        short port = selectPath.getPort();
        short it = selectPath.getHostGroup();
        SJmoPortIscsiTargetInfo dummyPT = new SJmoPortIscsiTargetInfo();
        SJmoIscsiTargetInfo dummyIT = new SJmoIscsiTargetInfo();
        dummyPT.setSPort(port);
        dummyIT.setSIscsiTarget(it);
        SJctrPortHostGroupTableKey searchData = new SJctrPortHostGroupTableKey(dummyPT, dummyIT);
        Collections.sort(tableKeyList);
        int selectIndex = Collections.binarySearch(tableKeyList, searchData);
        if (selectIndex >= 0) {
            this.selectData = (SJctrPortHostGroupTableKey)tableKeyList.get(selectIndex);
            tableKeyList.remove(selectIndex);
        }
        List<?> utilList = this.getCache(KEY_LUN_UTIL_DATA);
        SJmoRscUtilLun rscUtilLun = (SJmoRscUtilLun)utilList.get(0);
        this.resetRscUtil();
        for (SJctrPortHostGroupTableKey tblKeyData : tableKeyList) {
            SJmoRSGgetRsg hgRsg;
            SJmoHUVMvboxIndex itVboxId;
            BitSet bsOrgHmo;
            boolean bPortCosolidationHmo;
            boolean addFlg = true;
            int ptIndex = Collections.binarySearch(portLunData, tblKeyData.getPortIscsiTargetInfo());
            if (ptIndex >= 0) {
                SJmoPortLunInfo pathInfo = portLunData.get(ptIndex);
                ArrayList pathDtlList = pathInfo.getAlHostGroupLun(tblKeyData.getIscsiTargetInfo().getSIscsiTarget());
                Collections.sort(pathDtlList);
                if (pathDtlList.size() + this.selectPathList.size() > SJctrPortUtility.PORT_LUN_MAX) continue;
                Collections.sort(pathDtlList, PORTLUN_LUN_COMP);
                for (SJmoPortLunDetail selectPathDtl : selectPathDtlList) {
                    short chkLun;
                    short chkIT;
                    short chkPort = tblKeyData.getPortIscsiTargetInfo().getSPort();
                    int checkRet = rscUtilLun.chkLunID(chkPort, chkIT = tblKeyData.getIscsiTargetInfo().getSIscsiTarget(), chkLun = selectPathDtl.getSLUN());
                    if (checkRet == 0) continue;
                    addFlg = false;
                    break;
                }
                if (!addFlg) continue;
                Collections.sort(pathDtlList, PORTLUN_LDEV_COMP);
                for (SJmoPortLunDetail selectPathDtl : selectPathDtlList) {
                    if (Collections.binarySearch(pathDtlList, selectPathDtl, PORTLUN_LDEV_COMP) < 0) continue;
                    addFlg = false;
                    break;
                }
                if (!addFlg) continue;
            }
            short chkPort = tblKeyData.getPortIscsiTargetInfo().getSPort();
            short chkIT = tblKeyData.getIscsiTargetInfo().getSIscsiTarget();
            itIndex.setSPort(chkPort);
            itIndex.setSHostGroup(chkIT);
            boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(itIndex, rsgUtil);
            if (!rsgFlg || !(bPortCosolidationHmo = (bsOrgHmo = tblKeyData.getIscsiTargetInfo().getBtOption()).get(88)) && ((itVboxId = (hgRsg = rsgUtil.getRsgFromHg(itIndex)).getRsgInfo().getVboxIndex()) == null || itVboxId.compareTo(this.ldevVboxId) != 0) || !addFlg) continue;
            retList.add(tblKeyData);
        }
        this.portAttrList = portAttrData;
        return retList;
    }

    private void initPathGroupRadio() {
        this.radioInfo.selectHostGroup();
        SJctrPathIndex pathIndex = this.selectPathList.get(0);
        SJmoPortDetail targetPort = new SJmoPortDetail();
        targetPort.setSPort(pathIndex.getPort());
        List<?> modelPortDetailList = this.getCache(SJmoGetPortDetail.class);
        Collections.sort(modelPortDetailList);
        int portDetailIndex = Collections.binarySearch(modelPortDetailList, targetPort);
        if (portDetailIndex < 0) {
            SJctrError err = new SJctrError(10, 22, COPYLUNPATHS_ERR2);
            SJcException exp = err.createException();
            throw exp;
        }
        SJmoPortDetail ptDetail = (SJmoPortDetail)modelPortDetailList.get(portDetailIndex);
        if (ptDetail.getByPortKindNo() == 5) {
            this.radioInfo.selectIscsi();
        }
    }

    public static enum SELECT_HG_MSG implements SJctrNotifyState
    {
        ADD,
        REMOVE,
        DETAIL_AVAILABLE,
        DETAIL_SELECTED,
        DETAIL_ISCSI_AVAILABLE,
        DETAIL_ISCSI_SELECTED;

    }
}

