/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.createaltpaths;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.column.SJctrALUAModeColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrArrayGroupColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrEmulationTypeColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLdevCapacityLUSEColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLdevIdColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLdevNameColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrLunIdColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrPathNumColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.column.SJctrT10PiColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.data.SJctrTblDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLdevDetailLUSEInfo;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsConfirmData;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsPortHGInfo;
import sanproject.sn2.controller.wizard.lunm.createaltpaths.SJctrCreateAltPathsPortLunInfo;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.inf.SJmoSearchTerm_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrConfirmMapLUNsTableModel
extends SJctrTableDataModel {
    public static final String KEY_COL_LUNID = "COM_COL_LUNID";
    public static final String KEY_COL_LDEVID = "COM_COL_LDEVID";
    public static final String KEY_COL_LDEVNAME = "COM_COL_LDEVNAME";
    public static final String KEY_COL_EMUTYPE = "COM_COL_EMUTYPE";
    public static final String KEY_COL_LDEVCAP = "COM_COL_LDEVCAP";
    public static final String KEY_COL_ARYGRP = "COM_COL_ARYGRP";
    public static final String KEY_COL_RAIDLEV = "COM_COL_RAIDLEV";
    public static final String KEY_COL_LUNNUM = "COM_COL_LUNNUM";
    public static final String KEY_COL_ALUAMODE = "COM_COL_ALUAMODE";
    public static final String KEY_TOTAL_CAPACITY = "COM_TOTAL_CAPACITY";
    public static final int CALC_UNIT = 1024;
    static final Format CAP_FORMAT = new DecimalFormat("0.00");
    static final BigDecimal bdLBAtoGB = new BigDecimal(0x200000);

    public SJctrConfirmMapLUNsTableModel() {
        super(false);
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        List<?> confirmDataList = this.getDataController().getProxy().getCache(SJctrCreateAltPathsConfirmData.class);
        if (confirmDataList == null || confirmDataList.size() == 0) {
            return new ArrayList();
        }
        SJctrCreateAltPathsConfirmData confirmData = (SJctrCreateAltPathsConfirmData)confirmDataList.get(0);
        List<SJctrCreateAltPathsPortLunInfo> portLunList = confirmData.getPortLunList();
        if (portLunList == null || portLunList.size() == 0) {
            return new ArrayList();
        }
        SJctrCreateAltPathsPortLunInfo portLunInfo = portLunList.get(0);
        ArrayList portLunDetailList = portLunInfo.getAlPortLun();
        ArrayList<SJctrPortLunTableKey> retList = new ArrayList<SJctrPortLunTableKey>(portLunDetailList.size());
        for (Object portLunDetailObj : portLunDetailList) {
            SJmoPortLunDetail portLunDetail = (SJmoPortLunDetail)portLunDetailObj;
            SJctrPortLunTableKey tableKey = new SJctrPortLunTableKey(portLunInfo, portLunDetail);
            retList.add(tableKey);
        }
        Collections.sort(retList);
        return retList;
    }

    @Override
    public void makeDataObject() {
        String totalCap = this.makeTotalCapacity();
        ((SJctrTblDataObject)this.getManageData()).setData(KEY_TOTAL_CAPACITY, totalCap);
        super.makeDataObject();
    }

    private String makeTotalCapacity() {
        long totalCap = this.makeTotalCapacityLong();
        SJctrCapacityUtility capUtil = this.getComUtility().getCapacityUtility();
        String result = capUtil.toUnitString(totalCap);
        return result;
    }

    private long makeTotalCapacityLong() {
        long totalCap = 0L;
        List<?> confirmDataList = this.getDataController().getProxy().getCache(SJctrCreateAltPathsConfirmData.class);
        if (confirmDataList == null || confirmDataList.size() == 0) {
            return 0L;
        }
        SJctrCreateAltPathsConfirmData confirmData = (SJctrCreateAltPathsConfirmData)confirmDataList.get(0);
        List<SJctrCreateAltPathsPortLunInfo> portLunList = confirmData.getPortLunList();
        if (portLunList == null || portLunList.size() == 0) {
            return 0L;
        }
        SJctrCreateAltPathsPortLunInfo portLunInfo = portLunList.get(0);
        ArrayList lunDetailList = portLunInfo.getAlPortLun();
        List<SJctrLdevDetailLUSEInfo> ldevDetailList = confirmData.getLdevDetailList();
        for (Object obj : lunDetailList) {
            SJmoPortLunDetail lunDetail = (SJmoPortLunDetail)obj;
            SJmoLdevIndex key = new SJmoLdevIndex();
            key.setLdevIndex(lunDetail.getSLDKC(), lunDetail.getSCU(), lunDetail.getSLDEV());
            int index = Collections.binarySearch(ldevDetailList, key);
            if (index < 0) continue;
            SJmoLdevDetail ldevDetail = ldevDetailList.get(index);
            totalCap += ldevDetail.getLLDEVLBASize();
        }
        return totalCap;
    }

    @Override
    protected List<SJmoSearchTerm_IF> createModelFilter(Class<? extends SJmoGetKind_IF> kindClass) {
        ArrayList<SJmoSearchTerm_IF> retList = new ArrayList<SJmoSearchTerm_IF>();
        return retList;
    }

    @Override
    protected SJmoGetRange_IF createModelRange(Class<? extends SJmoGetKind_IF> kindClass) {
        SJmoGetRange_IF ret = null;
        return ret;
    }

    @Override
    protected void initTable() {
        this.addColumn(new SJctrLunIdColumnFromPortLunTableKey(KEY_COL_LUNID));
        this.addColumn(new SJctrLdevIdColumnFromPortLunTableKey(KEY_COL_LDEVID));
        this.addColumn(new SJctrLdevNameColumnFromPortLunTableKey(KEY_COL_LDEVNAME));
        SJctrEmulationTypeColumnFromPortLunTableKey emuType = new SJctrEmulationTypeColumnFromPortLunTableKey(KEY_COL_EMUTYPE);
        if (SJctrDataController.isHM()) {
            emuType.setSupportColumn(false);
        }
        this.addColumn(emuType);
        this.addColumn(new SJctrLdevCapacityLUSEColumnFromPortLunTableKey(KEY_COL_LDEVCAP));
        this.addColumn(new SJctrArrayGroupColumnFromPortLunTableKey(KEY_COL_ARYGRP));
        this.addColumn(new SJctrPathNumColumnFromPortLunTableKey(KEY_COL_LUNNUM));
        this.addColumn(new SJctrALUAModeColumnFromPortLunTableKey(KEY_COL_ALUAMODE));
        this.addColumn(new SJctrT10PiColumnFromPortLunTableKey("COM_COL_T10PI"));
    }

    @Override
    protected void setModelData(Map<SJctrGetDirectWrapper, List<?>> models) {
        HashMap map = new HashMap();
        super.setModelData(map);
        List<?> confirmDataList = this.getDataController().getProxy().getCache(SJctrCreateAltPathsConfirmData.class);
        if (confirmDataList == null || confirmDataList.size() == 0) {
            this.getLogUty().putlog("setModelData", "confirmData not found");
            return;
        }
        SJctrCreateAltPathsConfirmData confirmData = (SJctrCreateAltPathsConfirmData)confirmDataList.get(0);
        this.setBasicData(SJctrCreateAltPathsPortHGInfo.class, confirmData.getPortHGList());
        this.setBasicData(SJctrCreateAltPathsPortLunInfo.class, confirmData.getPortLunList());
        this.setBasicData(SJmoGetPortDetail.class, confirmData.getPortDetailList());
        this.setBasicData(SJmoGetPortAttributeInfo.class, confirmData.getPortAttributeList());
        this.setBasicData(SJmoGetLdevDetail.class, confirmData.getLdevDetailList());
        this.setBasicData(SJctrLdevDetailLUSEInfo.class, confirmData.getLdevDetailList());
        this.setBasicData(SJmoGetLdevNicknameInfo.class, confirmData.getLdevNickList());
    }
}

