/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.deluuid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.com.SJctrLdevDetailLUSEInfo;
import sanproject.sn2.controller.wizard.lunm.deluuid.SJctrDelUuidAC;
import sanproject.sn2.controller.wizard.lunm.deluuid.SJctrDelUuidConfirmDC;
import sanproject.sn2.controller.wizard.lunm.deluuid.SJctrDelUuidConfirmData;
import sanproject.sn2.controller.wizard.lunm.deluuid.SJctrDelUuidErrorTableModel;
import sanproject.sn2.controller.wizard.lunm.deluuid.SJctrDelUuidSelectData;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevUuidInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevLuseInfo;
import sanproject.sn2.model.data.volume.SJmoLdevNicknameInfo;
import sanproject.sn2.model.data.volume.SJmoLdevUuidInfo;

public class SJctrDelUuidSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "DELETE_UUID";
    private static final Class<?> CONFIRM_DC = SJctrDelUuidConfirmDC.class;
    public static final String KEY_TABLE = "COM_TABLE";
    public static int DEL_UUID_ERR1 = 107001;
    public static int DEL_UUID_ERR2 = 106519;
    public static int DEL_UUID_ERR3 = 107002;
    public static int DEL_UUID_ERR4 = 105298;
    public static int DEL_UUID_ERR5 = 105145;
    public static int DEL_UUID_ERR_SysRSG_LDEV = 205165;

    @Override
    public SJctrError checkInitParam(Object param) {
        return null;
    }

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        SJctrUserController uc = wizard.getOwner();
        List<?> selectList = wizard.getCache(SJctrDelUuidSelectData.KEY_SELECT_DATA);
        if (selectList == null) {
            SJctrError err = new SJctrError(200, 22, DEL_UUID_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        if (selectList.size() == 0) {
            SJctrError err = new SJctrError(200, 22, DEL_UUID_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        if (!(selectList.get(0) instanceof SJctrDelUuidSelectData)) {
            SJctrError err = new SJctrError(200, 22, DEL_UUID_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> rsgDetailList = wizard.getCache(SJmoGetRSGgetAllRsgs.class);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(200, 22, DEL_UUID_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(uc, (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        SJctrDelUuidSelectData selectData = (SJctrDelUuidSelectData)selectList.get(0);
        List<SJmoLdevIndex> ldevIndexList = selectData.getLdevIndexList();
        if (ldevIndexList.size() == 0) {
            SJctrError err = new SJctrError(200, 22, DEL_UUID_ERR1);
            SJcException exp = err.createException();
            throw exp;
        }
        List<SJmoLdevIndex> targetLdevIndexList = selectData.getLdevIndexList();
        boolean result = true;
        SJctrError representErrorInfo = null;
        SJctrDataController parentDC = wizard.getParentDC();
        SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
        List<Object> selectedRowList = parentTbl.getSelectedRowData();
        ArrayList<SJctrErrorColumnData> errorList = new ArrayList<SJctrErrorColumnData>(targetLdevIndexList.size());
        ArrayList<SJmoLdevDetail> tableKeyList = new ArrayList<SJmoLdevDetail>(targetLdevIndexList.size());
        List<?> modelLdevDetailList = wizard.getCache(SJmoGetLdevDetail.class);
        Collections.sort(modelLdevDetailList);
        for (SJmoLdevIndex selectLdevIndex : targetLdevIndexList) {
            int rsgId = rsgUtil.getRsgId(selectLdevIndex);
            boolean rsgFlg = SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil);
            if (!rsgFlg) {
                result = false;
                SJctrLogUty.info(this.getClass().getSimpleName(), "checkConstructData", "Extract Impossible Ldev RSG ID = " + rsgId);
                SJctrError err = new SJctrError(10, 22, DEL_UUID_ERR4);
                if (representErrorInfo == null) {
                    representErrorInfo = err;
                }
                SJmoLdevDetail errorKey = new SJmoLdevDetail();
                errorKey.setLdevIndex(selectLdevIndex.getSLdkc(), selectLdevIndex.getSCu(), selectLdevIndex.getSLdev());
                tableKeyList.add(errorKey);
                SJctrErrorColumnData errorData = new SJctrErrorColumnData(errorKey, err);
                errorList.add(errorData);
                continue;
            }
            boolean sysRsgFlg = rsgUtil.isSelRscLdevInSysRsg(selectLdevIndex);
            if (sysRsgFlg) {
                result = false;
                SJctrError err = new SJctrError(10, 22, DEL_UUID_ERR_SysRSG_LDEV);
                if (representErrorInfo == null) {
                    representErrorInfo = err;
                }
                SJmoLdevDetail errorKey = new SJmoLdevDetail();
                errorKey.setLdevIndex(selectLdevIndex.getSLdkc(), selectLdevIndex.getSCu(), selectLdevIndex.getSLdev());
                tableKeyList.add(errorKey);
                SJctrErrorColumnData errorData = new SJctrErrorColumnData(errorKey, err);
                errorList.add(errorData);
                continue;
            }
            int ldevIndex = Collections.binarySearch(modelLdevDetailList, selectLdevIndex);
            if (ldevIndex < 0) {
                result = false;
                SJctrError errorInfo = new SJctrError(200, 22, DEL_UUID_ERR2);
                if (representErrorInfo == null) {
                    representErrorInfo = errorInfo;
                }
                SJmoLdevDetail errorKey = new SJmoLdevDetail();
                errorKey.setLdevIndex(selectLdevIndex.getSLdkc(), selectLdevIndex.getSCu(), selectLdevIndex.getSLdev());
                tableKeyList.add(errorKey);
                SJctrErrorColumnData errorData = new SJctrErrorColumnData(errorKey, errorInfo);
                errorList.add(errorData);
                continue;
            }
            SJmoLdevDetail ldevDetail = (SJmoLdevDetail)modelLdevDetailList.get(ldevIndex);
            if (!ldevDetail.getbExternalMfVolume()) continue;
            result = false;
            SJctrError errorInfo = new SJctrError(10, 22, DEL_UUID_ERR5);
            if (representErrorInfo == null) {
                representErrorInfo = errorInfo;
            }
            SJmoLdevDetail errorKey = new SJmoLdevDetail();
            errorKey.setLdevIndex(selectLdevIndex.getSLdkc(), selectLdevIndex.getSCu(), selectLdevIndex.getSLdev());
            tableKeyList.add(errorKey);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(errorKey, errorInfo);
            errorList.add(errorData);
        }
        if (!result) {
            SJctrDelUuidErrorTableModel errorTable = new SJctrDelUuidErrorTableModel(tableKeyList);
            errorTable.setDataController(wizard);
            errorTable.initGuidance(this.getComUtility());
            errorTable.createModelDirect();
            errorTable.divideModelData(wizard.getProxy().getModelDataMap());
            errorTable.makeDataModel();
            SJctrRelatedDispDataObject rel = wizard.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errorDC = (SJctrErrorDataController)wizard.getOwner().getDataController(rel);
            errorDC.setParameter(errorTable, errorList);
            SJcException exp = representErrorInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        this.delUuidData(targetLdevIndexList, wizard);
        SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
        SJctrDelUuidAC ac = new SJctrDelUuidAC();
        SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
        SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
        List<?> confirmDataList = dc.getProxy().getCache(SJctrDelUuidConfirmData.class);
        if (confirmDataList == null || confirmDataList.size() == 0) {
            return;
        }
        SJctrDelUuidConfirmData confirmData = (SJctrDelUuidConfirmData)confirmDataList.get(0);
        List<SJctrLdevDetailLUSEInfo> ldevDetailList = confirmData.getLdevDetailList();
        ac.setApplyList(ldevDetailList);
        wizard.addConfirmData(ac, related);
    }

    private void delUuidData(List<SJmoLdevIndex> targetLdevIndexList, SJctrWizardWindowDC wizard) {
        List<SJmoLdevDetail> modelLdevDetailList = wizard.getCache(SJmoGetLdevDetail.class);
        Collections.sort(modelLdevDetailList);
        List<SJmoLdevLuseInfo> modeLuseInfolList = wizard.getCache(SJmoGetLdevLuseInfo.class);
        Collections.sort(modeLuseInfolList);
        List<?> modelLdevUuidInfoList = wizard.getCache(SJmoGetLdevUuidInfo.class);
        Collections.sort(modelLdevUuidInfoList);
        List<?> modelLdevNickInfoList = wizard.getCache(SJmoGetLdevNicknameInfo.class);
        Collections.sort(modelLdevNickInfoList);
        ArrayList<SJmoLdevDetail> confirmLdevDetailList = new ArrayList<SJmoLdevDetail>();
        SJctrDelUuidConfirmData confirmData = new SJctrDelUuidConfirmData();
        ArrayList<SJmoLdevUuidInfo> confirmLdevUuidInfoList = new ArrayList<SJmoLdevUuidInfo>();
        ArrayList<SJmoLdevNicknameInfo> confirmLdevNickInfoList = new ArrayList<SJmoLdevNicknameInfo>();
        for (SJmoLdevIndex selectLdevIndex : targetLdevIndexList) {
            int ldevIndex = Collections.binarySearch(modelLdevDetailList, selectLdevIndex);
            SJmoLdevDetail modelLdevDetail = modelLdevDetailList.get(ldevIndex);
            confirmLdevDetailList.add(modelLdevDetail);
            int devIndex = Collections.binarySearch(modelLdevUuidInfoList, selectLdevIndex);
            if (devIndex < 0) {
                SJctrError err = new SJctrError(10, 22, DEL_UUID_ERR2);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoLdevUuidInfo modelLdevUuidInfo = (SJmoLdevUuidInfo)modelLdevUuidInfoList.get(devIndex);
            SJmoLdevUuidInfo ldevUuidInfo = null;
            try {
                ldevUuidInfo = (SJmoLdevUuidInfo)modelLdevUuidInfo.clone();
            }
            catch (CloneNotSupportedException e) {
                wizard.getOwner().getDataController(17870962).getLogUty().putlog("deleteUuidData", "LdevUuidInfo clone fail", e, 40000);
                continue;
            }
            ldevUuidInfo.setStrUuid("");
            confirmLdevUuidInfoList.add(ldevUuidInfo);
            int ldevNickIndex = Collections.binarySearch(modelLdevNickInfoList, selectLdevIndex);
            if (ldevNickIndex < 0) continue;
            SJmoLdevNicknameInfo modelLdevNickname = (SJmoLdevNicknameInfo)modelLdevNickInfoList.get(ldevNickIndex);
            confirmLdevNickInfoList.add(modelLdevNickname);
        }
        Collections.sort(confirmLdevDetailList);
        Collections.sort(confirmLdevUuidInfoList);
        Collections.sort(confirmLdevNickInfoList);
        List<SJctrLdevDetailLUSEInfo> confirmLdevLuseList = SJctrLdevUtility.getLdevDetailLUListSEInfoList(confirmLdevDetailList, modelLdevDetailList, modeLuseInfolList);
        confirmData.setLdevDetailList(confirmLdevLuseList);
        confirmData.setLdevUuidInfoList(confirmLdevUuidInfoList);
        confirmData.setLdevNickInfoList(confirmLdevNickInfoList);
        ArrayList<SJctrDelUuidConfirmData> confirmDataList = new ArrayList<SJctrDelUuidConfirmData>();
        confirmDataList.add(confirmData);
        wizard.putCache(SJctrDelUuidConfirmData.class, confirmDataList);
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] clsList = new Class[]{};
        return clsList;
    }

    @Override
    public short[] getRequireRoll() {
        return null;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        return new SJctrGuidance("COMMON", TITLE);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetLdevDetail();
        SJmoGetRange_IF range = null;
        List<Object> filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevLuseInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevUuidInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetLdevNicknameInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }
}

