/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.edithost;

import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrTextBoxEvent;
import sanproject.sn2.controller.com.model.event.SJctrTextChangeListener;

public class SJctrHostNameDataModel
extends SJctrSimpleDataModel {
    public static final String KEY_CHECKBOX = "COM_CHECKBOX";
    public static final String KEY_HOSTNAME = "COM_HOSTNAME";
    public static final String GUIDE_DISPLAY_ID_LUNM = "LUNM";
    public static final String CHKBOX_GUIDE_HOST_NAME = "DISP_HOST_NAME";
    public static final String TEXTBOX_GUIDE_HOST_NAME_MAX_CHAR = "DISP_HOST_NAME_MAX_CHAR";
    public static final String GUIDKEY_ISCSI_HOST_NAME_MAX_CHAR = "DISP_ISCSI_HOST_NAME_MAX_CHAR";
    private boolean portType = true;

    public SJctrHostNameDataModel() {
        this.initDataModel();
        this.initListener();
    }

    public SJctrHostNameDataModel(boolean portType) {
        this();
        this.portType = portType;
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        SJctrCheckBoxDataModel checkBox = (SJctrCheckBoxDataModel)this.getDataModel(KEY_CHECKBOX);
        checkBox.setLabel(util.getGuidance(GUIDE_DISPLAY_ID_LUNM, CHKBOX_GUIDE_HOST_NAME));
        SJctrTextBoxDataModel textBox = (SJctrTextBoxDataModel)this.getDataModel(KEY_HOSTNAME);
        if (this.portType) {
            textBox.setLabel(util.getGuidance(GUIDE_DISPLAY_ID_LUNM, TEXTBOX_GUIDE_HOST_NAME_MAX_CHAR));
        } else {
            textBox.setLabel(util.getGuidance(GUIDE_DISPLAY_ID_LUNM, GUIDKEY_ISCSI_HOST_NAME_MAX_CHAR));
        }
    }

    protected void initDataModel() {
        this.addDataModel(KEY_CHECKBOX, new SJctrCheckBoxDataModel("N/A:"));
        this.addDataModel(KEY_HOSTNAME, new SJctrTextBoxDataModel("N/A"));
    }

    private void initListener() {
        final SJctrCheckBoxDataModel checkBox = (SJctrCheckBoxDataModel)this.getDataModel(KEY_CHECKBOX);
        final SJctrTextBoxDataModel textBox = (SJctrTextBoxDataModel)this.getDataModel(KEY_HOSTNAME);
        checkBox.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (checkBox.isSelect()) {
                    textBox.setChangeCheck(true);
                } else {
                    textBox.setChangeCheck(false);
                }
            }
        });
        textBox.addTextChangeListener(new SJctrTextChangeListener(){

            @Override
            public void textChanged(SJctrTextBoxEvent event) {
                if (checkBox.isSelect()) {
                    textBox.setChangeCheck(true);
                } else {
                    textBox.setChangeCheck(false);
                }
            }
        });
    }
}

