/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.editt10pimode;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.editt10pimode.SJctrEditT10PIModeConfirmData;
import sanproject.sn2.controller.wizard.lunm.editt10pimode.SJctrEditT10PIModeSelectPortTableModel;
import sanproject.sn2.controller.wizard.lunm.editt10pimode.SJctrPortGroupInfo;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetChaDetail;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoChaDetail;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrEditT10PIModeDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17838177;
    public static final String TITLE = "EDIT_T10PI_MODE";
    public static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_T10PI_MODEINF = "COM_T10PI_MODEINF";
    private static final String KEY_ENABLE = "COM_ENABLE";
    private static final String KEY_DISABLE = "COM_DISABLE";
    private static final String KEY_CONSTRUCT = "COM_CONSTRUCT";
    private SJctrEditT10PIModeSelectPortTableModel selectPortTable = null;
    private SJctrRadioButtonGroupDataModel t10PIModeRadio = null;
    private List<SJmoPortDetail> editPortDtlList = Collections.emptyList();
    private List<SJctrPortGroupInfo> targetPortGrpList = Collections.emptyList();
    private boolean hasT10PIEnableLU = false;
    public static final byte PKGTYPE_FC_2PORT_16G = 119;
    public static final byte PKGTYPE_FC_4PORT_32G = 125;

    public SJctrEditT10PIModeDC() throws SJcException {
        super(17838177);
        this.initDataModel();
    }

    @Override
    public void construct() throws SJcException {
        SJctrDataObject mgrData = this.getManageData();
        mgrData.setData(KEY_CONSTRUCT, this.isConstruct());
        super.construct();
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance(TITLE);
    }

    private void initDataModel() {
        this.selectPortTable = new SJctrEditT10PIModeSelectPortTableModel(false);
        this.addDataObjectModel(KEY_TABLE, this.selectPortTable);
        this.t10PIModeRadio = new SJctrRadioButtonGroupDataModel();
        this.t10PIModeRadio.add(KEY_ENABLE);
        this.t10PIModeRadio.add(KEY_DISABLE);
        this.addDataObjectModel(KEY_T10PI_MODEINF, this.t10PIModeRadio);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    @Override
    public boolean checkStartData() {
        List<?> getList = this.getCache("COM_SELECT_PORTS");
        if (getList == null || getList.isEmpty()) {
            SJctrError err = new SJctrError(10, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        SJcException exp;
        List<?> selPortList = this.getCache("COM_SELECT_PORTS");
        List<SJmoPortDetail> portDtlList = this.getCache(SJmoGetPortDetail.class);
        if (portDtlList == null || portDtlList.isEmpty()) {
            SJctrError err = new SJctrError(10, 22, 107002);
            SJcException exp2 = err.createException();
            throw exp2;
        }
        List<SJmoPortLunInfo> portLunList = this.getCache(SJmoGetPortLunInfo.class);
        if (portLunList == null) {
            SJctrError err = new SJctrError(10, 22, 107002);
            SJcException exp3 = err.createException();
            throw exp3;
        }
        List<SJmoLdevDetail> ldevDtlList = this.getCache(SJmoGetLdevDetail.class);
        if (ldevDtlList == null) {
            SJctrError err = new SJctrError(10, 22, 107002);
            SJcException exp4 = err.createException();
            throw exp4;
        }
        List<?> allRsgList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (allRsgList == null || allRsgList.isEmpty()) {
            SJctrError err = new SJctrError(10, 22, 107002);
            SJcException exp5 = err.createException();
            throw exp5;
        }
        List<SJmoChaDetail> chaDetailList = this.getCache(SJmoGetChaDetail.class);
        if (chaDetailList == null) {
            SJctrError err = new SJctrError(10, 22, 107002);
            SJcException exp6 = err.createException();
            throw exp6;
        }
        SJmoRSGgetAllRsgs rsgInfo = (SJmoRSGgetAllRsgs)allRsgList.get(0);
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), rsgInfo);
        List<SJmoPortIndex> impossiblePortList = rsgUtil.extractImpossiblePort(portDtlList);
        this.targetPortGrpList = new ArrayList<SJctrPortGroupInfo>();
        HashSet<Short> portIdSet = new HashSet<Short>(portDtlList.size());
        ArrayList<SJctrErrorColumnData> errColmnDataList = new ArrayList<SJctrErrorColumnData>(portDtlList.size());
        this.editPortDtlList = new ArrayList<SJmoPortDetail>(portDtlList.size());
        Map<Short, SJmoChaDetail> portChaDataMap = this.getPortChaDataMap(portDtlList, chaDetailList);
        Map<SJctrPortUtility.PortGroupType, List<SJctrPortGroupInfo>> portGroupInfoMap = this.getPortGroupInfoMap();
        for (SJmoPortIndex portIndex : selPortList) {
            if (!portIdSet.add(portIndex.getSPort())) continue;
            if (!this.checkPortRSG(portIndex, impossiblePortList)) {
                errColmnDataList.add(this.cleateErrorColData(portIndex, 205203));
                continue;
            }
            SJmoPortDetail portDtl = this.getPortDetail(portIndex, portDtlList);
            if (portDtl == null) {
                SJctrError err = new SJctrError(10, 22, 107002);
                SJcException exp7 = err.createException();
                throw exp7;
            }
            if (portDtl.getIT10Pi() == 0) {
                errColmnDataList.add(this.cleateErrorColData(portIndex, 206294));
                continue;
            }
            this.editPortDtlList.add(portDtl);
            SJmoChaDetail chaDetail = portChaDataMap.get(portIndex.getSPort());
            if (chaDetail == null) {
                SJctrError err = new SJctrError(10, 22, 107002);
                exp = err.createException();
                throw exp;
            }
            SJctrPortUtility.PortGroupType portGroupType = this.getPortGroupType(chaDetail);
            if (portGroupType == null) {
                SJctrError err = new SJctrError(10, 22, 107002);
                SJcException exp8 = err.createException();
                throw exp8;
            }
            List<SJctrPortGroupInfo> portGrpList = portGroupInfoMap.get((Object)portGroupType);
            if (portGrpList == null || portGrpList.isEmpty()) {
                SJctrError err = new SJctrError(10, 22, 107002);
                SJcException exp9 = err.createException();
                throw exp9;
            }
            boolean bfind = false;
            for (SJctrPortGroupInfo portGrpIndo : portGrpList) {
                if (!portGrpIndo.containsPortGroup(portIndex)) continue;
                bfind = true;
                this.targetPortGrpList.add(portGrpIndo);
                for (SJmoPortIndex relatedPort : portGrpIndo.getRelatedPortList()) {
                    SJmoPortDetail relatedPortDtl;
                    if (!portIdSet.add(relatedPort.getSPort()) || (relatedPortDtl = this.getPortDetail(relatedPort, portDtlList)) == null) continue;
                    if (!this.checkPortRSG(relatedPort, impossiblePortList)) {
                        errColmnDataList.add(this.cleateErrorColData(relatedPort, 205203));
                        continue;
                    }
                    if (relatedPortDtl.getIT10Pi() == 0) {
                        errColmnDataList.add(this.cleateErrorColData(relatedPort, 206294));
                        continue;
                    }
                    this.editPortDtlList.add(relatedPortDtl);
                }
            }
            if (bfind) continue;
            SJctrError err = new SJctrError(10, 22, 107002);
            SJcException exp10 = err.createException();
            throw exp10;
        }
        if (!errColmnDataList.isEmpty()) {
            SJctrDataController parentDC = this.getWizardWindow().getParentDC();
            SJctrTableDataModel parentTbl = (SJctrTableDataModel)parentDC.getDataObjectModel(KEY_TABLE);
            SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
            errDc.setParameter(parentTbl, errColmnDataList);
            SJctrError errInfo = errDc.getRepresentativeError(errColmnDataList, 4);
            exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
        Collections.sort(this.editPortDtlList);
        this.hasT10PIEnableLU = this.checkT10PIEnableLu(this.editPortDtlList, portLunList, ldevDtlList);
        return true;
    }

    private boolean checkT10PIEnableLu(List<SJmoPortDetail> portList, List<SJmoPortLunInfo> portLuInfoList, List<SJmoLdevDetail> ldevDtlList) {
        SJctrLdevIndexComparator ldevComp = new SJctrLdevIndexComparator();
        for (SJmoPortIndex sJmoPortIndex : this.editPortDtlList) {
            int searchIndex = Collections.binarySearch(portLuInfoList, (Object)sJmoPortIndex);
            if (searchIndex < 0) continue;
            SJmoPortLunInfo portLunInfo = portLuInfoList.get(searchIndex);
            for (Object portLuDtl : portLunInfo.getAlPortLun()) {
                SJmoLdevDetail ldevDtl;
                searchIndex = Collections.binarySearch(ldevDtlList, portLuDtl, (Comparator)ldevComp);
                if (searchIndex < 0 || !(ldevDtl = ldevDtlList.get(searchIndex)).getBT10pi()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void makeDataModel() {
        this.selectPortTable.setTableKeyData(this.editPortDtlList);
        HashSet<Integer> t10ModeSet = new HashSet<Integer>();
        for (SJmoPortDetail portDtl : this.editPortDtlList) {
            int t10Mode = portDtl.getIT10Pi();
            if (t10Mode == 0) continue;
            t10ModeSet.add(t10Mode);
        }
        if (t10ModeSet.size() == 1) {
            int t10Mode = 0;
            Iterator i$ = t10ModeSet.iterator();
            if (i$.hasNext()) {
                Integer value = (Integer)i$.next();
                t10Mode = value;
            }
            if (t10Mode == 1) {
                this.t10PIModeRadio.setSelect(KEY_ENABLE);
            } else if (t10Mode == 2) {
                this.t10PIModeRadio.setSelect(KEY_DISABLE);
            }
        }
        if (this.hasT10PIEnableLU) {
            this.t10PIModeRadio.setEnable(KEY_DISABLE, false);
        }
        super.makeDataModel();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        SJctrButtonDataModel finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH);
        finishButton.setChangeCheck(false);
    }

    @Override
    public boolean checkEndData() {
        int t10Mode = 0;
        boolean bT10PIMode = false;
        if (this.t10PIModeRadio.isSelect(KEY_ENABLE)) {
            t10Mode = 1;
            bT10PIMode = true;
        } else {
            t10Mode = 2;
            bT10PIMode = false;
        }
        ArrayList<SJmoPortDetail> confirmPortDtlList = new ArrayList<SJmoPortDetail>(this.editPortDtlList.size());
        for (SJmoPortDetail portDtl : this.editPortDtlList) {
            SJmoPortDetail clonePortDtl = null;
            try {
                clonePortDtl = (SJmoPortDetail)portDtl.clone();
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            clonePortDtl.setIT10Pi(t10Mode);
            confirmPortDtlList.add(clonePortDtl);
        }
        for (SJctrPortGroupInfo portGrpInfo : this.targetPortGrpList) {
            portGrpInfo.setT10PIMode(bT10PIMode);
        }
        SJctrEditT10PIModeConfirmData confirmData = new SJctrEditT10PIModeConfirmData(confirmPortDtlList, this.targetPortGrpList);
        ArrayList<SJctrEditT10PIModeConfirmData> confirmDataList = new ArrayList<SJctrEditT10PIModeConfirmData>();
        confirmDataList.add(confirmData);
        this.putCache("CONFIRM_DATA", confirmDataList);
        return true;
    }

    private boolean checkPortRSG(SJmoPortIndex portIndex, List<SJmoPortIndex> impossiblePortList) {
        return Collections.binarySearch(impossiblePortList, (Object)portIndex) < 0;
    }

    private SJmoPortDetail getPortDetail(SJmoPortIndex portIndex, List<SJmoPortDetail> portDtlList) {
        SJmoPortDetail ret = null;
        int searchIndex = Collections.binarySearch(portDtlList, (Object)portIndex);
        if (searchIndex >= 0) {
            ret = portDtlList.get(searchIndex);
        }
        return ret;
    }

    private SJctrErrorColumnData cleateErrorColData(SJmoPortIndex portIndex, int errorCode) {
        SJctrError err = new SJctrError(10, 22, errorCode);
        return new SJctrErrorColumnData(portIndex, err);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        Set<SJmoGetKind_IF> kindSet = this.getKindSet();
        for (SJmoGetKind_IF kind : kindSet) {
            SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
            set.add(new SJctrGetDirectWrapper(direct));
        }
        return set;
    }

    protected Set<SJmoGetKind_IF> getKindSet() {
        HashSet<SJmoGetKind_IF> kindSet = new HashSet<SJmoGetKind_IF>();
        kindSet.add(new SJmoGetPortDetail());
        kindSet.add(new SJmoGetPortLunInfo());
        kindSet.add(new SJmoGetLdevDetail());
        kindSet.add(new SJmoGetRSGgetAllRsgs());
        kindSet.add(new SJmoGetChaDetail());
        return kindSet;
    }

    private Map<Short, SJmoChaDetail> getPortChaDataMap(List<SJmoPortDetail> portDetailList, List<SJmoChaDetail> chaDetailList) {
        HashMap<Short, SJmoChaDetail> portChaDataMap = new HashMap<Short, SJmoChaDetail>();
        block0: for (SJmoPortDetail portDetail : portDetailList) {
            for (SJmoChaDetail chaDetail : chaDetailList) {
                short chaClusterNumber = SJctrPortUtility.getPortToCluster(portDetail.getSPort());
                short chaNumber = SJctrPortUtility.getPortToCHANumber(portDetail.getSPort());
                if (chaDetail.getSCHAClusterNumber() != chaClusterNumber || chaDetail.getSCHANumber() != chaNumber) continue;
                portChaDataMap.put(portDetail.getSPort(), chaDetail);
                continue block0;
            }
        }
        return portChaDataMap;
    }

    private SJctrPortUtility.PortGroupType getPortGroupType(SJmoChaDetail chaDetail) {
        SJctrPortUtility.PortGroupType result = null;
        byte chaPackageType = chaDetail.getByCHAPackageType();
        if (chaPackageType == 119) {
            result = SJctrPortUtility.PortGroupType.PORTGROUP_2PORT;
        } else if (chaPackageType == 125) {
            result = SJctrPortUtility.PortGroupType.PORTGROUP_4PORT;
        }
        return result;
    }

    private Map<SJctrPortUtility.PortGroupType, List<SJctrPortGroupInfo>> getPortGroupInfoMap() {
        EnumMap<SJctrPortUtility.PortGroupType, List<SJctrPortGroupInfo>> portGroupInfoMap = new EnumMap<SJctrPortUtility.PortGroupType, List<SJctrPortGroupInfo>>(SJctrPortUtility.PortGroupType.class);
        for (SJctrPortUtility.PortGroupType type : SJctrPortUtility.PortGroupType.values()) {
            ArrayList<SJctrPortGroupInfo> portGroupInfoList = new ArrayList<SJctrPortGroupInfo>();
            short[][] portGrpArray = SJctrPortUtility.getPortGrpArry(type);
            for (int index = 0; index < portGrpArray.length; ++index) {
                short[] portArray = portGrpArray[index];
                SJctrPortGroupInfo portGroupInfo = new SJctrPortGroupInfo(portArray);
                portGroupInfoList.add(portGroupInfo);
            }
            portGroupInfoMap.put(type, portGroupInfoList);
        }
        return portGroupInfoMap;
    }
}

