/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.SetHostMode;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrChapUserInfoIncludeNewChap;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrChapUserWithTgInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiNameInfoIncludeNewHost;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiNameWithTgInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationErrorForInitiatorChap;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationErrorForIscsiName;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiOperationErrorForIscsiTarget;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrKeyValueSetterForChapUserWithTgInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrKeyValueSetterForIscsiNameWithTgInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrKeyValueSetterForIscsiTargetInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsConfirmData;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.data.lu.SJmoChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public class SJctrCreateIscsiTargetsAC
extends SJctrApplyController
implements SJmoKeyValueDefine_IF {
    private static final long serialVersionUID = 7501462262198956970L;
    private List<SJctrCreateIscsiTargetInfo> createIscsiTargetList;
    private static final int ERROR_PART_DIGIT = 100;
    Map<String, SJctrIscsiOperationErrorForIscsiTarget> mapIscsiTargetError = new HashMap<String, SJctrIscsiOperationErrorForIscsiTarget>();
    protected List<SJctrError> resultData = null;
    private static final int LUNM_BASE_TIME = 30;
    private static final int CHECK_TIME = 5;
    private static final double COEFFICIENT = 0.003;

    public void setApplyData(SJctrCreateIscsiTargetsConfirmData confirmData) {
        this.createIscsiTargetList = confirmData.getIscsiTargetList();
    }

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw new NullPointerException();
        }
        try {
            ArrayList<SanRequest> createIscsiRetList = this.getIscsiTarget(supplier);
            SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMcreateiScsiTarget)");
            Object createIscsiTarget = supplier.applyStart(this.getLockId(), createIscsiRetList);
            SanResponse iscsiTargetResponse = (SanResponse)createIscsiTarget;
            SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMcreateiScsiTarget)");
            SanList portIscsiTargetList = iscsiTargetResponse.getList("iScsiPorts");
            this.getMapIscsiTargetError(portIscsiTargetList);
            List<SJmoIscsiTargetInfo> removeFailIscsiTargetList = this.refinementIscsiTargetInfo();
            if (removeFailIscsiTargetList.size() == 0) {
                SJctrLogUty.info(this.title, "applyStart", "Apply since iSCSI Target is not executed. ");
            } else {
                List<SJmoIscsiTargetInfo> iscsiTargetWithInitiatorChapInfoList;
                List<SJmoIscsiTargetInfo> iscsiTargetWithTargetChapInfoList;
                ArrayList<?> setHostModeList = this.getHostMode(removeFailIscsiTargetList);
                try {
                    SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (SetHostMode)");
                    supplier.applyStart(this.getLockId(), setHostModeList);
                    SJctrLogUty.info(this.title, "applyStart", "Apply End!! (SetHostMode)");
                }
                catch (Exception e) {
                    SJctrLogUty.info(this.title, "applyStart", "exception", e);
                    SJctrError error = SJctrError.parseError(e);
                    this.setError(error);
                    for (SJmoIscsiTargetInfo targetInfo : removeFailIscsiTargetList) {
                        SJmoIscsiTargetIndex targetIndex = new SJmoIscsiTargetIndex();
                        targetIndex.setSPort(targetInfo.getSPort());
                        targetIndex.setSIscsiTarget(targetInfo.getSIscsiTarget());
                        SJctrIscsiOperationErrorForIscsiTarget iscsiError = new SJctrIscsiOperationErrorForIscsiTarget(error.getFunc(), error.getModule(), error.getError(), targetInfo.getSPort(), targetInfo.getSIscsiTarget());
                        this.mapIscsiTargetError.put(targetInfo.toString(), iscsiError);
                    }
                }
                List<SJmoIscsiTargetInfo> iscsiTargetWithIscsiNameInfoList = this.getContainsIscsiNameInfoList(removeFailIscsiTargetList);
                if (iscsiTargetWithIscsiNameInfoList.size() > 0) {
                    ArrayList<SanRequest> createIscsiNameList = this.getIscsiName(supplier, iscsiTargetWithIscsiNameInfoList);
                    SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMcreateiScsiName)");
                    Object createIscsiName = supplier.applyStart(this.getLockId(), createIscsiNameList);
                    SanResponse iscsiNameResponse = (SanResponse)createIscsiName;
                    SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMcreateiScsiName)");
                    SanList portIscsiNameList = iscsiNameResponse.getList("iScsiPorts");
                    this.getMapIscsiNameError(portIscsiNameList);
                }
                if ((iscsiTargetWithTargetChapInfoList = this.getContainsTargetChapUserInfoList(removeFailIscsiTargetList)).size() > 0) {
                    ArrayList<SanRequest> setTargetChapList = this.getTargetChapUser(supplier, iscsiTargetWithTargetChapInfoList);
                    SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMupdateiScsiTargetUser)");
                    Object setTargetChap = supplier.applyStart(this.getLockId(), setTargetChapList);
                    SanResponse targetChapResponse = (SanResponse)setTargetChap;
                    SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMupdateiScsiTargetUser)");
                    SanList targetChapList = targetChapResponse.getList("iScsiPorts");
                    this.getMapTargetChapError(targetChapList);
                }
                if ((iscsiTargetWithInitiatorChapInfoList = this.getContainsInitiatorChapUserInfoList(removeFailIscsiTargetList)).size() > 0) {
                    ArrayList<SanRequest> setInitiatorChapList = this.getInitiatorChapUser(supplier, iscsiTargetWithInitiatorChapInfoList);
                    SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (LUNMcreateiScsiRemoteUser)");
                    Object setInitiatorChap = supplier.applyStart(this.getLockId(), setInitiatorChapList);
                    SanResponse initiatorChapResponse = (SanResponse)setInitiatorChap;
                    SJctrLogUty.info(this.title, "applyStart", "Apply End!! (LUNMcreateiScsiRemoteUser)");
                    SanList initiatorChapList = initiatorChapResponse.getList("iScsiPorts");
                    this.getMapInitiatorChapError(initiatorChapList);
                }
            }
            this.setApplyResult();
        }
        catch (SanDataException e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError((Exception)((Object)e));
            this.setError(error);
        }
    }

    private void getMapIscsiTargetError(SanList iscsiPortList) {
        try {
            if (null == iscsiPortList) {
                SJctrLogUty.info(this.title, "getIscsiTargetSanList", "iscsiPortList is null.");
            } else {
                for (SanObject iscsiPort : iscsiPortList) {
                    SanList iscsiTargetList = iscsiPort.getList("iScsiTargets");
                    for (SanObject iscsiTargetInfo : iscsiTargetList) {
                        SanObject errorInfo = iscsiTargetInfo.getObj("ErrorInfo");
                        int[] errorMsg = errorInfo.getIntArray("MessageId");
                        if (0 == errorMsg[1]) continue;
                        SJmoIscsiTargetIndex targetIndex = new SJmoIscsiTargetIndex();
                        targetIndex.setSPort((short)iscsiPort.getInt("Id"));
                        targetIndex.setSIscsiTarget((short)iscsiTargetInfo.getInt("Id"));
                        SJctrIscsiOperationErrorForIscsiTarget iscsiError = new SJctrIscsiOperationErrorForIscsiTarget(errorMsg[0] / 100, errorMsg[0] % 100, errorMsg[1], iscsiPort.getInt("Id"), iscsiTargetInfo.getInt("Id"));
                        this.mapIscsiTargetError.put(targetIndex.toString(), iscsiError);
                    }
                }
            }
        }
        catch (SanDataException e) {
            SJctrLogUty.info(this.title, "getMapIscsiTargetError", "exception", e);
            SJctrError error = SJctrError.parseError((Exception)((Object)e));
            this.setError(error);
        }
    }

    private void getMapIscsiNameError(SanList iscsiPortList) {
        try {
            if (null == iscsiPortList) {
                SJctrLogUty.info(this.title, "getIscsiTargetSanList", "iscsiPortList is null.");
            } else {
                for (SanObject iscsiPort : iscsiPortList) {
                    SanList iscsiTargetList = iscsiPort.getList("iScsiTargets");
                    for (SanObject iscsiTargetInfo : iscsiTargetList) {
                        SanList iscsiNameList = iscsiTargetInfo.getList("RemoteiScsiNames");
                        for (SanObject iscsiNameInfo : iscsiNameList) {
                            SanObject errorInfo = iscsiNameInfo.getObj("ErrorInfo");
                            int[] errorMsg = errorInfo.getIntArray("MessageId");
                            if (0 == errorMsg[1]) continue;
                            SJmoIscsiTargetIndex targetIndex = new SJmoIscsiTargetIndex();
                            targetIndex.setSPort((short)iscsiPort.getInt("Id"));
                            targetIndex.setSIscsiTarget((short)iscsiTargetInfo.getInt("Id"));
                            SJmoIscsiName iscsiName = new SJmoIscsiName();
                            iscsiName.setSPort((short)iscsiPort.getInt("Id"));
                            iscsiName.setStrIscsiName(iscsiNameInfo.getString("Name"));
                            SJctrIscsiOperationErrorForIscsiName iscsiError = new SJctrIscsiOperationErrorForIscsiName(errorMsg[0] / 100, errorMsg[0] % 100, errorMsg[1], iscsiName);
                            SJctrIscsiOperationErrorForIscsiTarget errorIscsi = this.mapIscsiTargetError.get(targetIndex.toString());
                            if (errorIscsi == null) {
                                SJctrIscsiOperationErrorForIscsiTarget iscsiInfo = new SJctrIscsiOperationErrorForIscsiTarget(12, 22, 206238, iscsiPort.getInt("Id"), iscsiTargetInfo.getInt("Id"));
                                ArrayList<SJctrIscsiOperationErrorForIscsiName> tempIscsiNameList = new ArrayList<SJctrIscsiOperationErrorForIscsiName>();
                                tempIscsiNameList.add(iscsiError);
                                iscsiInfo.setErrorIscsiNameList(tempIscsiNameList);
                                this.mapIscsiTargetError.put(targetIndex.toString(), iscsiInfo);
                                continue;
                            }
                            List<SJctrIscsiOperationErrorForIscsiName> tempIscsiNameList = errorIscsi.getErrorIscsiNameList();
                            tempIscsiNameList.add(iscsiError);
                        }
                    }
                }
            }
        }
        catch (SanDataException e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError((Exception)((Object)e));
            this.setError(error);
        }
    }

    private void getMapTargetChapError(SanList iscsiPortList) {
        try {
            if (null == iscsiPortList) {
                SJctrLogUty.info(this.title, "getIscsiTargetSanList", "iscsiPortList is null.");
            } else {
                for (SanObject iscsiPort : iscsiPortList) {
                    SanList iscsiTargetList = iscsiPort.getList("iScsiTargets");
                    for (SanObject iscsiTargetInfo : iscsiTargetList) {
                        SanObject errorInfo = iscsiTargetInfo.getObj("ErrorInfo");
                        int[] errorMsg = errorInfo.getIntArray("MessageId");
                        if (0 == errorMsg[1]) continue;
                        SJmoIscsiTargetIndex targetIndex = new SJmoIscsiTargetIndex();
                        targetIndex.setSPort((short)iscsiPort.getInt("Id"));
                        targetIndex.setSIscsiTarget((short)iscsiTargetInfo.getInt("Id"));
                        SJctrIscsiOperationErrorForIscsiTarget errorIscsi = this.mapIscsiTargetError.get(targetIndex.toString());
                        if (errorIscsi != null) continue;
                        SJctrIscsiOperationErrorForIscsiTarget iscsiError = new SJctrIscsiOperationErrorForIscsiTarget(errorMsg[0] / 100, errorMsg[0] % 100, errorMsg[1], iscsiPort.getInt("Id"), iscsiTargetInfo.getInt("Id"));
                        this.mapIscsiTargetError.put(targetIndex.toString(), iscsiError);
                    }
                }
            }
        }
        catch (SanDataException e) {
            SJctrLogUty.info(this.title, "getMapIscsiTargetError", "exception", e);
            SJctrError error = SJctrError.parseError((Exception)((Object)e));
            this.setError(error);
        }
    }

    private void getMapInitiatorChapError(SanList iscsiPortList) {
        try {
            if (null == iscsiPortList) {
                SJctrLogUty.info(this.title, "getIscsiTargetSanList", "iscsiPortList is null.");
            } else {
                for (SanObject iscsiPort : iscsiPortList) {
                    SanList iscsiTargetList = iscsiPort.getList("iScsiTargets");
                    for (SanObject iscsiTargetInfo : iscsiTargetList) {
                        SanList initiatorChapList = iscsiTargetInfo.getList("RemoteiScsiUsers");
                        for (SanObject initiatorChapInfo : initiatorChapList) {
                            SanObject errorInfo = initiatorChapInfo.getObj("ErrorInfo");
                            int[] errorMsg = errorInfo.getIntArray("MessageId");
                            if (0 == errorMsg[1]) continue;
                            SJmoIscsiTargetIndex targetIndex = new SJmoIscsiTargetIndex();
                            targetIndex.setSPort((short)iscsiPort.getInt("Id"));
                            targetIndex.setSIscsiTarget((short)iscsiTargetInfo.getInt("Id"));
                            SJmoChapUserInfo chapUser = new SJmoChapUserInfo();
                            chapUser.setSPort((short)iscsiPort.getInt("Id"));
                            chapUser.setStrUserName(initiatorChapInfo.getString("UserId"));
                            SJctrIscsiOperationErrorForInitiatorChap iscsiError = new SJctrIscsiOperationErrorForInitiatorChap(errorMsg[0] / 100, errorMsg[0] % 100, errorMsg[1], chapUser);
                            SJctrIscsiOperationErrorForIscsiTarget errorIscsi = this.mapIscsiTargetError.get(targetIndex.toString());
                            if (errorIscsi == null) {
                                SJctrIscsiOperationErrorForIscsiTarget iscsiInfo = new SJctrIscsiOperationErrorForIscsiTarget(12, 22, 206237, iscsiPort.getInt("Id"), iscsiTargetInfo.getInt("Id"));
                                ArrayList<SJctrIscsiOperationErrorForInitiatorChap> tempInitiatorChapList = new ArrayList<SJctrIscsiOperationErrorForInitiatorChap>();
                                tempInitiatorChapList.add(iscsiError);
                                iscsiInfo.setErrorInitiatorChapList(tempInitiatorChapList);
                                this.mapIscsiTargetError.put(targetIndex.toString(), iscsiInfo);
                                continue;
                            }
                            List<SJctrIscsiOperationErrorForInitiatorChap> tempInitiatorChapList = errorIscsi.getErrorInitiatorChapList();
                            tempInitiatorChapList.add(iscsiError);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            SJctrLogUty.info(this.title, "applyStart", "exception", e);
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    @Override
    public ArrayList<?> getSetList() {
        ArrayList applyList = new ArrayList(1);
        return applyList;
    }

    private List<SJmoIscsiTargetInfo> refinementIscsiTargetInfo() {
        ArrayList<SJmoIscsiTargetInfo> targetList = new ArrayList<SJmoIscsiTargetInfo>();
        for (SJmoIscsiTargetInfo sJmoIscsiTargetInfo : this.createIscsiTargetList) {
            if (this.mapIscsiTargetError.containsKey(sJmoIscsiTargetInfo.toString())) continue;
            targetList.add(sJmoIscsiTargetInfo);
        }
        return targetList;
    }

    private List<SJmoIscsiTargetInfo> getContainsIscsiNameInfoList(List<SJmoIscsiTargetInfo> targetList) {
        ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = new ArrayList<SJmoIscsiTargetInfo>();
        for (SJmoIscsiTargetInfo createIscsiInfo : targetList) {
            if (createIscsiInfo.getAlIscsiName().size() <= 0) continue;
            iscsiTargetList.add(createIscsiInfo);
        }
        return iscsiTargetList;
    }

    private List<SJmoIscsiTargetInfo> getContainsTargetChapUserInfoList(List<SJmoIscsiTargetInfo> targetList) {
        ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = new ArrayList<SJmoIscsiTargetInfo>();
        for (SJmoIscsiTargetInfo createIscsiInfo : targetList) {
            if (createIscsiInfo.getStrTargetUserName().length() <= 0) continue;
            iscsiTargetList.add(createIscsiInfo);
        }
        return iscsiTargetList;
    }

    private List<SJmoIscsiTargetInfo> getContainsInitiatorChapUserInfoList(List<SJmoIscsiTargetInfo> targetList) {
        ArrayList<SJmoIscsiTargetInfo> iscsiTargetList = new ArrayList<SJmoIscsiTargetInfo>();
        for (SJmoIscsiTargetInfo createIscsiInfo : targetList) {
            if (createIscsiInfo.getAlUserInfo().size() <= 0) continue;
            iscsiTargetList.add(createIscsiInfo);
        }
        return iscsiTargetList;
    }

    private ArrayList<SanRequest> getIscsiTarget(SJdsSupplierAgent supplier) throws SanDataException {
        SanRequest requestData = supplier.newRequest("LUNMcreateiScsiTarget");
        SJctrKeyValueSetterForIscsiTargetInfo paramSetter = new SJctrKeyValueSetterForIscsiTargetInfo(){

            @Override
            protected void setIscsiTargetSubParam(SanObject setIscsiTgObj, Object iscsiTgInfo) throws SanDataException {
                setIscsiTgObj.putString("Name", ((SJmoIscsiTargetInfo)iscsiTgInfo).getStrIscsiTargetName());
                setIscsiTgObj.putString("Alias", ((SJmoIscsiTargetInfo)iscsiTgInfo).getStrIscsiTargetAlias());
                setIscsiTgObj.putInt("UserAuthSwitch", ((SJmoIscsiTargetInfo)iscsiTgInfo).getiUserAuthentSwitch());
                setIscsiTgObj.putInt("AuthMode", ((SJmoIscsiTargetInfo)iscsiTgInfo).getiAuthentMode());
            }
        };
        paramSetter.setRequestParam(requestData, this.createIscsiTargetList);
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
        applyList.add(requestData);
        return applyList;
    }

    private ArrayList<?> getHostMode(List<SJmoIscsiTargetInfo> targetList) {
        ArrayList<SetHostMode> retList = new ArrayList<SetHostMode>();
        for (SJmoIscsiTargetInfo iscsiTarget : targetList) {
            SetHostMode hostModeInfo = new SetHostMode();
            hostModeInfo.setSPort(iscsiTarget.getSPort());
            hostModeInfo.setSHostgroupID(iscsiTarget.getSIscsiTarget());
            hostModeInfo.setByHostMode((byte)iscsiTarget.getIHostMode());
            hostModeInfo.setBtOption(iscsiTarget.getBtOption());
            retList.add(hostModeInfo);
        }
        return retList;
    }

    private ArrayList<SanRequest> getIscsiName(SJdsSupplierAgent supplier, List<SJmoIscsiTargetInfo> targetList) throws SanDataException {
        SanRequest requestData = supplier.newRequest("LUNMcreateiScsiName");
        SJctrKeyValueSetterForIscsiNameWithTgInfo paramSetter = new SJctrKeyValueSetterForIscsiNameWithTgInfo(){

            @Override
            protected void setIscsiNameSubParam(SanObject setIscsiTgObj, SJmoIscsiName setIscsiNameInfo) throws SanDataException {
                setIscsiTgObj.putString("NickName", ((SJctrIscsiNameInfoIncludeNewHost)setIscsiNameInfo).getStrIscsiNickName());
            }
        };
        ArrayList<SJctrIscsiNameWithTgInfo> hostWithTgList = new ArrayList<SJctrIscsiNameWithTgInfo>();
        for (SJmoIscsiTargetInfo createIscs : targetList) {
            for (SJmoIscsiName newHost : createIscs.getAlIscsiName()) {
                SJctrIscsiNameWithTgInfo chapWith = new SJctrIscsiNameWithTgInfo(newHost, createIscs);
                hostWithTgList.add(chapWith);
            }
        }
        paramSetter.setRequestParam(requestData, hostWithTgList);
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
        applyList.add(requestData);
        return applyList;
    }

    private ArrayList<SanRequest> getTargetChapUser(SJdsSupplierAgent supplier, List<SJmoIscsiTargetInfo> targetList) throws SanDataException {
        SanRequest requestData = supplier.newRequest("LUNMupdateiScsiTargetUsers");
        SJctrKeyValueSetterForIscsiTargetInfo paramSetter = new SJctrKeyValueSetterForIscsiTargetInfo(){

            @Override
            protected void setIscsiTargetSubParam(SanObject setIscsiTgObj, Object iscsiTgInfo) throws SanDataException {
                setIscsiTgObj.putString("UserId", ((SJmoIscsiTargetInfo)iscsiTgInfo).getStrTargetUserName());
                setIscsiTgObj.putString("Secret", ((SJmoIscsiTargetInfo)iscsiTgInfo).getStrTargetSecret());
            }
        };
        paramSetter.setRequestParam(requestData, targetList);
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
        applyList.add(requestData);
        return applyList;
    }

    private ArrayList<SanRequest> getInitiatorChapUser(SJdsSupplierAgent supplier, List<SJmoIscsiTargetInfo> targetList) throws SanDataException {
        SanRequest requestData = supplier.newRequest("LUNMcreateiScsiRemoteUsers");
        SJctrKeyValueSetterForChapUserWithTgInfo paramSetter = new SJctrKeyValueSetterForChapUserWithTgInfo(){

            @Override
            protected void setChapUserSubParam(SanObject setIscsiTgObj, SJmoChapUserInfo setChapUserInfo) throws SanDataException {
                setIscsiTgObj.putString("Secret", ((SJctrChapUserInfoIncludeNewChap)setChapUserInfo).getStrSecret());
            }
        };
        ArrayList<SJctrChapUserWithTgInfo> chapWithTgList = new ArrayList<SJctrChapUserWithTgInfo>();
        for (SJmoIscsiTargetInfo createIscs : targetList) {
            for (SJmoChapUserInfo newChap : createIscs.getAlUserInfo()) {
                SJctrChapUserWithTgInfo chapWith = new SJctrChapUserWithTgInfo(newChap, createIscs);
                chapWithTgList.add(chapWith);
            }
        }
        paramSetter.setRequestParam(requestData, chapWithTgList);
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
        applyList.add(requestData);
        return applyList;
    }

    protected void setApplyResult() {
        super.setApplyResult(null);
        int funcErc = 12;
        int moduleErc = 22;
        int delegateErc = 0;
        SJctrError error = new SJctrError(funcErc, moduleErc, delegateErc);
        this.resultData = new ArrayList<SJctrIscsiOperationErrorForIscsiTarget>(this.mapIscsiTargetError.values());
        if (this.resultData.size() > 0) {
            this.setError(this.resultData.get(0));
        } else {
            this.setError(error);
        }
    }

    @Override
    protected List<SJctrError> getResultData() {
        return this.resultData;
    }

    @Override
    public boolean hasApplyResult() {
        boolean rtn = false;
        if (this.resultData != null && this.resultData.size() > 0) {
            rtn = true;
        }
        return rtn;
    }

    @Override
    public int getLeadTime() {
        int counter = 0;
        counter = this.createIscsiTargetList.size();
        for (SJctrCreateIscsiTargetInfo createIscsiInfo : this.createIscsiTargetList) {
            if (createIscsiInfo.getAlIscsiName().size() > 0) {
                counter += createIscsiInfo.getAlIscsiName().size();
            }
            if (createIscsiInfo.getStrTargetUserName().length() > 0) {
                ++counter;
            }
            if (createIscsiInfo.getAlUserInfo().size() <= 0) continue;
            ++counter;
        }
        int leadTime = SJctrIscsiUtility.getLeadTime(counter, 1.0, 3200.0);
        leadTime = (int)((double)leadTime + (30.0 + (double)this.createIscsiTargetList.size() * 0.003 + 5.0));
        return leadTime;
    }
}

