/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrChapUserInfoIncludeNewChap;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrIscsiDataMacro;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsRsgDataModel;
import sanproject.sn2.model.data.lu.SJmoChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.modelrc.util.SJmoRscUtilIscsiTarget;

public class SJctrPortIscsiTargetData
implements Serializable {
    private final BitSet targetIdSet = new BitSet();
    private final Set<String> targetAliasSet = new HashSet<String>();
    private final Set<String> targetNameSet = new HashSet<String>();
    private final Set<String> targetChapNameSet = new HashSet<String>();
    private final HashMap<Integer, Integer> userSeqNoMap = new HashMap();
    private final HashMap<String, Integer> iscsiNameMap = new HashMap();
    private final HashMap<String, Integer> initiatorChapUserMap = new HashMap();
    private final HashMap<String, String> hostInfoMap = new HashMap();

    SJctrPortIscsiTargetData() {
    }

    public boolean addIscsiTarget(SJctrCreateIscsiTargetInfo targetInfo) {
        int value;
        boolean ret = true;
        this.targetIdSet.set(targetInfo.getSIscsiTarget());
        this.targetAliasSet.add(targetInfo.getStrIscsiTargetAlias());
        this.targetNameSet.add(targetInfo.getStrIscsiTargetName());
        for (SJmoIscsiName iscsiNameInfo : targetInfo.getAlIscsiName()) {
            String hbaName = iscsiNameInfo.getStrIscsiName();
            this.hostInfoMap.put(hbaName, iscsiNameInfo.getStrIscsiNickName());
            if (this.iscsiNameMap.containsKey(hbaName)) {
                value = this.iscsiNameMap.get(hbaName);
                this.iscsiNameMap.put(hbaName, ++value);
                continue;
            }
            value = 1;
            this.iscsiNameMap.put(hbaName, value);
        }
        for (SJmoChapUserInfo chapUserInfo : targetInfo.getAlUserInfo()) {
            String userName = chapUserInfo.getStrUserName();
            if (this.initiatorChapUserMap.containsKey(userName)) {
                value = this.initiatorChapUserMap.get(userName);
                this.initiatorChapUserMap.put(userName, ++value);
                continue;
            }
            value = 1;
            this.initiatorChapUserMap.put(userName, value);
        }
        if (targetInfo.getStrTargetUserName().length() != 0) {
            this.targetChapNameSet.add(targetInfo.getStrTargetUserName());
        }
        for (SJctrChapUserInfoIncludeNewChap newChapInfo : targetInfo.getInitiatorChapUserList()) {
            int userSeqNo = newChapInfo.getUserSeqNo();
            if (this.userSeqNoMap.containsKey(newChapInfo.getUserSeqNo())) {
                value = this.userSeqNoMap.get(userSeqNo);
                this.userSeqNoMap.put(userSeqNo, ++value);
                continue;
            }
            value = 1;
            this.userSeqNoMap.put(userSeqNo, value);
        }
        return ret;
    }

    public boolean removeIscsiTarget(SJctrCreateIscsiTargetInfo targetInfo) {
        int value;
        boolean ret = true;
        this.targetIdSet.clear(targetInfo.getSIscsiTarget());
        this.targetAliasSet.remove(targetInfo.getStrIscsiTargetAlias());
        this.targetNameSet.remove(targetInfo.getStrIscsiTargetName());
        for (SJmoIscsiName iscsiNameInfo : targetInfo.getAlIscsiName()) {
            String hbaName = iscsiNameInfo.getStrIscsiName();
            value = this.iscsiNameMap.get(hbaName);
            if (value <= 1) {
                this.iscsiNameMap.remove(hbaName);
                this.hostInfoMap.remove(hbaName);
                continue;
            }
            this.iscsiNameMap.put(hbaName, --value);
        }
        for (SJmoChapUserInfo chapUserInfo : targetInfo.getAlUserInfo()) {
            String userName = chapUserInfo.getStrUserName();
            value = this.initiatorChapUserMap.get(userName);
            if (value <= 1) {
                this.initiatorChapUserMap.remove(userName);
                continue;
            }
            this.initiatorChapUserMap.put(userName, --value);
        }
        this.targetChapNameSet.remove(targetInfo.getStrTargetUserName());
        for (SJctrChapUserInfoIncludeNewChap newChapInfo : targetInfo.getInitiatorChapUserList()) {
            int userSeqNo = newChapInfo.getUserSeqNo();
            value = this.userSeqNoMap.get(userSeqNo);
            if (value <= 1) {
                this.userSeqNoMap.remove(userSeqNo);
                continue;
            }
            this.userSeqNoMap.put(userSeqNo, --value);
        }
        return ret;
    }

    public short acquireIscsiTargetId(SJmoRscUtilIscsiTarget rscutilTarget, short sPort, SJctrResourceGroupUtility rsgUtil, SJctrCreateIscsiTargetsRsgDataModel rsgDataModel) {
        short sIscsiTarget = 0;
        int chkIscsiId = 3;
        SJmoHostGroupIndex hostIndex = new SJmoHostGroupIndex();
        String rsgComboSelect = rsgDataModel.getSelection();
        boolean anyFlg = rsgComboSelect.equals("Any");
        while (sIscsiTarget < SJctrIscsiDataMacro.PORT_ISCSITARGET_MAX) {
            if ((sIscsiTarget = (short)this.targetIdSet.nextClearBit(sIscsiTarget)) >= SJctrIscsiDataMacro.PORT_ISCSITARGET_MAX) continue;
            hostIndex.setSHostGroup(sIscsiTarget);
            hostIndex.setSPort(sPort);
            int rsgId = rsgUtil.getRsgId(hostIndex);
            if (!SJctrPortUtility.chkResourceGroup(rsgId, rsgUtil)) {
                sIscsiTarget = (short)(sIscsiTarget + 1);
                continue;
            }
            if (!anyFlg && rsgId != Integer.valueOf(rsgComboSelect)) {
                sIscsiTarget = (short)(sIscsiTarget + 1);
                continue;
            }
            chkIscsiId = rscutilTarget.chkIscsiTargetID(sPort, sIscsiTarget);
            if (chkIscsiId == 0) break;
            sIscsiTarget = (short)(sIscsiTarget + 1);
        }
        return sIscsiTarget;
    }

    public boolean containsIscsiTargetAlias(String iscsiTargetAlias) {
        return this.targetAliasSet.contains(iscsiTargetAlias);
    }

    public boolean containsIscsiTargetName(String iscsiTargetName) {
        return this.targetNameSet.contains(iscsiTargetName);
    }

    public boolean containsHbaIscsiName(String hbaIscsiName) {
        return this.hostInfoMap.containsKey(hbaIscsiName);
    }

    public boolean containsHostName(String hostName) {
        return this.hostInfoMap.containsValue(hostName);
    }

    public boolean containsInitiatorChapUserSeqNo(int seqNo) {
        return this.userSeqNoMap.containsKey(seqNo);
    }

    public boolean containsInitiatorChapUserName(String chapUserName) {
        return this.initiatorChapUserMap.containsKey(chapUserName);
    }

    public boolean containsTargetChapUserName(String chapUserName) {
        return this.targetChapNameSet.contains(chapUserName);
    }

    public List<String> getHbaIscsiNameList() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.addAll(this.hostInfoMap.keySet());
        return retList;
    }

    public List<String> getChapUserNameList() {
        ArrayList<String> retList = new ArrayList<String>();
        retList.addAll(this.initiatorChapUserMap.keySet());
        return retList;
    }

    public HashMap<String, String> getHostMap() {
        return this.hostInfoMap;
    }
}

