/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.iscsitargetproperties;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.com.SJctrChapUserInfoIncludeNewChap;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetInfo;
import sanproject.sn2.controller.wizard.lunm.iscsi.iscsitargetproperties.SJctrIscsiTargetPropertiesChapUsersTableDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.iscsitargetproperties.SJctrIscsiTargetPropertiesHostsTableDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.iscsitargetproperties.SJctrIscsiTargetPropertiesSummaryDataModel;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.lu.SJmoChapUserInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiName;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;

public class SJctrIscsiTargetPropertiesDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 33595527;
    private static final String KEY_SUMMARY = "COM_SUMMARY";
    private static final String KEY_TABLE_HOSTS = "COM_TABLE_HOSTS";
    private static final String KEY_TABLE_CHAP_USERS = "COM_TABLE_CHAP_USERS";
    public static final String KEY_ISCSI_NAME_APPLY_ERROR = "COM_ISCSI_NAME_APPLY_ERROR";
    public static final String KEY_CHAP_USER_APPLY_ERROR = "COM_CHAP_USER_APPLY_ERROR";

    public SJctrIscsiTargetPropertiesDC() throws SJcException {
        super(33595527);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrIscsiTargetPropertiesSummaryDataModel propSummary = new SJctrIscsiTargetPropertiesSummaryDataModel();
        SJctrIscsiTargetPropertiesHostsTableDataModel tableHosts = new SJctrIscsiTargetPropertiesHostsTableDataModel();
        tableHosts.setPaging(false);
        SJctrIscsiTargetPropertiesChapUsersTableDataModel tableChapUsers = new SJctrIscsiTargetPropertiesChapUsersTableDataModel();
        tableChapUsers.setPaging(false);
        this.addDataObjectModel(KEY_SUMMARY, propSummary);
        this.addDataObjectModel(KEY_TABLE_HOSTS, tableHosts);
        this.addDataObjectModel(KEY_TABLE_CHAP_USERS, tableChapUsers);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    @Override
    public boolean checkStartData() {
        List<?> viewDataList = this.getProxy().getCache("KEY_SELECTED_ISCSI_TARGETS");
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        viewDataList = this.getProxy().getCache(SJmoGetPortDetail.class.getName());
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        viewDataList = this.getProxy().getCache(SJmoGetRSGgetAllRsgs.class.getName());
        if (null == viewDataList) {
            this.logUty.putlog("checkStartData", "Inherited list data is null.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == viewDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of inherited list data is zero.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (((SJmoRSGgetAllRsgs)viewDataList.get(0)).getRsgs() == null) {
            this.logUty.putlog("checkStartData", "Resource Group data is null.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return true;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<SJmoRSGgetAllRsgs> rsgAllList;
            List<?> iscsiInfoList = this.getCache("KEY_SELECTED_ISCSI_TARGETS");
            SJmoIscsiTargetInfo iscsiInfo = (SJmoIscsiTargetInfo)iscsiInfoList.get(0);
            short iscsiPortIndex = iscsiInfo.getSPort();
            SJmoPortDetail summaryPortDetail = null;
            SJmoRSGgetRsg summaryRsg = null;
            List<SJmoPortDetail> portDetailList = SJctrIscsiUtility.getSJmoPortDetailList(this);
            summaryPortDetail = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortId(portDetailList, iscsiPortIndex);
            if (summaryPortDetail == null) {
                this.logUty.putlog("checkConstructData", "Port Detail data is null.");
            }
            if ((summaryRsg = SJctrIscsiUtility.getRsgInfoIncludeSpecifyIscsiTarget((rsgAllList = SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(this)).get(0).getRsgs(), iscsiInfo)) == null) {
                this.logUty.putlog("checkConstructData", "Resource Group data is null.");
            }
            SJctrIscsiTargetPropertiesSummaryDataModel summaryDataModel = (SJctrIscsiTargetPropertiesSummaryDataModel)this.getDataObjectModel(KEY_SUMMARY);
            summaryDataModel.setSummaryData(iscsiInfo, summaryPortDetail, summaryRsg);
            ArrayList<SJmoIscsiName> iscsiNameInfoList = iscsiInfo.getAlIscsiName();
            SJctrIscsiTargetPropertiesHostsTableDataModel hostsTableDataModel = (SJctrIscsiTargetPropertiesHostsTableDataModel)this.getDataObjectModel(KEY_TABLE_HOSTS);
            hostsTableDataModel.setBasicDataList(iscsiNameInfoList);
            SJctrIscsiTargetPropertiesChapUsersTableDataModel chapUsersTableDataModel = (SJctrIscsiTargetPropertiesChapUsersTableDataModel)this.getDataObjectModel(KEY_TABLE_CHAP_USERS);
            if (iscsiInfoList.get(0) instanceof SJctrCreateIscsiTargetInfo) {
                SJctrCreateIscsiTargetInfo createTargetInfo = (SJctrCreateIscsiTargetInfo)iscsiInfoList.get(0);
                List<SJctrChapUserInfoIncludeNewChap> iscsiChapUserInfoList = createTargetInfo.getInitiatorChapUserList();
                chapUsersTableDataModel.setBasicDataList(iscsiChapUserInfoList);
            } else {
                ArrayList<SJmoChapUserInfo> iscsiChapUserInfoList = iscsiInfo.getAlUserInfo();
                chapUsersTableDataModel.setBasicDataList(iscsiChapUserInfoList);
            }
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107002);
        }
        return true;
    }

    @Override
    public void makeDataModel() {
        SJctrErrorTableModel errTable;
        super.makeDataModel();
        List<SJctrErrorColumnData> errorIscsiNameInfo = this.getProxy().getCache(KEY_ISCSI_NAME_APPLY_ERROR);
        List<SJctrErrorColumnData> errorChapUserInfo = this.getProxy().getCache(KEY_CHAP_USER_APPLY_ERROR);
        if (null != errorIscsiNameInfo) {
            SJctrIscsiTargetPropertiesHostsTableDataModel hostTable = (SJctrIscsiTargetPropertiesHostsTableDataModel)this.getDataObjectModel(KEY_TABLE_HOSTS);
            errTable = new SJctrErrorTableModel();
            this.addDataObjectModel(KEY_TABLE_HOSTS, errTable);
            Comparator iscsiNamecomp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    SJmoIscsiName comp1 = (SJmoIscsiName)SJctrIscsiTargetPropertiesDC.this.getValue(o1);
                    SJmoIscsiName comp2 = (SJmoIscsiName)SJctrIscsiTargetPropertiesDC.this.getValue(o2);
                    String name1 = comp1.getStrIscsiName();
                    String name2 = comp2.getStrIscsiName();
                    return name1.compareTo(name2);
                }
            };
            errTable.initialize(hostTable, errorIscsiNameInfo, iscsiNamecomp);
            errTable.makeDataModel();
        }
        if (null != errorChapUserInfo) {
            SJctrIscsiTargetPropertiesChapUsersTableDataModel chapUserTable = (SJctrIscsiTargetPropertiesChapUsersTableDataModel)this.getDataObjectModel(KEY_TABLE_CHAP_USERS);
            errTable = new SJctrErrorTableModel();
            this.addDataObjectModel(KEY_TABLE_CHAP_USERS, errTable);
            Comparator chapUsercomp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    SJmoChapUserInfo comp1 = (SJmoChapUserInfo)SJctrIscsiTargetPropertiesDC.this.getValue(o1);
                    SJmoChapUserInfo comp2 = (SJmoChapUserInfo)SJctrIscsiTargetPropertiesDC.this.getValue(o2);
                    String name1 = comp1.getStrUserName();
                    String name2 = comp2.getStrUserName();
                    return name1.compareTo(name2);
                }
            };
            errTable.initialize(chapUserTable, errorChapUserInfo, chapUsercomp);
            errTable.makeDataModel();
        }
    }

    private Comparable getValue(Object obj) {
        Comparable comp = obj instanceof SJctrErrorColumnData ? ((SJctrErrorColumnData)obj).getKeyObj() : (Comparable)obj;
        return comp;
    }
}

