/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.portproperties;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.lunm.iscsi.portproperties.SJctrPortPropertiesSummaryModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;

public class SJctrPortPropertiesDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664544;
    private static final String KEY_SUMMARY = "COM_SUMMARY";
    public static final String KEY_SELECTED_PORT_ID = "KEY_SELECTED_PORT_ID";

    public SJctrPortPropertiesDC() throws SJcException {
        super(34664544);
        this.initDataModel();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_SUMMARY, new SJctrPortPropertiesSummaryModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> portIndexList = this.getCache(KEY_SELECTED_PORT_ID);
        if (null == portIndexList) {
            this.logUty.putlog("checkStartData", "Port information list data is null.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == portIndexList.size()) {
            this.logUty.putlog("checkStartData", "Size of Port information list data is zero.");
            SJctrError err = new SJctrError(12, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        try {
            List<?> portIdList = this.getCache(KEY_SELECTED_PORT_ID);
            Short portId = (Short)portIdList.get(0);
            List<SJmoPortDetail> portDetailInfo = SJctrIscsiUtility.getSJmoPortDetailList(this);
            List<SJmoPortAttributeInfo> portAttrInfo = SJctrIscsiUtility.getSJmoPortAttributeInfoList(this);
            SJmoPortDetail portDetail = (SJmoPortDetail)SJctrIscsiUtility.getPortInfoByPortId(portDetailInfo, portId);
            SJmoPortAttributeInfo portAttr = (SJmoPortAttributeInfo)SJctrIscsiUtility.getPortInfoByPortId(portAttrInfo, portId);
            if (portDetail == null || portAttr == null) {
                this.logUty.putlog("checkConstructData", "Inherited Port detail info is not exist.");
                throw SJctrIscsiUtility.makeException(206512);
            }
            SJctrPortPropertiesSummaryModel summary = (SJctrPortPropertiesSummaryModel)this.getDataObjectModel(KEY_SUMMARY);
            summary.makeSummary(portDetail, portAttr);
        }
        catch (SJcException e) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(e, 107002);
        }
        return true;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }
}

