/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.iscsi.removechaptargetusers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrGuidance;
import sanproject.sn2.controller.com.SJctrIscsiUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.comparator.SJctrIscsiTargetAliasComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.wizard.SJctrSubWizard;
import sanproject.sn2.controller.wizard.base.SJctrWizardWindowDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.removechaptargetusers.SJctrRemoveChapTargetUsersAC;
import sanproject.sn2.controller.wizard.lunm.iscsi.removechaptargetusers.SJctrRemoveChapTargetUsersConfirmDC;
import sanproject.sn2.controller.wizard.lunm.iscsi.removechaptargetusers.SJctrRemoveChapTargetUsersConfirmData;
import sanproject.sn2.controller.wizard.lunm.iscsi.removechaptargetusers.SJctrRemoveChapTargetUsersConfirmTableDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortAttributeInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;

public class SJctrRemoveChapTargetUsersSubWizard
extends SJctrSubWizard {
    public static final String TITLE = "REMOVE_TARGET_CHAP_USERS";
    private static final Class<?> CONFIRM_DC = SJctrRemoveChapTargetUsersConfirmDC.class;

    @Override
    public void constructConfirmData(SJctrWizardWindowDC wizard) {
        try {
            SJctrErrorColumnData errData;
            SJctrError err;
            SJctrUserController uc = wizard.getOwner();
            SJctrRelatedDispDataObject related = uc.getRelatedDispData(CONFIRM_DC);
            SJctrRemoveChapTargetUsersAC applyCntl = new SJctrRemoveChapTargetUsersAC();
            SJctrRelatedDispDataObject wizardWindowRelateDisp = uc.getRelatedDispData(SJctrWizardWindowDC.class);
            SJctrWizardWindowDC dc = (SJctrWizardWindowDC)uc.getDataController(wizardWindowRelateDisp);
            List<SJmoIscsiTargetInfo> selectedIscsiTargetList = dc.getProxy().getCache("KEY_SELECTED_ISCSI_TARGETS");
            if (null == selectedIscsiTargetList) {
                dc.getLogUty().putlog("constructConfirmData", "Inherited data list is null.");
                SJctrError err2 = new SJctrError(12, 22, 107002);
                SJcException exp = err2.createException();
                throw exp;
            }
            if (0 == selectedIscsiTargetList.size()) {
                dc.getLogUty().putlog("constructConfirmData", "Size of inherited data list is zero.");
                SJctrError err3 = new SJctrError(12, 22, 107002);
                SJcException exp = err3.createException();
                throw exp;
            }
            SJctrIscsiUtility.getSJmoPortDetailList(dc);
            SJctrIscsiUtility.getSJmoPortAttributeInfoList(dc);
            SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(dc);
            SJctrIscsiUtility.getSJmoRSGgetAllRsgsList(dc);
            Collections.sort(selectedIscsiTargetList, new SJctrIscsiTargetAliasComparator());
            List<SJmoPortIscsiTargetInfo> portIscsiList = SJctrIscsiUtility.getSJmoPortIscsiTargetInfoList(dc);
            ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>(selectedIscsiTargetList.size());
            for (SJmoIscsiTargetInfo info : selectedIscsiTargetList) {
                SJmoIscsiTargetInfo targetInfo = SJctrIscsiUtility.getIscsiTargetInfoByIndex(portIscsiList, (SJmoIscsiTargetIndex)info);
                if (targetInfo != null) continue;
                dc.getLogUty().putlog("constructConfirmData", "SJmoIscsiTargetInfo Model is null.");
                SJctrError err4 = new SJctrError(12, 22, 206513);
                SJctrErrorColumnData errData2 = new SJctrErrorColumnData(info, err4);
                errList.add(errData2);
            }
            if (errList.size() == 0) {
                for (SJmoIscsiTargetInfo info : selectedIscsiTargetList) {
                    if (info.getiAuthentMode() != 1) continue;
                    dc.getLogUty().putlog("constructConfirmData", "CHAP Authentication is Mutual.");
                    err = new SJctrError(12, 22, 206225);
                    errData = new SJctrErrorColumnData(info, err);
                    errList.add(errData);
                }
            }
            if (errList.size() == 0) {
                for (SJmoIscsiTargetInfo info : selectedIscsiTargetList) {
                    if (!info.getStrTargetUserName().equals("")) continue;
                    dc.getLogUty().putlog("constructConfirmData", "CHAP User Name is not set.");
                    err = new SJctrError(12, 22, 206222);
                    errData = new SJctrErrorColumnData(info, err);
                    errList.add(errData);
                }
            }
            SJctrRemoveChapTargetUsersConfirmData confirmData = new SJctrRemoveChapTargetUsersConfirmData();
            this.createError(dc, selectedIscsiTargetList, errList);
            ArrayList<SJctrRemoveChapTargetUsersConfirmData> confirmDataList = new ArrayList<SJctrRemoveChapTargetUsersConfirmData>();
            confirmData.setIscsiTargetList(selectedIscsiTargetList);
            confirmData.setNeedData(dc);
            confirmDataList.add(confirmData);
            dc.getProxy().putCache(SJctrRemoveChapTargetUsersConfirmData.class, confirmDataList);
            applyCntl.setApplyData(confirmData);
            wizard.addConfirmData(applyCntl, related);
        }
        catch (SJcException exp) {
            throw SJctrIscsiUtility.convIscsiLogicErrorException(exp, 107002);
        }
    }

    @Override
    public Class<?>[] getClassList() {
        Class[] Class2 = new Class[]{};
        return Class2;
    }

    @Override
    public SJctrGuidance getTaskNameGuidance() {
        SJctrGuidance guidance = new SJctrGuidance("COMMON", TITLE);
        return guidance;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        HashSet<SJctrGetDirectWrapper> set = new HashSet<SJctrGetDirectWrapper>();
        SJmoGetKind_IF kind = new SJmoGetPortDetail();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortAttributeInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    @Override
    public Class<?> getConfirmClass() {
        return CONFIRM_DC;
    }

    private void createError(SJctrWizardWindowDC dc, List<SJmoIscsiTargetInfo> transInfoList, List<SJctrErrorColumnData> errList) {
        if (!errList.isEmpty()) {
            SJctrRemoveChapTargetUsersConfirmTableDataModel chapTargetUserTable = new SJctrRemoveChapTargetUsersConfirmTableDataModel();
            chapTargetUserTable.setPaging(false);
            chapTargetUserTable.setDataController(dc);
            chapTargetUserTable.setBasicDataList(transInfoList);
            chapTargetUserTable.initGuidance(this.getComUtility());
            chapTargetUserTable.createModelDirect();
            chapTargetUserTable.divideModelData(dc.getProxy().getModelDataMap());
            chapTargetUserTable.makeDataModel();
            SJctrRelatedDispDataObject rel = dc.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errDc = (SJctrErrorDataController)dc.getOwner().getDataController(rel);
            errDc.setParameter(chapTargetUserTable, errList);
            SJctrError errInfo = errDc.getRepresentativeError(errList);
            SJcException exp = errInfo.createException();
            exp.setErrDisp(rel);
            throw exp;
        }
    }
}

