/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.mapluns;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.controller.com.column.SJctrLunIdColumnFromPortLunTableKey;
import sanproject.sn2.controller.com.comparator.SJctrPortLunDetail_LdevComparator;
import sanproject.sn2.controller.com.comparator.SJctrPortLunDetail_PortHgLdevComparator;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrLunIdCheckColumn
extends SJctrLunIdColumnFromPortLunTableKey {
    public static final String KEY_CHECKBOX = "COM_CHECKBOX";
    public static final Comparator<Object> PORT_HG_LDEV_COMPARATOR = new SJctrPortLunDetail_PortHgLdevComparator();
    public static final Comparator<Object> LDEV_COMPARATOR = new SJctrPortLunDetail_LdevComparator();
    private final List<SJmoPortLunDetail> lunList;
    private final SJctrSelectableDataObject check;
    private final SJmoPortLunDetail keyObj;

    public SJctrLunIdCheckColumn(String key, String label, List<SJmoPortLunDetail> list, boolean flg) {
        super(key);
        this.setLabel(label);
        this.lunList = list;
        Collections.sort(this.lunList, LDEV_COMPARATOR);
        if (flg) {
            this.check = new SJctrSelectableDataObject();
            this.check.label("");
            this.setSelect(false);
            this.setEnable(true);
        } else {
            this.check = null;
        }
        this.keyObj = new SJmoPortLunDetail();
        this.keyObj.setSPort((short)0);
        this.keyObj.setSHostGroup((short)0);
        this.keyObj.setSLUN((short)0);
        this.keyObj.setSLDKC((short)0);
        this.keyObj.setSCU((short)0);
        this.keyObj.setSLDEV((short)0);
    }

    @Override
    public HashMap<String, Object> getHeaderInfo(Map<String, Object> parent, Set<String> targetColumn) {
        HashMap<String, Object> headerInfo = super.getHeaderInfo(parent, targetColumn);
        if (this.check != null) {
            headerInfo.put(KEY_CHECKBOX, this.check);
        }
        return headerInfo;
    }

    public List<SJmoPortLunDetail> getLunList() {
        return this.lunList;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        ArrayList<SJmoPortLunDetail> retList = new ArrayList<SJmoPortLunDetail>();
        SJmoPortLunDetail lunDetail = this.getPortLunDetail(index);
        if (lunDetail != null) {
            retList.add(lunDetail);
        }
        return retList;
    }

    public void setEnable(boolean flg) {
        SJctrCheckBoxDataModel.setEnable(this.check, flg);
    }

    public void setSelect(boolean flg) {
        SJctrCheckBoxDataModel.setSelect(this.check, flg);
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long retNum = -1L;
        Object key = this.getPrimaryKeyObject(dat);
        SJmoPortLunDetail lunDetail = this.getPortLunDetail(key);
        if (lunDetail != null) {
            retNum = lunDetail.getSLUN();
        }
        return retNum;
    }

    public SJmoPortLunDetail getPortLunDetail(Object key) {
        SJmoPortLunDetail lunDetail = null;
        SJmoLdevDetail ldevDetail = (SJmoLdevDetail)key;
        this.keyObj.setSLDKC(ldevDetail.getSLdkc());
        this.keyObj.setSCU(ldevDetail.getSCu());
        this.keyObj.setSLDEV(ldevDetail.getSLdev());
        int i = Collections.binarySearch(this.lunList, this.keyObj, LDEV_COMPARATOR);
        if (i >= 0) {
            lunDetail = this.lunList.get(i);
        }
        return lunDetail;
    }
}

