/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.mapluns;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.data.SJctrNestedListDataObject;
import sanproject.sn2.controller.com.data.SJctrSelectableDataObject;
import sanproject.sn2.controller.com.data.SJctrTblDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrObjectSetListener;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHGIndex;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrLunIdCheckColumn;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLUNsSubWizard;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLunsComTableModel;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLunsDC;
import sanproject.sn2.model.connector.kind.SJmoGetHDPRelation;
import sanproject.sn2.model.connector.kind.SJmoGetLdevLuseInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevNicknameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPoolNameInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrMapLunsTableModel
extends SJctrMapLunsComTableModel {
    private static final String KEY_BUTTON_GROUP = "COM_BUTTON_GROUP";
    private static final String KEY_CHANGE_LDEV = "COM_CHANGELDEV";
    private static final String KEY_CHANGE_LUN = "COM_CHANGELUN";
    private static final String GUID_CHANGE_LDEV = "CHG_LD_SETTING";
    private Set<SJctrLunIdCheckColumn> selectColumnSet = new HashSet<SJctrLunIdCheckColumn>();

    public Map<SJctrPortHGIndex, SJctrLunIdCheckColumn> getSelectColumnMap() {
        TreeMap<SJctrPortHGIndex, SJctrLunIdCheckColumn> retMap = new TreeMap<SJctrPortHGIndex, SJctrLunIdCheckColumn>();
        for (SJctrLunIdCheckColumn selectColumn : this.selectColumnSet) {
            List<SJmoPortLunDetail> createLun = selectColumn.getLunList();
            if (createLun == null || createLun.isEmpty()) {
                this.getLogUty().putlog("getSelectColumnMap", "Create Lun: " + createLun, 40000);
                continue;
            }
            SJmoPortLunDetail lun = createLun.get(0);
            SJctrPortHGIndex key = new SJctrPortHGIndex();
            key.setPort(lun.getSPort());
            key.setHostGroup(lun.getSHostGroup());
            retMap.put(key, selectColumn);
        }
        return retMap;
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        SJctrSimpleDataModel buttonGroup = new SJctrSimpleDataModel();
        String label = util.getGuidance("COMMON", GUID_CHANGE_LDEV);
        SJctrButtonDataModel button = new SJctrButtonDataModel(label);
        buttonGroup.addDataModel(KEY_CHANGE_LDEV, button);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrMapLunsTableModel.this.fireMessageEvent(SJctrMapLunsDC.MAP_LUNS_MSG.CHANGE_LDEV);
            }
        });
        SJctrButtonDataModel button2 = new SJctrButtonDataModel();
        buttonGroup.addDataModel(KEY_CHANGE_LUN, button2);
        button2.setReceiveOnly();
        button2.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrMapLunsTableModel.this.fireMessageEvent(SJctrMapLunsDC.MAP_LUNS_MSG.CHANGE_LU);
            }
        });
        this.addDataModel(KEY_BUTTON_GROUP, buttonGroup);
    }

    @Override
    protected void initTable() {
        super.initTable();
        this.addObjectSetListener(new SJctrObjectSetListener(){

            @Override
            public void doAction(Object setObj) {
                Object getObj;
                SJctrTblDataObject setTable;
                if (setObj instanceof SJctrTblDataObject && (setTable = (SJctrTblDataObject)setObj).containsKey("COM_COLUMN_LIST") && (getObj = setTable.getData("COM_COLUMN_LIST")) instanceof SJctrNestedListDataObject) {
                    this.setColumnCheck((SJctrNestedListDataObject)getObj);
                }
            }

            private void setColumnCheck(SJctrNestedListDataObject setList) {
                if (setList.containsKey("COM_SET_ROW")) {
                    ArrayList<HashMap<String, Object>> columnList = setList.setRow();
                    for (HashMap<String, Object> column : columnList) {
                        String name = (String)column.get("name");
                        if (!name.equals("COM_COL_LUNID") || !column.containsKey("children")) continue;
                        ArrayList childList = (ArrayList)column.get("children");
                        for (HashMap child : childList) {
                            SJctrMapLunsTableModel.this.setChildColumnCheck(child);
                        }
                    }
                }
            }
        });
    }

    private void setChildColumnCheck(HashMap<String, Object> child) {
        SJctrSelectableDataObject check = (SJctrSelectableDataObject)child.get("COM_CHECKBOX");
        boolean flg = SJctrCheckBoxDataModel.isSelect(check);
        String selectColumnKey = (String)child.get("name");
        SJctrLunIdCheckColumn targetColumn = this.getCheckColumn(selectColumnKey);
        if (targetColumn == null) {
            this.logUty.putlog("setChildColumnCheck", "Not found column: " + selectColumnKey);
            this.setDirty();
            return;
        }
        targetColumn.setSelect(flg);
        if (flg) {
            this.selectColumnSet.add(targetColumn);
        } else {
            this.selectColumnSet.remove(targetColumn);
        }
        this.setDirty();
    }

    @Override
    public List<?> getBasicDataList(Class<?> cls) {
        SJctrWizardDataController dc = (SJctrWizardDataController)this.getDataController();
        List<?> retList = dc.getCache("KEY_TARGET_LDEV_INFO");
        boolean bCapacityFlg = true;
        boolean bMFFlg = false;
        boolean bOpenFlg = false;
        for (SJmoLdevDetail ldevDtl : retList) {
            if (bOpenFlg && bMFFlg) break;
            if (SJctrLdevUtility.isOpenVolume(ldevDtl)) {
                bOpenFlg = true;
                continue;
            }
            if (!SJctrLdevUtility.isMFVolume(ldevDtl)) continue;
            bMFFlg = true;
        }
        this.setCapacityFlg(bCapacityFlg);
        this.setMainframeVolumeFlg(bMFFlg);
        this.setOpenVolumeFlg(bOpenFlg);
        return retList;
    }

    @Override
    protected void setModelData(Map<SJctrGetDirectWrapper, List<?>> models) {
        super.setModelData(models);
        SJctrWizardDataController dc = (SJctrWizardDataController)this.getDataController();
        this.setBasicData(SJmoGetLdevLuseInfo.class, dc.getCache(SJctrMapLUNsSubWizard.KEY_LDEV_LUSE));
        this.setBasicData(SJmoGetPortLunInfo.class, dc.getCache(SJctrMapLUNsSubWizard.KEY_PORT_LUN));
        this.setBasicData(SJmoGetLdevNicknameInfo.class, dc.getCache("KEY_TARGET_LDEV_NICKNAME"));
        this.setBasicData(SJmoGetPoolNameInfo.class, dc.getCache(SJctrMapLUNsSubWizard.KEY_POOL_NAME));
        this.setBasicData(SJmoGetHDPRelation.class, dc.getCache(SJctrMapLUNsSubWizard.KEY_HDPR));
    }

    protected void setUpdateModelData() {
        SJctrWizardDataController dc = (SJctrWizardDataController)this.getDataController();
        this.setBasicData(SJmoGetLdevNicknameInfo.class, dc.getCache("KEY_TARGET_LDEV_NICKNAME"));
    }

    @Override
    public void clearChildColumn() {
        super.clearChildColumn();
        this.selectColumnSet.clear();
    }

    @Override
    protected void makeCapacityUnitInfo() {
    }
}

