/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.mapluns;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.topwindow.port.iscsi.port.iscsitargets.SJctrPortIscsiTargetsDC;
import sanproject.sn2.controller.topwindow.port.port.hostgroup.SJctrPortHostGroupDC;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHGIndex;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortHostGroupTableKey;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertyDC;
import sanproject.sn2.controller.wizard.lunm.comdialog.hgproperty.SJctrHGPropertySelectData;
import sanproject.sn2.controller.wizard.lunm.createhgs.SJctrCreateHostGroupsSubWizard;
import sanproject.sn2.controller.wizard.lunm.iscsi.createiscsitargets.SJctrCreateIscsiTargetsSubWizard;
import sanproject.sn2.controller.wizard.lunm.iscsi.iscsitargetproperties.SJctrIscsiTargetPropertiesDC;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrMapLUNsSubWizard;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrPortTypeDataModel;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrSelectHGTableModel;
import sanproject.sn2.controller.wizard.lunm.mapluns.SJctrSelectITTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetChaDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.device.SJmoChaDetail;
import sanproject.sn2.model.data.device.SJmoPortAttributeInfo;
import sanproject.sn2.model.data.device.SJmoPortDetail;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.huvm.SJmoHUVMvboxIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.rsg.SJmoRSGgetRsg;
import sanproject.sn2.model.data.util.SJmoChaUtility;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrSelectHostGroupDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 0x1001102;
    private static final String GUID_TITLE = "DISP_TITLE_SEL_HG_IT";
    private static final String KEY_TABLE_AVAILABLE = "COM_TABLE_AVAILABLE";
    private static final String KEY_TABLE_SELECTED = "COM_TABLE_SELECTED";
    private static final String KEY_ADD = "COM_ADD";
    private static final String KEY_REMOVE = "COM_REMOVE";
    private static final String KEY_TABLE = "COM_TABLE";
    private List<SJmoPortHostGroupInfo> checkedPortHgList;
    private int selectLdevNum;
    private Map<Integer, Integer> definedLunMap;
    private List<SJctrErrorColumnData> errorDataList;
    SJctrResourceGroupUtility rsgUtil;
    public static final int EC_COEXISTENCE_OF_HG = 205054;
    private static String KEY_TABLE_AVAILABLE_ISCSI = "COM_TABLE_AVAILABLE_ISCSI";
    private static String KEY_TABLE_SELECTED_ISCSI = "COM_TABLE_SELECTED_ISCSI";
    private static final String KEY_RADIO_SEL_OBJ = "COM_SELOBJINF";
    private SJctrPortTypeDataModel radioInfo = null;
    private List<SJctrPortHostGroupTableKey> hnasPortHostGroupTableKey = Collections.emptyList();
    private List<SJctrPortHostGroupTableKey> hnasSelectPortHostGroupTableKey = Collections.emptyList();
    private List<SJctrPortHostGroupTableKey> fibrePortHostGroupTableKey = Collections.emptyList();
    private List<SJctrPortHostGroupTableKey> fibreSelectPortHostGroupTableKey = Collections.emptyList();
    private int oldRadioSelect = 0;
    static SJctrLdevIndexComparator ldevIndexComparator = new SJctrLdevIndexComparator();

    public SJctrSelectHostGroupDC() throws SJcException {
        super(0x1001102);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public boolean checkConstructData() {
        ArrayList<SJmoChaDetail> chaList;
        boolean hfb;
        SJctrDataController parentDC;
        List<SJmoPortHostGroupInfo> phgList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_HG_INFO);
        if (phgList == null) {
            this.logUty.putlog("checkConstructData", "PortHostGroupInfo = null");
            SJctrError error = new SJctrError(10, 22, 107002);
            throw error.createException();
        }
        this.logUty.putlog("checkConstructData", "PortHostGroupInfo = " + phgList.size());
        List<SJmoLdevDetail> targetLdev = this.getCache("KEY_TARGET_LDEV_INFO");
        if (targetLdev == null) {
            this.logUty.putlog("checkConstructData", "LdevDetail = null");
            SJctrError error = new SJctrError(10, 22, 107002);
            throw error.createException();
        }
        this.logUty.putlog("checkConstructData", "LdevDetail = " + targetLdev.size());
        List<?> list = this.getCache("KEY_PORT_HG_MAP");
        if (list == null || list.isEmpty()) {
            this.logUty.putlog("checkConstructData", "Available PortHostGroup is no data.");
            SJctrError error = new SJctrError(10, 22, 107002);
            throw error.createException();
        }
        Map availableMap = (Map)list.get(0);
        this.logUty.putlog("checkConstructData", "Available PortHostGroup = " + availableMap.size());
        List<?> list2 = this.getCache("KEY_SELECT_HG_SET");
        if (list2 == null || list2.isEmpty()) {
            this.logUty.putlog("checkConstructData", "Select PortHostGroup is no data.");
            SJctrError error = new SJctrError(10, 22, 107002);
            throw error.createException();
        }
        Set selectHgInfo = (Set)list2.get(0);
        this.logUty.putlog("checkConstructData", "Select PortHostGroup = " + selectHgInfo.size());
        List<SJmoPortLunInfo> lunList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_LUN);
        if (lunList == null) {
            this.logUty.putlog("checkConstructData", "PortLunInfo = null");
            SJctrError error = new SJctrError(10, 22, 107002);
            throw error.createException();
        }
        this.logUty.putlog("checkConstructData", "PortLunInfo = " + lunList.size());
        List<?> rsgDetailList = this.getCache(SJctrMapLUNsSubWizard.KEY_ALL_RSG);
        if (rsgDetailList == null || rsgDetailList.size() == 0) {
            SJctrError err = new SJctrError(10, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        this.rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)rsgDetailList.get(0));
        List<SJmoPortDetail> portList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_DETAIL);
        if (portList == null) {
            this.logUty.putlog("checkConstructData", "PortDetail = null");
            SJctrError error = new SJctrError(10, 22, 107002);
            throw error.createException();
        }
        this.logUty.putlog("checkConstructData", "PortDetail = " + portList.size());
        List<?> chaDetailList = this.getCache(SJmoGetChaDetail.class);
        if (chaDetailList == null) {
            this.logUty.putlog("checkConstructData", "ChaDetail = null");
            SJctrError error = new SJctrError(10, 22, 107002);
            throw error.createException();
        }
        this.logUty.putlog("checkConstructData", "ChaDetail = " + chaDetailList.size());
        this.errorDataList = new ArrayList<SJctrErrorColumnData>(selectHgInfo.size());
        this.checkLunPath(selectHgInfo, availableMap, lunList, targetLdev);
        this.checkHostMode(selectHgInfo, availableMap, targetLdev);
        this.checkLunNum1(selectHgInfo, availableMap, lunList, targetLdev);
        this.checkLunNum2(selectHgInfo, availableMap, lunList);
        boolean t10piEnabled = this.hasT10PIEnabled(targetLdev);
        if (t10piEnabled) {
            this.checkT10PIMode(availableMap, portList);
        }
        List<SJmoPortDetail> portDetailList = this.getCache(SJmoGetPortDetail.class);
        ArrayList availableHgListFibreAll = new ArrayList(availableMap.values());
        ArrayList<SJctrPortHostGroupTableKey> rsglistFibreAll = new ArrayList<SJctrPortHostGroupTableKey>(SJctrPortUtility.HOST_GROUP_MAX);
        for (SJctrPortHostGroupTableKey ptHgTableKey : availableHgListFibreAll) {
            if (!this.checkHgRsgUserLu(portDetailList, ptHgTableKey)) continue;
            rsglistFibreAll.add(ptHgTableKey);
        }
        this.fibrePortHostGroupTableKey = rsglistFibreAll;
        LinkedHashMap selectMap = new LinkedHashMap(availableMap);
        selectMap.keySet().retainAll(selectHgInfo);
        ArrayList<SJctrPortHostGroupTableKey> list3 = new ArrayList<SJctrPortHostGroupTableKey>(SJctrPortUtility.HOST_GROUP_MAX);
        ArrayList listAll = new ArrayList(selectMap.values());
        boolean selectUserLuFlag = false;
        for (SJctrPortHostGroupTableKey ptHgTableKey : listAll) {
            if (this.checkHgUserLu(portDetailList, ptHgTableKey)) {
                selectUserLuFlag = true;
                continue;
            }
            list3.add(ptHgTableKey);
        }
        Collections.sort(list3);
        boolean selectedHgFlg = false;
        if (list3.size() > 0) {
            selectedHgFlg = true;
        }
        SJctrSelectHGTableModel table = (SJctrSelectHGTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
        table.setBasicDataList(list3);
        this.logUty.putlog("checkConstructData", "Selected Table = " + list3.size());
        this.putCache("KEY_TARGET_HG_INFO", list3);
        availableMap.keySet().removeAll(selectHgInfo);
        ArrayList availableHgList = new ArrayList(availableMap.values());
        Collections.sort(availableHgList);
        SJctrSelectHGTableModel availableHgTable = (SJctrSelectHGTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        ArrayList<SJctrPortHostGroupTableKey> rsglist = new ArrayList<SJctrPortHostGroupTableKey>(SJctrPortUtility.HOST_GROUP_MAX);
        for (SJctrPortHostGroupTableKey ptHgTableKey : availableHgList) {
            if (!this.checkHgRsgUserLu(portDetailList, ptHgTableKey)) continue;
            rsglist.add(ptHgTableKey);
        }
        availableHgTable.setBasicDataList(rsglist);
        this.radioInfo.selectHostGroup();
        this.radioInfo.setVisible(true);
        if (list3.size() == 0 && rsglist.size() == 0) {
            this.radioInfo.selectIscsi();
            this.radioInfo.setEnable("COM_HG", false);
        }
        if ((parentDC = this.getWizardWindow().getParentDC()) instanceof SJctrPortHostGroupDC) {
            this.radioInfo.setVisible(false);
        } else if (list3.size() > 0) {
            this.radioInfo.setEnable("COM_HG", false);
            this.radioInfo.setEnable("COM_ISCSI", false);
            this.radioInfo.setEnable("COM_HNAS", false);
        }
        if (this.getWizardWindow().getFirstSubWizard() instanceof SJctrCreateHostGroupsSubWizard) {
            this.radioInfo.setVisible(false);
        }
        if (!(hfb = SJmoChaUtility.isHfbPkInstall(chaList = new ArrayList<SJmoChaDetail>(chaDetailList)))) {
            this.radioInfo.setVisible("COM_HNAS", false);
        }
        this.radioInfo.setDirty();
        this.logUty.putlog("checkConstructData", "Available Table = " + rsglist.size());
        if (this.errorDataList.size() > 0) {
            this.logUty.putlog("checkConstructData", "Error Dialog Data = " + this.errorDataList.size());
            SJctrRelatedDispDataObject related = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errorDialog = (SJctrErrorDataController)this.getOwner().getDataController(related);
            SJctrTableDataModel errTable = SJctrSelectHostGroupDC.createErrorDialogTable(phgList, this, this.getComUtility());
            errorDialog.setParameter(errTable, this.errorDataList);
            SJctrError error = errorDialog.getRepresentativeError(this.errorDataList, 4);
            this.errorDataList = null;
            SJcException ex = error.createException();
            ex.setErrDisp(related);
            throw ex;
        }
        this.checkConstructIscsiData(targetLdev, lunList, selectedHgFlg);
        boolean hnasEnable = this.checkConstructHnasData(targetLdev, lunList, phgList);
        if (this.radioInfo.isEnable("COM_HNAS")) {
            this.radioInfo.setEnable("COM_HNAS", hnasEnable);
        }
        if (hnasEnable && selectUserLuFlag && list3.size() == 0) {
            this.oldRadioSelect = 2;
            boolean radioVisible = this.radioInfo.isVisible("COM_HG");
            boolean fibreEnable = this.radioInfo.isEnable("COM_HG");
            boolean iscsiEnable = this.radioInfo.isEnable("COM_ISCSI");
            this.radioInfo.setVisible(true);
            this.radioInfo.selectHnas();
            this.radioInfo.setEnable("COM_HG", fibreEnable);
            this.radioInfo.setEnable("COM_ISCSI", iscsiEnable);
            if (!radioVisible) {
                this.radioInfo.setVisible(false);
            }
            SJctrSelectHGTableModel selectTable = (SJctrSelectHGTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED);
            selectTable.setBasicDataList(this.hnasSelectPortHostGroupTableKey);
            this.putCache("KEY_TARGET_HG_INFO", this.hnasSelectPortHostGroupTableKey);
            SJctrSelectHGTableModel availableTable = (SJctrSelectHGTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE);
            availableTable.setBasicDataList(this.hnasPortHostGroupTableKey);
        }
        return true;
    }

    private boolean checkHgRsgUserLu(List<SJmoPortDetail> portDetailList, SJctrPortHostGroupTableKey ptHgTableKey) {
        boolean userLu;
        boolean sysRsgFlg;
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        SJmoHostGroupInfo hgInfo = ptHgTableKey.getHostGroupInfo();
        hgIndex.setSPort(hgInfo.getSPort());
        hgIndex.setSHostGroup(hgInfo.getSHostGroup());
        boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, this.rsgUtil);
        return rsgFlg && !(sysRsgFlg = this.rsgUtil.isSelRscHgInSysRsg(hgIndex)) && !(userLu = this.checkHgUserLu(portDetailList, ptHgTableKey));
    }

    private boolean checkHgUserLu(List<SJmoPortDetail> portDetailList, SJctrPortHostGroupTableKey ptHgTableKey) {
        SJmoHostGroupInfo hgInfo = ptHgTableKey.getHostGroupInfo();
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort(hgInfo.getSPort());
        int index = Collections.binarySearch(portDetailList, portIndex);
        if (index >= 0) {
            SJmoPortDetail portDetail = portDetailList.get(index);
            return SJctrPortUtility.isHnasUserPort(portDetail);
        }
        return false;
    }

    private boolean hasT10PIEnabled(List<SJmoLdevDetail> targetLdev) {
        boolean result = false;
        for (SJmoLdevDetail ldev : targetLdev) {
            boolean t10pi = ldev.getBT10pi();
            if (!t10pi) continue;
            result = true;
            break;
        }
        this.logUty.putlog("hasT10PIEnabled", Boolean.toString(result));
        return result;
    }

    private void checkT10PIMode(Map<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoPortDetail> portList) {
        this.logUty.putlog("checkT10PIMode", "input  = " + availableMap.size());
        SJmoPortIndex portIndex = new SJmoPortIndex();
        Iterator<SJmoHostGroupInfo> ite = availableMap.keySet().iterator();
        ArrayList<SJmoHostGroupInfo> ngkeyList = new ArrayList<SJmoHostGroupInfo>(availableMap.size());
        while (ite.hasNext()) {
            SJmoPortDetail portDetail;
            int t10piMode;
            SJmoHostGroupInfo key = ite.next();
            SJctrPortHostGroupTableKey tableKey = availableMap.get(key);
            SJmoHostGroupInfo hgInfo = tableKey.getHostGroupInfo();
            short sPort = hgInfo.getSPort();
            portIndex.setSPort(sPort);
            int index = Collections.binarySearch(portList, portIndex);
            if (index < 0 || (t10piMode = (portDetail = portList.get(index)).getIT10Pi()) == 1) continue;
            ngkeyList.add(hgInfo);
        }
        for (SJmoHostGroupInfo ngKey : ngkeyList) {
            availableMap.remove(ngKey);
        }
        this.logUty.putlog("checkT10PIMode", "output = " + availableMap.size());
    }

    private void checkT10PIModeIscsi(Map<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoPortDetail> portList) {
        this.logUty.putlog("checkT10PIModeIscsi", "input  = " + availableMap.size());
        SJmoPortIndex portIndex = new SJmoPortIndex();
        ArrayList<SJmoIscsiTargetInfo> ngList = new ArrayList<SJmoIscsiTargetInfo>();
        for (SJmoIscsiTargetInfo key : availableMap.keySet()) {
            SJmoPortDetail portDetail;
            int t10piMode;
            SJctrPortHostGroupTableKey PortHostGroup = availableMap.get(key);
            SJmoIscsiTargetInfo iTInfo = PortHostGroup.getIscsiTargetInfo();
            short sPort = iTInfo.getSPort();
            portIndex.setSPort(sPort);
            int index = Collections.binarySearch(portList, portIndex);
            if (index < 0 || (t10piMode = (portDetail = portList.get(index)).getIT10Pi()) == 1) continue;
            ngList.add(key);
        }
        for (SJmoIscsiTargetInfo key : ngList) {
            availableMap.remove(key);
        }
        this.logUty.putlog("checkT10PIMode", "output = " + availableMap.size());
    }

    private boolean checkConstructIscsiData(List<SJmoLdevDetail> targetLdevList, List<SJmoPortLunInfo> portLunList, boolean selectedHgFlg) {
        SJctrError error;
        List<SJmoPortIscsiTargetInfo> portItList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_IT_INFO);
        if (portItList == null) {
            SJctrError error2 = new SJctrError(10, 22, 107002);
            throw error2.createException();
        }
        List<?> portItMapList = this.getCache("KEY_PORT_IT_MAP");
        if (portItMapList == null || portItMapList.isEmpty()) {
            SJctrError error3 = new SJctrError(10, 22, 107002);
            throw error3.createException();
        }
        Map availableMap = (Map)portItMapList.get(0);
        List<?> list = this.getCache("KEY_SELECT_IT_SET");
        if (list == null) {
            ArrayList selectList = new ArrayList();
            List<?> itIndexList = this.getCache("KEY_SELECT_IT_INDEX");
            if (itIndexList != null && itIndexList.size() > 0) {
                for (SJmoIscsiTargetIndex itIndex : itIndexList) {
                    SJmoPortIndex ptIndex = new SJmoPortIndex();
                    ptIndex.setSPort(itIndex.getSPort());
                    for (SJmoPortIscsiTargetInfo ptItInfo : portItList) {
                        int itTargetIndex = Collections.binarySearch(ptItInfo.getAlPortIscsiTarget(), ptIndex);
                        if (itTargetIndex < 0) continue;
                        LinkedHashSet<SJmoIscsiTargetInfo> hashSet = new LinkedHashSet<SJmoIscsiTargetInfo>();
                        hashSet.add(ptItInfo.getAlPortIscsiTarget().get(itTargetIndex));
                        selectList.add(hashSet);
                    }
                }
                list = selectList;
            }
            if (list == null) {
                error = new SJctrError(10, 22, 107002);
                throw error.createException();
            }
            if ((list.isEmpty() || ((LinkedHashSet)list.get(0)).isEmpty()) && !selectedHgFlg) {
                return false;
            }
        }
        Set selectItInfo = (Set)list.get(0);
        List<SJmoPortDetail> portList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_DETAIL);
        if (portList == null) {
            this.logUty.putlog("checkConstructData", "PortDetail = null");
            error = new SJctrError(10, 22, 107002);
            throw error.createException();
        }
        this.logUty.putlog("checkConstructData", "PortDetail = " + portList.size());
        this.errorDataList = new ArrayList<SJctrErrorColumnData>(selectItInfo.size());
        this.checkLunPathIscsi(selectItInfo, availableMap, portLunList, targetLdevList);
        this.checkHostModeIscsi(selectItInfo, availableMap, targetLdevList);
        this.checkLunNumIscsi1(selectItInfo, availableMap, portLunList, targetLdevList);
        this.checkLunNumIscsi2(selectItInfo, availableMap, portLunList);
        boolean t10piEnabled = this.hasT10PIEnabled(targetLdevList);
        if (t10piEnabled) {
            this.checkT10PIModeIscsi(availableMap, portList);
        }
        LinkedHashMap selectMap = new LinkedHashMap(availableMap);
        selectMap.keySet().retainAll(selectItInfo);
        ArrayList<SJctrPortHostGroupTableKey> selectedITList = new ArrayList<SJctrPortHostGroupTableKey>(selectMap.values());
        Collections.sort(selectedITList);
        SJctrSelectITTableModel selectedITTable = (SJctrSelectITTableModel)this.getDataObjectModel(KEY_TABLE_SELECTED_ISCSI);
        selectedITTable.setBasicDataList(selectedITList);
        this.logUty.putlog("checkConstructIscsiData", "Selected Table = " + selectedITList.size());
        this.putCache("KEY_TARGET_IT_INFO", selectedITList);
        availableMap.keySet().removeAll(selectItInfo);
        ArrayList availableITList = new ArrayList(availableMap.values());
        Collections.sort(availableITList);
        ArrayList<SJctrPortHostGroupTableKey> rsglist = new ArrayList<SJctrPortHostGroupTableKey>(SJctrPortUtility.PORT_ISCSITARGET_MAX);
        SJmoHostGroupIndex itIndex = new SJmoHostGroupIndex();
        for (SJctrPortHostGroupTableKey ptHgTableKey : availableITList) {
            SJmoIscsiTargetInfo itInfo = ptHgTableKey.getIscsiTargetInfo();
            itIndex.setSPort(itInfo.getSPort());
            itIndex.setSHostGroup(itInfo.getSIscsiTarget());
            boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(itIndex, this.rsgUtil);
            if (!rsgFlg) continue;
            rsglist.add(ptHgTableKey);
        }
        SJctrSelectITTableModel availableITTable = (SJctrSelectITTableModel)this.getDataObjectModel(KEY_TABLE_AVAILABLE_ISCSI);
        availableITTable.setBasicDataList(rsglist);
        this.logUty.putlog("checkConstructData", "Available Table = " + rsglist.size());
        if (this.radioInfo.isVisible("COM_HG")) {
            SJctrDataController parentDC;
            if (selectedITList.size() == 0 && rsglist.size() == 0) {
                this.radioInfo.setEnable("COM_ISCSI", false);
            }
            if ((parentDC = this.getWizardWindow().getParentDC()) instanceof SJctrPortIscsiTargetsDC) {
                this.radioInfo.selectIscsi();
                this.radioInfo.setVisible(false);
            } else if (selectedITList.size() > 0) {
                this.radioInfo.selectIscsi();
                this.radioInfo.setEnable("COM_HG", false);
                this.radioInfo.setEnable("COM_ISCSI", false);
                this.radioInfo.setEnable("COM_HNAS", false);
            }
            if (this.getWizardWindow().getFirstSubWizard() instanceof SJctrCreateIscsiTargetsSubWizard) {
                this.radioInfo.selectIscsi();
                this.radioInfo.setVisible(false);
            }
            this.radioInfo.setDirty();
        }
        if (this.errorDataList.size() > 0) {
            this.logUty.putlog("checkConstructData", "Error Dialog Data = " + this.errorDataList.size());
            SJctrRelatedDispDataObject related = this.createDialog(SJctrErrorDataController.class, null);
            SJctrErrorDataController errorDialog = (SJctrErrorDataController)this.getOwner().getDataController(related);
            SJctrTableDataModel table = SJctrSelectHostGroupDC.createErrorDialogIscsiTable(portItList, this, this.getComUtility());
            errorDialog.setParameter(table, this.errorDataList);
            SJctrError error4 = errorDialog.getRepresentativeError(this.errorDataList, 4);
            this.errorDataList = null;
            SJcException ex = error4.createException();
            ex.setErrDisp(related);
            throw ex;
        }
        return true;
    }

    private boolean checkConstructHnasData(List<SJmoLdevDetail> targetLdevList, List portLunList, List phgList) {
        boolean hnasEnable = false;
        List<?> portDetailList = this.getCache(SJmoGetPortDetail.class);
        ArrayList<SJmoPortLunInfo> userLunList = new ArrayList<SJmoPortLunInfo>(2);
        ArrayList availableUserLunList = new ArrayList(2);
        SJmoPortLunInfo lunInfo = null;
        for (SJmoPortDetail portDetail : portDetailList) {
            if (!SJctrPortUtility.isHnasUserPort(portDetail)) continue;
            int portLunInfoIndex = Collections.binarySearch(portLunList, portDetail);
            if (portLunInfoIndex < 0) {
                lunInfo = new SJmoPortLunInfo();
                lunInfo.setSPort(portDetail.getSPort());
            } else {
                lunInfo = (SJmoPortLunInfo)portLunList.get(portLunInfoIndex);
            }
            if (userLunList.indexOf(lunInfo) >= 0) continue;
            userLunList.add(lunInfo);
        }
        int userLunSize = userLunList.size();
        if (userLunSize == 0) {
            return false;
        }
        BitSet userLuUsePathFirst = null;
        for (SJmoLdevDetail ldevDetail : targetLdevList) {
            BitSet userLuUsePath = this.getLdevUserLuUsePath(ldevDetail, userLunList);
            if (userLuUsePathFirst == null) {
                userLuUsePathFirst = userLuUsePath;
            }
            if (userLuUsePathFirst.equals(userLuUsePath)) continue;
            return false;
        }
        for (int i = 0; i < userLunSize; ++i) {
            if (userLuUsePathFirst.get(i)) continue;
            availableUserLunList.add(userLunList.get(i));
        }
        if (availableUserLunList.size() > 0) {
            ArrayList<SJmoPortHostGroupInfo> portHostGroupInfoList = new ArrayList<SJmoPortHostGroupInfo>(2);
            for (SJmoPortLunInfo portLunInfo : availableUserLunList) {
                int ptHgInfoIndex = Collections.binarySearch(phgList, portLunInfo);
                if (ptHgInfoIndex < 0) continue;
                SJmoPortHostGroupInfo ptHgInfo = (SJmoPortHostGroupInfo)phgList.get(ptHgInfoIndex);
                portHostGroupInfoList.add(ptHgInfo);
            }
            boolean bl = hnasEnable = portHostGroupInfoList.size() > 0;
            if (hnasEnable) {
                List<SJctrPortHostGroupTableKey> tmpList = SJctrSelectHostGroupDC.createPortHgList(portHostGroupInfoList);
                this.hnasSelectPortHostGroupTableKey = new ArrayList<SJctrPortHostGroupTableKey>(tmpList.size());
                for (SJctrPortHostGroupTableKey tblKey : tmpList) {
                    SJmoHostGroupInfo hgInfo = tblKey.getHostGroupInfo();
                    if (hgInfo.getSHostGroup() != 0) continue;
                    this.hnasSelectPortHostGroupTableKey.add(tblKey);
                }
                hnasEnable = this.hnasSelectPortHostGroupTableKey.size() > 0;
            }
        }
        return hnasEnable;
    }

    private BitSet getLdevUserLuUsePath(SJmoLdevDetail ldevDetail, List<SJmoPortLunInfo> userLunList) {
        int len = userLunList.size();
        BitSet ret = new BitSet(len);
        block0: for (int i = 0; i < len; ++i) {
            SJmoPortLunInfo lunInfo = userLunList.get(i);
            ArrayList userPortLunDetail = lunInfo.getAlPortLun();
            for (int j = 0; j < userPortLunDetail.size(); ++j) {
                SJmoPortLunDetail lunDetail = (SJmoPortLunDetail)userPortLunDetail.get(j);
                if (lunDetail.getSHostGroup() != 0 || ldevIndexComparator.compare(lunDetail, ldevDetail) != 0) continue;
                ret.set(i);
                continue block0;
            }
        }
        return ret;
    }

    static SJctrTableDataModel createErrorDialogTable(List<SJmoPortHostGroupInfo> list, SJctrDataController dc, SJctrComUtility util) {
        SJctrSelectHGTableModel table = new SJctrSelectHGTableModel();
        table.setDataController(dc);
        table.setPaging(false);
        table.initGuidance(util);
        table.createModelDirect();
        table.divideModelData(dc.getProxy().getModelDataMap());
        table.setBasicDataList(SJctrSelectHostGroupDC.createPortHgList(list));
        table.makeDataModel();
        return table;
    }

    static SJctrTableDataModel createErrorDialogIscsiTable(List<SJmoPortIscsiTargetInfo> list, SJctrDataController dc, SJctrComUtility util) {
        SJctrSelectITTableModel table = new SJctrSelectITTableModel();
        table.setDataController(dc);
        table.setPaging(false);
        table.initGuidance(util);
        table.createModelDirect();
        table.divideModelData(dc.getProxy().getModelDataMap());
        table.setBasicDataList(SJctrSelectHostGroupDC.createPortItList(list));
        table.makeDataModel();
        return table;
    }

    private static List<SJctrPortHostGroupTableKey> createPortHgList(List<SJmoPortHostGroupInfo> list) {
        int capacity = 0;
        int portListSize = list.size();
        for (int i = 0; i < portListSize; ++i) {
            SJmoPortHostGroupInfo portHgInfo = list.get(i);
            capacity += portHgInfo.getAlPortHostGroup().size();
        }
        ArrayList<SJctrPortHostGroupTableKey> tableKeyList = new ArrayList<SJctrPortHostGroupTableKey>(capacity);
        for (int i = 0; i < portListSize; ++i) {
            SJmoPortHostGroupInfo portHgInfo = list.get(i);
            ArrayList hgInfoList = portHgInfo.getAlPortHostGroup();
            int size = hgInfoList.size();
            for (int j = 0; j < size; ++j) {
                SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)hgInfoList.get(j);
                SJctrPortHostGroupTableKey tableKey = new SJctrPortHostGroupTableKey(portHgInfo, hgInfo);
                tableKeyList.add(tableKey);
            }
        }
        return tableKeyList;
    }

    private static List<SJctrPortHostGroupTableKey> createPortItList(List<SJmoPortIscsiTargetInfo> list) {
        int capacity = 0;
        int portListSize = list.size();
        for (int i = 0; i < portListSize; ++i) {
            SJmoPortIscsiTargetInfo portHgInfo = list.get(i);
            capacity += portHgInfo.getAlPortIscsiTarget().size();
        }
        ArrayList<SJctrPortHostGroupTableKey> tableKeyList = new ArrayList<SJctrPortHostGroupTableKey>(capacity);
        for (int i = 0; i < portListSize; ++i) {
            SJmoPortIscsiTargetInfo portHgInfo = list.get(i);
            ArrayList<SJmoIscsiTargetInfo> hgInfoList = portHgInfo.getAlPortIscsiTarget();
            int size = hgInfoList.size();
            for (int j = 0; j < size; ++j) {
                SJmoIscsiTargetInfo hgInfo = (SJmoIscsiTargetInfo)hgInfoList.get(j);
                SJctrPortHostGroupTableKey tableKey = new SJctrPortHostGroupTableKey(portHgInfo, hgInfo);
                tableKeyList.add(tableKey);
            }
        }
        return tableKeyList;
    }

    @Override
    public boolean checkEndData() {
        ArrayList errorList = new ArrayList();
        List<?> list = null;
        boolean isIscsi = false;
        if (this.getCache("KEY_TARGET_HG_INFO") != null && this.getCache("KEY_TARGET_HG_INFO").size() > 0) {
            list = this.getCache("KEY_TARGET_HG_INFO");
        } else {
            list = this.getCache("KEY_TARGET_IT_INFO");
            isIscsi = true;
        }
        if (list == null) {
            this.logUty.putlog("checkEndData", "There is no Target PortHostGroup.");
            SJctrError error = new SJctrError(10, 22, 107001);
            throw error.createException();
        }
        int size = list.size();
        if (0 >= size || size > 64) {
            this.logUty.putlog("checkEndData", "Target PortHostGroup range error = " + size);
            String[] msgArg = new String[]{Integer.toString(64)};
            SJctrError error = new SJctrError(10, 22, 105091);
            if (isIscsi) {
                error = new SJctrError(10, 22, SJctrMapLUNsSubWizard.MSG_SEL_IT_OVER);
            }
            SJcException ex = error.createException();
            ex.getMsg().setMsg_argument(msgArg);
            throw ex;
        }
        this.logUty.putlog("checkEndData", "Target PortHostGroup = " + list.size());
        List<?> ldevDL = this.getCache("KEY_TARGET_LDEV_INFO");
        int refVboxId = -1;
        boolean bMixLdevVbox = false;
        for (SJmoLdevDetail ldev : ldevDL) {
            SJmoRSGgetRsg refRsg = this.rsgUtil.getRsgFromLdev(ldev);
            SJmoRSGInfo refRsgInfo = refRsg.getRsgInfo();
            SJmoHUVMvboxIndex refVboxIndex = refRsgInfo.getVboxIndex();
            if (refVboxId != -1 && refVboxId != refVboxIndex.getIVboxId()) {
                bMixLdevVbox = true;
                break;
            }
            refVboxId = refVboxIndex.getIVboxId();
        }
        SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
        for (SJctrPortHostGroupTableKey HGkey : list) {
            BitSet bsOrgHmo;
            boolean bPortCosolidationHmo = false;
            if (HGkey.isFibre()) {
                SJmoHostGroupInfo hgInfo = HGkey.getHostGroupInfo();
                bsOrgHmo = hgInfo.getBtOption();
                bPortCosolidationHmo = bsOrgHmo.get(88);
                hgIndex.setSPort(hgInfo.getSPort());
                hgIndex.setSHostGroup(hgInfo.getSHostGroup());
            } else {
                SJmoIscsiTargetInfo itInfo = HGkey.getIscsiTargetInfo();
                bsOrgHmo = itInfo.getBtOption();
                bPortCosolidationHmo = bsOrgHmo.get(88);
                hgIndex.setSPort(itInfo.getSPort());
                hgIndex.setSHostGroup(itInfo.getSIscsiTarget());
            }
            SJmoRSGgetRsg rsg = this.rsgUtil.getRsgFromHg(hgIndex);
            SJmoRSGInfo rsgInfo = rsg.getRsgInfo();
            SJmoHUVMvboxIndex vboxIndex = rsgInfo.getVboxIndex();
            int vboxId = vboxIndex.getIVboxId();
            if (bPortCosolidationHmo || !bMixLdevVbox && refVboxId == vboxId) continue;
            this.logUty.putlog("checkEndData", "Selected any VDKCs at ML2", 40000);
            SJctrError err = new SJctrError(10, 22, 205054);
            SJcException exp = err.createException();
            throw exp;
        }
        return errorList.size() == 0;
    }

    @Override
    public boolean checkStartData() {
        int size;
        List<?> iscsiList;
        ArrayList errorList = new ArrayList();
        List<?> list = this.getCache("KEY_TARGET_LDEV_INFO");
        if (list == null || list.size() <= 0) {
            this.logUty.putlog("checkStartData", "There is no Target LdevDetail.");
            SJctrError error = new SJctrError(10, 22, 107001);
            throw error.createException();
        }
        this.logUty.putlog("checkStartData", "Target LdevDetail = " + list.size());
        list = this.getCache("KEY_SELECT_HG_INDEX");
        if (list != null) {
            int size2 = list.size();
            if (0 > size2 || size2 > 64) {
                this.logUty.putlog("checkStartData", "Select PortHostGroup range error = " + size2);
                String[] msgArg = new String[]{Integer.toString(64)};
                SJctrError error = new SJctrError(10, 22, 105091);
                SJcException ex = error.createException();
                ex.getMsg().setMsg_argument(msgArg);
                throw ex;
            }
            this.logUty.putlog("checkStartData", "Select PortHostGroup = " + list.size());
        }
        if ((iscsiList = this.getCache("KEY_SELECT_IT_INDEX")) != null && (0 > (size = iscsiList.size()) || size > 64)) {
            this.logUty.putlog("checkStartData", "Select PortHostGroup range error = " + size);
            String[] msgArg = new String[]{Integer.toString(64)};
            SJctrError error = new SJctrError(10, 22, SJctrMapLUNsSubWizard.MSG_SEL_IT_OVER);
            SJcException ex = error.createException();
            ex.getMsg().setMsg_argument(msgArg);
            throw ex;
        }
        return errorList.size() == 0;
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("LUNM", GUID_TITLE);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortLunInfo();
        SJmoGetRange_IF range = null;
        List filterList = Collections.emptyList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetChaDetail();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void addCheck(List<SJctrPortHostGroupTableKey> srcList, List<SJctrPortHostGroupTableKey> okList, List<SJctrPortHostGroupTableKey> ngList) {
        Collections.sort(srcList);
        ArrayList<SJctrPortHostGroupTableKey> list = new ArrayList<SJctrPortHostGroupTableKey>(SJctrPortUtility.PORT_HOSTGROUP_MAX);
        int size = srcList.size();
        int i = 0;
        while (i < size) {
            SJmoPortIscsiTargetInfo pItInfo;
            short port;
            SJmoPortHostGroupInfo phgInfo;
            SJctrPortHostGroupTableKey tableKey = srcList.get(i);
            if (tableKey.isFibre()) {
                phgInfo = tableKey.getPortHostGroupInfo();
                port = phgInfo.getSPort();
            } else {
                pItInfo = tableKey.getPortIscsiTargetInfo();
                port = pItInfo.getSPort();
            }
            list.clear();
            while (i < size && !((tableKey = srcList.get(i)).isFibre() ? port != (phgInfo = tableKey.getPortHostGroupInfo()).getSPort() : port != (pItInfo = tableKey.getPortIscsiTargetInfo()).getSPort())) {
                list.add(tableKey);
                ++i;
            }
            Integer portNum = port;
            Integer defLunNum = this.definedLunMap.get(portNum);
            int baseNum = defLunNum == null ? 0 : defLunNum;
            int newNum = baseNum + this.selectLdevNum * list.size();
            if (newNum <= SJctrPortUtility.PORT_LUN_MAX) {
                okList.addAll(list);
                this.definedLunMap.put(portNum, newNum);
                continue;
            }
            ngList.addAll(list);
            this.logUty.putlog("addCheck", "Add NG list = " + list);
        }
    }

    static Set<SJmoHostGroupInfo> checkEquipHostGroup(List<SJmoPortHostGroupInfo> infoList, List<SJctrPortHGIndex> indexList, List<SJctrErrorColumnData> errorList, SJctrLogUty logUty) {
        logUty.putlog("checkEquip", "Selected index list = " + indexList.size());
        int setCapacity = indexList.size() * 4 / 3 + 1;
        LinkedHashSet<SJmoHostGroupInfo> set = new LinkedHashSet<SJmoHostGroupInfo>(setCapacity);
        SJmoPortIndex phgInfo = null;
        ArrayList hgList = null;
        for (SJctrPortHGIndex phgIndex : indexList) {
            if (phgInfo == null || phgInfo.getSPort() != phgIndex.getPort()) {
                SJmoPortIndex portKey = new SJmoPortIndex();
                portKey.setSPort(phgIndex.getPort());
                int portIndex = Collections.binarySearch(infoList, portKey);
                if (portIndex < 0) {
                    SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkEquip", "Not equip Port: " + portKey);
                    SJmoPortHostGroupInfo phgKey = new SJmoPortHostGroupInfo();
                    phgKey.setSPort(phgIndex.getPort());
                    SJmoHostGroupInfo hgKey = new SJmoHostGroupInfo();
                    hgKey.setSPort(phgIndex.getPort());
                    hgKey.setSHostGroup(phgIndex.getHostGroup());
                    SJctrPortHostGroupTableKey tableKey = new SJctrPortHostGroupTableKey(phgKey, hgKey);
                    SJctrError error = new SJctrError(10, 22, 106501);
                    SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
                    errorList.add(errorData);
                    continue;
                }
                phgInfo = infoList.get(portIndex);
                hgList = ((SJmoPortHostGroupInfo)phgInfo).getAlPortHostGroup();
            }
            SJmoHostGroupInfo hgKey = new SJmoHostGroupInfo();
            hgKey.setSPort(phgIndex.getPort());
            hgKey.setSHostGroup(phgIndex.getHostGroup());
            int hgIndex = Collections.binarySearch(hgList, hgKey);
            if (hgIndex < 0) {
                SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkEquip", "Not equip HostGroup: " + hgKey);
                SJctrPortHostGroupTableKey tableKey = new SJctrPortHostGroupTableKey((SJmoPortHostGroupInfo)phgInfo, hgKey);
                SJctrError error = new SJctrError(10, 22, 106523);
                SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
                errorList.add(errorData);
                continue;
            }
            SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)hgList.get(hgIndex);
            set.add(hgInfo);
        }
        logUty.putlog("checkEquip", "Selected equipment list = " + set.size());
        return set;
    }

    static Set<SJmoIscsiTargetInfo> checkEquipIscsiTarget(List<SJmoPortIscsiTargetInfo> infoList, List<SJmoIscsiTargetIndex> indexList, List<SJctrErrorColumnData> errorList, SJctrLogUty logUty) {
        logUty.putlog("checkEquip", "Selected index list = " + indexList.size());
        int setCapacity = indexList.size() * 4 / 3 + 1;
        LinkedHashSet<SJmoIscsiTargetInfo> set = new LinkedHashSet<SJmoIscsiTargetInfo>(setCapacity);
        SJmoPortIndex ptItInfo = null;
        ArrayList<SJmoIscsiTargetInfo> itList = null;
        for (SJmoIscsiTargetIndex ptIdIndex : indexList) {
            if (ptItInfo == null || ptItInfo.getSPort() != ptIdIndex.getSPort()) {
                SJmoPortIndex portKey = new SJmoPortIndex();
                portKey.setSPort(ptIdIndex.getSPort());
                int portIndex = Collections.binarySearch(infoList, portKey);
                if (portIndex < 0) {
                    SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkEquip", "Not equip Port: " + portKey);
                    SJmoPortIscsiTargetInfo phgKey = new SJmoPortIscsiTargetInfo();
                    phgKey.setSPort(ptIdIndex.getSPort());
                    SJmoIscsiTargetInfo hgKey = new SJmoIscsiTargetInfo();
                    hgKey.setSPort(ptIdIndex.getSPort());
                    hgKey.setSIscsiTarget(ptIdIndex.getSIscsiTarget());
                    SJctrPortHostGroupTableKey tableKey = new SJctrPortHostGroupTableKey(phgKey, hgKey);
                    SJctrError error = new SJctrError(10, 22, 106501);
                    SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
                    errorList.add(errorData);
                    continue;
                }
                ptItInfo = infoList.get(portIndex);
                itList = ((SJmoPortIscsiTargetInfo)ptItInfo).getAlPortIscsiTarget();
            }
            SJmoIscsiTargetInfo hgKey = new SJmoIscsiTargetInfo();
            hgKey.setSPort(ptIdIndex.getSPort());
            hgKey.setSIscsiTarget(ptIdIndex.getSIscsiTarget());
            int itIndex = Collections.binarySearch(itList, hgKey);
            if (itIndex < 0) {
                SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkEquip", "Not equip HostGroup: " + hgKey);
                SJctrPortHostGroupTableKey tableKey = new SJctrPortHostGroupTableKey((SJmoPortIscsiTargetInfo)ptItInfo, hgKey);
                SJctrError error = new SJctrError(10, 22, 206522);
                SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
                errorList.add(errorData);
                continue;
            }
            SJmoIscsiTargetInfo itInfo = (SJmoIscsiTargetInfo)itList.get(itIndex);
            set.add(itInfo);
        }
        logUty.putlog("checkEquip", "Selected equipment list = " + set.size());
        return set;
    }

    private void checkHostMode(Set<SJmoHostGroupInfo> selectHgInfo, Map<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoLdevDetail> infoList) {
        this.logUty.putlog("checkHostMode", "input  = " + availableMap.size());
        if (!this.isAllMiddleTypeA(infoList)) {
            Iterator<Map.Entry<SJmoHostGroupInfo, SJctrPortHostGroupTableKey>> ite = availableMap.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> entry = ite.next();
                SJmoHostGroupInfo hgInfo = entry.getKey();
                if (hgInfo.getByHostMode() != 76) continue;
                ite.remove();
                boolean delFlg = selectHgInfo.remove(hgInfo);
                if (!delFlg) continue;
                SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkHostMode", "Off the subject: " + hgInfo);
                SJctrPortHostGroupTableKey tableKey = entry.getValue();
                SJctrError error = new SJctrError(10, 22, 108026);
                SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
                this.errorDataList.add(errorData);
            }
        }
        this.logUty.putlog("checkHostMode", "output = " + availableMap.size());
    }

    private void checkHostModeIscsi(Set<SJmoIscsiTargetInfo> selectItInfo, Map<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoLdevDetail> infoList) {
        this.logUty.putlog("checkHostModeIscsi", "input  = " + availableMap.size());
        if (!this.isAllMiddleTypeA(infoList)) {
            Iterator<Map.Entry<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey>> ite = availableMap.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey> entry = ite.next();
                SJmoIscsiTargetInfo itInfo = entry.getKey();
                if (itInfo.getIHostMode() != 76) continue;
                ite.remove();
                boolean delFlg = selectItInfo.remove(itInfo);
                if (!delFlg) continue;
                SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkHostModeIscsi", "Off the subject: " + itInfo);
                SJctrPortHostGroupTableKey tableKey = entry.getValue();
                SJctrError error = new SJctrError(10, 22, 108026);
                SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
                this.errorDataList.add(errorData);
            }
        }
        this.logUty.putlog("checkHostModeIscsi", "output = " + availableMap.size());
    }

    private void checkLunNum1(Set<SJmoHostGroupInfo> selectHgInfo, Map<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoPortLunInfo> infoList, List<SJmoLdevDetail> detailList) {
        this.logUty.putlog("checkLunNum1", "input  = " + availableMap.size());
        this.selectLdevNum = detailList.size();
        this.definedLunMap = new HashMap<Integer, Integer>();
        SJmoPortIndex lunInfo = null;
        List portLunList = null;
        Iterator<SJctrPortHostGroupTableKey> ite = availableMap.values().iterator();
        while (ite.hasNext()) {
            SJctrPortHostGroupTableKey tableKey = ite.next();
            SJmoPortHostGroupInfo phgInfo = tableKey.getPortHostGroupInfo();
            if (lunInfo == null || lunInfo.getSPort() != phgInfo.getSPort()) {
                int index = Collections.binarySearch(infoList, phgInfo);
                if (index < 0) {
                    SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkLunNum1", "Not found SJmoPortLunInfo: " + phgInfo);
                    continue;
                }
                lunInfo = infoList.get(index);
                portLunList = ((SJmoPortLunInfo)lunInfo).getAlPortLun();
                Integer portNum = phgInfo.getSPort();
                this.definedLunMap.put(portNum, portLunList.size());
            }
            if (portLunList.size() + this.selectLdevNum <= SJctrPortUtility.PORT_LUN_MAX) continue;
            ite.remove();
            boolean delFlg = selectHgInfo.remove(tableKey.getHostGroupInfo());
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkLunNum1", "Off the subject: " + tableKey.getHostGroupInfo());
            SJctrError error = new SJctrError(10, 22, 105207);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkLunNum1", "output = " + availableMap.size());
    }

    private void checkLunNumIscsi1(Set<SJmoIscsiTargetInfo> selectHgInfo, Map<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoPortLunInfo> infoList, List<SJmoLdevDetail> detailList) {
        this.logUty.putlog("checkLunNum1", "input  = " + availableMap.size());
        this.selectLdevNum = detailList.size();
        this.definedLunMap = new HashMap<Integer, Integer>();
        SJmoPortIndex lunInfo = null;
        List portLunList = null;
        Iterator<SJctrPortHostGroupTableKey> ite = availableMap.values().iterator();
        while (ite.hasNext()) {
            SJctrPortHostGroupTableKey tableKey = ite.next();
            SJmoPortIscsiTargetInfo phgInfo = tableKey.getPortIscsiTargetInfo();
            if (lunInfo == null || lunInfo.getSPort() != phgInfo.getSPort()) {
                int index = Collections.binarySearch(infoList, phgInfo);
                if (index < 0) {
                    SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkLunNumIscsi1", "Not found SJmoPortLunInfo: " + phgInfo);
                    continue;
                }
                lunInfo = infoList.get(index);
                portLunList = ((SJmoPortLunInfo)lunInfo).getAlPortLun();
                Integer portNum = phgInfo.getSPort();
                this.definedLunMap.put(portNum, portLunList.size());
            }
            if (portLunList.size() + this.selectLdevNum <= SJctrPortUtility.PORT_LUN_MAX) continue;
            ite.remove();
            boolean delFlg = selectHgInfo.remove(tableKey.getIscsiTargetInfo());
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkLunNum1", "Off the subject: " + tableKey.getIscsiTargetInfo());
            SJctrError error = new SJctrError(10, 22, 105207);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkLunNum1", "output = " + availableMap.size());
    }

    private void checkLunNum2(Set<SJmoHostGroupInfo> selectHgInfo, Map<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoPortLunInfo> infoList) {
        this.logUty.putlog("checkLunNum2", "input  = " + availableMap.size());
        int size = selectHgInfo.size();
        ArrayList<SJctrPortHostGroupTableKey> list = new ArrayList<SJctrPortHostGroupTableKey>(size);
        for (SJmoHostGroupInfo hgInfo : selectHgInfo) {
            SJctrPortHostGroupTableKey tableKey = availableMap.get(hgInfo);
            if (tableKey == null) {
                this.logUty.putlog("checkLunNum2", "Not found PortHostGroupTableKey: " + hgInfo);
                SJctrError error = new SJctrError(10, 22, 107002);
                throw error.createException();
            }
            list.add(tableKey);
        }
        ArrayList<SJctrPortHostGroupTableKey> okList = new ArrayList<SJctrPortHostGroupTableKey>(size);
        ArrayList<SJctrPortHostGroupTableKey> ngList = new ArrayList<SJctrPortHostGroupTableKey>(size);
        this.addCheck(list, okList, ngList);
        for (SJctrPortHostGroupTableKey tableKey : ngList) {
            SJmoHostGroupInfo hgInfo = tableKey.getHostGroupInfo();
            availableMap.remove(hgInfo);
            selectHgInfo.remove(hgInfo);
            SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkLunNum2", "Remove SJmoHostGroupInfo: " + hgInfo);
            SJctrError error = new SJctrError(10, 22, 105207);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkLunNum2", "output = " + availableMap.size());
    }

    private void checkLunNumIscsi2(Set<SJmoIscsiTargetInfo> selectHgInfo, Map<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoPortLunInfo> infoList) {
        this.logUty.putlog("checkLunNum2", "input  = " + availableMap.size());
        int size = selectHgInfo.size();
        ArrayList<SJctrPortHostGroupTableKey> list = new ArrayList<SJctrPortHostGroupTableKey>(size);
        for (SJmoIscsiTargetInfo hgInfo : selectHgInfo) {
            SJctrPortHostGroupTableKey tableKey = availableMap.get(hgInfo);
            if (tableKey == null) {
                this.logUty.putlog("checkLunNumIscsi2", "Not found PortHostGroupTableKey: " + hgInfo);
                SJctrError error = new SJctrError(10, 22, 107002);
                throw error.createException();
            }
            list.add(tableKey);
        }
        ArrayList<SJctrPortHostGroupTableKey> okList = new ArrayList<SJctrPortHostGroupTableKey>(size);
        ArrayList<SJctrPortHostGroupTableKey> ngList = new ArrayList<SJctrPortHostGroupTableKey>(size);
        this.addCheck(list, okList, ngList);
        for (SJctrPortHostGroupTableKey tableKey : ngList) {
            SJmoIscsiTargetInfo hgInfo = tableKey.getIscsiTargetInfo();
            availableMap.remove(hgInfo);
            selectHgInfo.remove(hgInfo);
            SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkLunNumIscsi2", "Remove SJmoIscsiTargetInfo: " + hgInfo);
            SJctrError error = new SJctrError(10, 22, 105207);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
            this.errorDataList.add(errorData);
        }
        this.logUty.putlog("checkLunNum2", "output = " + availableMap.size());
    }

    private void checkLunPath(Set<SJmoHostGroupInfo> selectHgInfo, Map<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoPortLunInfo> infoList, List<SJmoLdevDetail> detailList) {
        this.logUty.putlog("checkLunPath", "input  = " + availableMap.size());
        SJmoPortIndex lunInfo = null;
        ArrayList hgLunList = null;
        Iterator<SJctrPortHostGroupTableKey> ite = availableMap.values().iterator();
        block0: while (ite.hasNext()) {
            SJctrPortHostGroupTableKey tableKey = ite.next();
            SJmoPortHostGroupInfo phgInfo = tableKey.getPortHostGroupInfo();
            if (lunInfo == null || lunInfo.getSPort() != phgInfo.getSPort()) {
                int index = Collections.binarySearch(infoList, phgInfo);
                if (index < 0) {
                    SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkLunPath", "Not found SJmoPortLunInfo: " + phgInfo);
                    continue;
                }
                lunInfo = infoList.get(index);
            }
            hgLunList = ((SJmoPortLunInfo)lunInfo).getAlHostGroupLun(tableKey.getHostGroupInfo().getSHostGroup());
            int size = hgLunList.size();
            for (int i = 0; i < size; ++i) {
                SJmoPortLunDetail lunDetail = (SJmoPortLunDetail)hgLunList.get(i);
                SJmoLdevIndex ldevKey = new SJmoLdevIndex();
                ldevKey.setLdevIndex(lunDetail.getSLDKC(), lunDetail.getSCU(), lunDetail.getSLDEV());
                int index = Collections.binarySearch(detailList, ldevKey);
                if (index < 0) continue;
                ite.remove();
                boolean delFlg = selectHgInfo.remove(tableKey.getHostGroupInfo());
                if (!delFlg) continue block0;
                SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkLunPath", "Off the subject: " + tableKey.getHostGroupInfo());
                SJctrError error = new SJctrError(10, 22, 105090);
                SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
                this.errorDataList.add(errorData);
                continue block0;
            }
        }
        this.logUty.putlog("checkLunPath", "output = " + availableMap.size());
    }

    private void checkLunPathIscsi(Set<SJmoIscsiTargetInfo> selectItInfo, Map<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoPortLunInfo> infoList, List<SJmoLdevDetail> detailList) {
        this.logUty.putlog("checkLunPathIscsi", "input  = " + availableMap.size());
        SJmoPortIndex lunInfo = null;
        ArrayList hgLunList = null;
        Iterator<SJctrPortHostGroupTableKey> ite = availableMap.values().iterator();
        block0: while (ite.hasNext()) {
            SJctrPortHostGroupTableKey tableKey = ite.next();
            SJmoPortIscsiTargetInfo phgInfo = tableKey.getPortIscsiTargetInfo();
            if (lunInfo == null || lunInfo.getSPort() != phgInfo.getSPort()) {
                int index = Collections.binarySearch(infoList, phgInfo);
                if (index < 0) {
                    SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkLunPath", "Not found SJmoPortLunInfo: " + phgInfo);
                    continue;
                }
                lunInfo = infoList.get(index);
            }
            hgLunList = ((SJmoPortLunInfo)lunInfo).getAlHostGroupLun(tableKey.getIscsiTargetInfo().getSIscsiTarget());
            int size = hgLunList.size();
            for (int i = 0; i < size; ++i) {
                SJmoPortLunDetail lunDetail = (SJmoPortLunDetail)hgLunList.get(i);
                SJmoLdevIndex ldevKey = new SJmoLdevIndex();
                ldevKey.setLdevIndex(lunDetail.getSLDKC(), lunDetail.getSCU(), lunDetail.getSLDEV());
                int index = Collections.binarySearch(detailList, ldevKey);
                if (index < 0) continue;
                ite.remove();
                boolean delFlg = selectItInfo.remove(tableKey.getHostGroupInfo());
                if (!delFlg) continue block0;
                SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkLunPath", "Off the subject: " + tableKey.getHostGroupInfo());
                SJctrError error = new SJctrError(10, 22, 205143);
                SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
                this.errorDataList.add(errorData);
                continue block0;
            }
        }
        this.logUty.putlog("checkLunPathIscsi", "output = " + availableMap.size());
    }

    static void checkPortAttribute(Set<SJmoHostGroupInfo> selectHgInfo, Map<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoPortAttributeInfo> infoList, List<SJctrErrorColumnData> errorList, SJctrLogUty logUty) {
        logUty.putlog("checkPortAttribute", "input  = " + availableMap.size());
        SJmoPortIndex attributeInfo = null;
        byte attribute = 0;
        Iterator<SJctrPortHostGroupTableKey> ite = availableMap.values().iterator();
        while (ite.hasNext()) {
            SJctrError error;
            SJctrPortHostGroupTableKey tableKey = ite.next();
            SJmoPortHostGroupInfo phgInfo = tableKey.getPortHostGroupInfo();
            if (attributeInfo == null || attributeInfo.getSPort() != phgInfo.getSPort()) {
                int index = Collections.binarySearch(infoList, phgInfo);
                if (index < 0) {
                    logUty.putlog("checkPortAttribute", "Not found from PortAttributeInfo list: " + phgInfo);
                    error = new SJctrError(10, 22, 106520);
                    throw error.createException();
                }
                attributeInfo = infoList.get(index);
                attribute = ((SJmoPortAttributeInfo)attributeInfo).getByPortKind();
            }
            if (SJctrSelectHostGroupDC.isAvailableAttribute(attribute)) continue;
            ite.remove();
            boolean delFlg = selectHgInfo.remove(tableKey.getHostGroupInfo());
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkPortAttribute", "Off the subject: " + tableKey.getHostGroupInfo());
            error = new SJctrError(10, 22, 108025);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
            errorList.add(errorData);
        }
        logUty.putlog("checkPortAttribute", "output = " + availableMap.size());
    }

    static void checkHNASUserDefaultHG(Set<SJmoHostGroupInfo> selectHgInfo, Map<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoPortDetail> portDtlList, List<SJctrErrorColumnData> errorList, SJctrLogUty logUty) {
        logUty.putlog("checkHNASUserDefaultHG", "input  = " + availableMap.size());
        SJmoPortIndex portDtlInfo = null;
        Iterator<SJctrPortHostGroupTableKey> ite = availableMap.values().iterator();
        while (ite.hasNext()) {
            SJmoHostGroupInfo hgInfo;
            SJctrPortHostGroupTableKey tableKey = ite.next();
            SJmoPortHostGroupInfo phgInfo = tableKey.getPortHostGroupInfo();
            if (portDtlInfo == null || portDtlInfo.getSPort() != phgInfo.getSPort()) {
                int index = Collections.binarySearch(portDtlList, phgInfo);
                if (index < 0) {
                    logUty.putlog("checkHNASUserDefaultHG", "Not found from PortDetailInfo list: " + phgInfo);
                    SJctrError error = new SJctrError(10, 22, 106520);
                    throw error.createException();
                }
                portDtlInfo = portDtlList.get(index);
            }
            if (!SJctrPortUtility.isHnasUserPort((SJmoPortDetail)portDtlInfo) || (hgInfo = tableKey.getHostGroupInfo()).getSHostGroup() == 0) continue;
            ite.remove();
            boolean delFlg = selectHgInfo.remove(hgInfo);
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectHostGroupDC", "checkHNASUserDefaultHG", "Off the subject: " + tableKey.getHostGroupInfo());
            SJctrError error = new SJctrError(10, 22, 205209);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
            errorList.add(errorData);
        }
        logUty.putlog("checkHNASUserDefaultHG", "output = " + availableMap.size());
    }

    static void checkPortAttributeIscsi(Set<SJmoIscsiTargetInfo> selectHgInfo, Map<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey> availableMap, List<SJmoPortAttributeInfo> infoList, List<SJctrErrorColumnData> errorList, SJctrLogUty logUty) {
        logUty.putlog("checkPortAttributeIscsi", "input  = " + availableMap.size());
        SJmoPortIndex attributeInfo = null;
        byte attribute = 0;
        Iterator<SJctrPortHostGroupTableKey> ite = availableMap.values().iterator();
        while (ite.hasNext()) {
            SJctrPortHostGroupTableKey tableKey = ite.next();
            SJmoIscsiTargetInfo pItInfo = tableKey.getIscsiTargetInfo();
            if (attributeInfo == null || attributeInfo.getSPort() != pItInfo.getSPort()) {
                SJmoPortIndex ptIndex = new SJmoPortIndex();
                ptIndex.setSPort(pItInfo.getSPort());
                int index = Collections.binarySearch(infoList, ptIndex);
                if (index < 0) {
                    logUty.putlog("checkPortAttributeIscsi", "Not found from PortAttributeInfo list: " + pItInfo);
                    SJctrError error = new SJctrError(10, 22, 106520);
                    throw error.createException();
                }
                attributeInfo = infoList.get(index);
                attribute = ((SJmoPortAttributeInfo)attributeInfo).getByPortKind();
            }
            if (SJctrSelectHostGroupDC.isAvailableAttribute(attribute)) continue;
            ite.remove();
            boolean delFlg = selectHgInfo.remove(tableKey.getIscsiTargetInfo());
            if (!delFlg) continue;
            SJctrLogUty.debug("SJctrSelectIscsiTargetDC", "checkPortAttributeIscsi", "Off the subject: " + tableKey.getIscsiTargetInfo());
            SJctrError error = new SJctrError(10, 22, 108025);
            SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
            errorList.add(errorData);
        }
        logUty.putlog("checkPortAttributeIscsi", "output = " + availableMap.size());
    }

    static Map<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> createPortHgMap(List<SJmoPortHostGroupInfo> infoList, SJctrLogUty logUty) {
        logUty.putlog("createPortHgMap", "PortHostGroupInfo = " + infoList);
        int mapCapacity = 0;
        for (SJmoPortHostGroupInfo portHgInfo : infoList) {
            ArrayList hgInfoList = portHgInfo.getAlPortHostGroup();
            mapCapacity += hgInfoList.size();
        }
        mapCapacity = mapCapacity * 4 / 3 + 1;
        LinkedHashMap<SJmoHostGroupInfo, SJctrPortHostGroupTableKey> map = new LinkedHashMap<SJmoHostGroupInfo, SJctrPortHostGroupTableKey>(mapCapacity);
        for (SJmoPortHostGroupInfo portHgInfo : infoList) {
            ArrayList hgInfoList = portHgInfo.getAlPortHostGroup();
            int size = hgInfoList.size();
            for (int i = 0; i < size; ++i) {
                SJmoHostGroupInfo hgInfo = (SJmoHostGroupInfo)hgInfoList.get(i);
                SJctrPortHostGroupTableKey tableKey = new SJctrPortHostGroupTableKey(portHgInfo, hgInfo);
                map.put(hgInfo, tableKey);
            }
        }
        logUty.putlog("createPortHgMap", "Create = " + map.size());
        return map;
    }

    static Map<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey> createPortItMap(List<SJmoPortIscsiTargetInfo> infoList, SJctrLogUty logUty) {
        logUty.putlog("createPortItMap", "PortIscsiTargetInfo = " + infoList);
        int mapCapacity = 0;
        for (SJmoPortIscsiTargetInfo portItInfo : infoList) {
            ArrayList<SJmoIscsiTargetInfo> itInfoList = portItInfo.getAlPortIscsiTarget();
            mapCapacity += itInfoList.size();
        }
        mapCapacity = mapCapacity * 4 / 3 + 1;
        LinkedHashMap<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey> map = new LinkedHashMap<SJmoIscsiTargetInfo, SJctrPortHostGroupTableKey>(mapCapacity);
        for (SJmoPortIscsiTargetInfo portItInfo : infoList) {
            ArrayList<SJmoIscsiTargetInfo> itInfoList = portItInfo.getAlPortIscsiTarget();
            int size = itInfoList.size();
            for (int i = 0; i < size; ++i) {
                SJmoIscsiTargetInfo hgInfo = (SJmoIscsiTargetInfo)itInfoList.get(i);
                SJctrPortHostGroupTableKey tableKey = new SJctrPortHostGroupTableKey(portItInfo, hgInfo);
                map.put(hgInfo, tableKey);
            }
        }
        logUty.putlog("createPortItMap", "Create = " + map.size());
        return map;
    }

    private void initDataModel() {
        this.radioInfo = new SJctrPortTypeDataModel();
        this.radioInfo.selectHostGroup();
        this.radioInfo.setDirty();
        this.addDataObjectModel(KEY_RADIO_SEL_OBJ, this.radioInfo);
        this.radioInfo.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                if (event.isSelect()) {
                    SJctrSelectHGTableModel availableHgTable;
                    SJctrSelectHGTableModel table;
                    if (SJctrSelectHostGroupDC.this.radioInfo.isSelectFibre() && SJctrSelectHostGroupDC.this.oldRadioSelect != 0) {
                        table = (SJctrSelectHGTableModel)SJctrSelectHostGroupDC.this.getDataObjectModel(SJctrSelectHostGroupDC.KEY_TABLE_SELECTED);
                        table.setBasicDataList(SJctrSelectHostGroupDC.this.fibreSelectPortHostGroupTableKey);
                        table.setVisibleT10PIModeCol(true);
                        table.doRefresh();
                        SJctrSelectHostGroupDC.this.putCache("KEY_TARGET_HG_INFO", SJctrSelectHostGroupDC.this.fibreSelectPortHostGroupTableKey);
                        availableHgTable = (SJctrSelectHGTableModel)SJctrSelectHostGroupDC.this.getDataObjectModel(SJctrSelectHostGroupDC.KEY_TABLE_AVAILABLE);
                        availableHgTable.setBasicDataList(SJctrSelectHostGroupDC.this.fibrePortHostGroupTableKey);
                        availableHgTable.setVisibleT10PIModeCol(true);
                        availableHgTable.doRefresh();
                        SJctrSelectHostGroupDC.this.oldRadioSelect = 0;
                    }
                    if (SJctrSelectHostGroupDC.this.radioInfo.isSelectHnas() && SJctrSelectHostGroupDC.this.oldRadioSelect != 2) {
                        table = (SJctrSelectHGTableModel)SJctrSelectHostGroupDC.this.getDataObjectModel(SJctrSelectHostGroupDC.KEY_TABLE_SELECTED);
                        table.setBasicDataList(SJctrSelectHostGroupDC.this.hnasSelectPortHostGroupTableKey);
                        table.setVisibleT10PIModeCol(false);
                        table.doRefresh();
                        SJctrSelectHostGroupDC.this.putCache("KEY_TARGET_HG_INFO", SJctrSelectHostGroupDC.this.hnasSelectPortHostGroupTableKey);
                        availableHgTable = (SJctrSelectHGTableModel)SJctrSelectHostGroupDC.this.getDataObjectModel(SJctrSelectHostGroupDC.KEY_TABLE_AVAILABLE);
                        availableHgTable.setBasicDataList(SJctrSelectHostGroupDC.this.hnasPortHostGroupTableKey);
                        availableHgTable.setVisibleT10PIModeCol(false);
                        availableHgTable.doRefresh();
                        SJctrSelectHostGroupDC.this.oldRadioSelect = 2;
                    }
                }
            }
        });
        SJctrTableDataModel table = new SJctrSelectHGTableModel();
        this.addDataObjectModel(KEY_TABLE_AVAILABLE, table);
        SJctrButtonDataModel detail = ((SJctrSelectHGTableModel)table).getButton("COM_DETAIL");
        detail.addEventListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSelectHostGroupDC.this.fireMessageEvent(SELECT_HG_MSG.AVAILABLE_DETAIL);
            }
        });
        table = new SJctrSelectHGTableModel();
        table.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SELECTED, table);
        detail = ((SJctrSelectHGTableModel)table).getButton("COM_DETAIL");
        detail.addEventListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSelectHostGroupDC.this.fireMessageEvent(SELECT_HG_MSG.SELECTED_DETAIL);
            }
        });
        table = new SJctrSelectITTableModel();
        this.addDataObjectModel(KEY_TABLE_AVAILABLE_ISCSI, table);
        detail = ((SJctrSelectITTableModel)table).getButton("COM_DETAIL");
        detail.addEventListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSelectHostGroupDC.this.fireMessageEvent(SELECT_HG_MSG.AVAILABLE_IT_DETAIL);
            }
        });
        table = new SJctrSelectITTableModel();
        table.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_SELECTED_ISCSI, table);
        detail = ((SJctrSelectITTableModel)table).getButton("COM_DETAIL");
        detail.addEventListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSelectHostGroupDC.this.fireMessageEvent(SELECT_HG_MSG.SELECTED_IT_DETAIL);
            }
        });
        SJctrButtonDataModel button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_ADD, button);
        button.setRollBackCheck(true);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSelectHostGroupDC.this.fireMessageEvent(SELECT_HG_MSG.ADD);
            }
        });
        button = new SJctrButtonDataModel();
        this.addDataObjectModel(KEY_REMOVE, button);
        button.setRollBackCheck(true);
        button.addItemSelectListener(new SJctrItemSelectListener(){

            @Override
            public void selectChanged(SJctrItemSelectEvent<?> event) {
                SJctrSelectHostGroupDC.this.fireMessageEvent(SELECT_HG_MSG.REMOVE);
            }
        });
        SJctrFooterDataModel footer = new SJctrFooterDataModel();
        this.addDataObjectModel("COM_FOOTER", footer);
    }

    private void initListener() {
        this.addMessageEventListener(SELECT_HG_MSG.ADD, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable;
                SJctrTableDataModel availableTable;
                boolean isVisible = SJctrSelectHostGroupDC.this.radioInfo.isVisible("COM_HG");
                if (SJctrSelectHostGroupDC.this.radioInfo.isSelectFibre()) {
                    availableTable = (SJctrTableDataModel)SJctrSelectHostGroupDC.this.getDataObjectModel(SJctrSelectHostGroupDC.KEY_TABLE_AVAILABLE);
                    selectedTable = (SJctrTableDataModel)SJctrSelectHostGroupDC.this.getDataObjectModel(SJctrSelectHostGroupDC.KEY_TABLE_SELECTED);
                } else {
                    availableTable = (SJctrTableDataModel)SJctrSelectHostGroupDC.this.getDataObjectModel(KEY_TABLE_AVAILABLE_ISCSI);
                    selectedTable = (SJctrTableDataModel)SJctrSelectHostGroupDC.this.getDataObjectModel(KEY_TABLE_SELECTED_ISCSI);
                }
                SJctrSelectHostGroupDC.this.radioInfo.setEnable(false);
                if (!isVisible) {
                    SJctrSelectHostGroupDC.this.radioInfo.setVisible(false);
                }
                SJctrSelectHostGroupDC.this.radioInfo.setDirty();
                List<Object> srcList = availableTable.getSelectedRowData();
                int newSize = selectedTable.getAllRowData().size() + srcList.size();
                if (newSize > 64) {
                    SJctrSelectHostGroupDC.this.logUty.putlog("ADD Action", "Select PortHostGroup range error = " + newSize);
                    String[] msgArg = new String[]{Integer.toString(64)};
                    SJctrError error = new SJctrError(10, 22, 105091);
                    if (SJctrSelectHostGroupDC.this.radioInfo.isSelectIscsi()) {
                        error = new SJctrError(10, 22, SJctrMapLUNsSubWizard.MSG_SEL_IT_OVER);
                    }
                    SJcException ex = error.createException();
                    ex.getMsg().setMsg_argument(msgArg);
                    throw ex;
                }
                ArrayList okList = new ArrayList(srcList.size());
                ArrayList ngList = new ArrayList(srcList.size());
                SJctrSelectHostGroupDC.this.addCheck(srcList, okList, ngList);
                if (ngList.size() > 0) {
                    SJctrError error;
                    ArrayList<SJctrErrorColumnData> errorList = new ArrayList<SJctrErrorColumnData>(ngList.size());
                    for (SJctrPortHostGroupTableKey tableKey : ngList) {
                        error = new SJctrError(10, 22, 105089);
                        SJctrErrorColumnData errorData = new SJctrErrorColumnData(tableKey, error);
                        errorList.add(errorData);
                    }
                    SJctrRelatedDispDataObject related = SJctrSelectHostGroupDC.this.createDialog(SJctrErrorDataController.class, null);
                    SJctrErrorDataController errorDialog = (SJctrErrorDataController)SJctrSelectHostGroupDC.this.getOwner().getDataController(related);
                    errorDialog.setParameter(SJctrSelectHostGroupDC.this.getDataObjectModel(SJctrSelectHostGroupDC.KEY_TABLE_AVAILABLE), errorList);
                    error = errorDialog.getRepresentativeError(errorList);
                    SJcException ex = error.createException();
                    ex.setErrDisp(related);
                    throw ex;
                }
                availableTable.removeRowData(okList);
                selectedTable.addRowDataTop(okList);
                SJctrSelectHostGroupDC.this.logUty.putlog("ADD Action", "Add data = " + okList.size());
                SJctrSelectHostGroupDC.this.logUty.putlog("ADD Action", "Available : Selected = " + availableTable.getRowCount() + " : " + selectedTable.getRowCount());
                List<?> targetList = SJctrSelectHostGroupDC.this.radioInfo.isSelectFibre() ? SJctrSelectHostGroupDC.this.getCache("KEY_TARGET_HG_INFO") : SJctrSelectHostGroupDC.this.getCache("KEY_TARGET_IT_INFO");
                okList.addAll(targetList);
                Collections.sort(okList);
                if (SJctrSelectHostGroupDC.this.radioInfo.isSelectFibre()) {
                    SJctrSelectHostGroupDC.this.putCache("KEY_TARGET_HG_INFO", okList);
                } else {
                    SJctrSelectHostGroupDC.this.putCache("KEY_TARGET_IT_INFO", okList);
                }
                SJctrSelectHostGroupDC.this.updateFooter();
                SJctrSelectHostGroupDC.this.setDirtyAll();
            }
        });
        this.addMessageEventListener(SELECT_HG_MSG.REMOVE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable;
                SJctrTableDataModel availableTable;
                if (SJctrSelectHostGroupDC.this.radioInfo.isSelectFibre()) {
                    availableTable = (SJctrTableDataModel)SJctrSelectHostGroupDC.this.getDataObjectModel(SJctrSelectHostGroupDC.KEY_TABLE_AVAILABLE);
                    selectedTable = (SJctrTableDataModel)SJctrSelectHostGroupDC.this.getDataObjectModel(SJctrSelectHostGroupDC.KEY_TABLE_SELECTED);
                } else {
                    availableTable = (SJctrTableDataModel)SJctrSelectHostGroupDC.this.getDataObjectModel(KEY_TABLE_AVAILABLE_ISCSI);
                    selectedTable = (SJctrTableDataModel)SJctrSelectHostGroupDC.this.getDataObjectModel(KEY_TABLE_SELECTED_ISCSI);
                }
                List<Object> srcList = selectedTable.removeSelectedRowData();
                availableTable.addRowDataTop(srcList);
                SJctrSelectHostGroupDC.this.logUty.putlog("REMOVE Action", "Remove data = " + srcList.size());
                SJctrSelectHostGroupDC.this.logUty.putlog("REMOVE Action", "Available : Selected = " + availableTable.getRowCount() + " : " + selectedTable.getRowCount());
                SJctrSelectHostGroupDC.this.removeDefinedLun(srcList);
                ArrayList targetList = null;
                targetList = SJctrSelectHostGroupDC.this.radioInfo.isSelectFibre() ? new ArrayList(SJctrSelectHostGroupDC.this.getCache("KEY_TARGET_HG_INFO")) : new ArrayList(SJctrSelectHostGroupDC.this.getCache("KEY_TARGET_IT_INFO"));
                Collections.sort(targetList);
                Collections.sort(srcList);
                for (int i = srcList.size() - 1; i >= 0; --i) {
                    SJctrPortHostGroupTableKey key = (SJctrPortHostGroupTableKey)srcList.get(i);
                    int index = Collections.binarySearch(targetList, key);
                    if (index >= 0) {
                        targetList.remove(index);
                        continue;
                    }
                    SJctrSelectHostGroupDC.this.logUty.putlog("REMOVE Action", "Not found from cache list: " + key);
                }
                if (targetList.size() == 0) {
                    boolean isVisibleFlg = SJctrSelectHostGroupDC.this.radioInfo.isVisible("COM_HG");
                    if (isVisibleFlg) {
                        SJctrTableDataModel iscsiAvailableTable;
                        if (SJctrSelectHostGroupDC.this.fibrePortHostGroupTableKey.size() > 0) {
                            SJctrSelectHostGroupDC.this.radioInfo.setEnable("COM_HG", true);
                        }
                        if ((iscsiAvailableTable = (SJctrTableDataModel)SJctrSelectHostGroupDC.this.getDataObjectModel(KEY_TABLE_AVAILABLE_ISCSI)).getRowCount() > 0) {
                            SJctrSelectHostGroupDC.this.radioInfo.setEnable("COM_ISCSI", true);
                        }
                        if (SJctrSelectHostGroupDC.this.hnasSelectPortHostGroupTableKey.size() > 0) {
                            SJctrSelectHostGroupDC.this.radioInfo.setEnable("COM_HNAS", true);
                        }
                    }
                    SJctrSelectHostGroupDC.this.radioInfo.setDirty();
                }
                if (SJctrSelectHostGroupDC.this.radioInfo.isSelectFibre()) {
                    SJctrSelectHostGroupDC.this.putCache("KEY_TARGET_HG_INFO", targetList);
                } else {
                    SJctrSelectHostGroupDC.this.putCache("KEY_TARGET_IT_INFO", targetList);
                }
                SJctrSelectHostGroupDC.this.updateFooter();
                SJctrSelectHostGroupDC.this.setDirtyAll();
            }
        });
        this.addMessageEventListener(SELECT_HG_MSG.AVAILABLE_DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSelectHGTableModel table = (SJctrSelectHGTableModel)SJctrSelectHostGroupDC.this.getDataObjectModel(SJctrSelectHostGroupDC.KEY_TABLE_AVAILABLE);
                SJctrSelectHostGroupDC.this.makeDetailDialog(table);
            }
        });
        this.addMessageEventListener(SELECT_HG_MSG.SELECTED_DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSelectHGTableModel table = (SJctrSelectHGTableModel)SJctrSelectHostGroupDC.this.getDataObjectModel(SJctrSelectHostGroupDC.KEY_TABLE_SELECTED);
                SJctrSelectHostGroupDC.this.makeDetailDialog(table);
            }
        });
        this.addMessageEventListener(SELECT_HG_MSG.AVAILABLE_IT_DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSelectITTableModel table = (SJctrSelectITTableModel)SJctrSelectHostGroupDC.this.getDataObjectModel(KEY_TABLE_AVAILABLE_ISCSI);
                SJctrSelectHostGroupDC.this.makeDetailDialog(table);
            }
        });
        this.addMessageEventListener(SELECT_HG_MSG.SELECTED_IT_DETAIL, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrSelectITTableModel table = (SJctrSelectITTableModel)SJctrSelectHostGroupDC.this.getDataObjectModel(KEY_TABLE_SELECTED_ISCSI);
                SJctrSelectHostGroupDC.this.makeDetailDialog(table);
            }
        });
    }

    private boolean isAllMiddleTypeA(List<SJmoLdevDetail> infoList) {
        boolean result = false;
        if (infoList.size() > 0) {
            result = true;
            for (SJmoLdevDetail ldevDetail : infoList) {
                if (SJctrLdevUtility.isATypeVolume(ldevDetail)) continue;
                result = false;
                break;
            }
            if (result) {
                this.logUty.putlog("isAllMiddleTypeA", "Select LDEVs are all Middle Volume TypeA.");
            }
        }
        return result;
    }

    private static boolean isAvailableAttribute(byte attribute) {
        boolean result = false;
        switch (attribute) {
            case 3: 
            case 9: {
                result = true;
                break;
            }
            case 4: {
                result = true;
            }
        }
        return result;
    }

    private void makeDetailDialog(SJctrSelectHGTableModel table) {
        List<Object> selectList = table.getSelectedRowData();
        if (selectList.size() <= 0) {
            this.logUty.putlog("makeDetailDialog", "There is no selection.");
            return;
        }
        SJctrPortHostGroupTableKey tableKey = (SJctrPortHostGroupTableKey)selectList.get(0);
        SJmoPortHostGroupInfo phgInfo = tableKey.getPortHostGroupInfo();
        List<?> detailList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_DETAIL);
        int index = Collections.binarySearch(detailList, phgInfo);
        if (index < 0) {
            this.logUty.putlog("makeDetailDialog", "Not found from PortDetail list: " + phgInfo);
            SJctrError error = new SJctrError(10, 22, 106520);
            throw error.createException();
        }
        SJmoPortDetail detail = (SJmoPortDetail)detailList.get(index);
        SJctrHGPropertySelectData selectData = new SJctrHGPropertySelectData();
        selectData.setData(detail, tableKey.getHostGroupInfo());
        ArrayList<SJctrHGPropertySelectData> list = new ArrayList<SJctrHGPropertySelectData>(1);
        list.add(selectData);
        HashMap param = new HashMap();
        param.put("HG_PROPERTY_SELECT_DATA", list);
        SJctrRelatedDispDataObject related = this.createDialog(SJctrHGPropertyDC.class, param);
        this.addUpdateDisp(related);
    }

    private void removeDefinedLun(List<SJctrPortHostGroupTableKey> srcList) {
        Collections.sort(srcList);
        ArrayList<SJctrPortHostGroupTableKey> list = new ArrayList<SJctrPortHostGroupTableKey>(SJctrPortUtility.PORT_HOSTGROUP_MAX);
        int size = srcList.size();
        int i = 0;
        while (i < size) {
            int baseNum;
            short otherPort;
            SJctrPortHostGroupTableKey tableKey = srcList.get(i);
            short port = tableKey.isFibre() ? tableKey.getPortHostGroupInfo().getSPort() : tableKey.getPortIscsiTargetInfo().getSPort();
            list.clear();
            while (i < size && port == (otherPort = (tableKey = srcList.get(i)).isFibre() ? tableKey.getPortHostGroupInfo().getSPort() : tableKey.getPortIscsiTargetInfo().getSPort())) {
                list.add(tableKey);
                ++i;
            }
            Integer portNum = port;
            Integer defLunNum = this.definedLunMap.get(portNum);
            if (defLunNum != null) {
                baseNum = defLunNum;
            } else {
                baseNum = 0;
                this.logUty.putlog("removeDefinedLun", "Defined LUN is not found.");
            }
            int newNum = baseNum - this.selectLdevNum * list.size();
            if (newNum < 0) {
                this.logUty.putlog("removeDefinedLun", "[new, old, ldev, hg] = [" + newNum + ", " + baseNum + ", " + this.selectLdevNum + ", " + list.size() + "]");
                newNum = 0;
            }
            this.definedLunMap.put(portNum, newNum);
        }
    }

    private void makeDetailDialog(SJctrSelectITTableModel table) {
        List<Object> selectList = table.getSelectedRowData();
        if (selectList.size() <= 0) {
            this.logUty.putlog("makeDetailDialog", "There is no selection.");
            return;
        }
        SJctrPortHostGroupTableKey tableKey = (SJctrPortHostGroupTableKey)selectList.get(0);
        SJmoPortIscsiTargetInfo ptItInfo = tableKey.getPortIscsiTargetInfo();
        List<?> detailList = this.getCache(SJctrMapLUNsSubWizard.KEY_PORT_DETAIL);
        int index = Collections.binarySearch(detailList, ptItInfo);
        if (index < 0) {
            this.logUty.putlog("makeDetailDialog", "Not found from PortDetail list: " + ptItInfo);
            SJctrError error = new SJctrError(10, 22, 106520);
            throw error.createException();
        }
        ArrayList<SJmoIscsiTargetInfo> ptItList = new ArrayList<SJmoIscsiTargetInfo>();
        ptItList.add(tableKey.getIscsiTargetInfo());
        HashMap param = new HashMap();
        param.put("KEY_SELECTED_ISCSI_TARGETS", ptItList);
        SJctrRelatedDispDataObject related = this.createDialog(SJctrIscsiTargetPropertiesDC.class, param);
        this.addUpdateDisp(related);
    }

    public static enum SELECT_HG_MSG implements SJctrNotifyState
    {
        ADD,
        REMOVE,
        AVAILABLE_DETAIL,
        SELECTED_DETAIL,
        AVAILABLE_IT_DETAIL,
        SELECTED_IT_DETAIL;

    }
}

