/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.lunm.relhostreserve.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import sanproject.serverux.dataimpl.LUNMgetHostReserved;
import sanproject.serverux.dataimpl.LUNMgetHostReserved_IN;
import sanproject.serverux.dataimpl.LUNMgetHostReserved_OUT;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.lunm.com.SJctrPortLunTableKey;
import sanproject.sn2.controller.wizard.lunm.relhostreserve.com.SJctrGetHostReserve;
import sanproject.sn2.controller.wizard.lunm.relhostreserve.properties.SJctrHostReserveLunTableModel;
import sanproject.sn2.controller.wizard.lunm.relhostreserve.release.SJctrRelHostReserveSubWizard;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortHostGroupInfo;
import sanproject.sn2.model.connector.kind.SJmoGetPortIscsiTargetInfo;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.device.SJmoPortIndex;
import sanproject.sn2.model.data.lu.SJmoHostGroupIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetIndex;
import sanproject.sn2.model.data.lu.SJmoIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortHostGroupInfo;
import sanproject.sn2.model.data.lu.SJmoPortIscsiTargetInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.lu.SJmoPortLunInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;

public class SJctrHostReserveDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664514;
    private static final String KEY_FOOTER = "COM_FOOTER";
    private static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_BUTTON_GROUP = "COM_BUTTON_GROUP";
    public static final String KEY_RSTHTRSV = "COM_RSTHTRSV";
    public static final String KEY_PORTLUN_TO_VIEWHOSTRSV = "KEY_PORTLUN_TO_VIEWHOSTRSV";
    public static final String KEY_PORTLUN_TO_RSTHOSTRSV = "KEY_PORTLUN_TO_RSTHOSTRSV";
    public static int HOSTRSV_ERR_INVALID_DATA_LEVEL7 = 107001;
    public static int HOSTRSV_ERR_INVALID_DATA_LEVEL4 = 107002;
    public static int HOSTRSV_ERR_PORT_NOT_EXIST_LEVEL4 = 106501;
    public static int HOSTRSV_ERR_HG_NOT_EXIST_LEVEL4 = 106502;
    public static int HOSTRSV_ERR_HG_RSG_INVALID_LEVEL4 = 105297;
    public static int HOSTRSV_ERR_LUNPATH_NOT_EXIST_LEVEL4 = 106506;
    public static int HOSTRSV_ERR_LDEV_RSG_INVALID_LEVEL4 = 105298;
    public static int HOSTRSV_ERR_LDEV_RSG_INVALID_LEVEL7 = 105424;
    public static int HOSTRSV_ERR_NOT_AUTHORITY_LEVEL7 = 105423;

    public SJctrHostReserveDC() throws SJcException {
        super(34664514);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        SJctrHostReserveLunTableModel tableModel = new SJctrHostReserveLunTableModel();
        this.addDataObjectModel(KEY_TABLE, tableModel);
        this.addDataObjectModel(KEY_FOOTER, new SJctrFooterDataModel(SJctrFooterDataModel.BGO_CLOSE));
        SJctrSimpleDataModel buttonGroup = new SJctrSimpleDataModel();
        tableModel.addDataModel(KEY_BUTTON_GROUP, buttonGroup);
        SJctrButtonDataModel release = new SJctrButtonDataModel(){
            {
                this.setReceiveOnly();
                this.addItemSelectListener(new SJctrItemSelectListener(){

                    @Override
                    public void selectChanged(SJctrItemSelectEvent<?> event) {
                        this.fireMessageEvent(NOTIFY_RELEASE_HOST_RESERVE.RELEASE);
                    }
                });
            }
        };
        buttonGroup.addDataModel(KEY_RSTHTRSV, release);
    }

    @Override
    public boolean checkStartData() {
        boolean result = true;
        List<?> portLunTableKeyList = this.getCache(KEY_PORTLUN_TO_VIEWHOSTRSV);
        if (portLunTableKeyList == null) {
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL7);
            SJcException exp = err.createException();
            throw exp;
        }
        for (int i = 0; i < portLunTableKeyList.size(); ++i) {
            SJctrPortLunTableKey portLunTableKey = (SJctrPortLunTableKey)portLunTableKeyList.get(i);
            SJmoPortLunInfo portLunInfo = portLunTableKey.getPortLunInfo();
            SJmoPortLunDetail portLunDetail = portLunTableKey.getPortLunDetail();
            if (portLunInfo != null && portLunDetail != null) continue;
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL7);
            SJcException exp = err.createException();
            throw exp;
        }
        return result;
    }

    @Override
    public boolean checkConstructData() {
        boolean result = true;
        List<?> cachePortLunTableKeyList = this.getCache(KEY_PORTLUN_TO_VIEWHOSTRSV);
        if (cachePortLunTableKeyList.size() == 0) {
            return result;
        }
        List<?> moPortHGInfoList = this.getCache(SJmoGetPortHostGroupInfo.class);
        List<?> moPortITInfoList = this.getCache(SJmoGetPortIscsiTargetInfo.class);
        if (!(moPortHGInfoList != null && moPortHGInfoList.size() != 0 || moPortITInfoList != null && moPortITInfoList.size() != 0)) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoGetPortHostGroupInfo Not Found in the Cache.");
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        List<?> moAllRsgList = this.getCache(SJmoGetRSGgetAllRsgs.class);
        if (moAllRsgList == null || moAllRsgList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoGetRSGgetAllRsgs Not Found in the Cache.");
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrResourceGroupUtility rsgUtil = new SJctrResourceGroupUtility(this.getOwner(), (SJmoRSGgetAllRsgs)moAllRsgList.get(0));
        SJctrPortLunTableKey tableKey = (SJctrPortLunTableKey)cachePortLunTableKeyList.get(0);
        SJmoPortLunDetail portLunDetail = tableKey.getPortLunDetail();
        short sPort = portLunDetail.getSPort();
        short sHG = portLunDetail.getSHostGroup();
        SJmoPortLunInfo portLunInfo = tableKey.getPortLunInfo();
        SJmoPortIndex portIndex = new SJmoPortIndex();
        portIndex.setSPort(sPort);
        int searchIdx = -1;
        if (moPortHGInfoList != null && moPortHGInfoList.size() > 0) {
            searchIdx = Collections.binarySearch(moPortHGInfoList, portIndex);
        }
        boolean iscsiFlg = false;
        if (searchIdx < 0) {
            searchIdx = Collections.binarySearch(moPortITInfoList, portIndex);
            iscsiFlg = true;
        }
        if (searchIdx < 0) {
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_PORT_NOT_EXIST_LEVEL4);
            SJcException exp = err.createException();
            throw exp;
        }
        if (!iscsiFlg) {
            SJmoPortHostGroupInfo oneModelPt = (SJmoPortHostGroupInfo)moPortHGInfoList.get(searchIdx);
            ArrayList hgArray = oneModelPt.getAlPortHostGroup();
            SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
            hgIndex.setSPort(sPort);
            hgIndex.setSHostGroup(sHG);
            searchIdx = Collections.binarySearch(hgArray, hgIndex);
            if (searchIdx < 0) {
                SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_HG_NOT_EXIST_LEVEL4);
                SJcException exp = err.createException();
                throw exp;
            }
            boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
            if (!rsgFlg) {
                SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_HG_RSG_INVALID_LEVEL4);
                SJcException exp = err.createException();
                throw exp;
            }
        } else {
            SJmoPortIscsiTargetInfo oneModelPt = (SJmoPortIscsiTargetInfo)moPortITInfoList.get(searchIdx);
            ArrayList<SJmoIscsiTargetInfo> itArray = oneModelPt.getAlPortIscsiTarget();
            SJmoIscsiTargetIndex itIndex = new SJmoIscsiTargetIndex();
            itIndex.setSPort(sPort);
            itIndex.setSIscsiTarget(sHG);
            searchIdx = Collections.binarySearch(itArray, itIndex);
            if (searchIdx < 0) {
                SJctrError err = new SJctrError(10, 22, 206521);
                SJcException exp = err.createException();
                throw exp;
            }
            SJmoHostGroupIndex hgIndex = new SJmoHostGroupIndex();
            hgIndex.setSPort(sPort);
            hgIndex.setSHostGroup(sHG);
            boolean rsgFlg = SJctrPortUtility.isRsgHostGroupIndex(hgIndex, rsgUtil);
            if (!rsgFlg) {
                SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_HG_RSG_INVALID_LEVEL4);
                SJcException exp = err.createException();
                throw exp;
            }
        }
        return result;
    }

    public List<LUNMgetHostReserved> getHostReservedList(SJctrPortLunTableKey tblKey) {
        ArrayList<LUNMgetHostReserved> retList = new ArrayList<LUNMgetHostReserved>();
        LUNMgetHostReserved_IN input = new LUNMgetHostReserved_IN();
        short sPort = tblKey.getPortLunInfo().getSPort();
        short sHG = tblKey.getPortLunDetail().getSHostGroup();
        input.setSPort(sPort);
        SJctrGetHostReserve kind = new SJctrGetHostReserve(input);
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct, false);
        SJmoThroughRmiData rmiObj = null;
        LUNMgetHostReserved_OUT resultGetHostReserve = null;
        rmiObj = (SJmoThroughRmiData)this.getModelData(wrapper).get(0);
        resultGetHostReserve = (LUNMgetHostReserved_OUT)rmiObj.getObjRmi();
        if (resultGetHostReserve == null) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getHostReserveList", "LUNMgetHostReserved_OUT Not Found in the Cache.");
            return null;
        }
        LUNMgetHostReserved[] hostReserve = resultGetHostReserve.getObjHostReserved();
        for (int i = 0; i < hostReserve.length; ++i) {
            if (hostReserve[i].getSHostGroupId() != sHG) continue;
            retList.add(hostReserve[i]);
        }
        return retList;
    }

    private void initListener() {
        this.addMessageEventListener(NOTIFY_RELEASE_HOST_RESERVE.RELEASE, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrTableDataModel selectedTable = (SJctrTableDataModel)SJctrHostReserveDC.this.getDataObjectModel(SJctrHostReserveDC.KEY_TABLE);
                List<Object> selectedRows = selectedTable.getSelectedRowData();
                SJctrHostReserveDC.this.makeRelHostRsv(selectedRows);
            }
        });
    }

    private void makeRelHostRsv(List<Object> selectedRowList) {
        if (selectedRowList == null || selectedRowList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "makeRelHostRsv", "LUN isn't selected.");
            SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_INVALID_DATA_LEVEL7);
            SJcException exp = err.createException();
            throw exp;
        }
        SJctrUserController uc = this.getOwner();
        if (uc != null) {
            SJcRoleResourceContainer roleResourceContainer = uc.getAuthorizeContainer().getRoleResourceContainer();
            boolean checkResult = roleResourceContainer.checkAuthority(32);
            if (!(checkResult &= roleResourceContainer.checkAuthority(122))) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "makeRelHostRsv", "No editorial permission to the user.");
                SJctrError err = new SJctrError(10, 22, HOSTRSV_ERR_NOT_AUTHORITY_LEVEL7);
                SJcException exp = err.createException();
                throw exp;
            }
        }
        HashMap map = new HashMap();
        map.put(KEY_PORTLUN_TO_RSTHOSTRSV, selectedRowList);
        SJctrRelatedDispDataObject relatedObj = this.createWizard(SJctrRelHostReserveSubWizard.class, map);
        SJctrRelatedDispDataObject removeRelated = uc.removeRelatedDispData(this.getuId());
        this.addUpdateDisp(removeRelated);
        this.addUpdateDisp(relatedObj);
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetPortHostGroupInfo();
        SJmoGetRange_IF range = null;
        List<Object> filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetRSGgetAllRsgs();
        range = null;
        filterList = Collections.emptyList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetPortIscsiTargetInfo();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    public static enum NOTIFY_RELEASE_HOST_RESERVE implements SJctrNotifyState
    {
        RELEASE;

    }
}

