/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.editmonswitch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorConfirmTableInfo;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorConfirmTableModel;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorWarningMsgFlagData;
import sanproject.sn2.controller.wizard.monitor.optmon.editmonswitch.SJctrEditMonitoringSwitchConfirmData;

public class SJctrEditMonitoringSwitchConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 17827935;
    private static final String KEY_TABLE_MON_OBJECT = "COM_TABLE_MON_OBJECT";
    private static final String KEY_EDT_MON_SWITCH_WARN = "COM_EDT_MON_SWITCH_WARN";

    public SJctrEditMonitoringSwitchConfirmDC() throws SJcException {
        super(17827935);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrOptionMonitorConfirmTableModel confirmTable = new SJctrOptionMonitorConfirmTableModel();
        confirmTable.setPaging(false);
        this.addDataObjectModel(KEY_TABLE_MON_OBJECT, confirmTable);
        this.addDataObjectModel(KEY_EDT_MON_SWITCH_WARN, new SJctrOptionMonitorWarningMsgFlagData());
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        SJctrEditMonitoringSwitchConfirmData confirmData = null;
        List<?> confirmDataList = this.getCache(SJctrEditMonitoringSwitchConfirmData.class);
        if (confirmDataList == null) {
            this.logUty.putlog("checkStartData", "Confirmation data list is null.");
            SJctrError err = new SJctrError(51, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        if (confirmDataList.size() == 0) {
            this.logUty.putlog("checkStartData", "Size of confirmation data list is zero.");
            SJctrError err = new SJctrError(51, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        confirmData = (SJctrEditMonitoringSwitchConfirmData)confirmDataList.get(0);
        if (null == confirmData) {
            this.logUty.putlog("checkStartData", "Confirmation data is null.");
            SJctrError err = new SJctrError(51, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        SJctrEditMonitoringSwitchConfirmData confirmData = (SJctrEditMonitoringSwitchConfirmData)this.getProxy().getCache(SJctrEditMonitoringSwitchConfirmData.class).get(0);
        ArrayList<SJctrOptionMonitorConfirmTableInfo> confirmInfo = new ArrayList<SJctrOptionMonitorConfirmTableInfo>();
        confirmInfo.add(this.createMonSwitchRowData(confirmData));
        confirmInfo.add(this.createIntervalRowData(confirmData));
        SJctrOptionMonitorConfirmTableModel confirmTable = (SJctrOptionMonitorConfirmTableModel)this.getDataObjectModel(KEY_TABLE_MON_OBJECT);
        confirmTable.setBasicDataList(confirmInfo);
        SJctrOptionMonitorWarningMsgFlagData warningMsg = (SJctrOptionMonitorWarningMsgFlagData)this.getDataObjectModel(KEY_EDT_MON_SWITCH_WARN);
        warningMsg.setWarningFlag(confirmData.getViewWarningMsg());
        return true;
    }

    private SJctrOptionMonitorConfirmTableInfo createMonSwitchRowData(SJctrEditMonitoringSwitchConfirmData confirmData) {
        String item = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.MON_SWITCH);
        String value = "";
        value = confirmData.isMonSwitch() ? SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.ENABLED) : SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.DISABLED);
        return new SJctrOptionMonitorConfirmTableInfo(item, value);
    }

    private SJctrOptionMonitorConfirmTableInfo createIntervalRowData(SJctrEditMonitoringSwitchConfirmData confirmData) {
        String item = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.GENERATING_INTERVAL);
        String value = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.BAR);
        if (confirmData.isMonSwitch()) {
            value = Integer.toString(confirmData.getInterval() / 60);
            value = value + " " + SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), SJctrOptionMonitorGuidance.MIN);
        }
        return new SJctrOptionMonitorConfirmTableInfo(item, value);
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap retMap = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrEditMonitoringSwitchConfirmData.class);
        retMap.put(SJctrEditMonitoringSwitchConfirmData.class.getName(), confirmDataList);
        return retMap;
    }
}

