/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.monitor.optmon.editmonswitch;

import java.util.ArrayList;
import java.util.Set;
import sanproject.serverux.data.MonMonitoringInfoLDKC;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.model.SJctrButtonDataModel;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorGuidance;
import sanproject.sn2.controller.wizard.monitor.optmon.com.SJctrOptionMonitorUtility;
import sanproject.sn2.controller.wizard.monitor.optmon.editmonswitch.SJctrEditMonitoringSwitchConfirmData;
import sanproject.sn2.controller.wizard.monitor.optmon.editmonswitch.SJctrEditMonitoringSwitchDataModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetMonMonitoringInfoLDKC;

public class SJctrEditMonitoringSwitchDC
extends SJctrWizardDataController {
    private static final int DISP_ID = 17827921;
    private static final String[] DISP_TITLE = SJctrOptionMonitorGuidance.EDIT_MON_SWITCH;
    private static final String KEY_MON_OPTION = "COM_MON_OPTION";

    public SJctrEditMonitoringSwitchDC() throws SJcException {
        super(17827921);
        this.initDataModel();
        this.initListener();
    }

    @Override
    public String getDispName() {
        String dispName = SJctrOptionMonitorGuidance.getMonitorGuidanceStr(this.getComUtility(), DISP_TITLE);
        return dispName;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetMonMonitoringInfoLDKC kind = new SJmoGetMonMonitoringInfoLDKC();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        return set;
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_MON_OPTION, new SJctrEditMonitoringSwitchDataModel());
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel());
    }

    private void initListener() {
        this.addMessageEventListener(EDIT_MON_SW_MSG.RADIO_CHANGED, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditMonitoringSwitchDC.this.setFinishChangeCheck(true);
            }
        });
        this.addMessageEventListener(EDIT_MON_SW_MSG.COMBO_CHANGED, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrEditMonitoringSwitchDC.this.setFinishChangeCheck(true);
            }
        });
    }

    @Override
    public boolean checkConstructData() {
        try {
            SJctrOptionMonitorUtility.getMonMonitoringInfoLDKC(this);
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107002);
        }
        return true;
    }

    @Override
    public boolean checkEndData() {
        boolean ret = true;
        try {
            SJctrEditMonitoringSwitchConfirmData confirmData = new SJctrEditMonitoringSwitchConfirmData();
            MonMonitoringInfoLDKC monInfo = SJctrOptionMonitorUtility.getMonMonitoringInfoLDKC(this);
            SJctrEditMonitoringSwitchDataModel monSwitch = (SJctrEditMonitoringSwitchDataModel)this.getDataObjectModel(KEY_MON_OPTION);
            SJctrRadioButtonGroupDataModel monSwitchRadio = (SJctrRadioButtonGroupDataModel)monSwitch.getDataModel("COM_MONITORING_SWITCH");
            SJctrComboBoxDataModel monIntervalCombo = (SJctrComboBoxDataModel)monSwitch.getDataModel("COM_INTERVAL");
            if (monSwitchRadio.isSelect("COM_ENABLE")) {
                confirmData.setMonSwitch(true);
                String intervalKey = monIntervalCombo.getSelection();
                if (null == intervalKey || intervalKey.equals("COM_INTERVAL_MIN_EMPTY")) {
                    this.logUty.putlog("checkEndData", "Empty combobox is selected.");
                    SJctrError err = new SJctrError(51, 22, 107003);
                    SJcException exp = err.createException();
                    throw exp;
                }
                int splitIndex = intervalKey.lastIndexOf("_");
                if (-1 == splitIndex) {
                    this.logUty.putlog("checkEndData", "The error occurred at the interval time getting.");
                    SJctrError err = new SJctrError(51, 22, 107003);
                    SJcException exp = err.createException();
                    throw exp;
                }
                String intervalStr = intervalKey.substring(splitIndex + 1, intervalKey.length());
                try {
                    int interval = Integer.parseInt(intervalStr) * 60;
                    confirmData.setInterval(interval);
                }
                catch (NumberFormatException ne) {
                    this.logUty.putlog("checkEndData", "The error occurred at the interval time getting. NumberFormatException : " + ne.getMessage());
                    SJctrError err = new SJctrError(51, 22, 107003);
                    SJcException exp = err.createException();
                    throw exp;
                }
                if (confirmData.getInterval() != monInfo.getInterval()) {
                    confirmData.setViewWarningMsg(1);
                } else if (!monInfo.isStatus()) {
                    confirmData.setViewWarningMsg(1);
                } else {
                    confirmData.setViewWarningMsg(0);
                }
            } else {
                confirmData.setMonSwitch(false);
                confirmData.setInterval(monInfo.getInterval());
                confirmData.setViewWarningMsg(0);
            }
            ArrayList<SJctrEditMonitoringSwitchConfirmData> confirmDataList = new ArrayList<SJctrEditMonitoringSwitchConfirmData>();
            confirmDataList.add(confirmData);
            this.putCache(SJctrEditMonitoringSwitchConfirmData.class, confirmDataList);
            this.setFinishChangeCheck(false);
        }
        catch (SJcException e) {
            throw SJctrOptionMonitorUtility.convMonitorLogicalErr(e, 107003);
        }
        return ret;
    }

    private void setFinishChangeCheck(boolean changeCheckFlg) {
        SJctrButtonDataModel finishButton;
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (null != footer && null != (finishButton = footer.getFooterButtonObject(SJctrFooterDataModel.Button.FINISH))) {
            finishButton.setChangeCheck(changeCheckFlg);
        }
    }

    public static enum EDIT_MON_SW_MSG implements SJctrNotifyState
    {
        RADIO_CHANGED,
        COMBO_CHANGED;

    }
}

