/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.com;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.column.SJctrCapacityColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoPgDetail;
import sanproject.sn2.model.data.volume.SJmoPgIndex;
import sanproject.sn2.model.data.volume.SJmoPgScatteredInfo;
import sanproject.sn2.model.data.volume.SJmoVdevDetail;

public class SJctrWarnLdevRecommendedCapFromLdevDetail
extends SJctrCapacityColumn {
    private List<SJmoPgDetail> pgDtlList = null;
    public Map<String, Long> capMap = Collections.emptyMap();

    public SJctrWarnLdevRecommendedCapFromLdevDetail(String key) {
        super(key);
        this.setPartsId("RECOMMENDED");
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        list.add(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        list.add(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> basicData) {
        List<SJmoLdevDetail> ldevDtlList;
        List<SJmoPoolVolDetail> poolVolDtlList;
        SJmoPoolDetail poolDtl;
        long vdevCap;
        ArrayList<Long> retList = new ArrayList<Long>();
        SJmoLdevDetail ldevDtl = (SJmoLdevDetail)index;
        SJmoPgIndex pgIndex = new SJmoPgIndex();
        pgIndex.setFB4(ldevDtl.getIFB4());
        pgIndex.setPG(ldevDtl.getIPG());
        String pgKey = pgIndex.toString();
        Long capacity = this.capMap.get(pgKey);
        if (capacity != null) {
            retList.add(capacity);
            return retList;
        }
        long recommendCap = vdevCap = this.getScVDEVTortalPhyLbaSize(pgIndex, basicData);
        List<?> poolDtlList = basicData.get(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL);
        if (poolDtlList != null && !poolDtlList.isEmpty() && SJctrPoolUtility.hasNF2KPGPoolVol(poolDtl = (SJmoPoolDetail)poolDtlList.get(0), poolVolDtlList = basicData.get(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL), ldevDtlList = basicData.get(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL))) {
            recommendCap = this.getRecommendCap(pgIndex, vdevCap, poolDtl, basicData);
        }
        if (this.capMap == Collections.EMPTY_MAP) {
            int rowCount = this.getTable().getRowCount();
            this.capMap = new HashMap<String, Long>(rowCount);
        }
        this.capMap.put(pgKey, recommendCap);
        retList.add(recommendCap);
        return retList;
    }

    private long getScVDEVTortalPhyLbaSize(SJmoPgIndex pgIndex, Map<Class<?>, List<?>> basicData) {
        List<SJmoVdevDetail> vdevDtlList = basicData.get(SJctrPoolUtility.KEY_CLASS_VDEV_DETAIL);
        List<SJmoPgScatteredInfo> scPGInfoList = basicData.get(SJctrPoolUtility.KEY_CLASS_PGSCATTERED_INF);
        List<SJmoVdevDetail> scVdevList = SJctrPoolUtility.getScatteredVdevDtlList(pgIndex, vdevDtlList, scPGInfoList);
        long vdevCap = 0L;
        for (SJmoVdevDetail scVdev : scVdevList) {
            vdevCap += scVdev.getLVdevPhyMaxLba();
        }
        return vdevCap;
    }

    private long getRecommendCap(SJmoPgIndex pgIndex, long vdevCap, SJmoPoolDetail poolDtl, Map<Class<?>, List<?>> basicData) {
        List<?> poolVolDtlList = basicData.get(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        List<?> ldevDtlList = basicData.get(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        int recommendExpantionRate = SJctrPoolUtility.getRecommendExpantionRate(poolDtl);
        Map pgPoolVolMap = (Map)basicData.get(SJctrPoolUtility.KEY_PG_POOLVOL).get(0);
        if (this.pgDtlList == null) {
            this.pgDtlList = new ArrayList(pgPoolVolMap.keySet());
            Collections.sort(this.pgDtlList);
        }
        int searchPg = Collections.binarySearch(this.pgDtlList, pgIndex);
        long poolVolPages = 0L;
        if (0 <= searchPg) {
            SJmoPgDetail pgDtl = this.pgDtlList.get(searchPg);
            List poolVolList = (List)pgPoolVolMap.get(pgDtl);
            for (SJmoPoolVolInfo poolVol : poolVolList) {
                poolVolPages += poolVol.getLPoolVolPages();
                if (!poolVol.isHeadPoolVol()) continue;
                poolVolPages += 100L;
            }
        }
        long recommendCap = vdevCap * (long)recommendExpantionRate / 100L;
        long poolVolLba = poolVolPages * poolDtl.getPageSize() * 2L;
        if ((recommendCap -= poolVolLba) < 0L) {
            recommendCap = 0L;
        }
        return recommendCap;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        if (dataList != null && !dataList.isEmpty()) {
            long lbaSize = (Long)dataList.get(0);
            SJctrCapacityUtility capaUtil = this.getTable().getComUtility().getCapacityUtility();
            String select = this.getUnitSelect();
            SJctrCapacityUtility.UNIT unit = SJctrCapacityUtility.UNIT.GB;
            if (select.length() > 0) {
                unit = SJctrCapacityUtility.UNIT.valueOf(select);
            }
            String strCap = capaUtil.toString(lbaSize, unit);
            StringBuilder buf = new StringBuilder();
            buf.append(strCap);
            buf.append(" ");
            buf.append(capaUtil.getUnitString(unit));
            ret = buf.toString();
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        long ret = -2L;
        SJmoLdevDetail ldevDtl = (SJmoLdevDetail)this.getPrimaryKeyObject(dat);
        SJmoPgIndex pgIndex = new SJmoPgIndex();
        pgIndex.setFB4(ldevDtl.getIFB4());
        pgIndex.setPG(ldevDtl.getIPG());
        Long pgPoolVolCap = this.capMap.get(pgIndex.toString());
        if (pgPoolVolCap != null) {
            ret = pgPoolVolCap;
        }
        return ret;
    }
}

