/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.createpools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import sanproject.serverux.dataimpl.AddPoolData3;
import sanproject.serverux.dataimpl.POOLsetAddPool3_IN;
import sanproject.serverux.dataimpl.POOLsetAddPool3_OUT;
import sanproject.serverux.dataimpl.PoolVolData;
import sanproject.serverux.dataimpl.SetTierInfo2;
import sanproject.sn2.controller.com.SJctrApplyController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.wizard.pool.com.SJctrPoolError;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolTierInfo;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrCreatePoolsAC
extends SJctrApplyController {
    public List<SJmoPoolDetail> poolDetailList;
    public List<SJmoPoolVolDetail> poolVolDetailList;
    public HashMap<String, Short> ExternalLdevPerformanceMap = new HashMap();
    public POOLsetAddPool3_IN setaddPool;
    public AddPoolData3 addPoolData;
    public PoolVolData addPoolVolData;
    private POOLsetAddPool3_OUT addRst = null;
    private int iPoolTopErr = 0;
    private int iPoolVolTopErr = 0;

    public void setApplyList(List<SJmoPoolDetail> poolDtlList, List<SJmoPoolVolDetail> poolVolDtlListl, List<HashMap<String, Short>> selExtLdevPerformanceList) {
        this.poolDetailList = poolDtlList;
        if (this.poolDetailList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setApplyList", "poolDetailList Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        this.poolVolDetailList = poolVolDtlListl;
        if (this.poolVolDetailList.size() == 0) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setApplyList", "poolVolDetailList Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if (selExtLdevPerformanceList.size() != 0) {
            this.ExternalLdevPerformanceMap = selExtLdevPerformanceList.get(0);
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setApplyList", "selExtLdevPerformanceList Error");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
    }

    @Override
    public ArrayList<?> getSetList() {
        int iCnt = 0;
        int iIndex = 0;
        SJmoPoolDetail poolDetail = null;
        SJmoPoolVolDetail poolVolDetail = null;
        ArrayList ldevDetailList = null;
        ArrayList<POOLsetAddPool3_IN> applyDataList = new ArrayList<POOLsetAddPool3_IN>();
        this.setaddPool = new POOLsetAddPool3_IN();
        AddPoolData3[] addPoolData_interface = new AddPoolData3[this.poolDetailList.size()];
        Collections.sort(this.poolDetailList);
        Collections.sort(this.poolVolDetailList);
        for (iCnt = 0; iCnt < this.poolDetailList.size(); ++iCnt) {
            this.addPoolData = new AddPoolData3();
            poolDetail = this.poolDetailList.get(iCnt);
            iIndex = Collections.binarySearch(this.poolVolDetailList, poolDetail);
            if (iIndex < 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getSetList", "poolVolDetailList notFound");
                SJctrPoolUtility.SJctrErrorDialog(107007);
            } else {
                poolVolDetail = this.poolVolDetailList.get(iIndex);
            }
            ldevDetailList = poolVolDetail.getAlPoolInfo();
            if (ldevDetailList == null || ldevDetailList.size() == 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "getSetList", "ldevDetailList Error");
                SJctrPoolUtility.SJctrErrorDialog(107007);
            }
            PoolVolData[] poolVolData_interface = new PoolVolData[ldevDetailList.size()];
            this.setPoolId_AddPool(poolDetail);
            this.setPoolThreshold(poolDetail);
            this.setPoolFixThreshold(poolDetail);
            this.setPoolDepletionThreshold(poolDetail);
            this.setPoolThresholdMode(poolDetail);
            this.setPoolGrainSize(poolDetail);
            this.setPoolKind(poolDetail);
            this.setPoolSubscription(poolDetail);
            this.setPoolVol(ldevDetailList, poolVolData_interface);
            this.setTierControlInfo(poolDetail);
            this.setMonMode(poolDetail);
            this.setRelocationSpeed(poolDetail);
            this.setExecutionInterval(poolDetail);
            this.setMonitoringPeriod(poolDetail);
            this.addPoolData.setObjSetTierInfo(this.setTierInfo(poolDetail.getAlTierInfo()));
            this.setPoolOption(poolDetail);
            this.addPoolData.setObjPoolVolData(poolVolData_interface);
            addPoolData_interface[iCnt] = this.addPoolData;
        }
        this.setaddPool.setObjPoolData(addPoolData_interface);
        applyDataList.add(this.setaddPool);
        return applyDataList;
    }

    private void setPoolId_AddPool(SJmoPoolDetail poolDetail) {
        short sPoolId = 0;
        sPoolId = (short)poolDetail.getPoolId();
        this.addPoolData.setSPoolId(sPoolId);
    }

    private void setPoolThreshold(SJmoPoolDetail poolDetail) {
        short sThreshold = 0;
        sThreshold = poolDetail.getPoolThreshold();
        this.addPoolData.setSPoolThreshold(sThreshold);
    }

    private void setPoolFixThreshold(SJmoPoolDetail poolDetail) {
        this.addPoolData.setSPoolFixThreshold((short)0);
    }

    private void setPoolGrainSize(SJmoPoolDetail poolDetail) {
        this.addPoolData.setSPoolGrainSize((short)0);
    }

    private void setPoolKind(SJmoPoolDetail poolDetail) {
        byte byPoolKind = 0;
        byPoolKind = poolDetail.getPoolKind();
        this.addPoolData.setByPoolKind(byPoolKind);
    }

    private void setPoolSubscription(SJmoPoolDetail poolDetail) {
        int iSubscription = 0;
        iSubscription = poolDetail.getMaxSubscription();
        this.addPoolData.setIMaxSubscription(iSubscription);
    }

    private void setPoolVol(List<SJmoLdevDetail> ldevDetailList, PoolVolData[] poolVolData_interface) {
        SJmoLdevDetail ldevDetail = null;
        short sLdkc = 0;
        short sCu = 0;
        short sLdev = 0;
        int iCnt = 0;
        for (iCnt = 0; iCnt < ldevDetailList.size(); ++iCnt) {
            this.addPoolVolData = new PoolVolData();
            ldevDetail = ldevDetailList.get(iCnt);
            sLdkc = ldevDetail.getSLdkc();
            sCu = ldevDetail.getSCu();
            sLdev = ldevDetail.getSLdev();
            this.addPoolVolData.setSLDKC(sLdkc);
            this.addPoolVolData.setSCU(sCu);
            this.addPoolVolData.setSLDEV(sLdev);
            if (ldevDetail.getByVolumeType() == 1) {
                if (this.ExternalLdevPerformanceMap.containsKey(ldevDetail.getIndexKey())) {
                    this.addPoolVolData.setSExtLDEVAttribute(this.ExternalLdevPerformanceMap.get(ldevDetail.getIndexKey()));
                } else {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "setPoolVol", "ExternalLdevPerformanceMap Error");
                    SJctrPoolUtility.SJctrErrorDialog(107007);
                }
            } else {
                this.addPoolVolData.setSExtLDEVAttribute((short)0);
            }
            poolVolData_interface[iCnt] = this.addPoolVolData;
        }
    }

    @Override
    public int getLeadTime() {
        int iLeadTime = 0;
        int iAllPoolVolNum = 0;
        double dAllPoolCapa = 0.0;
        for (int iCnt = 0; iCnt < this.poolDetailList.size(); ++iCnt) {
            SJmoPoolDetail poolDtl = this.poolDetailList.get(iCnt);
            int iPoolVolNum = poolDtl.getPoolVolNum();
            iAllPoolVolNum += iPoolVolNum;
            long lPoolCapa = poolDtl.getPageSize() * poolDtl.getPoolPages();
            double dPoolCapa = lPoolCapa / 0x100000L;
            dAllPoolCapa += dPoolCapa;
        }
        int iDefaultPoolName = 45 + this.poolDetailList.size() * 2;
        iLeadTime = (int)(30.0 + ((double)(15 * (this.poolDetailList.size() / 24) + this.poolDetailList.size() * 2) + (double)iAllPoolVolNum * 0.2 + dAllPoolCapa / 20.0 * 0.2 + (double)iDefaultPoolName + 3.0));
        return iLeadTime;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        ArrayList<Object> rstList = null;
        if (null == resultObject) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setApplyResult", "The parameter is illegal.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if (resultObject instanceof List) {
            rstList = (ArrayList<Object>)resultObject;
        } else {
            rstList = new ArrayList<Object>();
            rstList.add(resultObject);
        }
        for (int iCnt = 0; iCnt < rstList.size(); ++iCnt) {
            if (null != rstList.get(iCnt) && rstList.get(iCnt) instanceof POOLsetAddPool3_OUT) {
                this.addRst = (POOLsetAddPool3_OUT)rstList.get(iCnt);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "setApplyResult", "The element in the list is illegal.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
    }

    @Override
    protected List<List<SJctrError>> getResultDataEx() {
        ArrayList<List<SJctrError>> addErrList = new ArrayList<List<SJctrError>>();
        ArrayList<SJctrPoolError> poolErrList = new ArrayList<SJctrPoolError>();
        int iTopErrCode = 0;
        if (null == this.addRst || null == this.addRst.getObjPoolData() || this.addRst.getObjPoolData().length == 0 || this.addRst.getObjPoolData().length != this.poolDetailList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getResultDataEx", "The ApplyResult is illegal.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        for (int iCnt = 0; iCnt < this.poolDetailList.size(); ++iCnt) {
            SJctrPoolError addPoolError = this.getAddPoolError(iCnt, this.poolDetailList.get(iCnt).getPoolId());
            if (null == addPoolError) continue;
            poolErrList.add(addPoolError);
        }
        addErrList.add(poolErrList);
        if (this.iPoolTopErr == 0 && this.iPoolVolTopErr == 0) {
            super.setApplyResult(addErrList);
        } else {
            iTopErrCode = this.iPoolTopErr != 0 ? this.iPoolTopErr : this.iPoolVolTopErr;
            SJctrError topErr = new SJctrError(31, 22, iTopErrCode);
            this.setError(topErr);
        }
        return addErrList;
    }

    @Override
    public boolean hasApplyResult() {
        return true;
    }

    private SJctrPoolError getAddPoolError(int iCnt, int iKeyData) {
        SJctrPoolError poolIndexErr = null;
        AddPoolData3[] poolErrInf = this.addRst.getObjPoolData();
        if (null == poolErrInf || null == poolErrInf[iCnt] || poolErrInf[iCnt].getSPoolId() != iKeyData) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getAddPoolError", "The parameter is illegal.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        if (poolErrInf[iCnt].getLErrorCode() != 0L) {
            if (this.iPoolTopErr == 0) {
                this.iPoolTopErr = 106061;
            }
            poolIndexErr = new SJctrPoolError(30, 5, (int)poolErrInf[iCnt].getLErrorCode());
            SJmoPoolIndex poolIdx = new SJmoPoolIndex();
            poolIdx.setPoolId(poolErrInf[iCnt].getSPoolId());
            poolIndexErr.setkeyData(poolIdx);
            poolIndexErr.setStrAssignTableKey("COM_TABLE");
            List<SJctrError> childErrList = this.getAddPoolVolError((PoolVolData[])poolErrInf[iCnt].getObjPoolVolData());
            poolIndexErr.setChildErrList(childErrList);
        }
        return poolIndexErr;
    }

    private List<SJctrError> getAddPoolVolError(PoolVolData[] poolVolErr) {
        ArrayList<SJctrError> poolVolErrList = new ArrayList<SJctrError>();
        for (int iCnt = 0; iCnt < poolVolErr.length; ++iCnt) {
            if (null != poolVolErr[iCnt]) {
                if (poolVolErr[iCnt].getLErrorCode() == 0L) continue;
                if (this.iPoolVolTopErr == 0) {
                    this.iPoolVolTopErr = 106061;
                }
                SJctrPoolError ldevIndexErr = new SJctrPoolError(30, 5, (int)poolVolErr[iCnt].getLErrorCode());
                SJmoLdevIndex ldIdx = new SJmoLdevIndex();
                ldIdx.setLdevIndex(poolVolErr[iCnt].getSLDKC(), poolVolErr[iCnt].getSCU(), poolVolErr[iCnt].getSLDEV());
                ldevIndexErr.setkeyData(ldIdx);
                ldevIndexErr.setStrAssignTableKey("COM_TABLE_POOLVOLUMES");
                poolVolErrList.add(ldevIndexErr);
                continue;
            }
            SJctrLogUty.warn(this.getClass().getSimpleName(), "getAddPoolVolError", "The array element is null.");
            SJctrPoolUtility.SJctrErrorDialog(107007);
        }
        return poolVolErrList;
    }

    private void setTierControlInfo(SJmoPoolDetail poolDetail) {
        short sTierControlInfo = 0;
        sTierControlInfo = (short)poolDetail.getITierControlInfo();
        this.addPoolData.setSTierControlInfo(sTierControlInfo);
    }

    private void setExecutionInterval(SJmoPoolDetail poolDetail) {
        short sExecutionInterval = 0;
        sExecutionInterval = (short)poolDetail.getIExecutionCycle();
        this.addPoolData.setSExecutionCycle(sExecutionInterval);
    }

    private void setMonitoringPeriod(SJmoPoolDetail poolDetail) {
        byte byMonStartPeriodHour = 0;
        byte byMonStartPeriodMin = 0;
        byte byMonEndPeriodHour = 0;
        byte byMonEndPeriodMin = 0;
        byMonStartPeriodHour = poolDetail.getByMonStartPeriodHour();
        byMonStartPeriodMin = poolDetail.getByMonStartPeriodMin();
        byMonEndPeriodHour = poolDetail.getByMonEndPeriodHour();
        byMonEndPeriodMin = poolDetail.getByMonEndPeriodMin();
        this.addPoolData.setByMonitorStartPeriodHour(byMonStartPeriodHour);
        this.addPoolData.setByMonitorStartPeriodMinute(byMonStartPeriodMin);
        this.addPoolData.setByMonitorEndPeriodHour(byMonEndPeriodHour);
        this.addPoolData.setByMonitorEndPeriodMinute(byMonEndPeriodMin);
    }

    private void setPoolDepletionThreshold(SJmoPoolDetail poolDetail) {
        short sThresholdMode;
        short sDepThreshold = 0;
        byte bPoolKind = poolDetail.getPoolKind();
        sDepThreshold = bPoolKind == 2 ? ((sThresholdMode = poolDetail.getSPoolThresholdMode()) == SJctrPoolUtility.THRESHOLD_MODE_DEPLETION_ON ? poolDetail.getSPoolDepletionThreshold() : (short)0) : (short)0;
        this.addPoolData.setSPoolDepletionThreshold(sDepThreshold);
    }

    private void setPoolThresholdMode(SJmoPoolDetail poolDetail) {
        short sThresholdMode = poolDetail.getSPoolThresholdMode();
        this.addPoolData.setSPoolThresholdMode(sThresholdMode);
    }

    private void setMonMode(SJmoPoolDetail poolDetail) {
        if ((poolDetail.getITierControlInfo() & 0x80) != 0) {
            this.addPoolData.setITierRelocatePolicy(poolDetail.getITierRelocatePolicy());
        }
    }

    private void setRelocationSpeed(SJmoPoolDetail poolDetail) {
        if ((poolDetail.getITierControlInfo() & 0x80) != 0) {
            this.addPoolData.setByRelocationSpeed(poolDetail.getByRelocationSpeed());
        }
    }

    public POOLsetAddPool3_OUT getApplyResultData() {
        return this.addRst;
    }

    private SetTierInfo2[] setTierInfo(List<SJmoPoolTierInfo> poolTierInfoList) {
        Collections.sort(poolTierInfoList);
        SetTierInfo2[] rmiTierInfList = new SetTierInfo2[poolTierInfoList.size()];
        for (int iCnt = 0; iCnt < poolTierInfoList.size(); ++iCnt) {
            SetTierInfo2 setTierInfo2 = new SetTierInfo2();
            SJmoPoolTierInfo tierInfoData = poolTierInfoList.get(iCnt);
            short sTierType = 48;
            setTierInfo2.setSEditTierInfoType(sTierType);
            setTierInfo2.setSTierAlocateCapa(tierInfoData.getSTierAlocateCapa());
            setTierInfo2.setSTierRelocateCapa(tierInfoData.getSTierRelocateCapa());
            rmiTierInfList[iCnt] = setTierInfo2;
        }
        return rmiTierInfList;
    }

    private void setPoolOption(SJmoPoolDetail poolDetail) {
        long lPoolOption = 0L;
        lPoolOption = poolDetail.getLPoolOptionFlag();
        this.addPoolData.setLPoolOptionFlag(lPoolOption);
    }
}

