/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.deletepools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.com.utility.account.SJcRoleResourceContainer;
import sanproject.sn2.controller.com.SJctrActionDefine;
import sanproject.sn2.controller.com.SJctrAuthorizeContainer;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorDataController;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrNotifyState;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.data.SJctrRelatedDispDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.cvs.com.SJctrCVSUtility;
import sanproject.sn2.controller.wizard.pool.com.SJctrPoolTaskVersion;
import sanproject.sn2.controller.wizard.pool.deletepools.SJctrDeletePoolsEventDetail;
import sanproject.sn2.controller.wizard.pool.deletepools.SJctrDeletePoolsTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.data.group.SJmoHDPRelation;
import sanproject.sn2.model.data.group.SJmoHDPRelationByPool;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolVolDetail;
import sanproject.sn2.model.data.group.SJmoPoolVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public class SJctrDeletePoolsDC
extends SJctrWizardDataController {
    public static final int DISP_ID = 0x1100191;
    public static final String KEY_TABLE = "COM_TABLE";
    public static final String KEY_FOOTER = "COM_FOOTER";
    public static final String KEY_CLASS_POOL_INDEX = "KEY_CLASS_POOL_INDEX";
    private List<SJmoPoolDetail> m_SelPoolList = null;
    private SJctrDeletePoolsTableModel m_Table = new SJctrDeletePoolsTableModel();
    private SJctrFooterDataModel m_Footer = new SJctrFooterDataModel();

    public SJctrDeletePoolsDC() {
        super(0x1100191);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.addDataObjectModel(KEY_TABLE, this.m_Table);
        this.addDataObjectModel(KEY_FOOTER, this.m_Footer);
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        boolean bNextBtn = false;
        SJctrAuthorizeContainer authCtnr = this.getOwner().getAuthorizeContainer();
        SJcRoleResourceContainer roleRscCntr = authCtnr.getRoleResourceContainer();
        bNextBtn = roleRscCntr.checkAuthority(52);
        this.m_Footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, bNextBtn);
    }

    private void initListener() {
        SJctrDeletePoolsEventDetail dpEvtDtl = new SJctrDeletePoolsEventDetail(this);
        this.addMessageEventListener(SELECT_DP_MSG.DETAIL, dpEvtDtl);
    }

    @Override
    public String getDispName() {
        return this.getComUtility().getGuidance("DELETE_PL");
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> retSet = super.getModelDirect();
        SJctrGetDirectWrapper getDrctWrpPoolVolDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL);
        retSet.add(getDrctWrpPoolVolDtl);
        SJctrGetDirectWrapper getDrctWrpLdevDetl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL);
        retSet.add(getDrctWrpLdevDetl);
        SJctrGetDirectWrapper getDrctWrpDpRelPool = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL);
        retSet.add(getDrctWrpDpRelPool);
        SJctrGetDirectWrapper getDrctWrpLdevNmaeInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LDEVNAME_INFO);
        retSet.add(getDrctWrpLdevNmaeInf);
        SJctrGetDirectWrapper getDrctWrpLdevLuseInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_LUSE_INFO);
        retSet.add(getDrctWrpLdevLuseInf);
        SJctrGetDirectWrapper getDrctWrpClprInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_CLPR_INFO);
        retSet.add(getDrctWrpClprInf);
        SJctrGetDirectWrapper getDrctWrpPdevDtl = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_PDEV_DETAIL);
        retSet.add(getDrctWrpPdevDtl);
        SJctrGetDirectWrapper getDrctWrpPoolClprInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOL_CLPR_INFO);
        retSet.add(getDrctWrpPoolClprInf);
        SJctrGetDirectWrapper getDrctWrpPoolNameInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_POOLNAME_INFO);
        retSet.add(getDrctWrpPoolNameInf);
        SJctrGetDirectWrapper getDrctWrpRsgInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_ALL_RSG);
        retSet.add(getDrctWrpRsgInf);
        SJctrGetDirectWrapper getDrctWrpHuvmDkcInf = this.createModelDirect(SJctrPoolUtility.KEY_DETAIL_HUVMDKCCLASS);
        retSet.add(getDrctWrpHuvmDkcInf);
        SJctrGetDirectWrapper getDrctWrpHuvmLdevInf = this.createModelDirect(SJctrPoolUtility.KEY_DETAIL_HUVMLDEVCLASS);
        retSet.add(getDrctWrpHuvmLdevInf);
        SJctrGetDirectWrapper getDrctWrpSsidInf = this.createModelDirect(SJctrPoolUtility.KEY_DETAIL_SSIDCLASS);
        retSet.add(getDrctWrpSsidInf);
        SJctrGetDirectWrapper getDrctWrpTiPairPVolInf = this.createModelDirect(SJctrPoolUtility.KEY_CLASS_TIPAIR_PVOL_STATUS);
        retSet.add(getDrctWrpTiPairPVolInf);
        return retSet;
    }

    private SJctrGetDirectWrapper createModelDirect(Class<? extends SJmoGetKind_IF> kindClass) throws SJcException {
        SJctrGetDirectWrapper getDrctWrap = null;
        try {
            SJmoGetKind_IF kind = kindClass.newInstance();
            SJmoGetRange_IF range = null;
            ArrayList search = new ArrayList();
            SJmoGetDirect getDrct = new SJmoGetDirect(kind, range, search);
            getDrctWrap = new SJctrGetDirectWrapper(getDrct);
        }
        catch (InstantiationException insExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch InstantiationException", insExp);
            SJctrError ctrErr = new SJctrError(31, 22, 107009);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        catch (IllegalAccessException illExp) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "createModelDirect", "catch IllegalAccessException", illExp);
            SJctrError ctrErr = new SJctrError(31, 22, 107009);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        return getDrctWrap;
    }

    @Override
    public boolean checkStartData() {
        boolean bRetChk = true;
        ArrayList selPoolList = new ArrayList(this.getCache(KEY_CLASS_POOL_INDEX));
        if (null == selPoolList || 0 == selPoolList.size()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkStartData", "Select Pool is null or size 0");
            bRetChk = false;
            SJctrError ctrErr = new SJctrError(31, 22, 107008);
            SJcException ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        this.m_SelPoolList = selPoolList;
        return bRetChk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkConstructData() {
        boolean bRetChk = true;
        SJctrPoolTaskVersion poolTaskVersionInfo = new SJctrPoolTaskVersion(1);
        ArrayList<SJctrPoolTaskVersion> versionList = new ArrayList<SJctrPoolTaskVersion>();
        versionList.add(poolTaskVersionInfo);
        this.putCache(SJctrPoolUtility.KEY_CLASS_POOL_TASK_VERSION.getName(), versionList);
        ArrayList<SJmoPoolDetail> delPoolDtlList = new ArrayList<SJmoPoolDetail>();
        ArrayList<SJmoHDPRelationByPool> delDPRelPoolList = new ArrayList<SJmoHDPRelationByPool>();
        ArrayList<SJctrErrorColumnData> errList = new ArrayList<SJctrErrorColumnData>();
        SJcException ctrExp = null;
        ArrayList poolDtlLst = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL));
        ArrayList dpRelPoolLst = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL));
        if (null != poolDtlLst && 0 != poolDtlLst.size() && null != dpRelPoolLst && 0 != dpRelPoolLst.size()) {
            Collections.sort(poolDtlLst);
            Collections.sort(dpRelPoolLst);
        } else {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "PoolDetail or HDPRelationbyPool is null or size 0");
            bRetChk = false;
            SJctrError ctrErr = new SJctrError(31, 22, 107007);
            ctrExp = ctrErr.createException();
            throw ctrExp;
        }
        for (int iSelPoolCnt = 0; iSelPoolCnt < this.m_SelPoolList.size(); ++iSelPoolCnt) {
            SJmoPoolDetail selPoolDtl = this.m_SelPoolList.get(iSelPoolCnt);
            int iPoolDtlIdx = Collections.binarySearch(poolDtlLst, selPoolDtl);
            int iDPRelPoolIdx = Collections.binarySearch(dpRelPoolLst, selPoolDtl);
            if (0 <= iPoolDtlIdx && 0 <= iDPRelPoolIdx) {
                try {
                    SJmoPoolDetail delPoolDtl = (SJmoPoolDetail)((SJmoPoolDetail)poolDtlLst.get(iPoolDtlIdx)).clone();
                    delPoolDtlList.add(delPoolDtl);
                    SJmoHDPRelationByPool delDPRelPool = (SJmoHDPRelationByPool)((SJmoHDPRelationByPool)dpRelPoolLst.get(iDPRelPoolIdx)).clone();
                    delDPRelPoolList.add(delDPRelPool);
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "Object.clone() is failed");
                    bRetChk = false;
                    SJctrError ctrErr = new SJctrError(31, 22, 107007);
                    ctrExp = ctrErr.createException();
                    throw ctrExp;
                }
            }
            bRetChk = false;
            SJmoPoolIndex poolIdx = new SJmoPoolIndex();
            poolIdx.setPoolId(selPoolDtl.getPoolId());
            SJctrPoolUtility.makeErrList(errList, poolIdx, 31, 22, 107023);
        }
        if (!bRetChk) {
            this.checkDeletePools(delPoolDtlList, delDPRelPoolList, errList);
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "checkDeletePools is Error");
            ctrExp = this.makeErrInfTableDP(errList);
            throw ctrExp;
        }
        bRetChk = this.checkDeletePools(delPoolDtlList, delDPRelPoolList, errList);
        if (bRetChk) {
            this.putCache(SJctrPoolUtility.KEY_CLASS_POOL_DETAIL, delPoolDtlList);
            this.putCache(SJctrPoolUtility.KEY_CLASS_HDP_RELATION_BY_POOL, delDPRelPoolList);
            return bRetChk;
        }
        SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "checkDeletePools is Error");
        ctrExp = this.makeErrInfTableDP(errList);
        throw ctrExp;
    }

    private boolean checkDeletePools(List<SJmoPoolDetail> poolDetailList, List<SJmoHDPRelationByPool> dpRelationPoolList, List<SJctrErrorColumnData> errList) {
        SJmoPoolIndex poolIdx;
        int iPoolID;
        SJmoHDPRelationByPool dpRelPool;
        SJmoPoolDetail poolDtl;
        boolean bRet = true;
        int iListCnt = 0;
        for (iListCnt = 0; iListCnt < poolDetailList.size(); ++iListCnt) {
            List<SJmoTiPvolStatus> tiPVolStatusList;
            SJctrPoolUtility poolUtil;
            poolDtl = poolDetailList.get(iListCnt);
            dpRelPool = dpRelationPoolList.get(iListCnt);
            if (!this.chkPoolRelation(dpRelPool)) {
                bRet = false;
                iPoolID = poolDtl.getPoolId();
                poolIdx = new SJmoPoolIndex();
                poolIdx.setPoolId(iPoolID);
                SJctrPoolUtility.makeErrList(errList, poolIdx, 31, 22, 106030);
                poolDetailList.remove(iListCnt);
                dpRelationPoolList.remove(iListCnt);
                --iListCnt;
                continue;
            }
            if (poolDtl.getPoolKind() != 2 || !(poolUtil = this.getComUtility().getPoolUtility()).checkTIPairExistsInPool(poolDtl, tiPVolStatusList = this.getCache(SJctrPoolUtility.KEY_CLASS_TIPAIR_PVOL_STATUS))) continue;
            bRet = false;
            int iPoolID2 = poolDtl.getPoolId();
            SJmoPoolIndex poolIdx2 = new SJmoPoolIndex();
            poolIdx2.setPoolId(iPoolID2);
            SJctrPoolUtility.makeErrList(errList, poolIdx2, 31, 22, 206330);
            poolDetailList.remove(iListCnt);
            dpRelationPoolList.remove(iListCnt);
            --iListCnt;
        }
        for (iListCnt = 0; iListCnt < poolDetailList.size(); ++iListCnt) {
            poolDtl = poolDetailList.get(iListCnt);
            if (0L == poolDtl.getPoolUsed() || this.chkPoolRelation(dpRelPool = dpRelationPoolList.get(iListCnt)) && poolDtl.getPoolUsedPages() - this.getAllFptUsedCap(dpRelPool) <= 0L) continue;
            bRet = false;
            iPoolID = poolDtl.getPoolId();
            poolIdx = new SJmoPoolIndex();
            poolIdx.setPoolId(iPoolID);
            SJctrPoolUtility.makeErrList(errList, poolIdx, 31, 22, 106031);
            poolDetailList.remove(iListCnt);
            dpRelationPoolList.remove(iListCnt);
            --iListCnt;
        }
        return bRet;
    }

    private long getAllFptUsedCap(SJmoHDPRelationByPool dpRelPool) {
        long rtn = 0L;
        ArrayList ldevDetailList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        Collections.sort(ldevDetailList);
        for (int i = 0; i < dpRelPool.getAlDPVOLInfo().size(); ++i) {
            SJmoLdevDetail ldev;
            SJmoHDPRelation ldevIndex = (SJmoHDPRelation)dpRelPool.getAlDPVOLInfo().get(i);
            int iIndex = Collections.binarySearch(ldevDetailList, ldevIndex);
            if (iIndex < 0 || !(ldev = (SJmoLdevDetail)ldevDetailList.get(iIndex)).getBFPTVol()) continue;
            rtn += ldevIndex.getLUsedpage();
        }
        return rtn;
    }

    private boolean chkPoolRelation(SJmoHDPRelationByPool dpRelPool) {
        ArrayList ldevDetailList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
        Collections.sort(ldevDetailList);
        boolean rtn = true;
        for (int i = 0; i < dpRelPool.getAlDPVOLInfo().size(); ++i) {
            SJmoLdevDetail ldev;
            SJmoHDPRelation ldevIndex = (SJmoHDPRelation)dpRelPool.getAlDPVOLInfo().get(i);
            int iIndex = Collections.binarySearch(ldevDetailList, ldevIndex);
            if (iIndex < 0 || (ldev = (SJmoLdevDetail)ldevDetailList.get(iIndex)).getBFPTVol()) continue;
            rtn = false;
        }
        return rtn;
    }

    private SJcException makeErrInfTableDP(List<SJctrErrorColumnData> errList) {
        SJctrRelatedDispDataObject relDisp = this.createDialog(SJctrErrorDataController.class, null);
        SJctrUserController userCtr = this.getOwner();
        SJctrDataController beginDC = this.getWizardWindow().getParentDC();
        SJcException ctrExp = SJctrPoolUtility.makeErrInfTable(relDisp, userCtr, beginDC, errList);
        return ctrExp;
    }

    public void addUpdateDispFromDP(SJctrRelatedDispDataObject related) {
        this.addUpdateDisp(related);
    }

    @Override
    public void selectNextTask(SJctrActionDefine actDefine) {
        ArrayList<Object> selPoolDetailList = null;
        SJmoPoolDetail poolDetail = null;
        ArrayList poolVolDetailList = null;
        SJmoPoolVolDetail poolVolDetail = null;
        ArrayList poolVolInfoList = new ArrayList();
        SJmoPoolVolInfo poolVolInfo = null;
        ArrayList ldevDetailList = null;
        SJmoLdevDetail ldevDetail = null;
        ArrayList<SJmoLdevDetail> transDataList = new ArrayList<SJmoLdevDetail>();
        ArrayList<Integer> dispIDList = new ArrayList<Integer>();
        int iIndex = 0;
        int iCnt = 0;
        if (actDefine == SJctrActionDefine.ACT_SHREDLDEV) {
            this.logUty.putlog("selectNextTask", "Delete Pools -> Shred Ldevs");
            selPoolDetailList = new ArrayList<Object>(this.m_Table.getAllRowData());
            Collections.sort(selPoolDetailList);
            poolVolDetailList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_POOLVOL_DETAIL));
            Collections.sort(poolVolDetailList);
            ldevDetailList = new ArrayList(this.getCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL));
            Collections.sort(ldevDetailList);
            HashMap<SJmoPoolVolInfo, SJmoPoolDetail> ldevPoolMap = new HashMap<SJmoPoolVolInfo, SJmoPoolDetail>(selPoolDetailList.size() * 1024);
            for (iCnt = 0; iCnt < selPoolDetailList.size(); ++iCnt) {
                poolDetail = (SJmoPoolDetail)selPoolDetailList.get(iCnt);
                iIndex = Collections.binarySearch(poolVolDetailList, poolDetail);
                if (iIndex < 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "selectNextTask", "poolVolDetailList notFound");
                    SJctrPoolUtility.SJctrErrorDialog(107007);
                }
                poolVolDetail = (SJmoPoolVolDetail)poolVolDetailList.get(iIndex);
                ArrayList poolVolList = new ArrayList(poolVolDetail.getAlPoolInfo());
                for (SJmoPoolVolInfo poolVol : poolVolList) {
                    ldevPoolMap.put(poolVol, poolDetail);
                }
                poolVolInfoList.addAll(poolVolList);
            }
            ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(poolVolInfoList.size());
            HashSet<Integer> poolIdSet = new HashSet<Integer>(poolVolInfoList.size());
            for (iCnt = 0; iCnt < poolVolInfoList.size(); ++iCnt) {
                poolVolInfo = (SJmoPoolVolInfo)poolVolInfoList.get(iCnt);
                iIndex = Collections.binarySearch(ldevDetailList, poolVolInfo);
                if (iIndex < 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "selectNextTask", "ldevDetailList notFound");
                    SJctrPoolUtility.SJctrErrorDialog(107007);
                }
                try {
                    ldevDetail = (SJmoLdevDetail)((SJmoLdevDetail)ldevDetailList.get(iIndex)).clone();
                }
                catch (CloneNotSupportedException e) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "selectNextTask", "LdevDetail cloneError");
                    SJctrPoolUtility.SJctrErrorDialog(107007);
                }
                if (ldevDetail.getBVirtSupport() && ldevDetail.getBVirtMode()) {
                    SJmoPoolIndex poolIndex = (SJmoPoolIndex)ldevPoolMap.get(poolVolInfo);
                    int poolId = poolIndex.getPoolId();
                    if (!poolIdSet.add(poolId)) continue;
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "selectNextTask", "Contains VirtMode Enable POOLVOL. POOL ID : " + poolId);
                    SJctrError err = new SJctrError(31, 22, 205212);
                    SJctrErrorColumnData errColumn = new SJctrErrorColumnData(poolIndex, err);
                    errColumnList.add(errColumn);
                    continue;
                }
                ldevDetail.setbPoolVol(false);
                transDataList.add(ldevDetail);
            }
            if (!errColumnList.isEmpty()) {
                SJctrRelatedDispDataObject rel = this.createDialog(SJctrErrorDataController.class, null);
                SJctrErrorDataController errDc = (SJctrErrorDataController)this.getOwner().getDataController(rel);
                errDc.setParameter(this.m_Table, errColumnList);
                SJctrError errInfo = errDc.getRepresentativeError(errColumnList, 7);
                SJcException exp = errInfo.createException();
                exp.setErrDisp(rel);
                throw exp;
            }
            if (transDataList.size() == 0) {
                SJctrLogUty.warn(this.getClass().getSimpleName(), "selectNextTask", "LdevDetail size0");
                SJctrPoolUtility.SJctrErrorDialog(106041);
            }
            Collections.sort(transDataList);
            this.putCache("KEY_SELECT_LDEV_INDEX", transDataList);
            this.putCache(SJctrPoolUtility.KEY_CLASS_LDEV_DETAIL, transDataList);
            dispIDList.add(0x1100191);
            this.putCache("KEY_SHRED_TASKCOMBINATION", dispIDList);
        }
    }

    @Override
    protected boolean preNextEvent(final SJctrMessageEvent msgEvent, final SJctrDataObjectModel<?> dstModel) {
        boolean simStatusFlg = SJctrCVSUtility.checkSubSystemStatus();
        if (!simStatusFlg) {
            SJctrItemSelectListener listner = new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    SJctrDeletePoolsDC.this.nextEvent(msgEvent, dstModel);
                }
            };
            SJctrRelatedDispDataObject related = SJctrCVSUtility.createOkCancelMsgDialog(205422, listner, this);
            this.addUpdateDisp(related);
            return false;
        }
        return super.preNextEvent(msgEvent, dstModel);
    }

    public static enum SELECT_DP_MSG implements SJctrNotifyState
    {
        DETAIL;

    }
}

