/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.pool.editpools;

import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrCapacityUtility;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPoolUtility;
import sanproject.sn2.controller.com.model.SJctrCheckBoxDataModel;
import sanproject.sn2.controller.com.model.SJctrRadioButtonGroupDataModel;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.wizard.cvs.createldevs.hdp.com.SJctrPoolDetail;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsDC;
import sanproject.sn2.controller.wizard.pool.editpools.SJctrEditPoolsDataDirectMapping;
import sanproject.sn2.model.data.group.SJmoPoolDetail;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;

public class SJctrEditPoolsTiPairSuspendArea
extends SJctrSimpleDataModel {
    public static final String KEY_RADIO_BUTTON = "COM_RADIO_BUTTON";
    SJctrRadioButtonGroupDataModel button = new SJctrRadioButtonGroupDataModel();
    SJctrCheckBoxDataModel checkBox = new SJctrCheckBoxDataModel();
    private SJctrEditPoolsDC edPDC = null;
    private static String KEY_DUMMY = "COM_DUMMY";
    public static final int STS_DATA = 0;
    public static final int STS_ENABLEPOOL_ON = 1;
    public static final int STS_DISABLEPOOL_ON = 2;
    public static final int STS_ALLDISABLE = 3;
    boolean bTiPairChkFlg = false;
    private int iSts = 0;
    boolean bDmMapDefault = true;
    boolean bMultiTierRadioDefault = true;
    private SJctrEditPoolsDataDirectMapping dmMapDefault = null;
    private SJctrRadioButtonGroupDataModel multiTierRadioDefault = null;

    public SJctrEditPoolsTiPairSuspendArea() {
        this.initDataModel();
    }

    protected void initDataModel() {
        this.addDataModel("COM_CHECKBOX", this.checkBox);
        this.button.add("COM_YES");
        this.button.add("COM_NO");
        this.addDataModel(KEY_RADIO_BUTTON, this.button);
    }

    public boolean getSelCheckBox() {
        return this.checkBox.isSelect();
    }

    public String getSelection() {
        return this.button.getSelect();
    }

    public boolean isSelectEnable() {
        boolean bRet = false;
        String selection = this.button.getSelect();
        if (selection != null && selection.length() != 0) {
            bRet = selection.equals("COM_YES");
        }
        return bRet;
    }

    public boolean chkMfPool(SJmoPoolDetail poolDetail) {
        boolean isMfPool = false;
        if (poolDetail.getPoolKind() == 2 && poolDetail.getEmulationType() == 1) {
            isMfPool = true;
        }
        return isMfPool;
    }

    public boolean chkTiPair(SJmoPoolDetail poolDetail) {
        boolean isTiPair = false;
        SJctrPoolUtility poolUtil = this.getComUtility().getPoolUtility();
        this.edPDC = (SJctrEditPoolsDC)this.getDataController();
        List<SJmoTiPvolStatus> tiPVolStatusList = this.edPDC.getCache(SJctrPoolUtility.KEY_CLASS_TIPAIR_PVOL_STATUS);
        isTiPair = poolUtil.checkTIPairExistsInPool(poolDetail, tiPVolStatusList);
        return isTiPair;
    }

    public boolean chkSubscripitionLimit() {
        List<Object> poolDetailList = new ArrayList();
        boolean isSubscripitionLimit = false;
        this.edPDC = (SJctrEditPoolsDC)this.getDataController();
        poolDetailList = this.edPDC.getCache("KEY_CLASS_EDIT_DATA");
        for (int iCnt = 0; iCnt < poolDetailList.size(); ++iCnt) {
            long wkRemainingLba;
            SJmoPoolDetail pool = (SJmoPoolDetail)poolDetailList.get(iCnt);
            SJctrPoolDetail poolDetail = new SJctrPoolDetail();
            poolDetail.setData(pool);
            if (poolDetail.getMaxSubscription() == 65535 || (wkRemainingLba = poolDetail.getRemainingTotalLBA(1)) > 0L) continue;
            isSubscripitionLimit = true;
            break;
        }
        return isSubscripitionLimit;
    }

    public long getLBlocks(SJmoPoolDetail poolDetail, long pages) {
        int iEmulation = 0;
        long lPoolPageSize = 0L;
        long lCapa = 0L;
        long lBlocks = 0L;
        SJctrCapacityUtility.UNIT poolCapaUnit = SJctrCapacityUtility.UNIT.KB;
        iEmulation = poolDetail.getEmulationType();
        lPoolPageSize = poolDetail.getPageSize();
        lCapa = pages * lPoolPageSize;
        SJctrComUtility comUtil = this.edPDC.getOwner().getComUtility();
        lBlocks = comUtil.getCapacityUtility().valueOf(lCapa, poolCapaUnit, iEmulation);
        return lBlocks;
    }

    public void refData() {
        super.setEnableListener(false);
        this.initDataModel();
        this.button.setEnable("COM_YES", true);
        this.button.setEnable("COM_NO", true);
        this.edPDC = (SJctrEditPoolsDC)this.getDataController();
        if (!this.edPDC.getOwner().getAuthorizeContainer().getRoleResourceContainer().checkAuthority(67)) {
            this.disableItem();
        }
        SJctrEditPoolsDataDirectMapping dmMap = (SJctrEditPoolsDataDirectMapping)this.edPDC.getDataObjectModel("COM_MAPPING_DATA");
        SJctrRadioButtonGroupDataModel multiTierRadio = this.edPDC.edPTierArea.getMultiTier();
        if (!dmMap.isSelectDisable() || !multiTierRadio.isSelect("COM_DISABLE")) {
            this.disableItem();
        } else {
            this.iSts = this.setTiPairSuspend();
            if (this.iSts == 1) {
                this.disItem(true);
            } else if (this.iSts == 2) {
                this.disItem(false);
            } else if (this.iSts == 3) {
                this.disableItem();
            }
        }
        if (this.bTiPairChkFlg) {
            dmMap.button.setEnable("COM_ENABLE", false);
            multiTierRadio.setEnable("COM_ENABLE", false);
        }
        super.setEnableListener(true);
    }

    private int setTiPairSuspend() {
        int rtn = 0;
        long lDefaultPoolOpt = 0L;
        List<Object> editData = new ArrayList();
        SJmoPoolDetail poolDetail = null;
        int iCnt = 0;
        long lPoolOpt = 0L;
        boolean bTiPairFlg = false;
        editData = this.edPDC.getCache("KEY_CLASS_EDIT_DATA");
        poolDetail = (SJmoPoolDetail)editData.get(0);
        lDefaultPoolOpt = poolDetail.getLPoolOptionFlag() & 0x10000000L;
        for (iCnt = 0; iCnt < editData.size(); ++iCnt) {
            poolDetail = (SJmoPoolDetail)editData.get(iCnt);
            lPoolOpt = poolDetail.getLPoolOptionFlag() & 0x10000000L;
            if (lPoolOpt != lDefaultPoolOpt && !bTiPairFlg) {
                bTiPairFlg = true;
            }
            if (!this.bTiPairChkFlg) {
                this.bTiPairChkFlg = this.chkTiPair(poolDetail);
            }
            if (bTiPairFlg && this.bTiPairChkFlg) break;
        }
        if (poolDetail.getPoolKind() == 8 || this.chkSubscripitionLimit() || this.chkMfPool(poolDetail)) {
            rtn = 3;
        } else if (!bTiPairFlg && 0x10000000L != lDefaultPoolOpt) {
            rtn = 1;
        } else if (!bTiPairFlg) {
            rtn = 2;
        }
        return rtn;
    }

    public void disableItem() {
        this.checkBox.setEnable(false);
        this.checkBox.setSelect(false);
        this.button.setEnable("COM_YES", false);
        this.button.setEnable("COM_NO", false);
        this.button.setSelect(KEY_DUMMY);
    }

    private void disItem(boolean bTiPair) {
        this.checkBox.setEnable(true);
        this.checkBox.setSelect(false);
        this.button.setEnable("COM_YES", true);
        this.button.setEnable("COM_NO", true);
        if (bTiPair) {
            this.button.setSelect("COM_YES");
        } else {
            this.button.setSelect("COM_NO");
        }
    }
}

