/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.com;

import java.util.List;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.SJctrUserController;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetRSGgetAllRsgs;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.rsg.SJmoRSGgetAllRsgs;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;

public abstract class SJctrItemSelectListenerLReplicaBase
implements SJctrItemSelectListener {
    protected List<SJmoLocalReplicationPairVolInfo> checkRSGInfoFromSelectedPairList(SJctrDataController dc, SJctrUserController uc, List<SJmoLocalReplicationPairVolInfo> selectedPairsList) {
        SJmoGetRSGgetAllRsgs kind = new SJmoGetRSGgetAllRsgs();
        List<Object> allRsgsList = SJctrReplicationUtility.getModelInfoNotUsedCache(dc, kind);
        SJmoRSGgetAllRsgs allRsg = SJctrReplicationUtility.checkSJmoRSGgetAllRsgsInfo(dc, allRsgsList);
        SJctrResourceGroupUtility rsgUty = new SJctrResourceGroupUtility(uc, allRsg);
        if (!SJctrReplicationUtility.checkLocalVolListResourcePrimaryVol(selectedPairsList, rsgUty)) {
            uc.getLogUty().putlog("checkRSGInfoFromSelectedPairList", "Selected pairs cannot use.");
            SJctrError err = new SJctrError(209, 22, 106144);
            SJcException exp = err.createException();
            throw exp;
        }
        return selectedPairsList;
    }

    protected int checkCopyTypeFromSelectedPairList(SJctrUserController uc, List<SJmoLocalReplicationPairVolInfo> selectedPairsList) {
        int copytype = SJctrReplicationUtility.checkCopyTypeForLocalPairVolList(selectedPairsList);
        if (-1 == copytype) {
            uc.getLogUty().putlog("checkCopyTypeFromSelectedPairList", "Selected pairs copytype are mixed.");
            SJctrError err = new SJctrError(209, 22, 106143);
            SJcException exp = err.createException();
            throw exp;
        }
        return copytype;
    }

    protected int checkFiconVolFromSelectedPairList(SJctrDataController dc, SJctrUserController uc, List<SJmoLocalReplicationPairVolInfo> selectedPairsList) {
        List<SJmoLdevDetail> ldevDetailList = dc.getModelData(SJmoGetLdevDetail.class);
        int simfPairType = SJctrReplicationUtility.checkConfigurationFiconVolFromLocalPairList(selectedPairsList, ldevDetailList);
        if (-1 == simfPairType) {
            uc.getLogUty().putlog("checkFiconVolFromSelectedPairList", "Selected pairs include FICON DMVOL and NormalVOL.");
            SJctrError err = new SJctrError(209, 22, 205020);
            SJcException exp = err.createException();
            throw exp;
        }
        return simfPairType;
    }
}

