/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import sanproject.serversx.data.RJiLDEVIndex;
import sanproject.serverux.dataimpl.MRCFgetTiPvolPairInfo_IN;
import sanproject.serverux.dataimpl.MRCFgetTiPvolPairParam;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.SJctrTiReplicationUtility;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetMRCFgetTiPvolPairParam;
import sanproject.sn2.controller.wizard.replication.com.SJctrTIPVolSnapshotGroupInfo;
import sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes.SJctrPVolErrorTableModel;
import sanproject.sn2.controller.wizard.replication.local.assignsecondaryvolumes.SJctrTIPairGetExecuter;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairInfo;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairUtility;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetTiPvolStatus;
import sanproject.sn2.model.data.group.SJmoPoolIndex;
import sanproject.sn2.model.data.group.SJmoPoolNameInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolMu;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.replication.local.SJmoTiSnapshotPair;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrTIPairGetExecuter_PVol
extends SJctrTIPairGetExecuter {
    private List<SJmoTiPvolInfo> selectRootVolList = Collections.emptyList();

    @Override
    public boolean checkInputData(List<?> inputDataList) {
        for (Object inputData : inputDataList) {
            if (inputData instanceof SJmoTiPvolInfo) continue;
            SJctrCreateTIPairUtility.createError(107001);
        }
        this.selectRootVolList = inputDataList;
        Collections.sort(this.selectRootVolList);
        return true;
    }

    @Override
    public boolean checkConstractData() {
        List<?> tiPVolStatusList = this.getCache(SJmoGetTiPvolStatus.class);
        if (tiPVolStatusList == null || tiPVolStatusList.isEmpty()) {
            SJctrLogUty.warn(this.getClass().getSimpleName(), "checkConstructData", "SJmoTiPvolStatus is null or Empty.");
            SJctrCreateTIPairUtility.createError(107002);
        }
        SJmoTiPvolStatus tiPVolStatusInfo = (SJmoTiPvolStatus)tiPVolStatusList.get(0);
        Object[] tiPVolArray = tiPVolStatusInfo.getTiPvolInfo();
        int ssDataNum = 0;
        for (SJmoLdevIndex sJmoLdevIndex : this.selectRootVolList) {
            int index = Arrays.binarySearch(tiPVolArray, sJmoLdevIndex);
            if (index < 0) {
                SJctrCreateTIPairUtility.createError(206525);
            }
            Object tiPVolInfo = tiPVolArray[index];
            ssDataNum = (int)((long)ssDataNum + ((SJmoTiPvolInfo)tiPVolInfo).getPairnum());
        }
        if (ssDataNum > 32768) {
            SJctrCreateTIPairUtility.createError(205159);
        }
        return true;
    }

    @Override
    protected SJmoGetKind_IF createGetInputData() {
        int getNum = this.selectRootVolList.size();
        MRCFgetTiPvolPairParam param = new MRCFgetTiPvolPairParam();
        param.setPvolNum(getNum);
        RJiLDEVIndex[] getLdevArray = new RJiLDEVIndex[getNum];
        for (int index = 0; index < getNum; ++index) {
            SJmoLdevIndex pVolIndex = this.selectRootVolList.get(index);
            RJiLDEVIndex getLdev = new RJiLDEVIndex();
            getLdev.setLDEVIndex(pVolIndex.getSLdkc(), pVolIndex.getSCu(), pVolIndex.getSLdev());
            getLdevArray[index] = getLdev;
        }
        param.setPvolList(getLdevArray);
        MRCFgetTiPvolPairInfo_IN input = new MRCFgetTiPvolPairInfo_IN();
        input.setTiPvolPairParam(param);
        return new SJctrGetMRCFgetTiPvolPairParam(input);
    }

    protected SanResponse getThroughRmiDataKeyValue() {
        try {
            SanRequest sanRequest = SJctrTiReplicationUtility.getTreePairsSanRequestFromTiPvolInfo(this.selectRootVolList, this.dc);
            SanResponse sanResponse = SJctrTiReplicationUtility.getTreePairSanResponseFromTiPvolInfo(sanRequest, this.dc);
            return sanResponse;
        }
        catch (SanDataException sdex) {
            SJctrLogUty.error("SJctrTIPairGetExecuter_PVol", "getThroughRmiDataKeyValue", sdex.getMessage());
            throw SJctrTiReplicationUtility.makeException(107001);
        }
    }

    @Override
    protected List<SJctrCreateTIPairInfo> getTIPair() {
        List<SJctrCreateTIPairInfo> retList = Collections.emptyList();
        SanResponse getInfo = this.getThroughRmiDataKeyValue();
        retList = this.createAvailablePairListKeyValue(getInfo, this.selectRootVolList);
        return retList;
    }

    protected List<SJctrCreateTIPairInfo> createAvailablePairListKeyValue(SanResponse rmiData, List<SJmoTiPvolInfo> selectPVolList) {
        if (rmiData == null) {
            return new ArrayList<SJctrCreateTIPairInfo>();
        }
        ArrayList<SJctrCreateTIPairInfo> retList = new ArrayList<SJctrCreateTIPairInfo>();
        try {
            SanList rootLdevList = rmiData.getList("RootLdevs");
            HashMap<Integer, SJmoPoolNameInfo> poolNameMap = new HashMap<Integer, SJmoPoolNameInfo>(this.poolNameList.size());
            SJmoTiPvolMu pVolMu = SJctrCreateTIPairUtility.createTiPVolMuInfo();
            for (SanObject rootLdev : rootLdevList) {
                if (rootLdev.getMember("TiPairs") == null) continue;
                int[] rootLdevId = rootLdev.getIntArray("Id");
                SJmoLdevIndex rootLdevIndex = new SJmoLdevIndex();
                rootLdevIndex.setLdevIndex((short)rootLdevId[0], (short)rootLdevId[1], (short)rootLdevId[2]);
                int searchIndex = Collections.binarySearch(selectPVolList, rootLdevIndex);
                if (searchIndex < 0) {
                    SJctrLogUty.warn(this.getClass().getSimpleName(), "createAvailablePairList", "Root LDEV not Found. RootLdev : " + rootLdevId[0] + ":" + rootLdevId[1] + ":" + rootLdevId[2]);
                    continue;
                }
                int poolId = selectPVolList.get(searchIndex).getPoolid();
                SJmoPoolNameInfo poolNameInfo = (SJmoPoolNameInfo)poolNameMap.get(poolId);
                if (poolNameInfo == null) {
                    SJmoPoolIndex poolIndex = new SJmoPoolIndex();
                    poolIndex.setPoolId(poolId);
                    searchIndex = Collections.binarySearch(this.poolNameList, poolIndex);
                    if (searchIndex < 0) {
                        SJctrLogUty.warn(this.getClass().getSimpleName(), "createAvailablePairList", "POOL notFound . POOL ID:" + SJctrComUtility.toDecString(poolId));
                        continue;
                    }
                    poolNameInfo = (SJmoPoolNameInfo)this.poolNameList.get(searchIndex);
                    poolNameMap.put(poolId, poolNameInfo);
                }
                SanList treePairList = rootLdev.getList("TiPairs");
                for (SanObject pair : treePairList) {
                    SanObject sanObjPvolInf = pair.getObj("PrimaryVolume").getObj("Ldev");
                    int[] pvol = sanObjPvolInf.getIntArray("Id");
                    SJmoLdevIndex pVolIndex = new SJmoLdevIndex();
                    pVolIndex.setLdevIndex((short)pvol[0], (short)pvol[1], (short)pvol[2]);
                    if (pair.getMember("SecondaryVolume") != null) continue;
                    SJmoLdevIndex sVolIndex = new SJmoLdevIndex();
                    int[] svol = new int[]{-1, -1, -1};
                    sVolIndex.setLdevIndex((short)svol[0], (short)svol[1], (short)svol[2]);
                    int pVolIndexKey = SJctrReplicationUtility.getLdevIndexKey(pVolIndex);
                    List luPathList = (List)this.ldevLUPathMap.get(pVolIndexKey);
                    SJmoPortLunDetail pVolLuPath = null;
                    if (luPathList != null && !luPathList.isEmpty()) {
                        pVolLuPath = (SJmoPortLunDetail)luPathList.get(0);
                    }
                    short muNum = (short)pair.getInt("MirrorUnit");
                    pVolMu.setLdevIndex(pVolIndex.getSLdkc(), pVolIndex.getSCu(), pVolIndex.getSLdev());
                    pVolMu.setMu(muNum);
                    searchIndex = Collections.binarySearch(this.tiPVolMuSSGrpInfo, pVolMu, this.PVOLMU_COMP);
                    SJmoSnapshotSetInfo snapshotGrpInfo = null;
                    if (searchIndex >= 0) {
                        SJctrTIPVolSnapshotGroupInfo pVolMuSSGrpInfo = (SJctrTIPVolSnapshotGroupInfo)this.tiPVolMuSSGrpInfo.get(searchIndex);
                        SJmoTiSnapshotPair ssGrpPairInfo = pVolMuSSGrpInfo.getTiSSPairInfo();
                        int ssGrpId = (int)ssGrpPairInfo.getSnapshotID();
                        snapshotGrpInfo = this.ssGrpMgr.getSnapshotSetInfo(ssGrpId);
                    }
                    short pairStatus = (short)pair.getInt("Status");
                    Date ssDate = new Date();
                    if (560 == pairStatus) {
                        int[] snapDate = pair.getIntArray("SnapshotDate");
                        Calendar calSnap = Calendar.getInstance();
                        calSnap.setTimeZone(TimeZone.getTimeZone("GMT"));
                        calSnap.set(snapDate[0], snapDate[1] - 1, snapDate[2], snapDate[3], snapDate[4], snapDate[5]);
                        ssDate = calSnap.getTime();
                    } else {
                        ssDate = null;
                    }
                    boolean bCascade = pair.getBoolean("Cascade");
                    boolean bClone = pair.getBoolean("Clone");
                    SJctrCreateTIPairInfo createTiPairInfo = new SJctrCreateTIPairInfo(pVolLuPath, pVolIndex, sVolIndex, snapshotGrpInfo, poolNameInfo, muNum, pairStatus, ssDate, bCascade, bClone, rootLdevIndex);
                    retList.add(createTiPairInfo);
                }
            }
        }
        catch (SanDataException e) {
            SJctrLogUty.error("SJctrTIPairGetExecuter_PVol", "getTIPair()", e.getMessage());
            throw SJctrTiReplicationUtility.makeException(107001);
        }
        return retList;
    }

    @Override
    protected boolean checkGetInfo(List<SJctrCreateTIPairInfo> tiPairList) {
        SJctrErrorColumnData errColumn;
        if (tiPairList == null) {
            SJctrCreateTIPairUtility.createError(206165);
        }
        Comparator<Object> pVolComp = SJctrCreateTIPairInfo.CreatePVolComparator();
        ArrayList<SJctrErrorColumnData> errColumnList = new ArrayList<SJctrErrorColumnData>(this.selectRootVolList.size());
        List<?> pairMgrList = this.getCache(SJmoGetLocalReplicationPairVolInfoMgr.class);
        if (pairMgrList == null || pairMgrList.isEmpty()) {
            SJctrCreateTIPairUtility.createError(107002);
        }
        SJmoLocalReplicationPairVolInfoMgr pairMgr = (SJmoLocalReplicationPairVolInfoMgr)pairMgrList.get(0);
        List<SJmoTiPvolInfo> rootLdevIndexList = this.getRootVolListMultipleHierarchy(tiPairList);
        if (rootLdevIndexList.size() >= 1) {
            for (SJmoTiPvolInfo sJmoTiPvolInfo : rootLdevIndexList) {
                SJctrError error = new SJctrError(209, 22, 206319);
                errColumn = new SJctrErrorColumnData(sJmoTiPvolInfo, error);
                errColumnList.add(errColumn);
            }
        } else {
            for (SJmoLdevIndex sJmoLdevIndex : this.selectRootVolList) {
                if (Collections.binarySearch(tiPairList, sJmoLdevIndex, pVolComp) >= 0) continue;
                SJctrError err = new SJctrError(209, 22, 206165);
                errColumn = new SJctrErrorColumnData(sJmoLdevIndex, err);
                errColumnList.add(errColumn);
            }
        }
        if (!errColumnList.isEmpty()) {
            ArrayList<SJmoLdevIndex> errLdevList = new ArrayList<SJmoLdevIndex>(errColumnList.size());
            for (SJctrErrorColumnData errColumn2 : errColumnList) {
                SJmoLdevIndex errLdev = (SJmoLdevIndex)errColumn2.getKeyObj();
                errLdevList.add(errLdev);
            }
            Collections.sort(errLdevList);
            SJctrPVolErrorTableModel sJctrPVolErrorTableModel = new SJctrPVolErrorTableModel();
            sJctrPVolErrorTableModel.setDataController(this.dc);
            sJctrPVolErrorTableModel.initGuidance(this.dc.getOwner().getComUtility());
            sJctrPVolErrorTableModel.createModelDirect();
            sJctrPVolErrorTableModel.divideModelData(this.dc.getProxy().getModelDataMap());
            sJctrPVolErrorTableModel.setTableKeyData(errLdevList);
            sJctrPVolErrorTableModel.makeDataModel();
            SJctrCreateTIPairUtility.createErrorTable(this.dc, sJctrPVolErrorTableModel, errColumnList);
        }
        this.checkRSGInfoFromSelectedPairList(tiPairList);
        return true;
    }

    private List<SJmoTiPvolInfo> getRootVolListMultipleHierarchy(List<SJctrCreateTIPairInfo> tiPairList) {
        ArrayList<SJmoTiPvolInfo> rtnRootLdevList = new ArrayList<SJmoTiPvolInfo>();
        for (SJctrCreateTIPairInfo pairVolInfo : tiPairList) {
            if (!this.isMultipleHierarchyTiPairInfo(pairVolInfo)) continue;
            int iIndex = Collections.binarySearch(this.selectRootVolList, pairVolInfo.getRootLdev());
            if (iIndex >= 0) {
                if (rtnRootLdevList.contains(this.selectRootVolList.get(iIndex))) continue;
                rtnRootLdevList.add(this.selectRootVolList.get(iIndex));
                continue;
            }
            SJctrLogUty.error("SJctrTIPairGetExecuter_PVol", "getRootVolListMultipleHierarchy", "TI root volume is not found.");
            SJctrCreateTIPairUtility.createError(107001);
        }
        Collections.sort(rtnRootLdevList);
        return rtnRootLdevList;
    }

    private boolean isMultipleHierarchyTiPairInfo(SJctrCreateTIPairInfo pairVolInfo) {
        boolean brtn = false;
        if (pairVolInfo.getPVolIndex().getIndex() != pairVolInfo.getRootLdev().getIndex()) {
            brtn = true;
        }
        return brtn;
    }
}

