/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createpairs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.sn2.controller.com.SJctrResourceGroupUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.replication.com.SJctrEmulationTypeDef;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;
import sanproject.sn2.model.data.volume.SJmoLdevStatusInfo;

public class SJctrCreatePairUtility {
    public static final String NON_SPLIT = "NON_SPLIT";
    public static final String QUICK_SPLIT = "QUICK_SPLIT";
    public static final String NORMAL_SPLIT = "NORMAL_SPLIT";
    public static final String MIGRATION = "MIGRATION";
    public static final short CPPACE_MEDIUM = 0;
    public static final short CPPACE_SLOWER = 1;
    public static final short CPPACE_FASTER = 2;
    public static final int LUSE_MAXSIZE = 36;
    public static final int MIN_PAIR = 1;
    public static final int SI_MAX_PAIR = 9;
    public static final int SI_L1_MAX_PAIR = 3;
    public static final int SI_L2_MAX_PAIR = 2;
    public static final int SIMF_MAX_PAIR = 3;
    public static final int SS_MAX_PAIR = 64;
    public static final int DS_MAX_PAIR = 1024;
    public static final int SI_L2_STARTMU = 1;
    public static final int SI_MAXMU = 2;
    public static final int MAX_SIPAIR_CONF = 32768;
    public static final int MAX_SSPAIR_CONF = 16384;
    public static final int MAX_DSPAIR_CONF = 32768;
    public static final int MAX_NUM_SNAPSHOT = 2048;
    public static final int MAX_NUM_SNAPSHOTSETPAIR = 8192;
    public static final String PAIR_NUM_SS = "PAIR_NUM_SS";
    public static final String PAIR_NUM_DS = "PAIR_NUM_DS";
    public static final byte POOL_KIND_DS = 8;
    private static final int INVALID = -1;
    public static final byte BIT_NOPAIR = 0;
    public static final byte BIT_SIL1 = -128;
    public static final byte BIT_SIL2_MU0 = 1;
    public static final byte BIT_SIL2_MU1 = 2;
    public static final byte BIT_SIL2_MU2 = 4;
    private static final Set<Byte> CREATE_NOTAVAILABLE_STATUS = new HashSet<Byte>();
    public static final long MAX_CAP_SS = 0x200000000L;
    public static final long MAX_CAP_DS = 0x1E00000000L;
    public static final Pattern SS_Set_Name;

    public static boolean checkLdevRSG(SJmoLdevIndex ldev, SJctrResourceGroupUtility rsgUtil) {
        ArrayList<SJmoLdevIndex> ldevList = new ArrayList<SJmoLdevIndex>();
        ldevList.add(ldev);
        List<SJmoLdevIndex> extractList = rsgUtil.extractLdev(ldevList);
        return !extractList.isEmpty();
    }

    public static boolean checkLUPath(SJmoLdevDetail ldev) {
        return ldev.getILUPathNumber() != 0;
    }

    public static boolean isSIUsableEmuType(SJmoLdevDetail ldev) {
        boolean ret = true;
        ret = SJctrEmulationTypeDef.SI_USABLE_EMU.contains(ldev.getIEmulationType());
        return ret;
    }

    public static boolean isSIMFUsableEmuType(SJmoLdevDetail ldev) {
        boolean ret = true;
        ret = SJctrEmulationTypeDef.SIMF_USABLE_EMU.contains(ldev.getIEmulationType());
        return ret;
    }

    public static boolean isSSUsableEmuType(SJmoLdevDetail ldev) {
        boolean ret = true;
        ret = SJctrEmulationTypeDef.SS_USABLE_EMU.contains(ldev.getIEmulationType());
        return ret;
    }

    public static boolean isDSUsableEmuType(SJmoLdevDetail ldev) {
        boolean ret = true;
        ret = SJctrEmulationTypeDef.DS_USABLE_EMU.contains(ldev.getIEmulationType());
        return ret;
    }

    public static boolean isInvalidIndex(SJmoLdevIndex index) {
        return index.getSLdkc() == -1 || index.getSCu() == -1 || index.getSLdev() == -1;
    }

    public static void setInvalidIndex(SJmoLdevIndex index) {
        index.setSLdkc((short)-1);
        index.setSCu((short)-1);
        index.setSLdev((short)-1);
    }

    public static int getPairPVolBit(short copyType) {
        int retBit = 0;
        switch (copyType) {
            case 1: {
                retBit = 4;
                break;
            }
            case 0: {
                retBit = 128;
                break;
            }
            case 2: 
            case 3: {
                retBit = 0x400000;
            }
        }
        return retBit;
    }

    public static int getPairSVolBit(short copyType) {
        int retBit = 0;
        switch (copyType) {
            case 1: {
                retBit = 8;
                break;
            }
            case 0: {
                retBit = 256;
                break;
            }
            case 2: 
            case 3: {
                retBit = 0x800000;
            }
        }
        return retBit;
    }

    public static int getSnapshotInfoBit(int cpType) {
        int retBit = 0;
        if (cpType == 3) {
            retBit = 1;
        }
        return retBit;
    }

    public static int getL1MaxPairNum(int cpType) {
        int ret = 0;
        switch (cpType) {
            case 1: {
                ret = 3;
                break;
            }
            case 0: {
                ret = 3;
                break;
            }
            case 2: {
                ret = 64;
                break;
            }
            case 3: {
                ret = 1024;
                break;
            }
            default: {
                ret = 0;
            }
        }
        return ret;
    }

    public static int getL2MaxPairNum(int cpType) {
        int ret = 0;
        switch (cpType) {
            case 1: {
                ret = 2;
                break;
            }
            default: {
                ret = 0;
            }
        }
        return ret;
    }

    public static int getMaxPairNum(int cpType, boolean bSVol) {
        int ret = 0;
        switch (cpType) {
            case 1: {
                if (bSVol) {
                    ret = 2;
                    break;
                }
                ret = 9;
                break;
            }
            case 0: {
                ret = 3;
                break;
            }
            case 2: {
                ret = 64;
                break;
            }
            case 3: {
                ret = 1024;
                break;
            }
            default: {
                ret = 0;
            }
        }
        return ret;
    }

    public static boolean checkCreatePiarUsableStatus(SJmoLdevStatusInfo ldevstatus) {
        boolean bRet = !CREATE_NOTAVAILABLE_STATUS.contains(ldevstatus.getLDEVStatus());
        return bRet;
    }

    public static boolean checkPairStatus(SJmoLocalReplicationPairVolInfo pairPVolInfo, SJmoLocalReplicationPairVolInfoMgr pairMgr, short sVolCPType, int[] passStatusArray) {
        boolean bRet = true;
        int pairSVolBit = SJctrCreatePairUtility.getPairSVolBit(sVolCPType);
        ArrayList<? extends SJmoLdevIndex> sVolList = pairPVolInfo.getAlSVolIndex();
        for (SJmoLdevIndex sJmoLdevIndex : sVolList) {
            SJmoLocalReplicationPairVolInfo pairSVolInfo = pairMgr.getLocalReplicationPairVolInfo(sJmoLdevIndex);
            if (pairSVolInfo == null || !pairSVolInfo.isVolPos(pairSVolBit) || SJctrCreatePairUtility.checkSVOLPairStatus(pairSVolInfo, passStatusArray)) continue;
            bRet = false;
            break;
        }
        return bRet;
    }

    public static boolean checkSVOLPairStatus(SJmoLocalReplicationPairVolInfo pairSVolInfo, int[] passStatusArray) {
        boolean bRet = false;
        short status = pairSVolInfo.getSPairStatus();
        for (int index = 0; index < passStatusArray.length; ++index) {
            if (status != passStatusArray[index]) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    public static Map<String, Integer> getSnapshotNum(List<SJmoLdevDetail> ldevDetailList, SJmoLocalReplicationPairVolInfoMgr pairInfoMgr) {
        HashMap<String, Integer> pairNumMap = new HashMap<String, Integer>();
        int ssPairNum = 0;
        int dsPairNum = 0;
        for (SJmoLdevDetail ldevDtl : ldevDetailList) {
            SJmoLocalReplicationPairVolInfo pairInfo = pairInfoMgr.getLocalReplicationPairVolInfo(ldevDtl);
            if (pairInfo == null || !pairInfo.isVolPos(0x800000)) continue;
            if (pairInfo.isExSnapshotInfo(1)) {
                ++dsPairNum;
                continue;
            }
            ++ssPairNum;
        }
        pairNumMap.put(PAIR_NUM_SS, ssPairNum);
        pairNumMap.put(PAIR_NUM_DS, dsPairNum);
        return pairNumMap;
    }

    public static int[] getSnapshotSetPairNum(List<SJmoLdevDetail> ldevDetailList, SJmoLocalReplicationPairVolInfoMgr pairInfoMgr) {
        int[] pairNumArray = new int[2048];
        for (SJmoLdevDetail ldevDtl : ldevDetailList) {
            int snapshotSetId;
            SJmoLocalReplicationPairVolInfo pairInfo = pairInfoMgr.getLocalReplicationPairVolInfo(ldevDtl);
            if (pairInfo == null || !pairInfo.isVolPos(0x800000) || !pairInfo.isExSnapshotInfo(1) || (snapshotSetId = pairInfo.getISnapshotSetId()) == -1) continue;
            int n = snapshotSetId;
            pairNumArray[n] = pairNumArray[n] + 1;
        }
        return pairNumArray;
    }

    public static boolean isValidSnapshotName(String name) {
        Matcher matcher = SS_Set_Name.matcher(name);
        return matcher.matches();
    }

    public static void setColumnVisible(SJctrTableDataModel table, Set<String> invisibleKeySet) {
        for (String key : table.getAllColumnKeySet(false)) {
            SJctrColumn colimn = table.getColumnInfo(key);
            if (colimn == null) continue;
            if (invisibleKeySet.contains(key)) {
                colimn.setShowColumn(false);
                continue;
            }
            colimn.setShowColumn(true);
        }
    }

    public static void setL1MUBit(byte[] topology, short mu_L1) {
        if (mu_L1 <= 2) {
            short s = mu_L1;
            topology[s] = (byte)(topology[s] | 0xFFFFFF80);
        }
    }

    public static void setL2MUBit(byte[] topology, short mu_L1, short mu_L2) {
        if (mu_L1 <= 2 && 1 <= mu_L2 && mu_L2 <= 2) {
            short s = mu_L1;
            topology[s] = (byte)(topology[s] | 1 << mu_L2);
        }
    }

    public static boolean isL1MUBit(byte[] topology, short mu_L1) {
        boolean ret = false;
        if (mu_L1 <= 2) {
            ret = (topology[mu_L1] & 0xFFFFFF80) != 0;
        }
        return ret;
    }

    public static boolean isL2MUBit(byte[] topology, short mu_L1, short mu_L2) {
        boolean ret = false;
        if (mu_L1 <= 2 && 1 <= mu_L2 && mu_L2 <= 2) {
            ret = (topology[mu_L1] & 1 << mu_L2) != 0;
        }
        return ret;
    }

    static {
        CREATE_NOTAVAILABLE_STATUS.add((byte)2);
        CREATE_NOTAVAILABLE_STATUS.add((byte)12);
        SS_Set_Name = Pattern.compile("[0-9a-zA-Z,-./:@\\\\_]{1,32}");
    }
}

