/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createpairs;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.serverux.dataimpl.MRCFgetSnapshotSetName;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrSnapshotSetNameComparator;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoSnapshotSetInfo;
import sanproject.sn2.model.data.replication.local.manager.SJmoSnapshotSetInfoMgr;

public class SJctrSnapshotSetInfoMgr {
    private final int ERR_NORMAL = 0;
    private final int ERR_SSSETNUM_OVER = 106166;
    private final int ERR_SSSETPAIR_NUM_OVER = 106167;
    private final int DEFAULT_NEWID = -2;
    private SJmoSnapshotSetInfoMgr moSnapshotSetInfoMgr = null;
    private Map<Integer, SJmoSnapshotSetInfo> newSnapshotSetMap = null;
    private Map<Integer, Integer> orgSnapshotSetPairNumMap = null;
    private Map<String, SJmoSnapshotSetInfo> snapshotSetNameMap = null;
    private Map<Integer, Integer> diffSnapshotSetPairNumMap = null;
    private BitSet newIDBitSet = null;
    private SJctrSnapshotSetNameComparator nameCmp = null;

    public SJctrSnapshotSetInfoMgr(SJmoSnapshotSetInfoMgr moSnapshotSetInfoMgr, Map<Integer, Integer> orgSnapshotSetPairNumMap) {
        this.moSnapshotSetInfoMgr = moSnapshotSetInfoMgr;
        this.orgSnapshotSetPairNumMap = orgSnapshotSetPairNumMap;
        this.diffSnapshotSetPairNumMap = new HashMap<Integer, Integer>(2048);
        this.newSnapshotSetMap = new HashMap<Integer, SJmoSnapshotSetInfo>(2048);
        this.newIDBitSet = new BitSet(2048);
        this.nameCmp = new SJctrSnapshotSetNameComparator();
        this.snapshotSetNameMap = new HashMap<String, SJmoSnapshotSetInfo>(2048);
        for (Integer id : orgSnapshotSetPairNumMap.keySet()) {
            SJmoSnapshotSetInfo existSnapshotSetInfo = this.getSnapshotSetInfo(id);
            if (existSnapshotSetInfo == null) continue;
            this.snapshotSetNameMap.put(existSnapshotSetInfo.getStrSnapshotSetName(), existSnapshotSetInfo);
        }
    }

    public SJmoSnapshotSetInfo getSnapshotSetInfo(int id) {
        SJmoSnapshotSetInfo snapshotSetInfo = null;
        snapshotSetInfo = this.moSnapshotSetInfoMgr.getSnapshotSetInfo(id);
        if (snapshotSetInfo == null) {
            snapshotSetInfo = this.newSnapshotSetMap.get(id);
        }
        return snapshotSetInfo;
    }

    public int addSnapshotSetPair(String name, List<?> pairList) {
        int error = 0;
        int pairNum = 0;
        SJmoSnapshotSetInfo snapshotSetInfo = this.searchSnapshotSetinfo(name);
        if (snapshotSetInfo == null) {
            int snapshotSetNum = this.getSnapshotSetNum() + 1;
            pairNum = pairList.size();
            if (snapshotSetNum > 2048) {
                error = 106166;
            } else if (pairNum > 8192) {
                error = 106167;
            } else {
                snapshotSetInfo = this.createSnapshotSetinfo(name);
                if (snapshotSetInfo != null) {
                    this.newSnapshotSetMap.put(snapshotSetInfo.getISnapshotSetId(), snapshotSetInfo);
                    this.snapshotSetNameMap.put(name, snapshotSetInfo);
                } else {
                    error = 106166;
                }
            }
        } else {
            pairNum = this.getPairNum(snapshotSetInfo.getISnapshotSetId());
            if ((pairNum += pairList.size()) > 8192) {
                error = 106167;
            }
        }
        if (error == 0) {
            int snapshotSetId = snapshotSetInfo.getISnapshotSetId();
            for (Object obj : pairList) {
                SJmoLocalReplicationPairVolInfo pairInfo = (SJmoLocalReplicationPairVolInfo)obj;
                pairInfo.setISnapshotSetId(snapshotSetId);
            }
            this.diffSnapshotSetPairNumMap.put(snapshotSetId, pairNum);
        }
        return error;
    }

    public boolean removeSnapshotSetPair(List<?> pairList) {
        boolean ret = true;
        for (Object obj : pairList) {
            SJmoLocalReplicationPairVolInfo pairInfo = (SJmoLocalReplicationPairVolInfo)obj;
            int snapshotSetId = pairInfo.getISnapshotSetId();
            if (snapshotSetId == -1) continue;
            int pairNum = this.getPairNum(snapshotSetId);
            if (--pairNum <= 0) {
                SJmoSnapshotSetInfo delSSSetInfo = this.getSnapshotSetInfo(snapshotSetId);
                this.snapshotSetNameMap.remove(delSSSetInfo.getStrSnapshotSetName());
                this.newSnapshotSetMap.remove(snapshotSetId);
                this.resetNewID(snapshotSetId);
            }
            int defaultNum = 0;
            Integer getNum = this.orgSnapshotSetPairNumMap.get(snapshotSetId);
            if (getNum != null) {
                defaultNum = getNum;
            }
            if (pairNum <= defaultNum) {
                this.diffSnapshotSetPairNumMap.remove(snapshotSetId);
            } else {
                this.diffSnapshotSetPairNumMap.put(snapshotSetId, pairNum);
            }
            pairInfo.setISnapshotSetId(-1);
        }
        return ret;
    }

    public int getPairNum(int id) {
        int num = 0;
        Integer getValue = this.diffSnapshotSetPairNumMap.get(id);
        if (getValue == null) {
            getValue = this.orgSnapshotSetPairNumMap.get(id);
        }
        if (getValue != null) {
            num = getValue;
        }
        return num;
    }

    private int getSnapshotSetNum() {
        int num = 0;
        num += this.orgSnapshotSetPairNumMap.size();
        return num += this.newSnapshotSetMap.size();
    }

    private SJmoSnapshotSetInfo createSnapshotSetinfo(String name) {
        SJmoSnapshotSetInfo snapshotSetInfo = null;
        MRCFgetSnapshotSetName nameInfo = new MRCFgetSnapshotSetName();
        snapshotSetInfo = new SJmoSnapshotSetInfo(nameInfo);
        int newId = this.getNewID();
        snapshotSetInfo.setISnapshotSetId(newId);
        snapshotSetInfo.setStrSnapshotSetName(name);
        this.setNewID(newId);
        return snapshotSetInfo;
    }

    public List<SJmoSnapshotSetInfo> getDiffSnapshotSetInfoList() {
        ArrayList<SJmoSnapshotSetInfo> retList = new ArrayList<SJmoSnapshotSetInfo>(2048);
        for (Integer id : this.diffSnapshotSetPairNumMap.keySet()) {
            SJmoSnapshotSetInfo snapshotSetInfo = this.getSnapshotSetInfo(id);
            if (snapshotSetInfo == null) continue;
            retList.add(snapshotSetInfo);
        }
        Collections.sort(retList);
        retList.trimToSize();
        return retList;
    }

    public SJmoSnapshotSetInfo searchSnapshotSetinfo(String name) {
        SJmoSnapshotSetInfo snapshotSetInfo = null;
        if (this.snapshotSetNameMap != null) {
            snapshotSetInfo = this.snapshotSetNameMap.get(name);
        }
        return snapshotSetInfo;
    }

    private int getNewID() {
        int newId = -1;
        int index = this.newIDBitSet.nextClearBit(0);
        newId = -2 - index;
        return newId;
    }

    private void setNewID(int id) {
        int index = -2 - id;
        if (0 <= index && index < 2048) {
            this.newIDBitSet.set(index);
        }
    }

    private void resetNewID(int id) {
        int index = -2 - id;
        if (0 <= index && index < 2048) {
            this.newIDBitSet.clear(index);
        }
    }
}

