/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createpairs.selectpaircofig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import sanproject.sn2.controller.com.SJctrComCVSUtility;
import sanproject.sn2.controller.com.model.SJctrComboBoxDataModel;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectEvent;
import sanproject.sn2.controller.com.model.event.SJctrItemSelectListener;
import sanproject.sn2.controller.wizard.replication.local.createpairs.selectpaircofig.SJctrSelectPairConfigDC;

public class SJctrEmulationTypeDataModel
extends SJctrComboBoxDataModel {
    public static final int EMULATION_TYPE_OPEN_V = 625;
    private List<String> siEmuList;
    private List<String> simfEmuList;
    private List<String> ssEmuList;
    private List<String> dsEmuList;
    private int selCpType = -1;
    private List<Integer> simfEmuIDList = null;
    private List<Integer> mgEmuIDList = null;
    private SJctrItemSelectListener itemSelectListener = null;

    public void initEmulationType(List<Integer> siEmuIDList, List<Integer> simfEmuIDList, List<Integer> mgEmuIDList, List<Integer> ssEmuIDList, List<Integer> dsEmuIDList, int cpType, int selectEmu) {
        String emuName;
        this.simfEmuIDList = simfEmuIDList;
        this.mgEmuIDList = mgEmuIDList;
        SJctrComCVSUtility cvsUtil = this.getComUtility().getCVSUtility();
        this.siEmuList = new ArrayList<String>(siEmuIDList.size());
        for (Integer siEmuId : siEmuIDList) {
            String emuName2 = cvsUtil.getEmulationTypeName(siEmuId);
            this.siEmuList.add(emuName2);
        }
        Collections.sort(this.siEmuList);
        HashSet<Integer> simfEmuIDSet = new HashSet<Integer>(simfEmuIDList.size() + mgEmuIDList.size());
        simfEmuIDSet.addAll(simfEmuIDList);
        simfEmuIDSet.addAll(mgEmuIDList);
        this.simfEmuList = new ArrayList<String>(simfEmuIDSet.size());
        for (Integer simfEmuId : simfEmuIDSet) {
            emuName = cvsUtil.getEmulationTypeName(simfEmuId);
            this.simfEmuList.add(emuName);
        }
        Collections.sort(this.simfEmuList);
        this.ssEmuList = new ArrayList<String>(ssEmuIDList.size());
        for (Integer ssEmuId : ssEmuIDList) {
            emuName = cvsUtil.getEmulationTypeName(ssEmuId);
            this.ssEmuList.add(emuName);
        }
        Collections.sort(this.ssEmuList);
        this.dsEmuList = new ArrayList<String>(dsEmuIDList.size());
        for (Integer dsEmuId : dsEmuIDList) {
            emuName = cvsUtil.getEmulationTypeName(dsEmuId);
            this.dsEmuList.add(emuName);
        }
        Collections.sort(this.dsEmuList);
        this.refEmulationType(cpType);
        if (selectEmu != -1) {
            this.setSelection(Integer.toHexString(selectEmu));
        }
    }

    public void refEmulationType(int cpType) {
        this.selCpType = cpType;
        this.removeAllItems();
        SJctrComCVSUtility cvsUtil = this.getComUtility().getCVSUtility();
        List<String> emuList = this.getUsableEmulationList(cpType);
        for (String emuName : emuList) {
            int emuID = cvsUtil.getEmu(emuName);
            this.addItem(Integer.toHexString(emuID), emuName);
        }
        if (!this.setSelection(Integer.toHexString(625))) {
            this.setSelectedIndex(0);
        }
    }

    private List<String> getUsableEmulationList(int cpType) {
        List<String> retList;
        switch (cpType) {
            case 1: {
                retList = this.siEmuList;
                break;
            }
            case 0: {
                retList = this.simfEmuList;
                break;
            }
            case 2: {
                retList = this.ssEmuList;
                break;
            }
            case 3: {
                retList = this.dsEmuList;
                break;
            }
            default: {
                retList = new ArrayList<String>(0);
            }
        }
        return retList;
    }

    public int getSelectEmulationType() {
        int ret = -1;
        String selection = this.getSelection();
        if (selection != null) {
            ret = Integer.valueOf(selection, 16);
        }
        return ret;
    }

    public void initListener() {
        if (this.itemSelectListener == null) {
            this.itemSelectListener = new SJctrItemSelectListener(){

                @Override
                public void selectChanged(SJctrItemSelectEvent<?> event) {
                    if (event.isSelect()) {
                        SJctrEmulationTypeDataModel.this.fireMessageEvent(SJctrSelectPairConfigDC.CREATEPAIR_MSG.CHG_EMUTYPE);
                    }
                }
            };
            this.addItemSelectListener(this.itemSelectListener);
        }
    }

    public boolean isUseNormalVol() {
        boolean ret = true;
        if (this.selCpType == 0) {
            int emuId = this.getSelectEmulationType();
            int index = Collections.binarySearch(this.simfEmuIDList, emuId);
            ret = index >= 0;
        }
        return ret;
    }

    public boolean isUseFiconUVMVol() {
        boolean ret = false;
        if (this.selCpType == 0) {
            int emuId = this.getSelectEmulationType();
            int index = Collections.binarySearch(this.mgEmuIDList, emuId);
            ret = index >= 0;
        }
        return ret;
    }
}

