/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetClprInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLdevDetail;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.system.SJmoClprIndex;
import sanproject.sn2.model.data.system.SJmoClprInfo;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrClprColumnFromPortLunDetail
extends SJctrColumn {
    protected SJmoLdevIndex ldevIndex = new SJmoLdevIndex();

    public SJctrClprColumnFromPortLunDetail(String key) {
        super(key);
        this.setPartsId("CLPR");
    }

    @Override
    public int getSortType() {
        return 2;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortLunInfo.class);
        list.add(SJmoGetLdevDetail.class);
        list.add(SJmoGetClprInfo.class);
        return list;
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<SJmoClprInfo> list = new ArrayList<SJmoClprInfo>();
        SJmoPortLunDetail luPathInfo = (SJmoPortLunDetail)index;
        this.ldevIndex.setLdevIndex(luPathInfo.getSLDKC(), luPathInfo.getSCU(), luPathInfo.getSLDEV());
        SJmoClprInfo clprInfo = this.getClprInfo(this.ldevIndex, modelData);
        list.add(clprInfo);
        return list;
    }

    protected SJmoClprInfo getClprInfo(SJmoLdevIndex ldevIndex, Map<Class<?>, List<?>> modelData) {
        SJmoClprInfo clprInfo = null;
        List<?> ldevDtlList = modelData.get(SJmoGetLdevDetail.class);
        int searchLdev = Collections.binarySearch(ldevDtlList, ldevIndex);
        if (searchLdev >= 0) {
            SJmoLdevDetail ldevDtl = (SJmoLdevDetail)ldevDtlList.get(searchLdev);
            SJmoClprIndex clprIndex = new SJmoClprIndex();
            short clpr = ldevDtl.getSCLPR();
            clprIndex.setSClpr(clpr);
            List<?> clprInfoList = modelData.get(SJmoGetClprInfo.class);
            int searchClpr = Collections.binarySearch(clprInfoList, clprIndex);
            if (searchClpr >= 0) {
                clprInfo = (SJmoClprInfo)clprInfoList.get(searchClpr);
            }
        }
        return clprInfo;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "";
        if (!dataList.isEmpty()) {
            SJmoClprInfo clprInfo = (SJmoClprInfo)dataList.get(0);
            SJctrLdevUtility util = this.getTable().getComUtility().getLdevUtility();
            ret = util.toClprDisplay(clprInfo);
        }
        return ret;
    }
}

