/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs.column;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.controller.com.comparator.SJctrLdevIndexComparator;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrLdevIDColumnFromPortLunDetail
extends SJctrColumn {
    private SJctrLdevIndexComparator objectComp = null;
    private Map<Integer, SJmoLdevIndex> ldevMap = null;
    private SJmoLdevIndex defaultLdev = new SJmoLdevIndex();

    public SJctrLdevIDColumnFromPortLunDetail(String key) {
        super(key);
        this.setPartsId("LDEV_ID");
        this.objectComp = new SJctrLdevIndexComparator();
    }

    @Override
    public int getFilterType() {
        return 16;
    }

    @Override
    public int getSortType() {
        return 3;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortLunInfo.class);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        SJmoPortLunDetail luPathInfo = (SJmoPortLunDetail)dataList.get(0);
        SJctrLdevUtility util = this.getTable().getComUtility().getLdevUtility();
        return util.toLdevDisplay(luPathInfo);
    }

    @Override
    protected Object getObject(Map<String, Object> dat) {
        SJmoPortLunDetail luPathInfo = (SJmoPortLunDetail)this.getPrimaryKeyObject(dat);
        return this.getLdevIndex(luPathInfo);
    }

    protected SJmoLdevIndex getLdevIndex(SJmoPortLunDetail luPathInfo) {
        if (this.ldevMap == null) {
            this.ldevMap = new HashMap<Integer, SJmoLdevIndex>(this.getTable().getRowCount());
        }
        if (luPathInfo == null) {
            return this.defaultLdev;
        }
        int indexKey = SJctrReplicationUtility.getLdevIndexKey(luPathInfo);
        SJmoLdevIndex ldev = this.ldevMap.get(indexKey);
        if (ldev == null) {
            ldev = new SJmoLdevIndex();
            ldev.setLdevIndex(luPathInfo.getSLDKC(), luPathInfo.getSCU(), luPathInfo.getSLDEV());
            this.ldevMap.put(indexKey, ldev);
        }
        return ldev;
    }

    @Override
    protected Comparator<Object> createObjectComparator() {
        return this.objectComp;
    }
}

