/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs.column;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sanproject.sn2.base.session.inf.SJbaseUserSessionInterface;
import sanproject.sn2.controller.com.SJctrComUtility;
import sanproject.sn2.controller.com.SJctrPortUtility;
import sanproject.sn2.controller.com.column.SJctrColumn;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.kind.SJmoGetPortLunInfo;
import sanproject.sn2.model.data.lu.SJmoPortLunDetail;

public class SJctrLunIDColumnFromPortLunDetail
extends SJctrColumn {
    private boolean bLunIdDec;

    public SJctrLunIDColumnFromPortLunDetail(String key) {
        super(key);
        this.setPartsId("LUN_ID");
    }

    @Override
    public void initGuidance(SJctrComUtility util) {
        super.initGuidance(util);
        this.setBLunIdDec(this.isLunIdNotationDec());
    }

    @Override
    public int getSortType() {
        return 1;
    }

    @Override
    public int getFilterType() {
        return 0;
    }

    @Override
    public String getInputFormat() {
        String ret = this.bLunIdDec ? "^\\d{1,19}$" : "^([0-9A-Fa-f]{1,4})$";
        return ret;
    }

    @Override
    public List<Class<? extends SJmoGetKind_IF>> getNeedModelKind() {
        ArrayList<Class<? extends SJmoGetKind_IF>> list = new ArrayList<Class<? extends SJmoGetKind_IF>>();
        list.add(SJmoGetPortLunInfo.class);
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "";
        if (!dataList.isEmpty()) {
            SJmoPortLunDetail luPathInfo = (SJmoPortLunDetail)dataList.get(0);
            ret = this.bLunIdDec ? SJctrComUtility.toDecString(luPathInfo.getSLUN()) : SJctrComUtility.toHexString(luPathInfo.getSLUN(), 4, true);
        }
        return ret;
    }

    @Override
    protected long getNumber(Map<String, Object> dat) {
        int lun = -1;
        SJmoPortLunDetail luPathInfo = (SJmoPortLunDetail)this.getPrimaryKeyObject(dat);
        if (luPathInfo != null) {
            lun = luPathInfo.getSLUN();
        }
        return lun;
    }

    private boolean isLunIdNotationDec() {
        boolean bRet = false;
        SJbaseUserSessionInterface userSession = this.getTable().getDataController().getOwner().getUserSession();
        bRet = SJctrPortUtility.isLunIdDecimal(userSession);
        return bRet;
    }

    public void setBLunIdDec(boolean bLunIdDec) {
        this.bLunIdDec = bLunIdDec;
    }
}

