/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import sanproject.sn2.controller.com.SJctrLdevUtility;
import sanproject.sn2.controller.com.SJctrReplicationUtility;
import sanproject.sn2.controller.com.column.replication.SJctrPairTopologyIDColumnFromPairVolInfo;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateSnapshotDataInfo;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.connector.kind.SJmoGetTiPvolStatus;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolInfo;
import sanproject.sn2.model.data.replication.local.SJmoTiPvolStatus;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrPairTopologyIDColumnFromLdevDetail
extends SJctrPairTopologyIDColumnFromPairVolInfo {
    public SJctrPairTopologyIDColumnFromLdevDetail(String key) {
        super(key);
        this.setPartsId("TI_PAIR_TOPOLOGY_ID");
    }

    @Override
    public List<?> getNeedModelData(Object index, Map<Class<?>, List<?>> modelData) {
        ArrayList<Object> list = new ArrayList<Object>();
        SJmoLdevIndex ldevIndex = (SJmoLdevIndex)index;
        SJmoTiPvolStatus tiPVolStatus = (SJmoTiPvolStatus)modelData.get(SJmoGetTiPvolStatus.class).get(0);
        Object[] tiPVolArray = tiPVolStatus.getTiPvolInfo();
        int rootIndex = Arrays.binarySearch(tiPVolArray, ldevIndex);
        if (rootIndex >= 0) {
            Object rootInfo = tiPVolArray[rootIndex];
            list.add(rootInfo);
        } else {
            list.add(null);
        }
        SJmoLocalReplicationPairVolInfoMgr pairMgr = (SJmoLocalReplicationPairVolInfoMgr)modelData.get(SJmoGetLocalReplicationPairVolInfoMgr.class).get(0);
        SJmoLocalReplicationPairVolInfo pairVolInfo = pairMgr.getLocalReplicationPairVolInfo(ldevIndex);
        if (pairVolInfo != null && pairVolInfo.isVolPos(0x800000)) {
            list.add(pairVolInfo);
            list.add(pairMgr);
        } else {
            list.add(null);
            list.add(null);
        }
        List<?> ssDataInfoList = modelData.get(SJctrCreateSnapshotDataInfo.class);
        if (ssDataInfoList != null && ssDataInfoList.size() > 0) {
            for (Object ssDataInfo : ssDataInfoList) {
                SJctrCreateSnapshotDataInfo ssData = (SJctrCreateSnapshotDataInfo)ssDataInfo;
                if (ssData.getIndex() != ldevIndex.getIndex()) continue;
                list.add(ssDataInfo);
                break;
            }
        }
        if (list.size() == 3) {
            list.add(null);
        }
        return list;
    }

    @Override
    public String toDispString(List<?> dataList) {
        String ret = "?";
        if (dataList != null && dataList.size() >= 4) {
            SJctrLdevUtility ldevUtil = this.getTable().getComUtility().getLdevUtility();
            SJmoTiPvolInfo rootLdevInfo = (SJmoTiPvolInfo)dataList.get(0);
            SJmoLocalReplicationPairVolInfo pairInfo = (SJmoLocalReplicationPairVolInfo)dataList.get(1);
            SJmoLocalReplicationPairVolInfoMgr pairInfoMgr = (SJmoLocalReplicationPairVolInfoMgr)dataList.get(2);
            SJctrCreateSnapshotDataInfo createSnapshotDataInfo = (SJctrCreateSnapshotDataInfo)dataList.get(3);
            if (rootLdevInfo != null) {
                ret = ldevUtil.toLdevDisplay(rootLdevInfo);
            } else if (pairInfo != null && pairInfoMgr != null) {
                if (pairInfo.isVolPos(0x800000) && !pairInfo.isVolPos(0x400000) && pairInfo.isBClone() && createSnapshotDataInfo != null) {
                    ret = ldevUtil.toLdevDisplay(pairInfo);
                } else {
                    SJctrReplicationUtility replicaUty = this.getTable().getComUtility().getReplicationUtility();
                    ret = replicaUty.getPairTopologyIdStringForPairInfo(pairInfo, pairInfoMgr, ldevUtil);
                }
            } else {
                ret = createSnapshotDataInfo != null ? ldevUtil.toLdevDisplay(createSnapshotDataInfo) : "";
            }
        }
        return ret;
    }
}

