/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.createtipairs.selectpvol;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sanproject.sn2.controller.com.model.SJctrSimpleDataModel;
import sanproject.sn2.controller.com.model.SJctrTextBoxDataModel;
import sanproject.sn2.controller.wizard.replication.local.createtipairs.SJctrCreateTIPairUtility;

public class SJctrCreateNewSSGrpDataModel
extends SJctrSimpleDataModel {
    private final String KEY_PREFIX = "COM_PREFIX";
    private final String KEY_INITNUM = "COM_INITNUM";
    private final Pattern PTN_SS_Grp_PreFixName = Pattern.compile("[0-9a-zA-Z,-./:@\\\\_]{0,32}");
    private final Pattern PTN_SS_Grp_InitialNum = Pattern.compile("[0-9]{0,9}");
    public static final int SNAPSHOTGROUP_NUM_MIN = 1;
    public static final int CREATE_SNAPSHOTGROUP_NUM_MAX = 1024;
    public static final int SNAPSHOTGROUP_LEN_MIN = 1;
    public static final int SNAPSHOTGROUP_LEN_MAX = 32;
    private SJctrTextBoxDataModel prefixTextBox = new SJctrTextBoxDataModel();
    private SJctrTextBoxDataModel initialNumTextBox = null;

    public SJctrCreateNewSSGrpDataModel() {
        this.addDataModel("COM_PREFIX", this.prefixTextBox);
        this.initialNumTextBox = new SJctrTextBoxDataModel();
        this.addDataModel("COM_INITNUM", this.initialNumTextBox);
    }

    private int getSnapshotGroupMaxNum(int ssGrpNum) {
        int maxNum = 2048;
        if ((maxNum -= ssGrpNum) < 0) {
            maxNum = 0;
        }
        return Math.min(maxNum, 1024);
    }

    public boolean checkInputData(int ssgrpNum) {
        int initNum_Len;
        int prefix_len;
        int total_Len;
        String strInitNum;
        boolean result = true;
        String prefix = this.prefixTextBox.getValue();
        if (!this.checkPattern(prefix, this.PTN_SS_Grp_PreFixName)) {
            SJctrCreateTIPairUtility.createError(105472);
        }
        if (!this.checkPattern(strInitNum = this.initialNumTextBox.getValue(), this.PTN_SS_Grp_InitialNum)) {
            SJctrCreateTIPairUtility.createError(105472);
        }
        if ((total_Len = (prefix_len = prefix.length()) + (initNum_Len = strInitNum.length())) < 1 || 32 < total_Len) {
            SJctrCreateTIPairUtility.createError(105472);
        }
        if (initNum_Len == 0 && 1 < ssgrpNum) {
            SJctrCreateTIPairUtility.createError(205087);
        }
        return result;
    }

    public String getPreFixValue() {
        return this.prefixTextBox.getValue();
    }

    public String getInitialNumValue() {
        return this.initialNumTextBox.getValue();
    }

    private boolean checkPattern(String value, Pattern ptn) {
        Matcher matcher = ptn.matcher(value);
        return matcher.matches();
    }
}

