/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.local.viewpairproperties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sanproject.serverux.dataimpl.MRCFgetPairInfEx;
import sanproject.serverux.dataimpl.MRCFgetPairLdev;
import sanproject.serverux.dataimpl.MRCFgetPairStatusEx;
import sanproject.serverux.dataimpl.MrcGetPairInf_Input;
import sanproject.serverux.dataimpl.MrcGetPairInf_Output;
import sanproject.serverux.dataimpl.SIgetPairFilter;
import sanproject.serverux.dataimpl.SIgetPairParam;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrDialogDataController;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrGetDirectWrapper;
import sanproject.sn2.controller.com.data.SJctrDataObject;
import sanproject.sn2.controller.com.model.SJctrDataObjectModel;
import sanproject.sn2.controller.com.model.event.SJctrMessageEvent;
import sanproject.sn2.controller.com.model.event.SJctrMessageEventListener;
import sanproject.sn2.controller.wizard.SJctrFooterDataModel;
import sanproject.sn2.controller.wizard.SJctrWizardDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrGetMRCFgetPairInf;
import sanproject.sn2.controller.wizard.replication.local.createpairs.SJctrCreatePairUtility;
import sanproject.sn2.controller.wizard.replication.local.viewpairproperties.SJctrPairPropertiesSummaryModel;
import sanproject.sn2.controller.wizard.replication.local.viewpairproperties.SJctrPairPropertiesTableModel;
import sanproject.sn2.model.connector.SJmoGetDirect;
import sanproject.sn2.model.connector.inf.SJmoGetKind_IF;
import sanproject.sn2.model.connector.inf.SJmoGetRange_IF;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualDkc;
import sanproject.sn2.model.connector.kind.SJmoGetHUVMVirtualLdev;
import sanproject.sn2.model.connector.kind.SJmoGetLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.SJmoThroughRmiData;
import sanproject.sn2.model.data.replication.SJmoReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.SJmoLocalReplicationPairVolInfo;
import sanproject.sn2.model.data.replication.local.manager.SJmoLocalReplicationPairVolInfoMgr;
import sanproject.sn2.model.data.util.SJmoDataUtility;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrViewPairPropertiesDC
extends SJctrDialogDataController {
    private static final int DISP_ID = 34664496;
    private static final String KEY_SUMMARY = "COM_SUMMARY";
    private static final String KEY_TABLE = "COM_TABLE";
    private static final String KEY_PAGE = "COM_PAGE";
    private static final String KEY_SELECTED_SVOL = "KEY_SELECTED_SVOL";
    private List<SJmoLdevIndex> sVolIndexList = null;
    protected List<SJmoLocalReplicationPairVolInfo> selectPairSVolList = null;
    private SJctrPairPropertiesSummaryModel summaryModel = null;
    protected SJctrPairPropertiesTableModel tableModel = null;
    protected SJmoLocalReplicationPairVolInfoMgr pairVolMgr = null;
    protected int dispPageIndex = 0;
    protected int tortalPageNum = 0;
    private final int EC_LREPLICA_INFO_CONTRADICTION = 106534;
    protected Map<Integer, List<SJmoLocalReplicationPairVolInfo>> relationPairsMap = null;
    public static final short PP_SI_CLIENT = -32756;
    private List<Integer> siPVolList = null;
    private List<SJmoLdevIndex> qsSVolList = null;

    public SJctrViewPairPropertiesDC() throws SJcException {
        super(34664496);
        this.initDataModel();
        this.initListener();
    }

    private void initDataModel() {
        this.summaryModel = new SJctrPairPropertiesSummaryModel();
        this.addDataObjectModel(KEY_SUMMARY, this.summaryModel);
        this.tableModel = new SJctrPairPropertiesTableModel();
        this.tableModel.setBasicDataList(new ArrayList());
        this.addDataObjectModel(KEY_TABLE, this.tableModel);
        this.addDataObjectModel("COM_FOOTER", new SJctrFooterDataModel(Collections.unmodifiableSet(EnumSet.of(SJctrFooterDataModel.Button.BACK, SJctrFooterDataModel.Button.NEXT, SJctrFooterDataModel.Button.CLOSE))));
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        List<?> cacheList = this.getCache(KEY_SELECTED_SVOL);
        if (cacheList == null || cacheList.isEmpty()) {
            SJctrError err = new SJctrError(209, 22, 107001);
            SJcException exp = err.createException();
            throw exp;
        }
        this.sVolIndexList = cacheList;
        return ret;
    }

    @Override
    public boolean checkConstructData() {
        boolean ret = true;
        List<?> pairVolMgrList = this.getCache(SJmoGetLocalReplicationPairVolInfoMgr.class);
        if (pairVolMgrList == null || pairVolMgrList.size() == 0) {
            SJctrError err = new SJctrError(209, 22, 107002);
            SJcException exp = err.createException();
            throw exp;
        }
        this.pairVolMgr = (SJmoLocalReplicationPairVolInfoMgr)pairVolMgrList.get(0);
        this.selectPairSVolList = new ArrayList<SJmoLocalReplicationPairVolInfo>(this.sVolIndexList.size());
        for (SJmoLdevIndex sVolIndex : this.sVolIndexList) {
            SJmoLocalReplicationPairVolInfo pairInfo = this.pairVolMgr.getLocalReplicationPairVolInfo(sVolIndex);
            if (pairInfo == null) {
                SJctrError err = new SJctrError(209, 22, 106534);
                SJcException exp = err.createException();
                throw exp;
            }
            if (pairInfo.getPVolIndex() == null) {
                SJctrError err = new SJctrError(209, 22, 106534);
                SJcException exp = err.createException();
                throw exp;
            }
            this.selectPairSVolList.add(pairInfo);
        }
        return ret;
    }

    @Override
    public void makeDataModel() {
        super.makeDataModel();
        this.initProperties();
    }

    protected void initProperties() {
        this.dispPageIndex = 0;
        this.tortalPageNum = this.selectPairSVolList.size();
        this.relationPairsMap = new HashMap<Integer, List<SJmoLocalReplicationPairVolInfo>>(this.tortalPageNum);
        this.siPVolList = new ArrayList<Integer>();
        this.qsSVolList = new ArrayList<SJmoLdevIndex>();
        for (int pageIndex = 0; pageIndex < this.tortalPageNum; ++pageIndex) {
            SJmoLocalReplicationPairVolInfo dispPair = this.selectPairSVolList.get(pageIndex);
            List<SJmoLocalReplicationPairVolInfo> relationPairList = this.getRelationPairInfoList(dispPair);
            this.relationPairsMap.put(pageIndex, relationPairList);
        }
        Collections.sort(this.siPVolList);
        Collections.sort(this.qsSVolList);
        List<SJmoLocalReplicationPairVolInfo> directPairList = this.getDirectPairInfo(this.siPVolList, this.qsSVolList);
        this.tableModel.setBasicData(SJctrGetMRCFgetPairInf.class, directPairList);
        this.refDataModel();
    }

    private void initListener() {
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.BACK, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrViewPairPropertiesDC.this.backAction();
            }
        });
        this.addMessageEventListener(SJctrWizardDataController.WIZ_MSG.NEXT, new SJctrMessageEventListener(){

            @Override
            public void doMessageAction(SJctrMessageEvent event, SJctrDataObjectModel<?> dstModel) {
                SJctrViewPairPropertiesDC.this.nextAction();
            }
        });
    }

    private void backAction() {
        if (this.dispPageIndex <= 0) {
            return;
        }
        --this.dispPageIndex;
        this.refDataModel();
    }

    private void nextAction() {
        if (this.dispPageIndex + 1 >= this.tortalPageNum) {
            return;
        }
        ++this.dispPageIndex;
        this.refDataModel();
    }

    protected void refDataModel() {
        this.setDispPage();
        this.updateFooter();
        SJmoLocalReplicationPairVolInfo dispPair = this.selectPairSVolList.get(this.dispPageIndex);
        List<SJmoLocalReplicationPairVolInfo> relationPairList = this.relationPairsMap.get(this.dispPageIndex);
        if (relationPairList == null) {
            relationPairList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        }
        SJmoLocalReplicationPairVolInfo mostRecentSSPair = this.getMostRecentSSPair(relationPairList);
        this.summaryModel.makeSummary(dispPair, mostRecentSSPair);
        this.tableModel.setBasicDataList(relationPairList);
        this.tableModel.doRefresh();
    }

    @Override
    protected void updateFooter() {
        super.updateFooter();
        SJctrFooterDataModel footer = (SJctrFooterDataModel)this.getDataObjectModel("COM_FOOTER");
        if (this.dispPageIndex > 0 && this.dispPageIndex < this.tortalPageNum) {
            footer.setEnableButton(SJctrFooterDataModel.Button.BACK, true);
        } else {
            footer.setEnableButton(SJctrFooterDataModel.Button.BACK, false);
        }
        if (this.dispPageIndex >= 0 && this.dispPageIndex + 1 < this.tortalPageNum) {
            footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, true);
        } else {
            footer.setEnableButton(SJctrFooterDataModel.Button.NEXT, false);
        }
    }

    private List<SJmoLocalReplicationPairVolInfo> getRelationPairInfoList(SJmoLocalReplicationPairVolInfo pairInfo) {
        int index;
        ArrayList<SJmoLocalReplicationPairVolInfo> relationPairList = new ArrayList<SJmoLocalReplicationPairVolInfo>();
        int chkCopyTypeBit = 0;
        if (pairInfo.isVolPos(8)) {
            chkCopyTypeBit = 8;
        } else if (pairInfo.isVolPos(256)) {
            chkCopyTypeBit = 256;
        } else if (pairInfo.isVolPos(0x800000)) {
            chkCopyTypeBit = 0x800000;
        }
        SJmoLdevIndex pVolIndex = pairInfo.getPVolIndex();
        SJmoReplicationPairVolInfo pVolPairInfo = null;
        if (pairInfo.isVolPos(0x800000)) {
            pVolPairInfo = this.pairVolMgr.getLocalReplicationPairVolInfo(pVolIndex);
        } else {
            while (pVolIndex != null && !SJctrCreatePairUtility.isInvalidIndex(pVolIndex)) {
                pVolPairInfo = this.pairVolMgr.getLocalReplicationPairVolInfo(pVolIndex);
                pVolIndex = pVolPairInfo.getPVolIndex();
            }
        }
        ArrayList<? extends SJmoLdevIndex> sVolIndexList = pVolPairInfo.getAlSVolIndex();
        if ((pVolPairInfo.isVolPos(128) || pVolPairInfo.isVolPos(4)) && !this.siPVolList.contains(index = pVolPairInfo.getIndex())) {
            this.siPVolList.add(index);
        }
        for (SJmoLdevIndex sJmoLdevIndex : sVolIndexList) {
            int index2;
            SJmoLocalReplicationPairVolInfo sVolPairInfo = this.pairVolMgr.getLocalReplicationPairVolInfo(sJmoLdevIndex);
            if (sVolPairInfo.isVolPos(chkCopyTypeBit)) {
                relationPairList.add(sVolPairInfo);
                if (sVolPairInfo.isVolPos(0x800000) && !this.qsSVolList.contains(sVolPairInfo)) {
                    this.qsSVolList.add(sVolPairInfo);
                }
            }
            if (!pairInfo.isVolPos(8)) continue;
            ArrayList<? extends SJmoLdevIndex> l2SVolIndexList = sVolPairInfo.getAlSVolIndex();
            if ((sVolPairInfo.isVolPos(128) || sVolPairInfo.isVolPos(4)) && !this.siPVolList.contains(index2 = sVolPairInfo.getIndex())) {
                this.siPVolList.add(index2);
            }
            for (SJmoLdevIndex sJmoLdevIndex2 : l2SVolIndexList) {
                SJmoLocalReplicationPairVolInfo l2SVolPairInfo = this.pairVolMgr.getLocalReplicationPairVolInfo(sJmoLdevIndex2);
                if (!l2SVolPairInfo.isVolPos(chkCopyTypeBit)) continue;
                relationPairList.add(l2SVolPairInfo);
                if (!l2SVolPairInfo.isVolPos(0x800000) || this.qsSVolList.contains(l2SVolPairInfo)) continue;
                this.qsSVolList.add(l2SVolPairInfo);
            }
        }
        return relationPairList;
    }

    @Override
    public Set<SJctrGetDirectWrapper> getModelDirect() {
        Set<SJctrGetDirectWrapper> set = super.getModelDirect();
        SJmoGetKind_IF kind = new SJmoGetLocalReplicationPairVolInfoMgr();
        SJmoGetRange_IF range = null;
        ArrayList filterList = new ArrayList();
        SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
        set.add(new SJctrGetDirectWrapper(direct));
        kind = new SJmoGetHUVMVirtualDkc();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        SJctrGetDirectWrapper wrapper = new SJctrGetDirectWrapper(direct, false);
        set.add(wrapper);
        kind = new SJmoGetHUVMVirtualLdev();
        range = null;
        filterList = new ArrayList();
        direct = new SJmoGetDirect(kind, range, filterList);
        wrapper = new SJctrGetDirectWrapper(direct, false);
        set.add(wrapper);
        return set;
    }

    private SJmoLocalReplicationPairVolInfo getMostRecentSSPair(List<SJmoLocalReplicationPairVolInfo> pairList) {
        SJmoLocalReplicationPairVolInfo mostRecentPair = null;
        Date mostRecentDate = null;
        for (SJmoLocalReplicationPairVolInfo pair : pairList) {
            if (!pair.isVolPos(0x800000)) continue;
            if (mostRecentPair == null) {
                mostRecentPair = pair;
                mostRecentDate = mostRecentPair.getSnapShotDate();
                continue;
            }
            Date date = pair.getSnapShotDate();
            if (date == null) continue;
            if (mostRecentDate == null) {
                mostRecentPair = pair;
                mostRecentDate = date;
                continue;
            }
            if (mostRecentDate.compareTo(date) >= 0) continue;
            mostRecentPair = pair;
            mostRecentDate = date;
        }
        return mostRecentPair;
    }

    private String setDispPage() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.dispPageIndex + 1);
        buf.append(" / ");
        buf.append(this.tortalPageNum);
        String dispStr = buf.toString();
        SJctrDataObject mgrData = this.getManageData();
        mgrData.setData(KEY_PAGE, dispStr);
        return dispStr;
    }

    protected List<SJmoLocalReplicationPairVolInfo> getDirectPairInfo(List<Integer> siPVolList, List<SJmoLdevIndex> qsPVolList) {
        ArrayList<SJmoLocalReplicationPairVolInfo> retList = new ArrayList<SJmoLocalReplicationPairVolInfo>(siPVolList.size() * 9 + qsPVolList.size());
        if (!siPVolList.isEmpty()) {
            int getSuccessNum;
            int getStartIndex = 0;
            int ldevNum = siPVolList.size();
            do {
                int getNum = 0;
                getNum = ldevNum > 4096 ? 4096 : ldevNum;
                SIgetPairParam siPairParam = new SIgetPairParam();
                siPairParam.setSTgtPp((short)-32756);
                SIgetPairFilter siPairFilter = new SIgetPairFilter();
                int[] iSiLdevArray = SJmoDataUtility.intArrayCast(siPVolList.subList(getStartIndex, getStartIndex + getNum));
                siPairFilter.setLDEVIndex(iSiLdevArray);
                siPairParam.setSiFlt(siPairFilter);
                MrcGetPairInf_Input siInput = new MrcGetPairInf_Input(siPairParam);
                SJctrGetMRCFgetPairInf kind = new SJctrGetMRCFgetPairInf(siInput);
                SJmoGetRange_IF range = null;
                ArrayList filterList = new ArrayList();
                SJmoGetDirect direct = new SJmoGetDirect(kind, range, filterList);
                SJctrGetDirectWrapper directWrapper = new SJctrGetDirectWrapper(direct, false);
                SJmoThroughRmiData siPairInfo = (SJmoThroughRmiData)this.getModelData(directWrapper).get(0);
                MrcGetPairInf_Output outPut = (MrcGetPairInf_Output)siPairInfo.getObjRmi();
                MRCFgetPairStatusEx PairInf = outPut.getInf();
                MRCFgetPairLdev[] siPairLdevInfList = (MRCFgetPairLdev[])PairInf.getPairLdev();
                getSuccessNum = 0;
                for (int isiPairLdevCnt = 0; isiPairLdevCnt < siPairLdevInfList.length; ++isiPairLdevCnt) {
                    MRCFgetPairLdev siPairLdevInf = siPairLdevInfList[isiPairLdevCnt];
                    ArrayList pairInfoList = siPairLdevInf.getAlPairInf();
                    if ((4 & siPairLdevInf.getVolAtrb()) != 0) {
                        if (pairInfoList.isEmpty()) {
                            break;
                        }
                    } else {
                        ++getSuccessNum;
                        continue;
                    }
                    ++getSuccessNum;
                    for (MRCFgetPairInfEx pairInfo : pairInfoList) {
                        SJmoLocalReplicationPairVolInfo siDirectPairInfo = (SJmoLocalReplicationPairVolInfo)SJmoDataUtility.makeModelObject(pairInfo);
                        SJmoLocalReplicationPairVolInfo olgPairInfo = this.pairVolMgr.getLocalReplicationPairVolInfo(siDirectPairInfo);
                        if (olgPairInfo == null) continue;
                        if (olgPairInfo.isVolPos(8)) {
                            siDirectPairInfo.setIPairVolPos(8);
                        } else if (olgPairInfo.isVolPos(256)) {
                            siDirectPairInfo.setIPairVolPos(256);
                        }
                        retList.add(siDirectPairInfo);
                    }
                }
                if (getSuccessNum <= 0) {
                    this.logUty.putlog("getDirectPairInfo", "MrcGetPairInf_Input get Failed. LDEV ID = 0x" + Integer.toHexString(iSiLdevArray[0]));
                    break;
                }
                getStartIndex += getSuccessNum;
            } while ((ldevNum -= getSuccessNum) > 0);
        }
        Collections.sort(retList);
        return retList;
    }
}

