/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.addremoteconn.com;

import com.hitachi.sanproject.data.SanDataException;
import com.hitachi.sanproject.data.SanList;
import com.hitachi.sanproject.data.SanObject;
import com.hitachi.sanproject.rmi.SanRequest;
import com.hitachi.sanproject.rmi.SanResponse;
import java.util.ArrayList;
import java.util.List;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrLogUty;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcIscsiPathsOperationError;
import sanproject.sn2.controller.wizard.replication.com.SJctrRemoteConnectionApplyControllerBase;
import sanproject.sn2.controller.wizard.replication.remote.addremoteconn.com.SJctrRemoteReplicationTargetPathInfo;
import sanproject.sn2.datasupplier.SJdsSupplierAgent;
import sanproject.sn2.model.inf.SJmoKeyValueDefine_IF;

public abstract class SJctrRemoteConnectionTargetPathApplyControllerBase
extends SJctrRemoteConnectionApplyControllerBase
implements SJmoKeyValueDefine_IF {
    private static final long serialVersionUID = 6500021554621354216L;
    protected List<SJctrRemoteReplicationTargetPathInfo> targetPathInfo = new ArrayList<SJctrRemoteReplicationTargetPathInfo>();
    protected int portType = -1;
    protected static final int ERROR_PART_DIGIT = 100;
    protected static final int REMOTE_REPLICATION_FUNCTION = 1;

    @Override
    protected void applyStart(SJdsSupplierAgent supplier) {
        if (supplier == null) {
            SJctrLogUty.info(this.title, "applyStart", "SJdsSupplierAgent is null.");
            throw new NullPointerException();
        }
        try {
            if (this.portType == 1) {
                ArrayList<SanRequest> createIscsiRetList = this.getSetTargetInfoList(supplier);
                SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (iSCSIcreateiScsiPaths)");
                Object createIscsiTarget = supplier.applyStart(this.getLockId(), createIscsiRetList);
                SanResponse createiScsiPathsResponse = (SanResponse)createIscsiTarget;
                SJctrLogUty.info(this.title, "applyStart", "Apply End!! (iSCSIcreateiScsiPaths)");
                this.setApplyResult(createiScsiPathsResponse);
            }
            if (this.resultData == null || this.resultData.isEmpty()) {
                ArrayList<?> setAddList = this.getSetList();
                SJctrLogUty.info(this.title, "applyStart", "Apply Start!! (RMCPConnections add)");
                Object resultObject = supplier.applyStart(this.getLockId(), setAddList);
                SJctrLogUty.info(this.title, "applyStart", "Apply End!! (RMCPConnections add)");
                super.setApplyResult(resultObject);
            }
        }
        catch (Exception e) {
            SJctrError error = SJctrError.parseError(e);
            this.setError(error);
        }
    }

    public ArrayList<SanRequest> getSetTargetInfoList(SJdsSupplierAgent supplier) throws SanDataException {
        SanRequest requestData = supplier.newRequest("iSCSIcreateiScsiPaths");
        requestData.putBoolean("ConnectionTest", false);
        SanList iscsiPathsList = requestData.newList("iScsiPaths");
        for (SJctrRemoteReplicationTargetPathInfo targetInfo : this.targetPathInfo) {
            SanObject iScsiPathsObj = iscsiPathsList.addObj();
            SanObject iScsiPort = iScsiPathsObj.newObj("iScsiPort");
            iScsiPort.putInt("Id", (int)targetInfo.getSPort());
            int ipType = targetInfo.getIIpType();
            SanObject remoteiScsiPort = iScsiPathsObj.newObj("RemoteiScsiPort");
            remoteiScsiPort.putInt("Function", 1);
            remoteiScsiPort.putInt("IpType", ipType);
            if (ipType == 0) {
                remoteiScsiPort.putIntArray("Ipv4Address", targetInfo.getIIpv4Address());
            } else {
                remoteiScsiPort.putIntArray("Ipv6Address", targetInfo.getIIpv6Address());
            }
            remoteiScsiPort.putInt("TcpPortNumber", targetInfo.getITcpPortNumber());
            SanObject remoteiScsiTarget = remoteiScsiPort.newObj("RemoteiScsiTarget");
            remoteiScsiTarget.putString("Name", targetInfo.getStrTargetName());
        }
        ArrayList<SanRequest> applyList = new ArrayList<SanRequest>(1);
        applyList.add(requestData);
        return applyList;
    }

    @Override
    protected void setApplyResult(Object resultObject) {
        SJctrError error = new SJctrError(210, 22, 0);
        this.resultData = new ArrayList();
        try {
            if (!(resultObject instanceof SanResponse)) {
                SJctrLogUty.error(this.title, "setApplyResult", "The instance is not SanResponse type.");
                error.setError(107001);
                this.setError(error);
            } else {
                this.setRepError((SanResponse)resultObject, error);
                if (this.getError().getError() != 0) {
                    this.setDetailError((SanResponse)resultObject);
                }
            }
            if (this.resultData.size() > 0) {
                this.setError((SJctrError)this.resultData.get(0));
            } else {
                this.setError(new SJctrError(210, 22, 0));
            }
        }
        catch (SanDataException sdEx) {
            SJctrLogUty.error(this.title, "setApplyResult", "The error occurred during generating SJctrError from SanResponse." + sdEx.getMessage());
            error = SJctrError.parseError((Exception)((Object)sdEx));
            this.setError(error);
        }
    }

    private void setRepError(SanResponse responseObject, SJctrError error) throws SanDataException {
        SanObject errInfo = responseObject.getObj("ErrorInfo");
        int[] errMsgId = errInfo.getIntArray("MessageId");
        if (0 != errMsgId[1]) {
            SJctrRcIscsiPathsOperationError iscsiError = new SJctrRcIscsiPathsOperationError(errMsgId);
            error = iscsiError;
        }
        this.setError(error);
    }

    protected void setDetailError(SanResponse responseObject) throws SanDataException {
        SanList iScsiPathsList = responseObject.getList("iScsiPaths");
        if (null == iScsiPathsList) {
            SJctrLogUty.info(this.title, "setDetailError", "iScsiPathsList is null.");
        } else {
            for (int i = 0; i < iScsiPathsList.size(); ++i) {
                SanObject iScsiPath = iScsiPathsList.getObj(i);
                SJctrRcIscsiPathsOperationError error = this.getOperationError(iScsiPath, i);
                if (error == null) continue;
                this.resultData.add(error);
            }
        }
    }

    private SJctrRcIscsiPathsOperationError getOperationError(SanObject iScsiPath, int index) throws SanDataException {
        SJctrRcIscsiPathsOperationError error = null;
        SanObject errorInfo = iScsiPath.getObj("ErrorInfo");
        int[] errMsgId = errorInfo.getIntArray("MessageId");
        if (0 != errMsgId[1]) {
            error = new SJctrRcIscsiPathsOperationError(errMsgId, index);
        }
        return error;
    }
}

