/*
 * Decompiled with CFR 0.152.
 */
package sanproject.sn2.controller.wizard.replication.remote.assignjournalvols;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sanproject.sn2.com.SJcException;
import sanproject.sn2.controller.com.SJctrError;
import sanproject.sn2.controller.com.SJctrErrorColumnData;
import sanproject.sn2.controller.com.SJctrErrorTableModel;
import sanproject.sn2.controller.com.SJctrRemoteReplicationUtility;
import sanproject.sn2.controller.com.comparator.SJctrErrorColumnDataComparator;
import sanproject.sn2.controller.com.model.SJctrTableDataModel;
import sanproject.sn2.controller.wizard.SJctrConfirmDataController;
import sanproject.sn2.controller.wizard.replication.com.SJctrLDEVDetailWithJnlInfo;
import sanproject.sn2.controller.wizard.replication.com.SJctrRcOperationErrorForJnlVol;
import sanproject.sn2.controller.wizard.replication.remote.assignjournalvols.SJctrAssignJournalVolsConfirmData;
import sanproject.sn2.controller.wizard.replication.remote.assignjournalvols.SJctrAssignJournalVolsSelConfirmTableDataModel;
import sanproject.sn2.controller.wizard.replication.remote.assignjournalvols.SJctrAssignJournalVolsTableDataModel;
import sanproject.sn2.controller.wizard.replication.remote.assignjournalvols.SJctrJournalIdTableDataModel;
import sanproject.sn2.model.data.volume.SJmoLdevDetail;
import sanproject.sn2.model.data.volume.SJmoLdevIndex;

public class SJctrAssignJournalVolsConfirmDC
extends SJctrConfirmDataController {
    private static final int DISP_ID = 17831231;
    private static final String KEY_CONF_TABLE_SEL_JNL = "COM_CONF_TABLE_SEL_JNL";
    private static final String KEY_CONF_TABLE_ASSIGNED_JNL_VOL = "COM_CONF_TABLE_ASSIGNED_JNL_VOL";
    private static final String KEY_CONF_TABLE_UNASSIGNED_JNL_VOL = "COM_CONF_TABLE_UNASSIGNED_JNL_VOL";

    public SJctrAssignJournalVolsConfirmDC() throws SJcException {
        super(17831231);
        this.initDataModel();
    }

    private void initDataModel() {
        SJctrJournalIdTableDataModel confirmJnlTable = new SJctrJournalIdTableDataModel();
        confirmJnlTable.setPaging(false);
        this.addDataObjectModel(KEY_CONF_TABLE_SEL_JNL, confirmJnlTable);
        SJctrAssignJournalVolsSelConfirmTableDataModel confirmAddTable = new SJctrAssignJournalVolsSelConfirmTableDataModel();
        confirmAddTable.setPaging(false);
        this.addDataObjectModel(KEY_CONF_TABLE_ASSIGNED_JNL_VOL, confirmAddTable);
        SJctrAssignJournalVolsSelConfirmTableDataModel confirmDelTable = new SJctrAssignJournalVolsSelConfirmTableDataModel();
        confirmDelTable.setPaging(false);
        confirmDelTable.setPaging(false);
        this.addDataObjectModel(KEY_CONF_TABLE_UNASSIGNED_JNL_VOL, confirmDelTable);
    }

    @Override
    public boolean checkStartData() {
        boolean ret = true;
        SJctrAssignJournalVolsConfirmData confirmData = null;
        List<?> confirmDataList = this.getCache(SJctrAssignJournalVolsConfirmData.class);
        if (null == confirmDataList) {
            this.logUty.putlog("checkStartData", "Confirmation data list is null.");
            SJctrError err = new SJctrError(210, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        if (0 == confirmDataList.size()) {
            this.logUty.putlog("checkStartData", "Size of confirmation data list is zero.");
            SJctrError err = new SJctrError(210, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        confirmData = (SJctrAssignJournalVolsConfirmData)confirmDataList.get(0);
        if (null == confirmData) {
            this.logUty.putlog("checkStartData", "Confirmation data is null.");
            SJctrError err = new SJctrError(210, 22, 107005);
            SJcException exp = err.createException();
            throw exp;
        }
        return ret;
    }

    @Override
    protected void makeDataObjectModel(Collection<String> keyList) throws SJcException {
        List<?> confirmDataList = this.getCache(SJctrAssignJournalVolsConfirmData.class);
        SJctrAssignJournalVolsConfirmData confirmData = (SJctrAssignJournalVolsConfirmData)confirmDataList.get(0);
        this.getProxy().getCacheMap().putAll(confirmData.getNeedDataMap());
        super.makeDataObjectModel(keyList);
    }

    @Override
    public boolean checkConstructData() {
        SJctrTableDataModel confirmJournalIdTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_CONF_TABLE_SEL_JNL);
        SJctrTableDataModel confirmAssignJournalVolsTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_CONF_TABLE_ASSIGNED_JNL_VOL);
        SJctrTableDataModel confirmUnassignJournalVolsTable = (SJctrTableDataModel)this.getDataObjectModel(KEY_CONF_TABLE_UNASSIGNED_JNL_VOL);
        SJctrAssignJournalVolsConfirmData confirmData = (SJctrAssignJournalVolsConfirmData)this.getProxy().getCache(SJctrAssignJournalVolsConfirmData.class).get(0);
        ((SJctrJournalIdTableDataModel)confirmJournalIdTable).setBasicDataList(confirmData.getJnlgInfo());
        if (confirmAssignJournalVolsTable instanceof SJctrAssignJournalVolsTableDataModel) {
            ((SJctrAssignJournalVolsTableDataModel)confirmAssignJournalVolsTable).setBasicDataList(confirmData.getAddJnlVolInfo());
        }
        if (confirmUnassignJournalVolsTable instanceof SJctrAssignJournalVolsTableDataModel) {
            ((SJctrAssignJournalVolsTableDataModel)confirmUnassignJournalVolsTable).setBasicDataList(confirmData.getRemoveJnlVolInfo());
        }
        return true;
    }

    @Override
    public Map<String, List<?>> getConfirmData() {
        HashMap retMap = new HashMap();
        List<?> confirmDataList = this.getCache(SJctrAssignJournalVolsConfirmData.class);
        retMap.put(SJctrAssignJournalVolsConfirmData.class.getName(), confirmDataList);
        return retMap;
    }

    @Override
    public void getConfirmWithStatus(List<Object> result) throws SJcException {
        SJctrAssignJournalVolsConfirmData confirmData = (SJctrAssignJournalVolsConfirmData)this.getProxy().getCache(SJctrAssignJournalVolsConfirmData.class).get(0);
        SJctrAssignJournalVolsTableDataModel confirmAssignedTable = (SJctrAssignJournalVolsTableDataModel)this.getDataObjectModel(KEY_CONF_TABLE_ASSIGNED_JNL_VOL);
        SJctrAssignJournalVolsTableDataModel confirmUnassignedTable = (SJctrAssignJournalVolsTableDataModel)this.getDataObjectModel(KEY_CONF_TABLE_UNASSIGNED_JNL_VOL);
        confirmAssignedTable.setBasicDataMap(confirmData.getNeedDataMap());
        confirmUnassignedTable.setBasicDataMap(confirmData.getNeedDataMap());
        confirmAssignedTable.setBasicDataList(confirmData.getAddJnlVolInfo());
        confirmUnassignedTable.setBasicDataList(confirmData.getRemoveJnlVolInfo());
        confirmAssignedTable.makeDataModel();
        confirmUnassignedTable.makeDataModel();
        List tempList = (List)result.get(0);
        List errorList = (List)tempList.get(0);
        ArrayList<SJctrErrorColumnData> errColumnAssignedList = new ArrayList<SJctrErrorColumnData>(errorList.size());
        ArrayList<SJctrErrorColumnData> errColumnUnassignedList = new ArrayList<SJctrErrorColumnData>(errorList.size());
        List<SJctrLDEVDetailWithJnlInfo> rowAssignedDataList = confirmData.getAddJnlVolInfo();
        List<SJctrLDEVDetailWithJnlInfo> rowUnassignedDataList = confirmData.getRemoveJnlVolInfo();
        Collections.sort(rowAssignedDataList);
        Collections.sort(rowUnassignedDataList);
        for (SJctrRcOperationErrorForJnlVol error : errorList) {
            SJmoLdevIndex ldevIndex = SJctrRemoteReplicationUtility.convertToLdevIndexFromInt(error.getLdevIndex());
            int assignIndex = Collections.binarySearch(rowAssignedDataList, ldevIndex);
            if (0 <= assignIndex) {
                SJmoLdevDetail ldevInfo = rowAssignedDataList.get(assignIndex);
                SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldevInfo, error);
                errColumnAssignedList.add(errColumn);
                continue;
            }
            int unAssignIndex = Collections.binarySearch(rowUnassignedDataList, ldevIndex);
            if (0 > unAssignIndex) continue;
            SJmoLdevDetail ldevInfo = rowUnassignedDataList.get(unAssignIndex);
            SJctrErrorColumnData errColumn = new SJctrErrorColumnData(ldevInfo, error);
            errColumnUnassignedList.add(errColumn);
        }
        SJctrErrorTableModel errAssignedTable = new SJctrErrorTableModel();
        SJctrErrorTableModel errUnassignedTable = new SJctrErrorTableModel();
        this.addDataObjectModel(KEY_CONF_TABLE_ASSIGNED_JNL_VOL, errAssignedTable);
        this.addDataObjectModel(KEY_CONF_TABLE_UNASSIGNED_JNL_VOL, errUnassignedTable);
        errAssignedTable.initialize(confirmAssignedTable, errColumnAssignedList, new SJctrErrorColumnDataComparator());
        errUnassignedTable.initialize(confirmUnassignedTable, errColumnUnassignedList, new SJctrErrorColumnDataComparator());
    }
}

